/*********************************************************************************************************************
File Name	: techwell.h
Author		: ST Chen
Date			: 2008.07.09
**********************************************************************************************************************/

//#define	DebugLevel				1


#define	DMA_debug	0

#define 	DBG( fmt, arg... )  if ( DMA_debug >= 1 ) \
		printk( fmt, ## arg )
		// printk( "TW6801: " fmt, ## arg )


/*
#define	DBG( Level, s... ) {
			if ( (Level) ) {
				printk( KERN_INFO (s) ) ;
			}

		}
*/

#if 0
	TW6802AUDIO_ADMAC		= 0,
	TW6802AUDIO_ADMAP_SA 	= 0x004,
	TW6802AUDIO_ADMAP_EXE 	= 0x008,
	TW6802AUDIO_ADMAP_PP	= 0x00C,
	TW6802AUDIO_ACTL1			= 0x010,
	TW6802AUDIO_APACKET		= 0x014,
	TW6802AUDIO_ACTL2			= 0x018,
	TW6802AUDIO_AINTSTAT		= 0x01C,
	TW6802AUDIO_AINTMASK		= 0x020,
	TW6802AUDIO_ARSTN		= 0x030,
	TW6802AUDIO_ACORE		= 0x034,
	TW6802AUDIO_APCICLK_REF	= 0x038,
	TW6802AUDIO_AVIDCLK_REF	= 0x03C,
	TW6802AUDIO_ACLK_SEL		= 0x040,
	TW6802AUDIO_DECODER_STS	= 0x044,
	TW6802AUDIO_AANACTL		= 0x048,

	// ST_0307, A special REG to force the AUDIO  pass DMA error
	// 0x0100 to pass the DMA error ....
	TW6802AUDIO_DMA_SPECIAL 	= 0x060,
	TW6802AUDIO_ADETECT 		= 0x074,

	// ST_051400_ADD
	TW6802AUDIO_ACKI 			= 0x068,
	TW6802AUDIO_ACKG 			= 0x070,



	TW6802AUDIO_SPECIAL		= 0x064,
	TW6802AUDIO_END			= 0xFFF
#endif



#define	TW6801_VERSION_CODE				0x000001
#define 	PCI_VENDOR_ID_TECHWELL			0x1797
#define 	PCI_DEVICE_ID_TW6805				0x6805
#define 	PCI_DEVICE_ID_TW6816_14				0x6814
#define 	PCI_DEVICE_ID_TW6816_15				0x6815
#define 	PCI_DEVICE_ID_TW6816_16				0x6816
#define 	PCI_DEVICE_ID_TW6816_17				0x6817


/* register offsets */
#define REG_ADMAC				0x000	/* Audio DMA Control  */
#define REG_RISC_STRT_ADD		0x004	/* RISC program start address */
#define REG_ACTL1				0x010	// Audio Control-1
#define REG_APACKET			0x014	// Audio Packet

#define REG_ACTL2				0x018	// Audio Control-2
#define REG_INT_STAT			0x01C	/* interrupt status */
#define REG_INT_MASK			0x020	/* interrupt mask */
#define REG_INT_ARSTN			0x030	/* Audio Reset */
#define REG_ACORE				0x034	// Audio PCI clock reference

#define REG_PCI_CLK_REF		0x038	// Audio PCI clock reference
#define REG_PCI_AVIDCLK_REF	0x03C	// Audio Video Clock reference
#define REG_ACLK_SEL			0x040	// Audio clock selection
#define REG_AANACTL			0x048	// Audio analog Control
#define REG_VOLUME_MASK		0x3F


// #define REG_GPIO_DMA_CTL		0x10c	/* audio control */
// #define REG_PACKET_LEN		0x110	/* audio packet lengths */
// #define REG_RISC_COUNT		0x120	/* RISC program counter */

/* interrupt bits */
#define INT_DMAPI		( 1 << 1 )			/* audio DMA Complete */
#define INT_OFLOW		( 1 << 3 )	/* audio FIFO overflow */
#define INT_ADMAPERR	( 1 << 5 )	/* RISC instruction parity error */
#define INT_PABORT		( 1 << 6  )	/* PCI master or target abort */
#define INT_PPERR		( 1 << 14)	/* PCI parity error */

//#define INT_RISC_EN	(1 << 27)	/* DMA controller running */
// #define INT_RISCI		(1 << 11)	/* RISC instruction IRQ bit set */
//#define INT_FBUS	(1 << 12)	/* FIFO overrun due to bus access latency */
//#define INT_FTRGT	(1 << 13)	/* FIFO overrun due to target latency */
// #define INT_FDSR	(1 << 14)	/* FIFO data stream resynchronization */
// #define INT_OCERR	(1 << 18)	/* invalid opcode */
// #define INT_SCERR	(1 << 19)	/* sync counter overflow */
// #define INT_RISCS_SHIFT	      28	/* RISC status bits */

/* audio control bits */
#define CTL_FIFO_ENABLE		(1 <<  1)	/* enable audio data FIFO */
#define CTL_RISC_ENABLE		(1 <<  0)	/* enable audio DMA controller */
//
// AANACTL: 0x048
#define CTL_A_PWRDN		( 1 << 9 )		// Sound ADC Power down=1, Normal: 0

#if 1
#define ERROR_INTERRUPTS 	( INT_PPERR | INT_ADMAPERR | INT_PABORT )
#define MY_INTERRUPTS ( INT_DMAPI | ERROR_INTERRUPTS)

#else
#define ERROR_INTERRUPTS 	(	INT_FBUS | INT_FTRGT | INT_PPERR | \
 			  INT_RIPERR | INT_PABORT | INT_OCERR)
#define MY_INTERRUPTS ( INT_RISCI | ERROR_INTERRUPTS)

#endif

// For DMA Engine ...
#define ASTART		0x90000000		// Receive data from beginning of scan line
#define TRIG_IRQ		0x08000000		// Generate one IRQ after current RISC instruction complete
#define DUMMY		0xE0000000		// No operation
#define JUMP			0xB0000000		// Jump to another RISC program pointer

//





#define CTL_PKTP_4		(0 <<  2)	/* packet mode FIFO trigger point - 4 DWORDs */
#define CTL_PKTP_8		(1 <<  2)	/* 8 DWORDs */
#define CTL_PKTP_16		(2 <<  2)	/* 16 DWORDs */
#define CTL_ACAP_EN		(1 <<  4)	/* enable audio capture */
#define CTL_DA_APP		(1 <<  5)	/* GPIO input */
#define CTL_DA_IOM_AFE		(0 <<  6)	/* audio A/D input */
#define CTL_DA_IOM_DA		(1 <<  6)	/* digital audio input */
#define CTL_DA_SDR_SHIFT	       8	/* DDF first stage decimation rate */
#define CTL_DA_SDR_MASK		(0xf<< 8)
#define CTL_DA_LMT		(1 << 12)	/* limit audio data values */
#define CTL_DA_ES2		(1 << 13)	/* enable DDF stage 2 */
#define CTL_DA_SBR		(1 << 14)	/* samples rounded to 8 bits */
#define CTL_DA_DPM		(1 << 15)	/* data packet mode */
#define CTL_DA_LRD_SHIFT	      16	/* ALRCK delay */
#define CTL_DA_MLB		(1 << 21)	/* MSB/LSB format */
#define CTL_DA_LRI		(1 << 22)	/* left/right indication */
#define CTL_DA_SCE		(1 << 23)	/* sample clock edge */
#define CTL_A_SEL_STV		(0 << 24)	/* TV tuner audio input */
#define CTL_A_SEL_SFM		(1 << 24)	/* FM audio input */
#define CTL_A_SEL_SML		(2 << 24)	/* mic/line audio input */
#define CTL_A_SEL_SMXC		(3 << 24)	/* MUX bypass */
#define CTL_A_SEL_SHIFT		      24
#define CTL_A_SEL_MASK		(3 << 24)

#define CTL_A_G2X		(1 << 27)	/* audio gain boost */
#define CTL_A_GAIN_SHIFT	      28	/* audio input gain */
#define CTL_A_GAIN_MASK		(0xf<<28)

/* RISC instruction opcodes */
#define RISC_WRITE	(0x1 << 28)	/* write FIFO data to memory at address */
#define RISC_WRITEC	(0x5 << 28)	/* write FIFO data to memory at current address */
#define RISC_SKIP	(0x2 << 28)	/* skip FIFO data */
#define RISC_JUMP	(0x7 << 28)	/* jump to address */
#define RISC_SYNC	(0x8 << 28)	/* synchronize with FIFO */

/* RISC instruction bits */
#define RISC_BYTES_ENABLE	(0xf << 12)	/* byte enable bits */
#define RISC_RESYNC		(  1 << 15)	/* disable FDSR errors */
#define RISC_SET_STATUS_SHIFT	        16	/* set status bits */
#define RISC_RESET_STATUS_SHIFT	        20	/* clear status bits */
#define RISC_IRQ		(  1 << 24)	/* interrupt */
#define RISC_EOL		(  1 << 26)	/* end of line */
#define RISC_SOL		(  1 << 27)	/* start of line */

/* SYNC status bits values */
#define RISC_SYNC_FM1	0x6
#define RISC_SYNC_VRO	0xc

#define ANALOG_CLOCK 1792000
#ifdef CONFIG_SND_BT87X_OVERCLOCK
#define CLOCK_DIV_MIN 1
#else
#define CLOCK_DIV_MIN 4
#endif
#define CLOCK_DIV_MAX 15

/* SYNC, one WRITE per line, one extra WRITE per page boundary, SYNC, JUMP */
#define MAX_RISC_SIZE ((1 + 255 + (PAGE_ALIGN(255 * 4092) / PAGE_SIZE - 1) + 1 + 1) * 8)

/* Cards with configuration information */
enum snd_bt87x_boardid {
	SND_BT87X_BOARD_UNKNOWN,
	SND_BT87X_BOARD_GENERIC,	/* both an & dig interfaces, 32kHz */
	SND_BT87X_BOARD_ANALOG,		/* board with no external A/D */
	SND_BT87X_BOARD_OSPREY2x0,
	SND_BT87X_BOARD_OSPREY440,
	SND_BT87X_BOARD_AVPHONE98,
	// ST_070900, Add TW68xx support
	SND_BT87X_BOARD_TECHWELL,
	// ST_END
};

/* Card configuration */
struct snd_bt87x_board {
	int dig_rate;		/* Digital input sampling rate */
	u32 digital_fmt;	/* Register settings for digital input */
	unsigned no_analog:1;	/* No analog input */
	unsigned no_digital:1;	/* No digital input */
};

#if 0

static __devinitdata struct snd_bt87x_board snd_bt87x_boards[] = {
	[SND_BT87X_BOARD_UNKNOWN] = {
		.dig_rate = 32000, /* just a guess */
	},
	[SND_BT87X_BOARD_GENERIC] = {
		.dig_rate = 32000,
	},
	[SND_BT87X_BOARD_ANALOG] = {
		.no_digital = 1,
	},
	[SND_BT87X_BOARD_OSPREY2x0] = {
		.dig_rate = 44100,
		.digital_fmt = CTL_DA_LRI | (1 << CTL_DA_LRD_SHIFT),
	},
	[SND_BT87X_BOARD_OSPREY440] = {
		.dig_rate = 32000,
		.digital_fmt = CTL_DA_LRI | (1 << CTL_DA_LRD_SHIFT),
		.no_analog = 1,
	},
	[SND_BT87X_BOARD_AVPHONE98] = {
		.dig_rate = 48000,
	},

	// ST_070900
	[SND_BT87X_BOARD_TECHWELL] = {
		.dig_rate = 8000,
		//.no_digital = 1,
	},
	// ST_END
};

#endif

struct snd_bt87x {
	struct snd_card *card;
	struct pci_dev *pci;
	struct snd_bt87x_board board;

	void __iomem *mmio;
	int irq;

	// ST_070900_ADD, Add Tw68xx support...
	// Copy this from bt87x.c_org
	int dig_rate;
	// ST_070900_END

	spinlock_t reg_lock;
	unsigned long opened;
	struct snd_pcm_substream *substream;

	struct snd_dma_buffer dma_risc;
	unsigned int line_bytes;
	unsigned int lines;

	u32 reg_control;
	u32 interrupt_mask;

	int current_line;

	int pci_parity_errors;

	// ST_080300, for volume control
	u32		m_Volume ;
	int		m_BoostMode ;


};

enum { DEVICE_DIGITAL, DEVICE_ANALOG };


static int
snd_bt87x_start
(
	struct snd_bt87x *chip
) ;




