// Security_DemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Security_Demo.h"
#include "Security_DemoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

UINT g_nInetlEncoderCount = 0;

BOOL g_bSaveAVIFile = TRUE;

extern PVOID g_pCustomChannelFullWindow;
/////////////////////////////////////////////////////////////////////////////
// CSecurity_DemoDlg dialog

CSecurity_DemoDlg::CSecurity_DemoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSecurity_DemoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSecurity_DemoDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_pIniFile = NULL;

	m_strChipName = "TW6802";

	m_nChannelNum = 4;

	m_nStandard = 0x00000001;

	m_nVideoType = SD_TYPE; 

	m_nVideoInput = 0x00000004; 

	m_nColorSpace = MAKEFOURCC('Y', 'U', 'Y', '2');

	m_nBitCount = 16;

	m_bRecordCH01 = FALSE;

	m_bShowInfo = FALSE;

	m_bUseIntelCodec = FALSE;

	m_bSaveAVIFile = FALSE;

	m_bSetWindowRes = FALSE;

	m_nWinWidth = 1280;

	m_nWinHeight = 960;

	m_nSwitchType = NO_SWICTH_CARD;

	m_pCustomVideoRenderer1 = NULL;

	m_pCustomVideoRenderer2 = NULL;

	m_nActiveFullWndCH = -1;
}

void CSecurity_DemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSecurity_DemoDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSecurity_DemoDlg, CDialog)
	//{{AFX_MSG_MAP(CSecurity_DemoDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_ERASEBKGND()
	ON_WM_DESTROY()
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(IDM_CLOSE, OnCloseSystem)
	ON_COMMAND(IDM_USE_INTEL, OnUseIndel)
	ON_COMMAND(IDM_SAVE_AVI, OnSaveAVI)
	ON_COMMAND(IDM_RECORD_CH01, OnRecordCH01)
	ON_COMMAND(IDM_RECORD_ALL, OnRecordAll)
	ON_COMMAND(IDM_STOP_RECORD, OnStopRecord)
	ON_COMMAND(IDM_SHOW_INFO, OnShowInfo)
	ON_COMMAND(IDM_PLAYBACK, OnPlayback)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSecurity_DemoDlg message handlers

BOOL CSecurity_DemoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here	

	// CREATE A VIDEO REBDERER. VIDEO RENDERER IS A BASE CONTAINER FOR INSERTING NULTIPLE CHANNEL WINDOWS
	//
	m_pCustomVideoRenderer1 = CVRSDK_CREATE();

	if( m_pCustomVideoRenderer1 == NULL ) {  return FALSE; }

	// CREATE A VIDEO RENDERER FOR INSERTING A FULL SCREEN WINDOW
	//
	m_pCustomVideoRenderer2 = CVRSDK_CREATE();

	if( m_pCustomVideoRenderer2 == NULL ) {  return FALSE; }

	bmpChkedMenu.LoadBitmap( IDB_CHECKED );

	bmpUnChkedMenu.LoadBitmap( IDB_UNCHECKED );

	m_ShowInfoDlg.Create( IDD_SHOW_INFO );	

	m_ShowInfoDlg.SetWindowText( "Yuan's Capture Card Demo Software - Display Frame Rate" );

	m_ShowInfoDlg.ShowWindow( SW_HIDE );

	// CREATE POPUP MENU
	//
	m_PopupMenu.CreatePopupMenu();

	m_PopupMenu.AppendMenu(MF_STRING, IDM_USE_INTEL, "INTEL CODEC" );

	m_PopupMenu.AppendMenu(MF_STRING, IDM_RECORD_CH01, "RECORD CH01" );

	m_PopupMenu.AppendMenu(MF_STRING, IDM_RECORD_ALL, "RECORD ALL" );

	m_PopupMenu.AppendMenu(MF_STRING, IDM_STOP_RECORD, "STOP RECORD" );

	m_PopupMenu.AppendMenu(MF_STRING, IDM_PLAYBACK, "PLAYBACK" );

	m_PopupMenu.AppendMenu(MF_STRING, IDM_SHOW_INFO, "SHOW FRAMERATE" );

	m_PopupMenu.AppendMenu(MF_STRING, IDM_SAVE_AVI, "SAVE AVI FILE" );

	m_PopupMenu.AppendMenu(MF_STRING, IDM_CLOSE, "CLOSE" );

	// m_PopupMenu.EnableMenuItem(IDM_USE_INTEL, MF_BYCOMMAND | MF_GRAYED );

	m_PopupMenu.EnableMenuItem(IDM_USE_INTEL, MF_BYCOMMAND | MF_ENABLED );

	m_PopupMenu.EnableMenuItem(IDM_RECORD_CH01, MF_BYCOMMAND | MF_ENABLED);

	m_PopupMenu.EnableMenuItem(IDM_RECORD_ALL, MF_BYCOMMAND | MF_ENABLED);

	m_PopupMenu.EnableMenuItem(IDM_STOP_RECORD, MF_BYCOMMAND | MF_GRAYED);

	m_PopupMenu.EnableMenuItem(IDM_PLAYBACK, MF_BYCOMMAND | MF_ENABLED);

	m_PopupMenu.EnableMenuItem(IDM_SHOW_INFO, MF_BYCOMMAND | MF_ENABLED);

	m_PopupMenu.EnableMenuItem(IDM_SAVE_AVI, MF_BYCOMMAND | MF_ENABLED);

	m_PopupMenu.EnableMenuItem(IDM_CLOSE, MF_BYCOMMAND | MF_ENABLED);

	m_PopupMenu.SetMenuItemBitmaps( 0, MF_BYPOSITION, &bmpUnChkedMenu, &bmpChkedMenu);

	m_PopupMenu.SetMenuItemBitmaps( 6, MF_BYPOSITION, &bmpChkedMenu, &bmpUnChkedMenu);

	UINT i = 0;

	for ( i = 0 ; i < 32 ; i++ )
	{
		m_pLiveAV[ i ] = NULL; 

		m_pSwitchLiveAV[ i ] = NULL; 

		m_pRecordAV[ i ] = NULL;

		m_pSwEncodeAV[ i ] = NULL;

		m_pHwEncodeAV[ i ] = NULL;

		m_pOverlayWindow[ i ] = NULL;
	}

	m_pOverlayFullWindow = NULL;

	m_pViewManager = new MyViewManager;	

	CString strIniFile;

	strIniFile = GetWorkingPath( "CaptureCard.ini" );

	// OPEN CAPTURECARD.INI FILE
	//
	BOOL bOpenIniFile = OpenIniFile( strIniFile );

	if ( !bOpenIniFile )
	{
		AfxMessageBox( "Can't open CaptureCard.ini file !" );

		SendMessage( WM_CLOSE );

		return FALSE;
	}

	// READ RELATED INFO FROM INI FILE
	//
	if ( m_pIniFile != NULL )
	{
		CString strLine, strCH;

		while( m_pIniFile->ReadString( strLine ) )
		{
			CStringVector strVector = SplitString(strLine, ",", true);

			if (strVector.size() >= 2)
			{			
				if ( strLine.Find( "CHIPNAME" ) != -1 )
				{
					m_strChipName = strVector[ 1 ];
				}

				if ( strLine.Find( "MANUAL_SET_WINDOW_RESOLUTION" ) != -1 )
				{
					if ( strVector[ 1 ] == "YES" )
					{
						m_bSetWindowRes = TRUE;
					}
				}

				if ( strLine.Find( "WINRES" ) != -1 )
				{
					m_nWinWidth = atol( strVector[ 1 ] );

					m_nWinHeight = atol( strVector[ 2 ] );					
				}

				if ( strLine.Find( "SWITCHCARDTYPE" ) != -1 )
				{
					if ( strVector[ 1 ] == "D" )
					{
						m_nSwitchType = DOUBLE_SWITCH_CARD;
					}
					else if ( strVector[ 1 ] == "Q" )
					{
						m_nSwitchType = QUAD_SWITCH_CARD;
					}
					else
					{
						m_nSwitchType = NO_SWICTH_CARD;
					}
				}

				if ( strLine.Find( "CHANNELNUM" ) != -1 )
				{
					m_nChannelNum = atol( strVector[ 1 ] );
				}

				if ( strLine.Find( "VIDEOSTANDARD" ) != -1 )
				{				
					if ( strVector[ 1 ] == "PAL" )
					{
						m_nStandard = 0x00000010;	// PAL
					}
					else
					{
						m_nStandard = 0x00000001;	// NTSC
					}
				}

				if ( strLine.Find( "VIDEOTYPE" ) != -1 )
				{
					if ( strVector[ 1 ] == "HD" )
					{
						m_nVideoType = HD_TYPE;		// HD
					}
					else
					{
						m_nVideoType = SD_TYPE;		// SD
					}
				}	

				if ( strLine.Find( "VIDEOINPUT" ) != -1 )
				{
					if ( strVector[ 1 ] == "HDMI" )
					{
						m_nVideoInput = 0x00000000;		// HDMI
					}
					else
					{
						m_nVideoInput = 0x00000004;		// SDI
					}
				}

				if ( strLine.Find( "INTELENCODERNUM" ) != -1 )
				{
					g_nInetlEncoderCount = atoi( strVector[ 1 ] );

					if ( g_nInetlEncoderCount < 0 ) g_nInetlEncoderCount = 0;

					if ( g_nInetlEncoderCount > 32 ) g_nInetlEncoderCount = 32;
				}
			}

			if (strVector.size() >= 22)
			{				
				for (int i = 0 ; i < 64 ; i++ )
				{
					strCH.Format( "CH%02d" , i + 1 );

					if ( strLine.Find( strCH ) != -1 && strLine.Find( "YCODEC" ) != -1 )
					{
						m_YChInfo[ i ].nCH = i + 1;

						m_YChInfo[ i ].nWidth = atoi( strVector[ 3 ] );

						m_YChInfo[ i ].nHeight = atoi( strVector[ 4 ] );

						bool bDeinterlace = false;

						if ( strVector[ 6 ] == "ENABLE" ) { bDeinterlace = true; } else { bDeinterlace = false; }

						m_YChInfo[ i ].bDeinterlace = bDeinterlace;

						m_YChInfo[ i ].dFrameRate = atof( strVector[ 8 ] );

						if ( strVector[ 10 ] == "CBR" ) { m_YChInfo[ i ].nRecordMode = 2; } else { m_YChInfo[ i ].nRecordMode = 1; }

						m_YChInfo[ i ].nBitRate = atol( strVector[ 12 ] );

						m_YChInfo[ i ].nQuality = atol( strVector[ 14 ] );

						m_YChInfo[ i ].nGop = atol( strVector[ 16 ] );

						m_YChInfo[ i ].m_nFileWidth = atol( strVector[ 18 ] );

						m_YChInfo[ i ].m_nFileHeight = atol( strVector[ 19 ] );

						m_YChInfo[ i ].nDropFrame = atol( strVector[ 21 ] );

						break;
					}

					if ( strLine.Find( strCH ) != -1 && strLine.Find( "ICODEC" ) != -1 )
					{
						m_IChInfo[ i ].nCH = i + 1;

						m_IChInfo[ i ].nWidth = atoi( strVector[ 3 ] );

						m_IChInfo[ i ].nHeight = atoi( strVector[ 4 ] );

						bool bDeinterlace = false;

						if ( strVector[ 6 ] == "ENABLE" ) { bDeinterlace = true; } else { bDeinterlace = false; }

						m_IChInfo[ i ].bDeinterlace = bDeinterlace;

						m_IChInfo[ i ].dFrameRate = atof( strVector[ 8 ] );

						if ( strVector[ 10 ] == "CBR" ) { m_IChInfo[ i ].nRecordMode = 2; } else { m_IChInfo[ i ].nRecordMode = 1; }

						m_IChInfo[ i ].nBitRate = atol( strVector[ 12 ] );

						m_IChInfo[ i ].nQuality = atol( strVector[ 14 ] );

						m_IChInfo[ i ].nGop = atol( strVector[ 16 ] );

						m_IChInfo[ i ].m_nFileWidth = atol( strVector[ 18 ] );

						m_IChInfo[ i ].m_nFileHeight = atol( strVector[ 19 ] );

						m_IChInfo[ i ].nDropFrame = atol( strVector[ 21 ] );

						break;
					}
				}			
			}
		}
	}

	// CHECK CHIP NAME
	//
	if ( m_strChipName != "TW6802" && m_strChipName != "AH8400" &&  m_strChipName != "FH8735" && m_strChipName != "TW5864" && m_strChipName != "SA7160" &&  m_strChipName != "CX2581" &&  m_strChipName != "TW2809" )
	{
		AfxMessageBox( "Error chip name !" );

		CloseIniFile();

		SendMessage( WM_CLOSE );

		return FALSE;
	}

	// CHECK CHANNEL NUMBER
	//
	if ( m_nChannelNum > 32 || m_nChannelNum <= 0 ) { AfxMessageBox( "Error channel number !" ); CloseIniFile(); SendMessage( WM_CLOSE ); return FALSE; }

	if ( m_strChipName == "AH8400" || m_strChipName == "FH8735" || m_strChipName == "TW5864" || m_strChipName == "TW2809" ) { m_nSwitchType = 0; }

	if ( m_nSwitchType == DOUBLE_SWITCH_CARD ) { if ( ( m_nChannelNum % 2 ) != 0 )  {  AfxMessageBox( "Error channel number !" ); CloseIniFile(); SendMessage( WM_CLOSE ); return FALSE; } }

	if ( m_nSwitchType == QUAD_SWITCH_CARD ) { if ( ( m_nChannelNum % 4 ) != 0 ) {  AfxMessageBox( "Error channel number !" );	CloseIniFile(); SendMessage( WM_CLOSE ); return FALSE; } }

	for ( i = 0 ; i < m_nChannelNum ; i++ )
	{
		m_pLiveAV[ i ] = new MyLiveAV;

		m_pSwitchLiveAV[ i ] = new MySwitchLiveAV;

		m_pRecordAV[ i ] = new MyRecordAV;

		m_pSwEncodeAV[ i ] = new MySwEncodeAV;

		m_pHwEncodeAV[ i ] = new MyHwEncodeAV;
	}

	RECT rect;

	int nXResolution = GetSystemMetrics( SM_CXSCREEN );

	int nYResolution = GetSystemMetrics( SM_CYSCREEN );

	//rect.left = 0; rect.top = 0; rect.right = nXResolution; rect.bottom = nYResolution;	

	//MoveWindow( 0, 0, nXResolution, nYResolution );

	//MoveWindow( 0, 0, 176 * 6, 120 * 6 );

	if ( m_bSetWindowRes )
	{
		rect.left = 0; 
		
		rect.top = 0; 
		
		rect.right = m_nWinWidth; 
		
		rect.bottom = m_nWinHeight;	

		MoveWindow( 0, 0, m_nWinWidth, m_nWinHeight );
	}
	else
	{
		rect.left = 0; 
		
		rect.top = 0; 
		
		rect.right = nXResolution; 
		
		rect.bottom = nYResolution;	

		MoveWindow( 0, 0, nXResolution, nYResolution );
	}

	// FOR CVRSDK LAYOUT
	//
	CRect  rect_client; GetClientRect( &rect_client );

	int nChWidth  = 0;

	int nChHeight = 0;	

	CRect rectFull(0);

	CRect rectWin[ 36 ] = {0};

	int j = 0;

	rectFull.left = 0; rectFull.top = 0; rectFull.right = rect_client.Width(); rectFull.bottom = rect_client.Height();	

	// CALCULATE WINDOW LAYOUT POSITION
	//
	if ( m_nChannelNum <= 4 )
	{
		nChWidth  = (int)(rect_client.Width() / 2);

		nChHeight = (int)(rect_client.Height() / 2);

		for ( i = 0 ; i < 4 ; i++ )
		{
			rectWin[ i ].left   = (j * nChWidth);

			rectWin[ i ].right  = rectWin[ i ].left + nChWidth;

			if ( i >= 0 && i < 2 ) { rectWin[ i ].top = 0;  }

			if ( i >= 2 && i < 4 ) { rectWin[ i ].top =  nChHeight * 1; }

			rectWin[ i ].bottom = rectWin[ i ].top + nChHeight;

			j++;

			if ( j % 2 == 0 ) j = 0;
		}
	}

	if ( m_nChannelNum > 4 && m_nChannelNum <= 8 )
	{
		nChWidth  = (int)(rect_client.Width() / 3);

		nChHeight = (int)(rect_client.Height() / 3);

		for ( i = 0 ; i < 9 ; i++ )
		{
			rectWin[ i ].left   = (j * nChWidth);

			rectWin[ i ].right  = rectWin[ i ].left + nChWidth;

			if ( i >= 0 && i < 3 ) { rectWin[ i ].top = 0; }
			
			if ( i >= 3 && i < 6 ) { rectWin[ i ].top = nChHeight * 1; }

			if ( i >= 6 && i < 9 ) { rectWin[ i ].top = nChHeight * 2; }

			rectWin[ i ].bottom = rectWin[ i ].top + nChHeight;		

			j++;

			if ( j % 3 == 0 ) j = 0;		
		}
	}

	if ( m_nChannelNum > 8 && m_nChannelNum <= 16 )
	{
		nChWidth  = (int)(rect_client.Width() / 4);

		nChHeight = (int)(rect_client.Height() / 4);

		for ( i = 0 ; i < 16 ; i++ )
		{
			rectWin[ i ].left   = (j * nChWidth);

			rectWin[ i ].right  = rectWin[ i ].left + nChWidth;

			if ( i >= 0  && i < 4 )  { rectWin[ i ].top  = 0;  }

			if ( i >= 4  && i < 8 )  { rectWin[ i ].top  =  nChHeight * 1; }

			if ( i >= 8  && i < 12 ) { rectWin[ i ].top  =  nChHeight * 2; }

			if ( i >= 12 && i < 16 ) { rectWin[ i ].top  =  nChHeight * 3; }

			rectWin[ i ].bottom = rectWin[ i ].top + nChHeight;

			j++;

			if ( j % 4 == 0 ) j = 0;
		}
	}

	if ( m_nChannelNum > 16 )
	{
		nChWidth  = (int)(rect_client.Width() / 6);

		nChHeight = (int)(rect_client.Height() / 6);

		for ( i = 0 ; i < 36 ; i++ )
		{
			rectWin[ i ].left  = ( j * nChWidth );

			rectWin[ i ].right = rectWin[ i ].left + nChWidth;
			
			if ( i >= 0 && i < 6 )   { rectWin[ i ].top = 0; }

			if ( i >= 6 && i < 12 )  { rectWin[ i ].top = nChHeight * 1; }

			if ( i >= 12 && i < 18 ) { rectWin[ i ].top = nChHeight * 2; }

			if ( i >= 18 && i < 24 ) { rectWin[ i ].top = nChHeight * 3; }

			if ( i >= 24 && i < 30 ) { rectWin[ i ].top = nChHeight * 4; }

			if ( i >= 30 && i < 36 ) { rectWin[ i ].top = nChHeight * 5; }

			rectWin[ i ].bottom = rectWin[ i ].top + nChHeight;		

			j++;

			if ( j % 6 == 0 ) j = 0;		
		}
	}

	// CREATE CHANNEL WINDOW
	//	
	CString strWinName;

	for ( i = 0 ; i < 36 ; i++ )
	{
		strWinName.Format( "MyChannelWindow%02d", i + 1 );

		m_oVideoWnd[ i ].m_nWndID = i;		

		m_oVideoWnd[ i ].m_pParentDlg = this;

		m_oVideoWnd[ i ].Create( NULL, strWinName,  WS_CHILD | WS_VISIBLE, rectWin[ i ], this, i, NULL );

		m_oVideoWnd[ i ].ShowWindow( FALSE );
	}
	
	// CREATE FULL SCREEN WINDOW
	//
	strWinName.Format( "MyChannelWindow%02d", 36 );

	m_oFullVideoWnd.m_nWndID = 36;

	m_oFullVideoWnd.m_pParentDlg = this;

	m_oFullVideoWnd.m_bFullScreen = TRUE;

	m_oFullVideoWnd.Create( NULL, strWinName,  WS_CHILD | WS_VISIBLE, rectFull, this, 36, NULL );
		
	if ( g_pCustomChannelFullWindow != NULL )
	{
		m_pOverlayFullWindow = CVRSDK_CREATE_OVERLAY_BUFFER(g_pCustomChannelFullWindow, 125, 20);		
	}	

	m_oFullVideoWnd.ShowWindow( FALSE );
	//

	//
	//
	m_pViewManager->SetVideoWnds(LAYOUT01, m_oVideoWnd, 1);

	m_pViewManager->SetVideoWnds(LAYOUT04, m_oVideoWnd, 4);

	m_pViewManager->SetVideoWnds(LAYOUT09, m_oVideoWnd, 9);

	m_pViewManager->SetVideoWnds(LAYOUT16, m_oVideoWnd, 16);

	m_pViewManager->SetVideoWnds(LAYOUT36, m_oVideoWnd, 36);

	//rect.left   = 0;
	//rect.top    = 0;
	//rect.right  = 176 * 6;
	//rect.bottom = 120 * 6;

	m_pViewManager->SetLayoutRect(rect);

	// ACTIVE LAYOUT TYPE	
	//
	if ( m_nChannelNum <= 4 )						{ m_pViewManager->Activate(LAYOUT04, TRUE); }

	if ( m_nChannelNum > 4 && m_nChannelNum <= 8 )  { m_pViewManager->Activate(LAYOUT09, TRUE); }

	if ( m_nChannelNum > 8 && m_nChannelNum <= 16 ) { m_pViewManager->Activate(LAYOUT16, TRUE); }
	
	if ( m_nChannelNum > 16 )						{ m_pViewManager->Activate(LAYOUT36, TRUE); }

	SetWindowText( "Yuan's Capture Card Demo Software" );

	CenterWindow( GetDesktopWindow() );

	ShowWindow( FALSE );

	// CLOSE INI FILE
	//
	if ( bOpenIniFile )
	{
		CloseIniFile();
	}

	// INITIALIZE DOUBLE SWITCH CARD
	//
	if ( m_nSwitchType == DOUBLE_SWITCH_CARD )
	{
		HwInitializeDoubleSwitch();
	}
	// INITIALIZE QUAD SWITCH CARD
	//
	else if ( m_nSwitchType == QUAD_SWITCH_CARD )
	{
		HwInitializeQuadSwitch();
	}
	// INITIALIZE NON SWITCH CARD
	//
	else
	{
		HwInitialize();
	}	
	
	for ( i = 0 ; i < 32 ; i++ )
	{
		m_pOverlayWindow[ i ] = CVRSDK_CREATE_OVERLAY_BUFFER(m_oVideoWnd[ i ].m_pCustomChannelWindow, 125, 20);
	}

	// SHOW OVERLAY WINDOW
	//
	SetTimer( 0x00000000, 1000, NULL );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

BOOL CSecurity_DemoDlg::HwInitializeDoubleSwitch()
{
	BeginWaitCursor();

	ULONG i = 0 , j = 0, k = 0, n = 0;

	ULONG nColorSpace = 0 , nWidth = 0 , nHeight = 0 , nBitCount = 0 ;
	
	DOUBLE dFrameRate = 0.0;

	m_nColorSpace = MAKEFOURCC('Y', 'U', 'Y', '2');

	m_nBitCount = 16;

	for ( i = 0 ; i < m_nChannelNum ; i++ )
	{	
		m_pSwEncodeAV[ i ]->SetChannelID( i + 1 );

		m_pHwEncodeAV[ i ]->SetChannelID( i + 1 );

		m_pRecordAV[ i ]->SetChannelID( i + 1 );		
	}

	for ( i = 0 ; i < m_nChannelNum / 2 ; i++ )
	{
		n = 0;

		m_pSwitchLiveAV[ i ]->SetChannelID( i + 1 );

		m_pSwitchLiveAV[ i ]->m_nSwitchType = m_nSwitchType;

		m_pSwitchLiveAV[ i ]->SetChipName( m_strChipName + " PCI" );		

		m_pSwitchLiveAV[ i ]->m_nDropFrame = m_IChInfo[ i ].nDropFrame;

		m_pSwitchLiveAV[ i ]->m_hWnd1 = m_oVideoWnd[ j ].GetSafeHwnd();

		// CVRSDK : SET CHANNEL WINDOW POINTER
		//
		m_pSwitchLiveAV[ i ]->m_pCustomChannelWindow1 = m_oVideoWnd[ j ].m_pCustomChannelWindow;

		m_oVideoWnd[ j ].SetSwitchLiveAV( m_pSwitchLiveAV[ i ] );

		m_oVideoWnd[ j ].m_nSubChannelNumber = n;

		j++; n++;

		m_pSwitchLiveAV[ i ]->m_hWnd2 = m_oVideoWnd[ j ].GetSafeHwnd();

		// CVRSDK : SET CHANNEL WINDOW POINTER
		//
		m_pSwitchLiveAV[ i ]->m_pCustomChannelWindow2 = m_oVideoWnd[ j ].m_pCustomChannelWindow;

		m_oVideoWnd[ j ].SetSwitchLiveAV( m_pSwitchLiveAV[ i ] );

		m_oVideoWnd[ j ].m_nSubChannelNumber = n;

		j++; n++;

		if ( m_pSwitchLiveAV[ i ]->Connect() )
		{
			k = ( i * 2 ) + 0;

			for (ULONG m = k ; m < k + 2 ; m++ )
			{
				m_oVideoWnd[ m ].m_bConnectVideo = TRUE;
			}		
		}
		else
		{
			k = ( i * 2 ) + 0;

			for (ULONG m = k ; m < k + 2 ; m++ )
			{
				m_oVideoWnd[ m ].m_bConnectVideo = FALSE;
			}
		}
	}	

	for ( i = 0 ; i < m_nChannelNum / 2 ; i++ )
	{	
		if ( m_pSwitchLiveAV[ i ]->IsConnected() )
		{
			m_pSwitchLiveAV[ i ]->SetVideoStandard( m_nStandard );			

			// SET VIDEO FORMAT
			//
			if ( !m_pSwitchLiveAV[ i ]->SetVideoFormat(m_nColorSpace, m_IChInfo[ i ].nWidth, m_IChInfo[ i ].nHeight, m_nBitCount, m_IChInfo[ i ].dFrameRate ) )
			{
				k = ( i * 2 ) + 0;

				for (ULONG m = k ; m < k + 2 ; m++ )
				{
					if ( m_oVideoWnd[ m ].m_bConnectVideo )
					{
						m_oVideoWnd[ m ].m_bConnectVideo = FALSE;

						m_oVideoWnd[ m ].m_strShowText = "FAIL TO SET VIDEO FORMAT";
					}
				}			
			}			
			
			if ( m_IChInfo[ i ].bDeinterlace ) { m_pSwitchLiveAV[ i ]->SetVideoDeinterlace( 0x00000007 ); } else { m_pSwitchLiveAV[ i ]->SetVideoDeinterlace( 0x00000000 ); }
		}

		if ( m_nVideoType == HD_TYPE ) { m_pSwitchLiveAV[ i ]->SetVideoInput( m_nVideoInput ); }
	}

	// SET SWITCH TABLE - FOR SWITCH CARD
	//	
	BYTE TABLE[ 12 ] = { 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1 };

	for( i = 0, j = 0 ; i < 12 ; i++ )  { TABLE[ i ] = (BYTE)(j);  j++;  j %= 2; }

	for ( i = 0 ; i < m_nChannelNum / 2 ; i++ )
	{
		m_pSwitchLiveAV[ i ]->SetSwitchTable( TABLE );
	}		

	// FILE RECORDING
	//

	CString strRecordName, strRecordPath;

	for ( i = 0 ; i < m_nChannelNum ; i++ ) 
	{ 
		strRecordName.Format( "RECORD%02d.AVI", i + 1 );

		strRecordPath = GetWorkingPath( strRecordName );

		m_pRecordAV[ i ]->SetChannelID( i + 1 );

		m_pRecordAV[ i ]->SetFilePathName( strRecordPath.GetBuffer( 256 ) );

		strRecordPath.ReleaseBuffer();		
	}

	for ( i = 0 ; i < m_nChannelNum ; i++ )
	{
		m_pSwEncodeAV[ i ]->SetRecordAV( m_pRecordAV[ i ] );
	}
	
	for ( i = 0 ; i < m_nChannelNum / 2 ; i++ )
	{
		m_pSwitchLiveAV[ i ]->m_pRecordAV1 = m_pRecordAV[ ( i * 2 ) + 0 ];

		m_pSwitchLiveAV[ i ]->m_pRecordAV2 = m_pRecordAV[ ( i * 2 ) + 1 ];	

		m_pSwitchLiveAV[ i ]->m_pMySwEncodeAV1 = m_pSwEncodeAV[ ( i * 2 ) + 0 ];

		m_pSwitchLiveAV[ i ]->m_pMySwEncodeAV2 = m_pSwEncodeAV[ ( i * 2 ) + 1 ];		
	}

	for ( i = 0 ; i < m_nChannelNum / 2 ; i++ )
	{
		m_pSwitchLiveAV[ i ]->LiveRun();
	}

	EndWaitCursor();

	return TRUE;
}

BOOL CSecurity_DemoDlg::HwInitializeQuadSwitch()
{
	BeginWaitCursor();

	ULONG i = 0 , j = 0, k = 0, n = 0;

	ULONG nColorSpace = 0 , nWidth = 0 , nHeight = 0 , nBitCount = 0 ;
	
	DOUBLE dFrameRate = 0.0;

	m_nColorSpace = MAKEFOURCC('Y', 'U', 'Y', '2');

	m_nBitCount = 16;

	for ( i = 0 ; i < m_nChannelNum ; i++ )
	{	
		m_pSwEncodeAV[ i ]->SetChannelID( i + 1 );

		m_pHwEncodeAV[ i ]->SetChannelID( i + 1 );

		m_pRecordAV[ i ]->SetChannelID( i + 1 );		
	}	

	for ( i = 0 ; i < m_nChannelNum / 4 ; i++ )
	{
		n = 0;

		m_pSwitchLiveAV[ i ]->SetChannelID( i + 1 );

		m_pSwitchLiveAV[ i ]->m_nSwitchType = m_nSwitchType;

		m_pSwitchLiveAV[ i ]->SetChipName( m_strChipName + " PCI" );	

		m_pSwitchLiveAV[ i ]->m_nDropFrame = m_IChInfo[ i ].nDropFrame;	

		m_pSwitchLiveAV[ i ]->m_hWnd1 = m_oVideoWnd[ j ].GetSafeHwnd();

		// CVRSDK : SET CHANNEL WINDOW POINTER
		//
		m_pSwitchLiveAV[ i ]->m_pCustomChannelWindow1 = m_oVideoWnd[ j ].m_pCustomChannelWindow;

		m_oVideoWnd[ j ].SetSwitchLiveAV( m_pSwitchLiveAV[ i ] );

		m_oVideoWnd[ j ].m_nSubChannelNumber = n;

		j++; n++;

		m_pSwitchLiveAV[ i ]->m_hWnd2 = m_oVideoWnd[ j ].GetSafeHwnd();

		// CVRSDK : SET CHANNEL WINDOW POINTER
		//
		m_pSwitchLiveAV[ i ]->m_pCustomChannelWindow2 = m_oVideoWnd[ j ].m_pCustomChannelWindow;

		m_oVideoWnd[ j ].SetSwitchLiveAV( m_pSwitchLiveAV[ i ] );

		m_oVideoWnd[ j ].m_nSubChannelNumber = n;

		j++; n++;

		m_pSwitchLiveAV[ i ]->m_hWnd3 = m_oVideoWnd[ j ].GetSafeHwnd();

		// CVRSDK : SET CHANNEL WINDOW POINTER
		//
		m_pSwitchLiveAV[ i ]->m_pCustomChannelWindow3 = m_oVideoWnd[ j ].m_pCustomChannelWindow;

		m_oVideoWnd[ j ].SetSwitchLiveAV( m_pSwitchLiveAV[ i ] );

		m_oVideoWnd[ j ].m_nSubChannelNumber = n;

		j++; n++;

		m_pSwitchLiveAV[ i ]->m_hWnd4 = m_oVideoWnd[ j ].GetSafeHwnd();

		// CVRSDK : SET CHANNEL WINDOW POINTER
		//
		m_pSwitchLiveAV[ i ]->m_pCustomChannelWindow4 = m_oVideoWnd[ j ].m_pCustomChannelWindow;

		m_oVideoWnd[ j ].SetSwitchLiveAV( m_pSwitchLiveAV[ i ] );

		m_oVideoWnd[ j ].m_nSubChannelNumber = n;

		j++; n++;

		if ( m_pSwitchLiveAV[ i ]->Connect() )
		{
			k = ( i * 4 ) + 0;

			for (ULONG m = k ; m < k + 4 ; m++ )
			{
				m_oVideoWnd[ m ].m_bConnectVideo = TRUE;
			}		
		}
		else
		{
			k = ( i * 4 ) + 0;

			for (ULONG m = k ; m < k + 4 ; m++ )
			{
				m_oVideoWnd[ m ].m_bConnectVideo = FALSE;
			}
		}
	}

	for ( i = 0 ; i < m_nChannelNum / 4 ; i++ )
	{	
		if ( m_pSwitchLiveAV[ i ]->IsConnected() )
		{
			m_pSwitchLiveAV[ i ]->SetVideoStandard( m_nStandard );			

			// SET VIDEO FORMAT
			//
			if ( !m_pSwitchLiveAV[ i ]->SetVideoFormat(m_nColorSpace, m_IChInfo[ i ].nWidth, m_IChInfo[ i ].nHeight, m_nBitCount, m_IChInfo[ i ].dFrameRate ) )
			{
				k = ( i * 4 ) + 0;

				for (ULONG m = k ; m < k + 4 ; m++ )
				{
					if ( m_oVideoWnd[ m ].m_bConnectVideo )
					{
						m_oVideoWnd[ m ].m_bConnectVideo = FALSE;

						m_oVideoWnd[ m ].m_strShowText = "FAIL TO SET VIDEO FORMAT";
					}
				}			
			}		
			
			if ( m_IChInfo[ i ].bDeinterlace ) { m_pSwitchLiveAV[ i ]->SetVideoDeinterlace( 0x00000007 ); } else { m_pSwitchLiveAV[ i ]->SetVideoDeinterlace( 0x00000000 ); }
		}

		if ( m_nVideoType == HD_TYPE ) { m_pSwitchLiveAV[ i ]->SetVideoInput( m_nVideoInput ); }
	}

	// SET SWITCH TABLE - FOR SWITCH CARD
	//
	BYTE TABLE[ 12 ] = { 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3 };

	for( i = 0, j = 0 ; i < 12 ; i++ )  { TABLE[ i ] = (BYTE)(j);  j++;  j %= 4; }

	for ( i = 0 ; i < m_nChannelNum / 4 ; i++ )
	{
		m_pSwitchLiveAV[ i ]->SetSwitchTable( TABLE );
	}

	// FILE RECORDING
	//

	CString strRecordName, strRecordPath;

	for ( i = 0 ; i < m_nChannelNum ; i++ ) 
	{ 
		strRecordName.Format( "RECORD%02d.AVI", i + 1 );

		strRecordPath = GetWorkingPath( strRecordName );

		m_pRecordAV[ i ]->SetChannelID( i + 1 );

		m_pRecordAV[ i ]->SetFilePathName( strRecordPath.GetBuffer( 256 ) );

		strRecordPath.ReleaseBuffer();				
	}

	for ( i = 0 ; i < m_nChannelNum ; i++ )
	{
		m_pSwEncodeAV[ i ]->SetRecordAV( m_pRecordAV[ i ] );
	}
	
	for ( i = 0 ; i < m_nChannelNum / 4 ; i++ )
	{
		m_pSwitchLiveAV[ i ]->m_pRecordAV1 = m_pRecordAV[ ( i * 4 ) + 0 ];

		m_pSwitchLiveAV[ i ]->m_pRecordAV2 = m_pRecordAV[ ( i * 4 ) + 1 ];

		m_pSwitchLiveAV[ i ]->m_pRecordAV3 = m_pRecordAV[ ( i * 4 ) + 2 ];

		m_pSwitchLiveAV[ i ]->m_pRecordAV4 = m_pRecordAV[ ( i * 4 ) + 3 ];

		m_pSwitchLiveAV[ i ]->m_pMySwEncodeAV1 = m_pSwEncodeAV[ ( i * 4 ) + 0 ];

		m_pSwitchLiveAV[ i ]->m_pMySwEncodeAV2 = m_pSwEncodeAV[ ( i * 4 ) + 1 ];

		m_pSwitchLiveAV[ i ]->m_pMySwEncodeAV3 = m_pSwEncodeAV[ ( i * 4 ) + 2 ];

		m_pSwitchLiveAV[ i ]->m_pMySwEncodeAV4 = m_pSwEncodeAV[ ( i * 4 ) + 3 ];
	}

	for ( i = 0 ; i < m_nChannelNum / 4 ; i++ )
	{
		m_pSwitchLiveAV[ i ]->LiveRun();
	}

	EndWaitCursor();

	return TRUE;
}

BOOL CSecurity_DemoDlg::HwInitialize()
{
	BeginWaitCursor();

	ULONG i = 0;

	for ( i = 0 ; i < m_nChannelNum ; i++ )
	{
		m_pLiveAV[ i ]->SetChannelID( i + 1 );

		m_pSwEncodeAV[ i ]->SetChannelID( i + 1 );

		m_pHwEncodeAV[ i ]->SetChannelID( i + 1 );

		m_pRecordAV[ i ]->SetChannelID( i + 1 );

		m_pLiveAV[ i ]->SetPreviewHwnd( m_oVideoWnd[ i ].GetSafeHwnd() );

		// CVRSDK : SET CHANNEL WINDOW
		//
		m_pLiveAV[ i ]->SetCustomChannelWindow( m_oVideoWnd[ i ].m_pCustomChannelWindow );

		m_oVideoWnd[ i ].SetLiveAV( m_pLiveAV[ i ] );
	}

	if ( m_strChipName == "TW6802" || m_strChipName == "SA7160" || m_strChipName == "CX2581" ) { m_nColorSpace = MAKEFOURCC('Y', 'U', 'Y', '2'); m_nBitCount = 16; }

	if ( m_strChipName == "AH8400" ) { m_nColorSpace = MAKEFOURCC('U', 'Y', 'V', 'Y'); m_nBitCount = 16; }

	if ( m_strChipName == "FH8735" || m_strChipName == "TW5864" || m_strChipName == "TW2809" ) { m_nColorSpace = MAKEFOURCC('Y', 'V', '1', '2'); m_nBitCount = 12; }

	ULONG nColorSpace = 0 , nWidth = 0 , nHeight = 0 , nBitCount = 0 ;
	
	DOUBLE dFrameRate = 0.0;

	for ( i = 0 ; i < m_nChannelNum ; i++ )
	{
		m_pLiveAV[ i ]->SetChipName( m_strChipName + " PCI" );

		if ( m_bUseIntelCodec )
			m_pLiveAV[ i ]->m_nDropFrame = m_IChInfo[ i ].nDropFrame;
		else
			m_pLiveAV[ i ]->m_nDropFrame = m_YChInfo[ i ].nDropFrame;

		if ( m_pLiveAV[ i ]->Connect() )
		{	
			m_oVideoWnd[ i ].m_bConnectVideo = TRUE;
		}
		else
		{
			m_oVideoWnd[ i ].m_bConnectVideo = FALSE;
		}
	}

	for ( i = 0 ; i < m_nChannelNum ; i++ )
	{	
		if ( m_pLiveAV[ i ]->IsConnected() )
		{
			m_pLiveAV[ i ]->SetVideoStandard( m_nStandard );		

			if ( m_bUseIntelCodec )
			{
				// SET VIDEO FORMAT
				//
				if ( !m_pLiveAV[ i ]->SetVideoFormat(m_nColorSpace, m_IChInfo[ i ].nWidth, m_IChInfo[ i ].nHeight, m_nBitCount, m_IChInfo[ i ].dFrameRate ) )
				{
					if ( m_oVideoWnd[ i ].m_bConnectVideo )
					{
						m_oVideoWnd[ i ].m_bConnectVideo = FALSE;

						m_oVideoWnd[ i ].m_strShowText = "FAIL TO SET VIDEO FORMAT";
					}
				}
			}
			else
			{
				// SET VIDEO FORMAT
				//
				if ( !m_pLiveAV[ i ]->SetVideoFormat(m_nColorSpace, m_YChInfo[ i ].nWidth, m_YChInfo[ i ].nHeight, m_nBitCount, m_YChInfo[ i ].dFrameRate ) )
				{
					if ( m_oVideoWnd[ i ].m_bConnectVideo )
					{
						m_oVideoWnd[ i ].m_bConnectVideo = FALSE;

						m_oVideoWnd[ i ].m_strShowText = "FAIL TO SET VIDEO FORMAT";
					}
				}
			}

			if ( m_bUseIntelCodec )
			{
				if ( m_IChInfo[ i ].bDeinterlace ) 
				{ 
					m_pLiveAV[ i ]->SetVideoDeinterlace( 0x00000007 ); 
				} 
				else 
				{ 
					m_pLiveAV[ i ]->SetVideoDeinterlace( 0x00000000 ); 
				}
			}
			else
				if ( m_YChInfo[ i ].bDeinterlace ) 
				{ 
					m_pLiveAV[ i ]->SetVideoDeinterlace( 0x00000007 ); 
				}
				else 
				{ 
					m_pLiveAV[ i ]->SetVideoDeinterlace( 0x00000000 ); 
				}

			if ( m_nVideoType == HD_TYPE ) { m_pLiveAV[ i ]->SetVideoInput( m_nVideoInput ); }
		}
	}	

	// HARDWARE CODEC
	//
	if ( m_strChipName == "FH8735" || m_strChipName == "AH8400" || m_strChipName == "TW5864" || m_strChipName == "TW2809" )
	{
		for ( i = 0 ; i < m_nChannelNum ; i++ )
		{
			m_pHwEncodeAV[ i ]->SetChipName( m_strChipName + " PCI" );

			m_pHwEncodeAV[ i ]->Connect();

			// CBR
			//
			if ( m_YChInfo[ i ].nRecordMode == 2 ) 
			{
				m_pHwEncodeAV[ i ]->SetEncodeCBR( m_YChInfo[ i ].nBitRate, 1, m_YChInfo[ i ].nGop );
			}
			
			// VBR
			//
			if ( m_YChInfo[ i ].nRecordMode == 1 ) 
			{
				m_pHwEncodeAV[ i ]->SetEncodeVBR( m_YChInfo[ i ].nQuality, m_YChInfo[ i ].nGop );
			}		

			m_pHwEncodeAV[ i ]->SetEncodeVideoFormat(m_nColorSpace, m_nStandard, m_YChInfo[ i ].m_nFileWidth, m_YChInfo[ i ].m_nFileHeight, m_nBitCount, m_IChInfo[ i ].dFrameRate );
		}

		for ( i = 0 ; i < m_nChannelNum ; i++ )
		{
			m_pHwEncodeAV[ i ]->SetEncodeRun();
		}
	}	

	// FILE RECORDING
	//

	CString strRecordName, strRecordPath;

	for ( i = 0 ; i < m_nChannelNum ; i++ ) 
	{ 
		strRecordName.Format( "RECORD%02d.AVI", i + 1 );

		strRecordPath = GetWorkingPath( strRecordName );

		m_pRecordAV[ i ]->SetChannelID( i + 1 );

		m_pRecordAV[ i ]->SetFilePathName( strRecordPath.GetBuffer( 256 ) );

		strRecordPath.ReleaseBuffer();		
	}

	for ( i = 0 ; i < m_nChannelNum ; i++ )
	{
		m_pHwEncodeAV[ i ]->SetRecordAV( m_pRecordAV[ i ] );

		m_pSwEncodeAV[ i ]->SetRecordAV( m_pRecordAV[ i ] );
	}

	for ( i = 0 ; i < m_nChannelNum ; i++ )
	{
		m_pLiveAV[ i ]->SetSwEncodeAV( m_pSwEncodeAV[ i ] );

		m_pLiveAV[ i ]->SetHwEncodeAV( m_pHwEncodeAV[ i ] );

		m_pLiveAV[ i ]->SetRecordAV( m_pRecordAV[ i ] );
	}
	for ( i = 0 ; i < m_nChannelNum ; i++ )
	{
		m_pLiveAV[ i ]->LiveRun();
	}
	
	EndWaitCursor();

	return TRUE;
}

BOOL CSecurity_DemoDlg::HwUnInitialize()
{
	BeginWaitCursor();

	ULONG i = 0;

	for ( i = 0 ; i < m_nChannelNum ; i++ )
	{
		if ( m_pLiveAV[ i ] != NULL )
		{			
			m_pLiveAV[ i ]->Disconnect();

			delete m_pLiveAV[ i ];

			m_pLiveAV[ i ] = NULL;
		}

		if ( m_pSwitchLiveAV[ i ] != NULL )
		{			
			m_pSwitchLiveAV[ i ]->Disconnect();

			delete m_pSwitchLiveAV[ i ];

			m_pSwitchLiveAV[ i ] = NULL;
		}

		if ( m_pRecordAV[ i ] != NULL )
		{			
			m_pRecordAV[ i ]->Disconnect();

			delete m_pRecordAV[ i ];

			m_pRecordAV[ i ] = NULL;
		}

		if ( m_pSwEncodeAV[ i ] != NULL )
		{			
			m_pSwEncodeAV[ i ]->Disconnect();

			delete m_pSwEncodeAV[ i ];

			m_pSwEncodeAV[ i ] = NULL;
		}

		if ( m_pHwEncodeAV[ i ] != NULL )
		{			
			m_pHwEncodeAV[ i ]->Disconnect();

			delete m_pHwEncodeAV[ i ];

			m_pHwEncodeAV[ i ] = NULL;
		}
	}

	EndWaitCursor();

	return TRUE;
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSecurity_DemoDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

BOOL CSecurity_DemoDlg::OnEraseBkgnd(CDC* pDC) 
{
	return TRUE;

	return CWnd::OnEraseBkgnd(pDC);
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSecurity_DemoDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BOOL CSecurity_DemoDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class

	if(pMsg->message == WM_KEYDOWN)
	{		
		if (pMsg->wParam == VK_ESCAPE)
		{
			SendMessage( WM_CLOSE, 0, 0 );

			return FALSE;
		}
	}
	
	return CDialog::PreTranslateMessage(pMsg);
}

CString CSecurity_DemoDlg::GetWorkingPath(CString strWorkFile)
{
	TCHAR szCurPath[MAX_PATH] = {0};

	GetModuleFileName(NULL, szCurPath, MAX_PATH);

	CString strCurPath = szCurPath;

	strCurPath = strCurPath.Left(strCurPath.ReverseFind('\\') + 1);

	strCurPath += strWorkFile;

	return strCurPath;
}

BOOL CSecurity_DemoDlg::IsFileExists(const TCHAR* pFile)
{
	WIN32_FIND_DATA FindFileData;

	HANDLE hFind = INVALID_HANDLE_VALUE;

	hFind = FindFirstFile(pFile, &FindFileData);

	if (hFind == INVALID_HANDLE_VALUE) 
	{	
		return FALSE;
	} 
	else 
	{
		FindClose(hFind);

		return TRUE;
	}
}

CStringVector CSecurity_DemoDlg::SplitString(const CString& strSource, const CString& delim, bool bRemoveNone)
{
	CStringVector strRows;	
	int nStart = 0;
	int delimLen = delim.GetLength();
	int nPos = strSource.Find(delim, nStart);		

	while(nPos >= 0)
	{	
		if(bRemoveNone) 
		{
			if(nPos > nStart)
			{
				strRows.push_back(strSource.Mid(nStart, nPos - nStart));	
			}
		}
		else 
		{
			strRows.push_back(strSource.Mid(nStart, nPos - nStart));		
		}

		nStart = nPos + delimLen;
		nPos = strSource.Find(delim, nStart);	
	}	
	
	int length = strSource.GetLength();

	if(bRemoveNone)
	{
		if(length > nStart)
		{
			strRows.push_back(strSource.Mid(nStart, length - nStart));
		}
	} 
	else
	{
		if(length >= nStart)
		{
			strRows.push_back(strSource.Mid(nStart, length - nStart));
		}
	}
	return strRows;
}

BOOL CSecurity_DemoDlg::OpenIniFile(CString strFilePath)
{
	m_pIniFile = NULL;

	TRY
	{
		m_pIniFile = new CStdioFile(strFilePath,  CFile::modeRead | CFile::typeText);
	}
	CATCH (CFileException, pFileException)
	{
		pFileException->ReportError();

		m_pIniFile = NULL;

		return FALSE;
	}
	END_CATCH

	return TRUE;
}


BOOL CSecurity_DemoDlg::CloseIniFile()
{
	if (m_pIniFile == NULL)
	{
		return FALSE;
	}

	m_pIniFile->Close();

	delete m_pIniFile;

	m_pIniFile = NULL;

	return TRUE;
}

void CSecurity_DemoDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	
	HBITMAP bmp1 = (HBITMAP)bmpChkedMenu.Detach(); 

	DeleteObject( bmp1 );

	HBITMAP bmp2 = (HBITMAP)bmpUnChkedMenu.Detach(); 

	DeleteObject( bmp2 );
	
	HwUnInitialize();
	
	ULONG i = 0;
	
	for ( i = 0 ; i < 32 ; i++ )
	{
		if (m_pOverlayWindow[ i ] != NULL)
		{
			CVRSDK_DESTROY_OVERLAY_BUFFER( m_oVideoWnd[ i ].m_pCustomChannelWindow, m_pOverlayWindow[ i ]  );

			m_pOverlayWindow[ i ] = NULL;
		}
	}	
	
	if ( m_pOverlayFullWindow != NULL )
	{
			CVRSDK_DESTROY_OVERLAY_BUFFER(  m_oFullVideoWnd.m_pCustomChannelWindow, m_pOverlayFullWindow  );

			m_pOverlayFullWindow = NULL;		
	}

	// RELEASE ALL RESOURCES OF THE VIDEO RENDERER
	//
	if( m_pCustomVideoRenderer1 ) { CVRSDK_DESTROY( m_pCustomVideoRenderer1 ); m_pCustomVideoRenderer1 = NULL; }

	if( m_pCustomVideoRenderer2 ) { CVRSDK_DESTROY( m_pCustomVideoRenderer2 ); m_pCustomVideoRenderer2 = NULL; }	

	if ( m_pViewManager ) { delete m_pViewManager;  m_pViewManager = NULL; }		
}

void CSecurity_DemoDlg::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

	POINT point2;

	GetCursorPos( &point2 );

	m_PopupMenu.TrackPopupMenu( TPM_LEFTALIGN | TPM_LEFTBUTTON, point2.x, point2.y, this);
	
	CDialog::OnRButtonDown(nFlags, point);
}

void CSecurity_DemoDlg::OnUseIndel()
{	
	if ( m_bUseIntelCodec )
	{
		// m_PopupMenu.ModifyMenu( IDM_USE_INTEL, MF_BYCOMMAND | MF_STRING, IDM_USE_INTEL, "YUAN CODEC");

		m_PopupMenu.SetMenuItemBitmaps( 0, MF_BYPOSITION, &bmpUnChkedMenu, &bmpChkedMenu);

		m_bUseIntelCodec = FALSE;
	}
	else
	{
		// m_PopupMenu.ModifyMenu( IDM_USE_INTEL, MF_BYCOMMAND | MF_STRING, IDM_USE_INTEL, "INTEL CODEC");

		m_PopupMenu.SetMenuItemBitmaps( 0, MF_BYPOSITION, &bmpChkedMenu, &bmpUnChkedMenu);
		
		m_bUseIntelCodec = TRUE;
	}
}

void CSecurity_DemoDlg::OnSaveAVI()
{
	if ( m_bSaveAVIFile )
	{
		m_PopupMenu.SetMenuItemBitmaps( 6, MF_BYPOSITION, &bmpUnChkedMenu, &bmpChkedMenu);
		
		m_bSaveAVIFile = FALSE;

		g_bSaveAVIFile = FALSE;
	}
	else
	{
		m_PopupMenu.SetMenuItemBitmaps( 6, MF_BYPOSITION, &bmpChkedMenu, &bmpUnChkedMenu);

		m_bSaveAVIFile = TRUE;

		g_bSaveAVIFile = TRUE;
	}
}

VOID CSecurity_DemoDlg::SwitchSwCodec()
{
	BeginWaitCursor();	

	ULONG i = 0;

	// CREATE SOFTWARE CODEC
	//
	if ( m_strChipName == "TW6802" || m_strChipName == "SA7160" || m_strChipName == "CX2581" )
	{
		for ( i = 0 ; i < m_nChannelNum ; i++ )
		{
			m_pSwEncodeAV[ i ]->Disconnect();
		}		

		if ( m_bUseIntelCodec )
		{
			if ( m_nSwitchType == NO_SWICTH_CARD ) { for ( i = 0 ; i < m_nChannelNum ; i++ ) { m_pLiveAV[ i ]->m_nDropFrame = m_IChInfo[ i ].nDropFrame; } }

			if ( m_nSwitchType == DOUBLE_SWITCH_CARD ) { for ( i = 0 ; i < m_nChannelNum / 2 ; i++ ) { m_pSwitchLiveAV[ i ]->m_nDropFrame = m_IChInfo[ i ].nDropFrame; } }

			if ( m_nSwitchType == QUAD_SWITCH_CARD ) { for ( i = 0 ; i < m_nChannelNum / 4 ; i++ ) { m_pSwitchLiveAV[ i ]->m_nDropFrame = m_IChInfo[ i ].nDropFrame; } }
		}
		else
		{
			if ( m_nSwitchType == NO_SWICTH_CARD ) { for ( i = 0 ; i < m_nChannelNum ; i++ ) { m_pLiveAV[ i ]->m_nDropFrame = m_YChInfo[ i ].nDropFrame; } }

			if ( m_nSwitchType == DOUBLE_SWITCH_CARD ) { for ( i = 0 ; i < m_nChannelNum / 2 ; i++ ) { m_pSwitchLiveAV[ i ]->m_nDropFrame = m_YChInfo[ i ].nDropFrame; } }

			if ( m_nSwitchType == QUAD_SWITCH_CARD ) { for ( i = 0 ; i < m_nChannelNum / 4 ; i++ ) { m_pSwitchLiveAV[ i ]->m_nDropFrame = m_YChInfo[ i ].nDropFrame; } }
		}

		for ( i = 0 ; i < m_nChannelNum ; i++ )
		{	
			if ( m_bUseIntelCodec )
			{
				// CBR
				//
				if ( m_IChInfo[ i ].nRecordMode == 2 ) 
				{
					m_pSwEncodeAV[ i ]->SetEncodeCBR( m_IChInfo[ i ].nBitRate, 1, m_IChInfo[ i ].nGop );
				}
			
				// VBR
				//
				if ( m_IChInfo[ i ].nRecordMode == 1 ) 
				{
					m_pSwEncodeAV[ i ]->SetEncodeVBR( m_IChInfo[ i ].nQuality, m_IChInfo[ i ].nGop );
				}		

				m_pSwEncodeAV[ i ]->SetEncodeVideoFormat(m_nColorSpace, m_nStandard, m_IChInfo[ i ].m_nFileWidth, m_IChInfo[ i ].m_nFileHeight, m_nBitCount, m_IChInfo[ i ].dFrameRate );
			}
			else
			{
				// CBR
				//
				if ( m_YChInfo[ i ].nRecordMode == 2 ) 
				{
					m_pSwEncodeAV[ i ]->SetEncodeCBR( m_YChInfo[ i ].nBitRate, 1, m_YChInfo[ i ].nGop );
				}
			
				// VBR
				//
				if ( m_YChInfo[ i ].nRecordMode == 1 ) 
				{
					m_pSwEncodeAV[ i ]->SetEncodeVBR( m_YChInfo[ i ].nQuality, m_YChInfo[ i ].nGop );
				}

				m_pSwEncodeAV[ i ]->SetEncodeVideoFormat(m_nColorSpace, m_nStandard, m_YChInfo[ i ].m_nFileWidth, m_YChInfo[ i ].m_nFileHeight, m_nBitCount, m_YChInfo[ i ].dFrameRate );
			}
		}

		for ( i = 0 ; i < m_nChannelNum ; i++ )
		{
			m_pSwEncodeAV[ i ]->m_bUseIntel = m_bUseIntelCodec;

			m_pSwEncodeAV[ i ]->Connect();
		}

		for ( i = 0 ; i < m_nChannelNum ; i++ )
		{
			m_pSwEncodeAV[ i ]->SetEncodeRun();
		}
	}

	EndWaitCursor();
}

void CSecurity_DemoDlg::OnCloseSystem()
{
	SendMessage(WM_CLOSE, 0, 0);	
}

void CSecurity_DemoDlg::OnRecordCH01()
{
	m_PopupMenu.EnableMenuItem(IDM_RECORD_CH01, MF_BYCOMMAND | MF_GRAYED);

	m_PopupMenu.EnableMenuItem(IDM_RECORD_ALL, MF_BYCOMMAND | MF_GRAYED);

	m_PopupMenu.EnableMenuItem(IDM_STOP_RECORD, MF_BYCOMMAND | MF_ENABLED);	

	m_bRecordCH01 = TRUE;	

	// IF SOFTWARE-COMPRESSED CARD , CREATE SOFTWARE CODEC 
	//
	SwitchSwCodec();

	ULONG i = 0;

	for ( i = 0 ; i < m_nChannelNum ; i++ )
	{
		if ( m_bUseIntelCodec && ( m_strChipName == "TW6802" || m_strChipName == "SA7160" || m_strChipName == "CX2581" ) )
		{
			m_pRecordAV[ i ]->SetRecordFormat( m_nColorSpace, m_IChInfo[ i ].m_nFileWidth, m_IChInfo[ i ].m_nFileHeight, 24, m_IChInfo[ i ].dFrameRate );
		}
		else
		{
			m_pRecordAV[ i ]->SetRecordFormat( m_nColorSpace, m_YChInfo[ i ].m_nFileWidth, m_YChInfo[ i ].m_nFileHeight, 24, m_YChInfo[ i ].dFrameRate );
		}
	}

	// RECORDING CH01
	//
	if ( m_pLiveAV[ 0 ] != NULL && m_nSwitchType == NO_SWICTH_CARD )
	{
		if ( m_pLiveAV[ 0 ]->GetChannelID() == 1 )
		{
			if ( m_strChipName == "AH8400" || m_strChipName == "FH8735" || m_strChipName == "TW5864" || m_strChipName == "TW2809" )
			{
				MyHwEncodeAV * pHwEncodeAV = m_pLiveAV[ 0 ]->GetHwEncodeAV();

				if ( pHwEncodeAV != NULL )
				{
					MyRecordAV * pMyRecord = pHwEncodeAV->GetRecordAV();

					if (pMyRecord != NULL)
					{
						pMyRecord->SetRecordRun();
					}
				}
			}

			if ( m_strChipName == "TW6802" || m_strChipName == "SA7160" || m_strChipName == "CX2581" )
			{
				MySwEncodeAV * pSwEncodeAV = m_pLiveAV[ 0 ]->GetSwEncodeAV();

				if ( pSwEncodeAV != NULL )
				{
					MyRecordAV * pMyRecord = pSwEncodeAV->GetRecordAV();

					if (pMyRecord != NULL)
					{
						pMyRecord->SetRecordRun();
					}
				}
			}

		}
	}

	// SWITCH CARD
	//
	if ( m_pSwitchLiveAV[ 0 ] != NULL && ( m_nSwitchType == DOUBLE_SWITCH_CARD || m_nSwitchType == QUAD_SWITCH_CARD ) )
	{
		if ( m_pSwitchLiveAV[ 0 ]->GetChannelID() == 1 )
		{
			if ( m_strChipName == "TW6802" || m_strChipName == "SA7160" || m_strChipName == "CX2581" )
			{
				MySwEncodeAV * pSwEncodeAV1 = m_pSwitchLiveAV[ 0 ]->m_pMySwEncodeAV1;

				MySwEncodeAV * pSwEncodeAV2 = m_pSwitchLiveAV[ 0 ]->m_pMySwEncodeAV2;

				MySwEncodeAV * pSwEncodeAV3 = m_pSwitchLiveAV[ 0 ]->m_pMySwEncodeAV3;

				MySwEncodeAV * pSwEncodeAV4 = m_pSwitchLiveAV[ 0 ]->m_pMySwEncodeAV4;

				if ( pSwEncodeAV1 != NULL && pSwEncodeAV2 != NULL && pSwEncodeAV3 != NULL && pSwEncodeAV4 != NULL )
				{
					MyRecordAV * pMyRecord1 = m_pSwitchLiveAV[ 0 ]->m_pRecordAV1;

					MyRecordAV * pMyRecord2 = m_pSwitchLiveAV[ 0 ]->m_pRecordAV2;

					MyRecordAV * pMyRecord3 = m_pSwitchLiveAV[ 0 ]->m_pRecordAV3;

					MyRecordAV * pMyRecord4 = m_pSwitchLiveAV[ 0 ]->m_pRecordAV4;

					if ( pMyRecord1 != NULL && pMyRecord2 != NULL && pMyRecord3 != NULL && pMyRecord4 != NULL )
					{
						pMyRecord1->SetRecordRun();

						pMyRecord2->SetRecordRun();

						pMyRecord3->SetRecordRun();

						pMyRecord4->SetRecordRun();
					}
				}
			}

		}
	}
}

void CSecurity_DemoDlg::OnRecordAll()
{
	m_PopupMenu.EnableMenuItem(IDM_RECORD_CH01, MF_BYCOMMAND | MF_GRAYED);

	m_PopupMenu.EnableMenuItem(IDM_RECORD_ALL, MF_BYCOMMAND | MF_GRAYED);

	m_PopupMenu.EnableMenuItem(IDM_STOP_RECORD, MF_BYCOMMAND | MF_ENABLED);	

	m_bRecordCH01 = FALSE;

	// IF SOFTWARE-COMPRESSED CARD , CREATE SOFTWARE CODEC 
	//
	SwitchSwCodec();

	ULONG i = 0;

	for ( i = 0 ; i < m_nChannelNum ; i++ )
	{
		if ( m_bUseIntelCodec && ( m_strChipName == "TW6802" || m_strChipName == "SA7160" || m_strChipName == "CX2581" ) )
		{
			m_pRecordAV[ i ]->SetRecordFormat( m_nColorSpace, m_IChInfo[ i ].m_nFileWidth, m_IChInfo[ i ].m_nFileHeight, 24, m_IChInfo[ i ].dFrameRate );
		}
		else
		{
			m_pRecordAV[ i ]->SetRecordFormat( m_nColorSpace, m_YChInfo[ i ].m_nFileWidth, m_YChInfo[ i ].m_nFileHeight, 24, m_YChInfo[ i ].dFrameRate );
		}
	}

	// RECORDING ALL CHANNEL
	//
	if ( m_strChipName == "AH8400" || m_strChipName == "FH8735" || m_strChipName == "TW5864" || m_strChipName == "TW2809" )
	{
		for ( i = 0 ; i < m_nChannelNum ; i++ )
		{
			if ( m_pLiveAV[ i ] != NULL )
			{
				MyHwEncodeAV * pHwEncodeAV = m_pLiveAV[ i ]->GetHwEncodeAV();

				if ( pHwEncodeAV != NULL )
				{
					MyRecordAV * pMyRecord = pHwEncodeAV->GetRecordAV();

					if (pMyRecord != NULL)
					{							
						pMyRecord->SetRecordRun();
					}
				}
			}
		}
	}	

	if ( m_strChipName == "TW6802" || m_strChipName == "SA7160" || m_strChipName == "CX2581" )
	{
		if ( m_nSwitchType == NO_SWICTH_CARD )
		{
			for ( i = 0 ; i < m_nChannelNum ; i++ )
			{
				if ( m_pLiveAV[ i ] != NULL )
				{
					MySwEncodeAV * pSwEncodeAV = m_pLiveAV[ i ]->GetSwEncodeAV();

					if ( pSwEncodeAV != NULL )
					{
						MyRecordAV * pMyRecord = pSwEncodeAV->GetRecordAV();

						if (pMyRecord != NULL)
						{							
							pMyRecord->SetRecordRun();
						}
					}
				}
			}
		}

		// DOUBLE SWITCH CARD
		//
		if ( m_nSwitchType == DOUBLE_SWITCH_CARD )
		{
			for ( i = 0 ; i < m_nChannelNum / 2 ; i++ )
			{
				if ( m_pSwitchLiveAV[ i ] != NULL )
				{
					MySwEncodeAV * pSwEncodeAV1 = m_pSwitchLiveAV[ i ]->m_pMySwEncodeAV1;

					MySwEncodeAV * pSwEncodeAV2 = m_pSwitchLiveAV[ i ]->m_pMySwEncodeAV2;

					if ( pSwEncodeAV1 != NULL && pSwEncodeAV2 != NULL )
					{
						MyRecordAV * pMyRecord1 = m_pSwitchLiveAV[ i ]->m_pRecordAV1;

						MyRecordAV * pMyRecord2 = m_pSwitchLiveAV[ i ]->m_pRecordAV2;

						if ( pMyRecord1 != NULL && pMyRecord2 != NULL )
						{
							pMyRecord1->SetRecordRun();

							pMyRecord2->SetRecordRun();
						}
					}
				}
			}
		}

		// QUAD SWITCH CARD
		//
		if ( m_nSwitchType == QUAD_SWITCH_CARD )
		{
			for ( i = 0 ; i < m_nChannelNum / 4 ; i++ )
			{
				if ( m_pSwitchLiveAV[ i ] != NULL )
				{
					MySwEncodeAV * pSwEncodeAV1 = m_pSwitchLiveAV[ i ]->m_pMySwEncodeAV1;

					MySwEncodeAV * pSwEncodeAV2 = m_pSwitchLiveAV[ i ]->m_pMySwEncodeAV2;

					MySwEncodeAV * pSwEncodeAV3 = m_pSwitchLiveAV[ i ]->m_pMySwEncodeAV3;

					MySwEncodeAV * pSwEncodeAV4 = m_pSwitchLiveAV[ i ]->m_pMySwEncodeAV4;

					if ( pSwEncodeAV1 != NULL && pSwEncodeAV2 != NULL && pSwEncodeAV3 != NULL && pSwEncodeAV4 != NULL )
					{
						MyRecordAV * pMyRecord1 = m_pSwitchLiveAV[ i ]->m_pRecordAV1;

						MyRecordAV * pMyRecord2 = m_pSwitchLiveAV[ i ]->m_pRecordAV2;

						MyRecordAV * pMyRecord3 = m_pSwitchLiveAV[ i ]->m_pRecordAV3;

						MyRecordAV * pMyRecord4 = m_pSwitchLiveAV[ i ]->m_pRecordAV4;

						if ( pMyRecord1 != NULL && pMyRecord2 != NULL && pMyRecord3 != NULL && pMyRecord4 != NULL )
						{
							pMyRecord1->SetRecordRun();

							pMyRecord2->SetRecordRun();

							pMyRecord3->SetRecordRun();

							pMyRecord4->SetRecordRun();
						}
					}
				}
			}
		}
	}	
}

void CSecurity_DemoDlg::OnStopRecord()
{
	m_PopupMenu.EnableMenuItem(IDM_RECORD_CH01, MF_BYCOMMAND | MF_ENABLED);

	m_PopupMenu.EnableMenuItem(IDM_RECORD_ALL, MF_BYCOMMAND | MF_ENABLED);

	m_PopupMenu.EnableMenuItem(IDM_STOP_RECORD, MF_BYCOMMAND | MF_GRAYED);	

	ULONG i = 0;

	// STOP RECORDING CH01
	//
	if ( m_bRecordCH01 == TRUE )
	{
		if ( m_pLiveAV[ 0 ] != NULL && m_nSwitchType == NO_SWICTH_CARD )
		{
			if ( m_pLiveAV[ 0 ]->GetChannelID() == 1 )
			{
				if ( m_strChipName == "AH8400" || m_strChipName == "FH8735" || m_strChipName == "TW5864" || m_strChipName == "TW2809" )
				{
					MyHwEncodeAV * pHwEncodeAV = m_pLiveAV[ 0 ]->GetHwEncodeAV();

					if ( pHwEncodeAV != NULL )
					{
						MyRecordAV * pMyRecord = pHwEncodeAV->GetRecordAV();

						if (pMyRecord != NULL)
						{
							pMyRecord->SetRecordStop();
						}
					}
				}

				if ( m_strChipName == "TW6802" || m_strChipName == "SA7160" || m_strChipName == "CX2581" )
				{
					MySwEncodeAV * pSwEncodeAV = m_pLiveAV[ 0 ]->GetSwEncodeAV();

					if ( pSwEncodeAV != NULL )
					{
						MyRecordAV * pMyRecord = pSwEncodeAV->GetRecordAV();

						if (pMyRecord != NULL)
						{
							pMyRecord->SetRecordStop();
						}
					}
				}
			}
		}

		// SWITCH CARD
		//
		if ( m_pSwitchLiveAV[ 0 ] != NULL && ( m_nSwitchType == DOUBLE_SWITCH_CARD || m_nSwitchType == QUAD_SWITCH_CARD )  )
		{
			if ( m_pSwitchLiveAV[ 0 ]->GetChannelID() == 1 )
			{
				if ( m_strChipName == "TW6802" || m_strChipName == "SA7160" || m_strChipName == "CX2581" )
				{
					MySwEncodeAV * pSwEncodeAV1 = m_pSwitchLiveAV[ 0 ]->m_pMySwEncodeAV1;

					MySwEncodeAV * pSwEncodeAV2 = m_pSwitchLiveAV[ 0 ]->m_pMySwEncodeAV2;

					MySwEncodeAV * pSwEncodeAV3 = m_pSwitchLiveAV[ 0 ]->m_pMySwEncodeAV3;

					MySwEncodeAV * pSwEncodeAV4 = m_pSwitchLiveAV[ 0 ]->m_pMySwEncodeAV4;

					if ( pSwEncodeAV1 != NULL && pSwEncodeAV2 != NULL && pSwEncodeAV3 != NULL && pSwEncodeAV4 != NULL )
					{
						MyRecordAV * pMyRecord1 = m_pSwitchLiveAV[ 0 ]->m_pRecordAV1;

						MyRecordAV * pMyRecord2 = m_pSwitchLiveAV[ 0 ]->m_pRecordAV2;

						MyRecordAV * pMyRecord3 = m_pSwitchLiveAV[ 0 ]->m_pRecordAV3;

						MyRecordAV * pMyRecord4 = m_pSwitchLiveAV[ 0 ]->m_pRecordAV4;

						if ( pMyRecord1 != NULL && pMyRecord2 != NULL && pMyRecord3 != NULL && pMyRecord4 != NULL )
						{
							pMyRecord1->SetRecordStop();

							pMyRecord2->SetRecordStop();

							pMyRecord3->SetRecordStop();

							pMyRecord4->SetRecordStop();
						}
					}
				}
			}
		}

		m_bRecordCH01 = FALSE;
	}
	// STOP RECORDING ALL CHANNEL
	//
	else if ( m_bRecordCH01 == FALSE )
	{
		if ( m_strChipName == "AH8400" || m_strChipName == "FH8735" || m_strChipName == "TW5864" || m_strChipName == "TW2809" )
		{
			for ( ULONG i = 0 ; i < m_nChannelNum ; i++ )
			{
				if ( m_pLiveAV[ i ] != NULL )
				{
					MyHwEncodeAV * pHwEncodeAV = m_pLiveAV[ i ]->GetHwEncodeAV();

					if ( pHwEncodeAV != NULL )
					{
						MyRecordAV * pMyRecord = pHwEncodeAV->GetRecordAV();

						if (pMyRecord != NULL)
						{
							pMyRecord->SetRecordStop();
						}
					}
				}
			}			
		}	

		if ( m_strChipName == "TW6802" || m_strChipName == "SA7160" || m_strChipName == "CX2581" )
		{
			if ( m_nSwitchType == NO_SWICTH_CARD )
			{
				for ( ULONG i = 0 ; i < m_nChannelNum ; i++ )
				{
					if ( m_pLiveAV[ i ] != NULL )
					{
						MySwEncodeAV * pSwEncodeAV = m_pLiveAV[ i ]->GetSwEncodeAV();

						if ( pSwEncodeAV != NULL )
						{
							MyRecordAV * pMyRecord = pSwEncodeAV->GetRecordAV();

							if (pMyRecord != NULL)
							{
								pMyRecord->SetRecordStop();
							}
						}
					}
				}
			}

			// DOUBLE SWITCH CARD
			//
			if ( m_nSwitchType == DOUBLE_SWITCH_CARD )
			{
				for ( i = 0 ; i < m_nChannelNum / 2 ; i++ )
				{
					if ( m_pSwitchLiveAV[ i ] != NULL )
					{
						MySwEncodeAV * pSwEncodeAV1 = m_pSwitchLiveAV[ i ]->m_pMySwEncodeAV1;

						MySwEncodeAV * pSwEncodeAV2 = m_pSwitchLiveAV[ i ]->m_pMySwEncodeAV2;

						if ( pSwEncodeAV1 != NULL && pSwEncodeAV2 != NULL )
						{
							MyRecordAV * pMyRecord1 = m_pSwitchLiveAV[ i ]->m_pRecordAV1;

							MyRecordAV * pMyRecord2 = m_pSwitchLiveAV[ i ]->m_pRecordAV2;

							if ( pMyRecord1 != NULL && pMyRecord2 != NULL )
							{
								pMyRecord1->SetRecordStop();

								pMyRecord2->SetRecordStop();
							}
						}
					}
				}
			}

			// QUAD SWITCH CARD
			//
			if ( m_nSwitchType == QUAD_SWITCH_CARD )
			{
				for ( i = 0 ; i < m_nChannelNum / 4 ; i++ )
				{
					if ( m_pSwitchLiveAV[ i ] != NULL )
					{
						MySwEncodeAV * pSwEncodeAV1 = m_pSwitchLiveAV[ i ]->m_pMySwEncodeAV1;

						MySwEncodeAV * pSwEncodeAV2 = m_pSwitchLiveAV[ i ]->m_pMySwEncodeAV2;

						MySwEncodeAV * pSwEncodeAV3 = m_pSwitchLiveAV[ i ]->m_pMySwEncodeAV3;

						MySwEncodeAV * pSwEncodeAV4 = m_pSwitchLiveAV[ i ]->m_pMySwEncodeAV4;

						if ( pSwEncodeAV1 != NULL && pSwEncodeAV2 != NULL && pSwEncodeAV3 != NULL && pSwEncodeAV4 != NULL )
						{
							MyRecordAV * pMyRecord1 = m_pSwitchLiveAV[ i ]->m_pRecordAV1;

							MyRecordAV * pMyRecord2 = m_pSwitchLiveAV[ i ]->m_pRecordAV2;

							MyRecordAV * pMyRecord3 = m_pSwitchLiveAV[ i ]->m_pRecordAV3;

							MyRecordAV * pMyRecord4 = m_pSwitchLiveAV[ i ]->m_pRecordAV4;

							if ( pMyRecord1 != NULL && pMyRecord2 != NULL && pMyRecord3 != NULL && pMyRecord4 != NULL )
							{
								pMyRecord1->SetRecordStop();

								pMyRecord2->SetRecordStop();

								pMyRecord3->SetRecordStop();

								pMyRecord4->SetRecordStop();
							}
						}
					}
				}
			}
		}	
	}
}

void CSecurity_DemoDlg::OnShowInfo()
{
	if ( m_bShowInfo == FALSE )
	{
		m_PopupMenu.ModifyMenu( IDM_SHOW_INFO, MF_BYCOMMAND | MF_STRING, IDM_SHOW_INFO, "HIDE FRAMERATE" );

		m_bShowInfo = TRUE;

		m_ShowInfoDlg.ShowWindow( SW_SHOW );
	}
	else if ( m_bShowInfo == TRUE )
	{
		m_PopupMenu.ModifyMenu( IDM_SHOW_INFO, MF_BYCOMMAND | MF_STRING, IDM_SHOW_INFO, "SHOW FRAMERATE" );

		m_bShowInfo = FALSE;

		m_ShowInfoDlg.ShowWindow( SW_HIDE );
	}	
}

void CSecurity_DemoDlg::OnPlayback()
{
	// GET WORKING RECORD FOLDER
	//
	TCHAR szCurPath[MAX_PATH] = {0};

	GetModuleFileName(NULL, szCurPath, MAX_PATH);

	CString strCurPath = szCurPath;

	strCurPath = strCurPath.Left(strCurPath.ReverseFind('\\') + 1);

	// OPEN ASSIGNED FOLDER IN FILE BROWSER

	TCHAR szWinDir[ MAX_PATH ], szExplorer[ MAX_PATH ];

	GetWindowsDirectory( szWinDir, MAX_PATH );

	sprintf( szExplorer, "%s\\EXPLORER.EXE", szWinDir );	

	ShellExecute(NULL, "open", strCurPath, NULL, NULL, SW_SHOWNORMAL);
}

void CSecurity_DemoDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default	

	/*
	if( nIDEvent == 0x00000000 ) 
	{
		KillTimer( 0x00000000 );

		// DRAW TIME INFORMATION ON CHANNEL WINDOW
		//
		ULONG i = 0;

		CWnd * pFullWnd = CWnd::FromHandle( m_oFullVideoWnd );

		HDC hMemoryDC = NULL;

		if ( pFullWnd && pFullWnd->GetSafeHwnd() != NULL )
		{
			if ( pFullWnd->IsWindowVisible() )
			{
				if ( g_pCustomChannelFullWindow != NULL )
					{
						if( CVRSDK_LOCK_OVERLAY_BUFFER( g_pCustomChannelFullWindow, m_pOverlayFullWindow, &hMemoryDC ) == TRUE ) 
					{
						SYSTEMTIME s_system_time; GetLocalTime( &s_system_time );

						SolidBrush o_solid_brush_black( Color( 255,   0,   0,   0 ) );

						SolidBrush o_solid_brush_white( Color( 255, 255, 255, 255 ) );
		
						Font o_font( L"Terminal", 12, FontStyleBold );
				
						Graphics graphics( hMemoryDC );

						graphics.SetSmoothingMode( SmoothingModeHighSpeed );

						graphics.SetInterpolationMode( InterpolationModeLowQuality );
								
						WCHAR psz[ 32 ];
					
						swprintf( psz, L"CH%02d %02d:%02d:%02d", m_nActiveFullWndCH + 1,  s_system_time.wHour, s_system_time.wMinute, s_system_time.wSecond );
									
						graphics.DrawString( psz, -1, &o_font, RectF( 0, 1, 640, 48 ), NULL, &o_solid_brush_black );

						graphics.DrawString( psz, -1, &o_font, RectF( 1, 0, 640, 48 ), NULL, &o_solid_brush_black );

						graphics.DrawString( psz, -1, &o_font, RectF( 2, 1, 640, 48 ), NULL, &o_solid_brush_black );

						graphics.DrawString( psz, -1, &o_font, RectF( 1, 2, 640, 48 ), NULL, &o_solid_brush_black );

						graphics.DrawString( psz, -1, &o_font, RectF( 1, 1, 640, 48 ), NULL, &o_solid_brush_white );

						CVRSDK_UNLOCK_OVERLAY_BUFFER( g_pCustomChannelFullWindow, m_pOverlayFullWindow, hMemoryDC );

						CVRSDK_SHOW_OVERLAY_BUFFER( g_pCustomChannelFullWindow, m_pOverlayFullWindow, TRUE, 0, 0 );			
					}
				}
			}
			else
			{
				for ( i = 0 ; i < m_nChannelNum ; i++ )
				{
					// DYNAMIC OVERYLAY
					//
					if( CVRSDK_LOCK_OVERLAY_BUFFER( m_oVideoWnd[ i ].m_pCustomChannelWindow, m_pOverlayWindow[ i ], &hMemoryDC ) == TRUE ) 
					{ 				
							SYSTEMTIME s_system_time; GetLocalTime( &s_system_time );

							SolidBrush o_solid_brush_black( Color( 255,   0,   0,   0 ) );

							SolidBrush o_solid_brush_white( Color( 255, 255, 255, 255 ) );
					
							Font o_font( L"Terminal", 12, FontStyleBold );
				
							Graphics graphics( hMemoryDC );

							graphics.SetSmoothingMode( SmoothingModeHighSpeed );

							graphics.SetInterpolationMode( InterpolationModeLowQuality );
								
							WCHAR psz[ 32 ];
					
							swprintf( psz, L"CH%02d %02d:%02d:%02d", i + 1, s_system_time.wHour, s_system_time.wMinute, s_system_time.wSecond );
					
							graphics.DrawString( psz, -1, &o_font, RectF( 0, 1, 640, 48 ), NULL, &o_solid_brush_black );

							graphics.DrawString( psz, -1, &o_font, RectF( 1, 0, 640, 48 ), NULL, &o_solid_brush_black );

							graphics.DrawString( psz, -1, &o_font, RectF( 2, 1, 640, 48 ), NULL, &o_solid_brush_black );

							graphics.DrawString( psz, -1, &o_font, RectF( 1, 2, 640, 48 ), NULL, &o_solid_brush_black );

							graphics.DrawString( psz, -1, &o_font, RectF( 1, 1, 640, 48 ), NULL, &o_solid_brush_white );

							CVRSDK_UNLOCK_OVERLAY_BUFFER( m_oVideoWnd[ i ].m_pCustomChannelWindow, m_pOverlayWindow[ i ], hMemoryDC );

							CVRSDK_SHOW_OVERLAY_BUFFER( m_oVideoWnd[ i ].m_pCustomChannelWindow, m_pOverlayWindow[ i ], TRUE, 0, 0 );					
					}
				}
			}
		}

		SetTimer( 0x00000000, 1000, NULL );	
	}	
	*/
	
	CDialog::OnTimer(nIDEvent);
}

void CSecurity_DemoDlg::SmallWindowToFullWindow()
{
	HDC hMemoryDC = NULL;

	ULONG i = 0;

	for ( i = 0 ; i < m_nChannelNum ; i++ )
	{					
		if( CVRSDK_LOCK_OVERLAY_BUFFER( m_oVideoWnd[ i ].m_pCustomChannelWindow, m_pOverlayWindow[ i ], &hMemoryDC ) == TRUE ) 
		{
			CVRSDK_UNLOCK_OVERLAY_BUFFER( m_oVideoWnd[ i ].m_pCustomChannelWindow, m_pOverlayWindow[ i ], hMemoryDC );
		}
	}
}

void CSecurity_DemoDlg::FullWindowToSmallWindow()
{
	HDC hMemoryDC = NULL;

	if( CVRSDK_LOCK_OVERLAY_BUFFER( g_pCustomChannelFullWindow, m_pOverlayFullWindow, &hMemoryDC ) == TRUE )
	{
		CVRSDK_UNLOCK_OVERLAY_BUFFER( g_pCustomChannelFullWindow, m_pOverlayFullWindow, hMemoryDC );
	}
}