// NetBroadcasterDlg.cpp : implementation file
//

#include "stdafx.h"
#include "NetBroadcaster.h"
#include "NetBroadcasterDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

QRETURN on_no_signal_detected_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);

	pNetBroadcasterDlg->m_nVideoWidth = 0;
	
	pNetBroadcasterDlg->m_nVideoHeight = 0;
	
	pNetBroadcasterDlg->m_bVideoIsInterleaved = FALSE;
	
	pNetBroadcasterDlg->m_dVideoFrameRate = 0.0;
	
	pNetBroadcasterDlg->m_nAudioChannels = 0; 
	
	pNetBroadcasterDlg->m_nAudioBitsPerSample = 0;
	
	pNetBroadcasterDlg->m_nAudioSampleFrequency = 0;

	pNetBroadcasterDlg->m_statFormat.SetWindowText( "INFO: ..." );

	return QCAP_RT_OK;
}

QRETURN on_no_signal_removed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);

	pNetBroadcasterDlg->m_nVideoWidth = 0;
	
	pNetBroadcasterDlg->m_nVideoHeight = 0;
	
	pNetBroadcasterDlg->m_bVideoIsInterleaved = FALSE;
	
	pNetBroadcasterDlg->m_dVideoFrameRate = 0.0;
	
	pNetBroadcasterDlg->m_nAudioChannels = 0; 
	
	pNetBroadcasterDlg->m_nAudioBitsPerSample = 0;
	
	pNetBroadcasterDlg->m_nAudioSampleFrequency = 0;

	pNetBroadcasterDlg->m_statFormat.SetWindowText( "INFO: ..." );

	return QCAP_RT_OK;
}    

QRETURN on_format_changed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample, ULONG nAudioSampleFrequency, PVOID pUserData )
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);

	pNetBroadcasterDlg->m_nVideoWidth = nVideoWidth;
	
	pNetBroadcasterDlg->m_nVideoHeight = nVideoHeight;
	
	pNetBroadcasterDlg->m_bVideoIsInterleaved = bVideoIsInterleaved;
	
	pNetBroadcasterDlg->m_dVideoFrameRate = dVideoFrameRate;
	
	pNetBroadcasterDlg->m_nAudioChannels = nAudioChannels; 
	
	pNetBroadcasterDlg->m_nAudioBitsPerSample = nAudioBitsPerSample;
	
	pNetBroadcasterDlg->m_nAudioSampleFrequency = nAudioSampleFrequency;

	CHAR psz[ MAX_PATH ];

	if( bVideoIsInterleaved == TRUE ) {

		sprintf( psz, "INFO: %dx%dI@%2.3fFPS, %dx%dBITSx%dHZ", nVideoWidth, nVideoHeight * 1, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency );

		pNetBroadcasterDlg->m_statFormat.SetWindowText( psz );
	}
	else {

		sprintf( psz, "INFO: %dx%dP@%2.3fFPS, %dx%dBITSx%dHZ", nVideoWidth, nVideoHeight * 1, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency );

		pNetBroadcasterDlg->m_statFormat.SetWindowText( psz );
	}
	return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);
	
	EnterCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSection );

		if( pNetBroadcasterDlg->m_nNetworkServerState > 0x00000000 ) {

			QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 0, QCAP_COLORSPACE_TYEP_YUY2, pNetBroadcasterDlg->m_nVideoWidth, pNetBroadcasterDlg->m_nVideoHeight, pFrameBuffer, nFrameBufferLen );

			QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 1, QCAP_COLORSPACE_TYEP_YUY2, pNetBroadcasterDlg->m_nVideoWidth, pNetBroadcasterDlg->m_nVideoHeight, pFrameBuffer, nFrameBufferLen );
		}

	LeaveCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSection );

    return QCAP_RT_OK;
}

// PREVIEW AUDIO CALLBACK FUNCTION
//
QRETURN on_audio_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);

	EnterCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSection );

	if( pNetBroadcasterDlg->m_nNetworkServerState > 0x00000000 ) {

		QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 0, pFrameBuffer, nFrameBufferLen );

		QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 1, pFrameBuffer, nFrameBufferLen );
	}
	LeaveCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSection );

    return QCAP_RT_OK;
}

//CLIENT

QRETURN on_audio_broadcast_client_callback( PVOID pClient, double dSampleTime, BYTE * pStreamBuffer, ULONG nStreamBufferLen, PVOID pUserData )
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);

	EnterCriticalSection( &pNetBroadcasterDlg->m_hrecordCriticalSection );

	pNetBroadcasterDlg->m_nNetworkAudioStreamSize += nStreamBufferLen;

	pNetBroadcasterDlg->m_nNetworkAudioFrames++;

	if( (pStreamBuffer) && (pNetBroadcasterDlg->m_recordState> 0x00000000) )
	{
		QCAP_SET_AUDIO_SHARE_RECORD_COMPRESSION_BUFFER( 0, pStreamBuffer, nStreamBufferLen );
	}

	LeaveCriticalSection( &pNetBroadcasterDlg->m_hrecordCriticalSection );

	return QCAP_RT_OK;
}

QRETURN on_audio_decoder_broadcast_client_callback( PVOID pClient, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	CNetBroadcasterDlg * pNetBroadcasterDlg = (CNetBroadcasterDlg *)(pUserData);

	pNetBroadcasterDlg->m_nNetworkAudioDecoderFrames++;

	return QCAP_RT_OK;
}

extern CNetBroadcasterApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetBroadcasterDlg dialog

CNetBroadcasterDlg::CNetBroadcasterDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNetBroadcasterDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNetBroadcasterDlg)
	m_nProtocol = -1;
	m_nPort_RTSPOverHTTP = 0;
	m_nPort_RTSP = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CNetBroadcasterDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNetBroadcasterDlg)
	DDX_Control(pDX, IDC_STATIC_FORMAT, m_statFormat);
	DDX_Control(pDX, IDC_STATIC_DISPLAY_WINDOW, m_statDisplayWindow);
	DDX_Text(pDX, IDC_EDIT_HTTP, m_nPort_RTSPOverHTTP);
	DDV_MinMaxDWord(pDX, m_nPort_RTSPOverHTTP, 0, 65535);
	DDX_Text(pDX, IDC_EDIT_RTSP, m_nPort_RTSP);
	DDV_MinMaxDWord(pDX, m_nPort_RTSP, 0, 65535);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_CHECK_SERVER_AUDIO_DISPLAY, m_server_audio_display);
	DDX_Control(pDX, IDC_EDIT_URL, m_editURL);
	DDX_Control(pDX, IDC_STATIC_AUDIO_INFO, m_statAudioInfo);
	DDX_Radio(pDX, IDC_RADIO_UDP, m_nProtocol);
}

BEGIN_MESSAGE_MAP(CNetBroadcasterDlg, CDialog)
	//{{AFX_MSG_MAP(CNetBroadcasterDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_START, OnButtonStart)
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnButtonStop)
	//}}AFX_MSG_MAP
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_CHECK_SERVER_AUDIO_DISPLAY, &CNetBroadcasterDlg::OnServerAudioDisplay)
	ON_BN_CLICKED(IDC_BUTTON_SERVER_START_RECORD, &CNetBroadcasterDlg::OnServerStartRecord)
	ON_BN_CLICKED(IDC_BUTTON_SERVER_STOP_RECORD, &CNetBroadcasterDlg::OnServerStopRecord)
	ON_BN_CLICKED(IDC_BUTTON_START_CLIENT, &CNetBroadcasterDlg::OnButtonStartClient)
	ON_BN_CLICKED(IDC_BUTTON_STOP_CLIENT, &CNetBroadcasterDlg::OnButtonStopClient)
	ON_BN_CLICKED(IDC_BUTTON_CLIENT_START_RECORD, &CNetBroadcasterDlg::OnClientStartRecord)
	ON_BN_CLICKED(IDC_BUTTON_CLIENT_STOP_RECORD, &CNetBroadcasterDlg::OnClientStopRecord)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetBroadcasterDlg message handlers

BOOL CNetBroadcasterDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// INITIALIZE COM LIBRARY
	//
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE MEMBER VARIABLES
	//
	InitializeCriticalSection( &m_hNetworkServerAccessCriticalSection );

	InitializeCriticalSection( &m_hrecordCriticalSection );

	m_pDevice = NULL;

	m_hNetworkServer = NULL;

	m_nNetworkServerState = 0x00000000;

	m_recordState = 0x00000000;

	m_nVideoWidth = 0;
	
	m_nVideoHeight = 0;
	
	m_bVideoIsInterleaved = FALSE;
	
	m_dVideoFrameRate = 0.0;
	
	m_nAudioChannels = 0; 
	
	m_nAudioBitsPerSample = 0;
	
	m_nAudioSampleFrequency = 0;

	//server audio
	m_server_audio = FALSE;

	m_nPort_RTSP = theApp.GetProfileInt( "DEFAULT", "PORT.RTSP", 554 );

	m_nPort_RTSPOverHTTP = theApp.GetProfileInt( "DEFAULT", "PORT.HTTP", 8080 );

	GetDlgItem( IDC_BUTTON_START )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( FALSE );

	//CLIENT
	m_editURL.SetWindowText( theApp.GetProfileString( "DEFAULT", "URL", "rtsp://root:root@127.0.0.1:1000/session0.mpg" ) );

	m_nProtocol = theApp.GetProfileInt( "DEFAULT", "PROTOCOL", 0 );

	m_nNetworkAudioStreamSize = 0;

	m_nNetworkAudioFrames = 0;

	m_nNetworkAudioDecoderFrames = 0;

	m_pNetworkReceiver = NULL;

	UpdateData( FALSE );

	//RECORD

	GetDlgItem( IDC_BUTTON_SERVER_START_RECORD )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_SERVER_STOP_RECORD )->EnableWindow( FALSE );

	//CLIENT
	GetDlgItem( IDC_BUTTON_START_CLIENT )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP_CLIENT )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_CLIENT_START_RECORD )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_CLIENT_STOP_RECORD )->EnableWindow( FALSE );

	// INITIALIZE DEVICE RESOURCE
	//
	QCAP_CREATE( "SA7160 PCI", 0, m_statDisplayWindow.m_hWnd, &m_pDevice, TRUE );

	QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevice, on_format_changed_callback, this );

	QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevice, on_no_signal_detected_callback, this );

	QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevice, on_no_signal_removed_callback, this );

    QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevice, on_video_preview_callback, this );

    QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevice, on_audio_preview_callback, this );

	QCAP_SET_VIDEO_INPUT( m_pDevice, QCAP_INPUT_TYPE_AUTO );

	QCAP_SET_AUDIO_INPUT( m_pDevice, QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

	m_server_audio = m_server_audio_display.GetCheck();

	if(m_server_audio)
	{
		QCAP_SET_AUDIO_VOLUME( m_pDevice, 100 );
	}
	else
	{
		QCAP_SET_AUDIO_VOLUME( m_pDevice, 0 );
	}

	QCAP_RUN( m_pDevice );

	SetTimer( 0x00000000, 1000, NULL );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CNetBroadcasterDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	
	// UNINITIALIZE DEVICE RESOURCE
	//
	OnButtonStop();

	OnServerStopRecord();

	OnClientStopRecord();

	OnButtonStopClient();

	KillTimer( 0x00000000 );

	if( m_pDevice ) {

		QCAP_STOP( m_pDevice );

		QCAP_DESTROY( m_pDevice );

		m_pDevice = NULL;
	}

	// UNINITIALIZE MEMBER VARIABLES
	//
	UpdateData( TRUE );

	theApp.WriteProfileInt( "DEFAULT", "PORT.RTSP", m_nPort_RTSP );

	theApp.WriteProfileInt( "DEFAULT", "PORT.HTTP", m_nPort_RTSPOverHTTP );

	DeleteCriticalSection( &m_hNetworkServerAccessCriticalSection );

	//CLIENT
	CString strURL;

	m_editURL.GetWindowText( strURL );

	theApp.WriteProfileString( "DEFAULT", "URL", (LPCTSTR)(strURL) );

	theApp.WriteProfileInt( "DEFAULT", "PROTOCOL", m_nProtocol );

	DeleteCriticalSection( &m_hrecordCriticalSection );

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();
}

void CNetBroadcasterDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CNetBroadcasterDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CNetBroadcasterDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CNetBroadcasterDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CNetBroadcasterDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CNetBroadcasterDlg::OnButtonStart() 
{
	// TODO: Add your control notification handler code here
	
	UpdateData( TRUE );

	OnButtonStop();

	if( m_nVideoWidth == 0 ) { return ; }

	if( m_nVideoHeight == 0 ) { return ; }

	QCAP_CREATE_BROADCAST_RTSP_SERVER( 0, 2 /*2 CHANNELS*/, &m_hNetworkServer, "root", "root", m_nPort_RTSP, m_nPort_RTSPOverHTTP );

//	QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 1280, 720, 30, QCAP_RECORD_MODE_CBR, 8000, 8000000, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );
//
//	QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2,  640, 360, 30, QCAP_RECORD_MODE_CBR, 8000, 3000000, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

	QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 1280, 720, 30, QCAP_RECORD_MODE_CBR, 8000, 8000000, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

	QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2,  640, 360, 30, QCAP_RECORD_MODE_CBR, 8000, 2000000, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

	QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency, 0 );

	QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency, 0 );

	QCAP_START_BROADCAST_SERVER( m_hNetworkServer );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSection );

	m_nNetworkServerState = 0x00000001;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection );

	GetDlgItem( IDC_BUTTON_START )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( TRUE );

}

void CNetBroadcasterDlg::OnButtonStop() 
{
	// TODO: Add your control notification handler code here

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSection );

	m_nNetworkServerState = 0x00000000;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection );

	if ( m_hNetworkServer != NULL ) {

		QCAP_STOP_BROADCAST_SERVER( m_hNetworkServer );

		QCAP_DESTROY_BROADCAST_SERVER( m_hNetworkServer );

		m_hNetworkServer = NULL;
	}
	GetDlgItem( IDC_BUTTON_START )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( FALSE );
}


void CNetBroadcasterDlg::OnServerAudioDisplay()
{
	// TODO: Add your control notification handler code here

	m_server_audio = m_server_audio_display.GetCheck();

	if(m_server_audio)
	{
		QCAP_SET_AUDIO_VOLUME( m_pDevice, 100 );
	}
	else
	{
		QCAP_SET_AUDIO_VOLUME( m_pDevice, 0 );
	}
}


void CNetBroadcasterDlg::OnServerStartRecord()
{
	// TODO: Add your control notification handler code here

	OnServerStopRecord();

	QCAP_SET_VIDEO_RECORD_PROPERTY( m_pDevice, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12*1024* 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF);

	QCAP_SET_AUDIO_RECORD_PROPERTY( m_pDevice, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC);

	QCAP_START_RECORD( m_pDevice, 0, "record_server.MP4" );

	GetDlgItem( IDC_BUTTON_SERVER_START_RECORD )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_SERVER_STOP_RECORD )->EnableWindow( TRUE );

}


void CNetBroadcasterDlg::OnServerStopRecord()
{
	// TODO: Add your control notification handler code here

	if( m_pDevice )
	{
		QCAP_STOP_RECORD( m_pDevice, 0 );
	}

	GetDlgItem( IDC_BUTTON_SERVER_START_RECORD )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_SERVER_STOP_RECORD )->EnableWindow( FALSE );
}

void CNetBroadcasterDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default

	CHAR psz[ MAX_PATH ];

	sprintf( psz, "AUDIO: %d KB (%d / %d)", (ULONG)(m_nNetworkAudioStreamSize / 1024), m_nNetworkAudioFrames, m_nNetworkAudioDecoderFrames );

	m_statAudioInfo.SetWindowText( psz );

	CDialog::OnTimer(nIDEvent);
}


void CNetBroadcasterDlg::OnButtonStartClient()
{
	// TODO: Add your control notification handler code here

	OnButtonStopClient();

	m_pNetworkReceiver = NULL;

	m_nNetworkAudioStreamSize = 0;

	m_nNetworkAudioFrames = 0;

	m_nNetworkAudioDecoderFrames = 0;

	UpdateData( TRUE );

	CString strURL;

	m_editURL.GetWindowText( strURL );

	CHAR psz[ MAX_PATH ];

	sprintf( psz, "%s", strURL );

	QCAP_CREATE_BROADCAST_CLIENT( 0, psz, &m_pNetworkReceiver, QCAP_ENCODER_TYPE_SOFTWARE, m_statDisplayWindow.m_hWnd, TRUE );

	QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK( m_pNetworkReceiver, on_audio_broadcast_client_callback, this );

	QCAP_REGISTER_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK( m_pNetworkReceiver, on_audio_decoder_broadcast_client_callback, this );

	if( m_nProtocol == 0 ) { QCAP_START_BROADCAST_CLIENT( m_pNetworkReceiver, QCAP_BROADCAST_PROTOCOL_UDP ); }

	if( m_nProtocol == 1 ) { QCAP_START_BROADCAST_CLIENT( m_pNetworkReceiver, QCAP_BROADCAST_PROTOCOL_TCP ); }	

	if( m_nProtocol == 2 ) { QCAP_START_BROADCAST_CLIENT( m_pNetworkReceiver, QCAP_BROADCAST_PROTOCOL_HTTP ); }

	GetDlgItem( IDC_BUTTON_START_CLIENT )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_STOP_CLIENT )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_CLIENT_START_RECORD )->EnableWindow( TRUE );
}


void CNetBroadcasterDlg::OnButtonStopClient()
{
	// TODO: Add your control notification handler code here

	OnClientStopRecord();

	if( m_pNetworkReceiver ) {

		QCAP_STOP_BROADCAST_CLIENT( m_pNetworkReceiver );

		QCAP_DESTROY_BROADCAST_CLIENT( m_pNetworkReceiver );

		m_pNetworkReceiver = NULL;
	}

	GetDlgItem( IDC_BUTTON_START_CLIENT )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP_CLIENT )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_CLIENT_START_RECORD )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_CLIENT_STOP_RECORD )->EnableWindow( FALSE );
}


void CNetBroadcasterDlg::OnClientStartRecord()
{
	// TODO: Add your control notification handler code here

	OnClientStopRecord();

	if( m_pNetworkReceiver ) {

		QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 0, 0, m_dVideoFrameRate, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, NULL, 1 );

		QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 100 );

		QCAP_START_SHARE_RECORD(0, "client_mic.MP4", QCAP_RECORD_FLAG_FILE | QCAP_RECORD_FLAG_ENCODE | QCAP_RECORD_FLAG_AUDIO_ONLY);

		EnterCriticalSection( &m_hrecordCriticalSection );

	    m_recordState = 0x00000001;

	    LeaveCriticalSection( &m_hrecordCriticalSection );

	}

	GetDlgItem( IDC_BUTTON_CLIENT_START_RECORD )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_CLIENT_STOP_RECORD )->EnableWindow( TRUE );
}


void CNetBroadcasterDlg::OnClientStopRecord()
{
	// TODO: Add your control notification handler code here

	if( m_pNetworkReceiver ) {

		QCAP_STOP_SHARE_RECORD(0);

		EnterCriticalSection( &m_hrecordCriticalSection );

	    m_recordState = 0x00000000;

	    LeaveCriticalSection( &m_hrecordCriticalSection );
	}

	GetDlgItem( IDC_BUTTON_CLIENT_START_RECORD )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_CLIENT_STOP_RECORD )->EnableWindow( FALSE );
}
