// SetupDialog.cpp : implementation file
//

#include "stdafx.h"
#include "netproxy.h"
#include "NetProxyDlg.h"
#include "SetupDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSetupDialog dialog

extern CNetProxyApp theApp;

CSetupDialog::CSetupDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CSetupDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetupDialog)
	//}}AFX_DATA_INIT
}


void CSetupDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetupDialog)
	DDX_Control(pDX, IDC_EDIT_PORT, m_editPort);
	DDX_Control(pDX, IDC_BUTTON_CONNECT, m_btnConnect);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSetupDialog, CDialog)
	//{{AFX_MSG_MAP(CSetupDialog)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_CONNECT, OnConnect)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetupDialog message handlers

void CSetupDialog::OnCancel() 
{
	// TODO: Add extra cleanup here
	
//	CDialog::OnCancel();
}

void CSetupDialog::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

BOOL CSetupDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	CHAR psz[ MAX_PATH ];

	ULONG cx = 88;

	ULONG cy = 22;

	ULONG xo = 0;

	ULONG yo = 0;

	m_ipAddress.Create( WS_CHILD | WS_VISIBLE, CRect( xo + (cx * 0), yo + (cy * 0), (int)(cx * 3.5), cy ), this, 0x00000000 );

	m_ipAddress.MoveWindow( xo + (cx * 0), yo + (cy * 0), (int)(cx * 3.5), cy );

	m_editPort.MoveWindow( xo + (int)(cx * 3.5), yo + (cy * 0), cx, cy );

	m_btnConnect.MoveWindow( xo + (int)(cx * 4.5), yo + (cy * 0), cx, cy );

	DWORD dw_ip = theApp.GetProfileInt( "DEFAULT", "ADDRESS", 0x7F000001 );

	USHORT w_port = theApp.GetProfileInt( "DEFAULT", "PORT", 554 );

	m_ipAddress.SetAddress( (BYTE)(dw_ip >> 24), (BYTE)(dw_ip >> 16), (BYTE)(dw_ip >> 8), (BYTE)(dw_ip >> 0) );

	m_editPort.SetWindowText( itoa( w_port, psz, 10 ) );

	m_editPort.SetLimitText( 5 );

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSetupDialog::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	
	DWORD dw_ip = 0;

	USHORT w_port = 0;

	GetNetworkParameters( &dw_ip, &w_port );

	theApp.WriteProfileInt( "DEFAULT", "ADDRESS", dw_ip );

	theApp.WriteProfileInt( "DEFAULT", "PORT", w_port );
}

void CSetupDialog::OnConnect() 
{
	// TODO: Add your control notification handler code here

	CNetProxyDlg * pParent = (CNetProxyDlg *)(GetParent());

	pParent->OnConnect_SetupDialog();
}
