#!/bin/bash
# VERSION 3.0 
# DATE 2020/03/19 
# functions for bash.
set -e 

clear_cache()
{
	echo_title "clear_cache"
	echo 1 > /proc/sys/vm/drop_caches
	sleep 1
	echo 2 > /proc/sys/vm/drop_caches
	sleep 1
	echo 3 > /proc/sys/vm/drop_caches
	sleep 1
	sync
	#echo 0 > /proc/sys/vm/drop_caches
}

write2kern_log()
{
	echo $@ > /dev/kmsg
}

write2kern_log_t()
{
	curr=$(print_time)
	write2kern_log ${curr} $@
}

app2front()
{
	echo "app2front= $@"
	#if [ -n $1 ]; then 
		wmctrl -a $1
		#echo "app2front-wmctrl $1"
	#fi
	#root@tegra-ubuntu-tx2:/media/nvidia/ext4# 
}

get_time_str()
{
	DT=$(date '+%Y%m%d_%H%M%S')
	echo ${DT}
}

print_time()
{
	curr=$(date +%d%m%Y-%H:%M:%S)
	echo "[${curr}] $@"
}

#show title
echo_title()
{
	echo "=====================================" 
	echo $@ 
	echo "=====================================" 
}

echo_title_t()
{
	curr=$(print_time) 
	echo_title ${curr} $@ 
}

# print and execute command
run_cmd()
{
	echo $@ 
	$@
}

# print and execute command in background mode
run_cmd_bg()
{
	echo $@
	$@ &
}

# execute and print timestamp
run_cmd_t()
{
	print_time $@ 
	$@
}

# install package
# Return 1 if install package, 0 for not execute the install process.
PkgInstall()
{
 	if [ -z "$1" ]; then
		echo 0
		#exit 1
    fi

	# check wget is exist
	QUERY_PKG=$(sudo apt -qq list $1 2>/dev/null)
	
	if [[ $QUERY_PKG != *"[installed]"* ]]; then
		#only do the update when the package is not installed.
		#sudo apt-get update
		run_cmd sudo apt-get install -y $1

		#QUERY_PKG=`$QUERY_CMD`
		#if [[ $QUERY_PKG != *"[installed]"* ]]; then
		#	"Can't install the $1, please check your internet connection!"
		#	exit 1
		#fi
		echo 1
	else
		echo 0
	fi
	
}

# Creakte directory when not exists
mkDirectory()
{
	if [ ! -d $1 ] ;then
		sudo mkdir -p $1
	fi
}

# Install Bonjour packages
Bonjour()
{
	echo_title "Package for Bonjour"
	RET=$(PkgInstall avahi-daemon)
	RET=$(PkgInstall avahi-discover)
	RET=$(PkgInstall avahi-utils)
}

# mount hdd to fs
mount_hdd()
{
	mkDirectory $3
	run_cmd mount -t $1 $2 $3
}

# mount samba share folder to local fs
mount_smb()
{
	PkgInstall cifs-utils; 
	mkDirectory $6
	run_cmd mount -t $1 -o user=$2,password=$3,domain=$4 $5 $6
	#sudo mount -t cifs -o user=James_cheng,password=E2345678e*,domain=YUAN //James_cheng/W "${DIR_MOUNT}"
	ls $6
}

#Create ssh connection
ssh_connection()
{
	RET=$(PkgInstall sshpass)
	sshpass -p ${1} ssh -o StrictHostKeyChecking=no ${2}@${3}
}

# Install Bonjour packages
pkg_ssh()
{
	echo_title "Package for ssh"
	RET=$(PkgInstall sshpass)
	RET=$(PkgInstall apt-utils)
}


