// CLibTest.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <windows.h>
#include <conio.h>
#include "..\NUCUpsLib.h"

int _tmain(int argc, _TCHAR* argv[])
{
	printf("HIT <Esc> TO EXIT!\n");

	int state;

	nucupsOpenDeviceHandler(1000);
	if (isNUCUpsConnected())
	{
		printf("NUC-UPS opened!\n");
		Sleep(500);	//it's recommended to give a few miliseconds before the first read otherwise the first read might be 0 

		//the library reads the NUC values in every 1000 msec (once per second)
		//therefore is useless to read them faster from here

		char path[1024];
		getNUCUpsDevicePath(path);
		
		printf(" firmware: %02d.%02d \n",getNUCUpsVerMajor(),getNUCUpsVerMinor());
		printf(" mode: %d\n",getNUCUpsMode());
		printf(" path: %s\n",path);
		printf("------------------------------\n");
	}
	else printf("NUCUps not found!\n");

	char ch = 0;

	while (ch != 27)
	{
		if (_kbhit())
		{
			ch = _getch();
			if (ch != 27)
			{
				printf("Press again:\n");
				printf("L.Load flash\nQ.Set flash 1\nW.Set flash 2\nA.Save settings to file\nS.Load settings from file\n");
				ch = _getch();
				switch (ch)
				{
				case 'l':
				case 'L': 
					{
						printf("Loading flash values. Wait ...\n");
						startNUCUpsLoadingSettings(0,0);
						int timeout = 0;
						while ((getNUCUpsLoadingSettingsState() < 100) && (timeout < 20))//wait for 10 seconds
						{
							printf("Loading %d%c\n",getNUCUpsLoadingSettingsState(),'%');
							timeout++;
							Sleep(500);
						}
						printf("Loading final: %d%c\n",getNUCUpsLoadingSettingsState(),'%');//100=OK, F0-FF=ERRORCODE
						if (getNUCUpsLoadingSettingsState() == 100)//succesfull
						{
							unsigned int var_max = getNUCUpsMaxVariableCnt();
							char name[256];
							char value[256];
							char unit[256];
							char comment[1024];

							for (int i=0;i<var_max;i++)
								if (getNUCUpsVariableData(i, name, value, unit, comment))
									printf("[%d] %s=%s %s\n",i,name, value, unit);//, comment);
						}
						else printf("    ERROR: %02x", getNUCUpsLoadingSettingsState());
					}break;
				case 'a':
				case 'A':
					{
						printf("Saving flash values to file. Wait ...\n");
						startNUCUpsLoadingSettings(1,0);
						int timeout = 0;
						while ((getNUCUpsLoadingSettingsState() < 100) && (timeout < 20))//wait for 10 seconds
						{
							printf("Loading %d%c\n",getNUCUpsLoadingSettingsState(),'%');
							timeout++;
							Sleep(500);
						}
						printf("Loading final: %d%c\n",getNUCUpsLoadingSettingsState(),'%');//100=OK, F0-FF=ERRORCODE
					}break;
				case 's':
				case 'S':
					{
						printf("Loading flash values from file. Wait ...\n");
						startNUCUpsSaveSettings(1);
						int timeout = 0;
						while ((getNUCUpsSaveSettingsState() < 100) && (timeout < 20))//wait for 10 seconds
						{
							printf("Saving %d%c\n",getNUCUpsSaveSettingsState(),'%');
							timeout++;
							Sleep(500);
						}
						printf("Saving final: %d%c\n",getNUCUpsSaveSettingsState(),'%');//100=OK, F0-FF=ERRORCODE
					}break;
				case 'q':
				case 'Q':
				case 'w':
				case 'W':
					if ((ch == 'q') || (ch == 'Q'))
					{
						setNUCUpsVariableData(48, "3111");//POUT_HIGH_THRESHOLD
						setNUCUpsVariableData(20, "11111111");//CONFIG2
					}
					else
					{
						setNUCUpsVariableData(48, "3000");//POUT_HIGH_THRESHOLD
						setNUCUpsVariableData(20, "00000000");//CONFIG2
					}

					startNUCUpsSaveSettings(0);
					int timeout = 0;
					while ((getNUCUpsSaveSettingsState() < 100) && (timeout < 20))//wait for 10 seconds
					{
						printf("Saving %d%c\n",getNUCUpsSaveSettingsState(),'%');
						timeout++;
						Sleep(500);
					}
					printf("Saving final: %d%c\n",getNUCUpsSaveSettingsState(),'%');//100=OK, F0-FF=ERRORCODE
					break;
				}
			}
		}
		else
		{
			if (isNUCUpsConnected() == false)
			{
				//NUCCloseDeviceHandler();//close it only if you do not want auto reconnect
				printf("No device\n");
			}
			else
			{
				printf("MD=%d ",getNUCUpsMode());
				printf("VIn=%.2f ",getNUCUpsVIn());
				printf("VIgn=%.2f ",getNUCUpsVIgnition());
				printf("VBat=%.2f ",getNUCUpsVBat());
				printf("VOut=%.2f ",getNUCUpsVOut());
				printf("POut=%.2f ",getNUCUpsPOut());
				printf("IOut=%.2f ",getNUCUpsIOut());
				printf("Capacity=%d\n",(int)getNUCUpsBatteryLevel());
				printf("   Ichg=%.2f ",getNUCUpsIChgDchg());
				printf("Cells=");
				for (int i=0;i<4;i++)
					printf("[%d %.02fV %dC] ",i,getNUCUpsVBats(i),getNUCUpsTemperature(i));
				printf("\n");
			}
			Sleep(1000);
		}
	}//while
	nucupsCloseDeviceHandler();

	return 0;
}

