/*
 * wireless event polling
 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <sys/socket.h>
#include <signal.h>
#include <time.h>
#include <linux/if_packet.h>
#include <net/if.h>
#include <netinet/in.h>
#include <linux/wireless.h>
#include <linux/rtnetlink.h>

typedef unsigned long u64;
typedef unsigned int u32;
typedef unsigned short u16;
typedef unsigned char u8;

#define CHAR            char
#define INT             int
#define SHORT           int
#define UINT            u32
#define ULONG           u32
#define USHORT          u16
#define UCHAR           u8

#define uint32		u32
#define uint8		u8


#define BOOLEAN         u8
#define VOID            void
#define LONG            int
#define LONGLONG        s64
#define ULONGLONG       u64

//*********route info***********//
#define BUFSIZE 8192 
struct route_info{ 
u_int dstAddr; 
u_int srcAddr; 
u_int gateWay; 
char ifName[IF_NAMESIZE]; 
}; 

//below macro is copyed from driver layer
#define RT_INSMOD_EVENT_FLAG                             0x0101
#define RT_UPDEV_EVENT_FLAG                               0x0102
#define RT_DISCONNECTED_EVENT_FLAG               0x0103
#define RT_WPACONNECTED_EVENT_FLAG             0x0104
#define RT_DOWNDEV_EVENT_FLAG                        0x0105
#define RT_RMMOD_EVENT_FLAG                              0x0106
	
static int rtm_sock =0;
static int ioctl_sock =0;
static int we_version_compiled=19;
static int WPA_SUPPLICANT_RUN=0;
static int dhcp_has_run=0;
static char dev_name[IFNAMSIZ];
static char gateway[255];

//run&kill wpa_supplicnat,dhclient
void run_wpa_supplicant(void) {
  char tempcmd[200];

 memset(tempcmd,0,sizeof(tempcmd));
 strcat(tempcmd,"./wpa_supplicant -i ");
 strcat(tempcmd,dev_name);
 strcat(tempcmd," -c wpa_supplicant.conf -Dvntwusb >/dev/null 2>&1");
 strcat(tempcmd," &");
 //printf("execute command :%s\n",tempcmd);
 system(tempcmd);
 WPA_SUPPLICANT_RUN =1;

 return;
}
	
void run_dhclinet(void) {
    char tempcmd[100];

      memset(tempcmd,0,100);
      strcat(tempcmd,"/sbin/dhclient ");
      strcat(tempcmd,dev_name);
      strcat(tempcmd," >/dev/null 2>&1");
     // printf("execute command :%s\n",tempcmd);
      system(tempcmd);
      dhcp_has_run = 1;
   
  return;
}

void kill_wpa_supplicant(void) {
    char tempcmd[100];

if(WPA_SUPPLICANT_RUN==1) {
   memset(tempcmd,0,100);
   strcat(tempcmd,"killall -9 ");
   strcat(tempcmd,"wpa_supplicant");
   //printf("execute command :%s\n",tempcmd);
   system(tempcmd);
   WPA_SUPPLICANT_RUN = 0;
}
   
  return;
}

void kill_dhclient(void) {
  char tempcmd[100];

if(dhcp_has_run==1) {
       memset(tempcmd,0,100);
       strcat(tempcmd,"killall -9 ");
       strcat(tempcmd,"/sbin/dhclient");
       //printf("execute command :%s\n",tempcmd);
       system(tempcmd);				   
   dhcp_has_run = 0;
}

  return;
}

int get_IP_addr(char *devname) {
   struct	sockaddr_in  my_addr;
   struct ifreq ifr;

    /**//* Get IP Address */
    strncpy(ifr.ifr_name, devname, IF_NAMESIZE);
    ifr.ifr_name[IFNAMSIZ-1]='\0';

    if (ioctl(ioctl_sock, SIOCGIFADDR, &ifr) < 0){
        perror("ioctl");
        return -1;
    }

    memcpy(&my_addr, &ifr.ifr_addr, sizeof(my_addr));
    printf("ip addr:%s\n",inet_ntoa(my_addr.sin_addr));

  return 0;
}

void signal_catch(int msgno) {

  printf("***Exit***\n");

	     kill_wpa_supplicant();
	     kill_dhclient();
				 
close(rtm_sock);
close(ioctl_sock);
exit(0);
}

//***get route info routine---->
int readNlSock(int sockFd, char *bufPtr, int seqNum, int pId){ 
struct nlmsghdr *nlHdr; 
int readLen = 0, msgLen = 0; 

do{ 
/* Recieve response from the kernel */ 
if((readLen = recv(sockFd, bufPtr, BUFSIZE - msgLen, 0)) < 0){ 
perror("SOCK READ: "); 
return -1; 
} 

nlHdr = (struct nlmsghdr *)bufPtr; 

/* Check if the header is valid */ 
if((NLMSG_OK(nlHdr, readLen) == 0) || (nlHdr->nlmsg_type == NLMSG_ERROR)) 
{ 
perror("Error in recieved packet"); 
return -1; 
} 

/* Check if the its the last message */ 
if(nlHdr->nlmsg_type == NLMSG_DONE) { 
break; 
} 
else{ 
/* Else move the pointer to buffer appropriately */ 
bufPtr += readLen; 
msgLen += readLen; 
} 

/* Check if its a multi part message */ 
if((nlHdr->nlmsg_flags & NLM_F_MULTI) == 0) { 
/* return if its not */ 
break; 
} 
} while((nlHdr->nlmsg_seq != seqNum) || (nlHdr->nlmsg_pid != pId)); 
return msgLen; 
} 

/* For printing the routes. */ 
void printRoute(struct route_info *rtInfo) 
{ 
char tempBuf[512]; 

/* Print Destination address */ 
if(rtInfo->dstAddr != 0) 
strcpy(tempBuf, (char *)inet_ntoa(rtInfo->dstAddr)); 
else 
sprintf(tempBuf,"*.*.*.*\t"); 
fprintf(stdout,"%s\t", tempBuf); 

/* Print Gateway address */ 
if(rtInfo->gateWay != 0) 
strcpy(tempBuf, (char *)inet_ntoa(rtInfo->gateWay)); 
else 
sprintf(tempBuf,"*.*.*.*\t"); 
fprintf(stdout,"%s\t", tempBuf); 

/* Print Interface Name*/ 
fprintf(stdout,"%s\t", rtInfo->ifName); 

/* Print Source address */ 
if(rtInfo->srcAddr != 0) 
strcpy(tempBuf, (char *)inet_ntoa(rtInfo->srcAddr)); 
else 
sprintf(tempBuf,"*.*.*.*\t"); 
fprintf(stdout,"%s\n", tempBuf); 
} 

/* For parsing the route info returned */ 
void parseRoutes(struct nlmsghdr *nlHdr, struct route_info *rtInfo,char *gateway) 
{ 
struct rtmsg *rtMsg; 
struct rtattr *rtAttr; 
int rtLen; 
char *tempBuf = NULL; 

tempBuf = (char *)malloc(100); 
rtMsg = (struct rtmsg *)NLMSG_DATA(nlHdr); 

/* If the route is not for AF_INET or does not belong to main routing table 
then return. */ 
if((rtMsg->rtm_family != AF_INET) || (rtMsg->rtm_table != RT_TABLE_MAIN)) 
return; 

/* get the rtattr field */ 
rtAttr = (struct rtattr *)RTM_RTA(rtMsg); 
rtLen = RTM_PAYLOAD(nlHdr); 
for(;RTA_OK(rtAttr,rtLen);rtAttr = RTA_NEXT(rtAttr,rtLen)){ 
switch(rtAttr->rta_type) { 
case RTA_OIF: 
if_indextoname(*(int *)RTA_DATA(rtAttr), rtInfo->ifName); 
break; 
case RTA_GATEWAY: 
rtInfo->gateWay = *(u_int *)RTA_DATA(rtAttr); 
break; 
case RTA_PREFSRC: 
rtInfo->srcAddr = *(u_int *)RTA_DATA(rtAttr); 
break; 
case RTA_DST: 
rtInfo->dstAddr = *(u_int *)RTA_DATA(rtAttr); 
break; 
} 
} 
//printf("%s\n", (char *)inet_ntoa(rtInfo->dstAddr)); 
// ADDED BY BOB - ALSO COMMENTED printRoute 
if (strstr((char *)inet_ntoa(rtInfo->dstAddr), "0.0.0.0")) 
sprintf(gateway, (char *)inet_ntoa(rtInfo->gateWay)); 
//printRoute(rtInfo); 
free(tempBuf); 
return; 
} 

int get_gateway(char *gateway) 
{ 
struct nlmsghdr *nlMsg; 
struct rtmsg *rtMsg; 
struct route_info *rtInfo; 
char msgBuf[BUFSIZE]; 

int sock, len, msgSeq = 0; 
char buff[1024]; 


/* Create Socket */ 
if((sock = socket(PF_NETLINK, SOCK_DGRAM, NETLINK_ROUTE)) < 0) 
perror("Socket Creation: "); 

/* Initialize the buffer */ 
memset(msgBuf, 0, BUFSIZE); 

/* point the header and the msg structure pointers into the buffer */ 
nlMsg = (struct nlmsghdr *)msgBuf; 
rtMsg = (struct rtmsg *)NLMSG_DATA(nlMsg); 

/* Fill in the nlmsg header*/ 
nlMsg->nlmsg_len = NLMSG_LENGTH(sizeof(struct rtmsg)); // Length of message. 
nlMsg->nlmsg_type = RTM_GETROUTE; // Get the routes from kernel routing table . 

nlMsg->nlmsg_flags = NLM_F_DUMP | NLM_F_REQUEST; // The message is a request for dump. 
nlMsg->nlmsg_seq = msgSeq++; // Sequence of the message packet. 
nlMsg->nlmsg_pid = getpid(); // PID of process sending the request. 

/* Send the request */ 
if(send(sock, nlMsg, nlMsg->nlmsg_len, 0) < 0){ 
printf("Write To Socket Failed...\n");
close(sock); 
return -1; 
} 

/* Read the response */ 
if((len = readNlSock(sock, msgBuf, msgSeq, getpid())) < 0) { 
printf("Read From Socket Failed...\n"); 
close(sock); 
return -1; 
} 
/* Parse and print the response */ 
rtInfo = (struct route_info *)malloc(sizeof(struct route_info)); 

/* THIS IS THE NETTSTAT -RL code I commented out the printing here and in parse routes */ 
//fprintf(stdout, "Destination\tGateway\tInterface\tSource\n"); 
for(;NLMSG_OK(nlMsg,len);nlMsg = NLMSG_NEXT(nlMsg,len)){ 
memset(rtInfo, 0, sizeof(struct route_info)); 
parseRoutes(nlMsg, rtInfo,gateway); 
} 
free(rtInfo); 
close(sock); 

return 0; 
} 


int get_route_info(void) 
{
 int result=0;

memset(gateway,0,sizeof(gateway));
result=get_gateway(gateway); 

return result;
}
//***get route info routine<---

void driver_event_wireless(char *data, int len)
{
	struct iw_event iwe_buf, *iwe = &iwe_buf;
	char *pos, *end, *custom, *buf, *assoc_info_buf, *info_pos;
	
        assoc_info_buf = info_pos = NULL;
	pos = data;
	end = data + len;

	while (pos + IW_EV_LCP_LEN <= end)
	{
		/* Event data may be unaligned, so make a local, aligned copy
		 * before processing. */
		memcpy(&iwe_buf, pos, IW_EV_LCP_LEN);

		if (iwe->len <= IW_EV_LCP_LEN)
			return;

		custom = pos + IW_EV_POINT_LEN;
		//printf("get wireless_event=%04x\n",iwe->cmd);
		
		if (we_version_compiled > 18 &&
		    (iwe->cmd == IWEVMICHAELMICFAILURE ||
		     iwe->cmd == IWEVCUSTOM ||
		     iwe->cmd == IWEVASSOCREQIE ||
		     iwe->cmd == IWEVASSOCRESPIE ||
		     iwe->cmd == IWEVPMKIDCAND))
		{
			/* WE-19 removed the pointer from struct iw_point */
			char *dpos = (char *) &iwe_buf.u.data.length;
			int dlen = dpos - (char *) &iwe_buf;
			memcpy(dpos, pos + IW_EV_LCP_LEN,
			       sizeof(struct iw_event) - dlen);
		}
		else
		{
			memcpy(&iwe_buf, pos, sizeof(struct iw_event));
		    custom += IW_EV_POINT_OFF;
                  }
		
		switch (iwe->cmd)
		{
		
			case IWEVCUSTOM:
                                  if (iwe->u.data.flags == RT_INSMOD_EVENT_FLAG)
                  		{
                  		   char tempcmd1[100];
                  		   memset(dev_name,0,IFNAMSIZ);
                  		   memcpy(dev_name,custom,IFNAMSIZ);
                                     // printf("get wireless event IWEVCUSTOM[insmod device:%s]\n",dev_name);
				 //up device
                                       memset(tempcmd1,0,100);
				    strcat(tempcmd1,"ifconfig ");
				    strcat(tempcmd1,dev_name);
				    strcat(tempcmd1," up");
				    //printf("execute command :%s\n",tempcmd1);
				    system(tempcmd1);
				   printf("connecting...");
                  		}
         		       else if(iwe->u.data.flags == RT_UPDEV_EVENT_FLAG)
         		       	{
         		       	   printf("...");
                                      //printf("get wireless event IWEVCUSTOM[up device]\n");
				   kill_wpa_supplicant();
				   printf("...");
                                      run_wpa_supplicant();
				   printf("...\n");
         		       	}
         		       else if(iwe->u.data.flags == RT_DISCONNECTED_EVENT_FLAG)
         		       	{
                                      printf("disconnected???\n");
				   //kill_wpa_supplicant();
				   //kill_dhclient();
         		       	}
         		       else if(iwe->u.data.flags == RT_WPACONNECTED_EVENT_FLAG)
         		       	{ 
                                         printf("connected with [%s]...\n",custom);
				      printf("IP Address Detecting.....\n");
				      kill_dhclient();
                                         run_dhclinet();
				      if(get_IP_addr(dev_name) ==0) {
				         printf("IP Address Detecting.....sucess\n");
                                            if(get_route_info()!=0)
                                                printf("get route info.....fail\n"); 
				         else
					    printf("Gateway:%s\n", gateway);
				      }
				      else
					 printf("IP Address Detecting.....fail\n");
         		       	}
         		       else if(iwe->u.data.flags == RT_DOWNDEV_EVENT_FLAG)
         		       	{ 
                                      printf("get wireless event IWEVCUSTOM[down device]\n");
				   kill_wpa_supplicant();
				   kill_dhclient();
         		       	}
         		       else if(iwe->u.data.flags == RT_RMMOD_EVENT_FLAG)
         		       	{
                                       printf("get wireless event IWEVCUSTOM[rmmod device]\n");
                                       kill_wpa_supplicant();
                                       kill_dhclient();
         		       	}
			       else
				   printf("get wireless event IWEVCUSTOM[unknow--->0x%04x]\n",iwe->u.data.flags);
			         break;

			  case SIOCGIWAP:
			  	//printf("get wireless event SIOCGIWAP\n");
				break;

			 case IWEVMICHAELMICFAILURE:
			  	//printf("get wireless event IWEVMICHAELMICFAILURE\n");
				break;

			  case SIOCGIWSCAN:
			  	//printf("get wireless event SIOCGIWSCAN\n");
				break;
				
			  case IWEVASSOCREQIE:
			  	//printf("get wireless event IWEVASSOCREQIE\n");
				break;

			  case IWEVASSOCRESPIE:
			  	//printf("get wireless event IWEVASSOCRESPIE\n");
				break;

			default:
				printf("get UNKNOWN wireless event [0x%04x]\n",iwe->cmd);
				break;
		
		}

		pos += iwe->len;
	}
}

void driver_rtm_newlink(struct nlmsghdr *h,int len)
{
	struct ifinfomsg *ifi;
	int attrlen, nlmsg_len, rta_len;
	struct rtattr * attr;

	if (len < sizeof(*ifi))
		return;

	ifi = NLMSG_DATA(h);
	
	nlmsg_len = NLMSG_ALIGN(sizeof(struct ifinfomsg));
       
	attrlen = h->nlmsg_len - nlmsg_len;
	//printf("attrlen=%d\n",attrlen);
	if (attrlen < 0)
		return;

	attr = (struct rtattr *) (((char *) ifi) + nlmsg_len);
	rta_len = RTA_ALIGN(sizeof(struct rtattr));
	while (RTA_OK(attr, attrlen))
	{
		//printf("rta_type=%02x\n",attr->rta_type);
		if (attr->rta_type == IFLA_WIRELESS)
		{
		       // printf("Rec wireless event!!!\n");
			driver_event_wireless(((char *) attr) + rta_len, attr->rta_len - rta_len);
		} 
		attr = RTA_NEXT(attr, attrlen);
	}
}	


int main(int argc, char *argv[]) {
	int s;
	struct sockaddr_nl local;
	
	char buf[8192];
	int left;
	struct sockaddr_nl from;
	socklen_t fromlen;
	struct nlmsghdr *h;

       //get wireless extension version number
	    we_version_compiled = WIRELESS_EXT;
	// printf("WE_Version:%d\n",we_version_compiled);

     if ((ioctl_sock = socket(PF_INET, SOCK_DGRAM, 0)) < 0){
        perror("ioctl socket");
        return -1;
    }
		
	//use netlink like this

	s = socket(PF_NETLINK, SOCK_RAW, NETLINK_ROUTE);

	if (s < 0)
	{
		perror("socket(PF_NETLINK,SOCK_RAW,NETLINK_ROUTE)");
		close(ioctl_sock);
		return 1;
	}

	memset(&local, 0, sizeof(local));
	local.nl_family = AF_NETLINK;
	local.nl_groups = RTMGRP_LINK;

	if (bind(s, (struct sockaddr *) &local, sizeof(local)) < 0)
	{
		perror("bind(netlink)");
		close(s);
		close(ioctl_sock);
		return 1;
	}

signal(SIGINT,signal_catch);
signal(SIGTERM,signal_catch);
rtm_sock = s;
WPA_SUPPLICANT_RUN =0;
dhcp_has_run = 0;

printf("\n");
printf("\n");
printf("***VIA NetWorking Wireless Monitor***\n");
printf("\n");

while(1) {
//polling event start
	fromlen = sizeof(from);
	left = recvfrom(s, buf, sizeof(buf), 0, (struct sockaddr *) &from, &fromlen);

	if (left < 0)
	{
              //   printf("Recv wrong length?\n");
		continue;
	}

	h = (struct nlmsghdr *) buf;

	while (left >= sizeof(*h))
	{
		int len, plen;

		len = h->nlmsg_len;              //total message length including header
		plen = len - sizeof(*h);       //message body length
		if (len > left || plen < 0)
		{
			printf( "Malformed netlink message:len=%d left=%d plen=%d", len, left, plen);
			break;
		}

		switch (h->nlmsg_type)
		{
		case RTM_NEWLINK:
			driver_rtm_newlink(h, plen);
			break;
		}

		len = NLMSG_ALIGN(len);
		left -= len;
		h = (struct nlmsghdr *) ((char *) h + len);
	}

	if (left > 0)
	{
		printf( "%d extra bytes in the end of netlink ", left);
	}
}

  close(s);
  close(ioctl_sock);
  printf("***Exit***\n");
  return 0;
}
