/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology	5th	Rd.
 * Science-based Industrial	Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002-2004, Ralink Technology, Inc.
 *
 * All rights reserved.	Ralink's source	code is	an unpublished work	and	the
 * use of a	copyright notice does not imply	otherwise. This	source code
 * contains	confidential trade secret material of Ralink Tech. Any attemp
 * or participation	in deciphering,	decoding, reverse engineering or in	any
 * way altering	the	source code	is stricitly prohibited, unless	the	prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	wpa.c

	Abstract:

	Revision History:
	Who			When			What
	--------	----------		----------------------------------------------
	Jan	Lee		03-07-22		Initial
	Paul Lin	03-11-28		Modify for supplicant
*/
#include "rt_config.h"

//extern UCHAR BIT8[];
UCHAR	CipherWpaPskTkip[] = {
		0xDD, 0x16,				// RSN IE
		0x00, 0x50, 0xf2, 0x01,	// oui
		0x01, 0x00,				// Version
		0x00, 0x50, 0xf2, 0x02,	// Multicast
		0x01, 0x00,				// Number of unicast
		0x00, 0x50, 0xf2, 0x02,	// unicast
		0x01, 0x00,				// number of authentication method
		0x00, 0x50, 0xf2, 0x02	// authentication
		};
UCHAR	CipherWpaPskTkipLen = (sizeof(CipherWpaPskTkip) / sizeof(UCHAR));

UCHAR	CipherWpaPskAes[] = {
		0xDD, 0x16, 			// RSN IE
		0x00, 0x50, 0xf2, 0x01,	// oui
		0x01, 0x00,				// Version
		0x00, 0x50, 0xf2, 0x04,	// Multicast
		0x01, 0x00,				// Number of unicast
		0x00, 0x50, 0xf2, 0x04,	// unicast
		0x01, 0x00,				// number of authentication method
		0x00, 0x50, 0xf2, 0x02	// authentication
		};
UCHAR	CipherWpaPskAesLen = (sizeof(CipherWpaPskAes) / sizeof(UCHAR));

UCHAR	CipherSuiteCiscoCCKM[] = {
		0xDD, 0x16,				// RSN IE
		0x00, 0x50, 0xf2, 0x01, // oui
		0x01, 0x00,				// Version
		0x00, 0x40, 0x96, 0x01, // Multicast
		0x01, 0x00,				// Number of uicast
		0x00, 0x40, 0x96, 0x01, // unicast
		0x01, 0x00,				// number of authentication method
		0x00, 0x40, 0x96, 0x00  // Authentication
		};
UCHAR	CipherSuiteCiscoCCKMLen = (sizeof(CipherSuiteCiscoCCKM) / sizeof(UCHAR));

UCHAR	CipherSuiteCiscoCCKM24[] = {
		0xDD, 0x18,				// RSN IE
		0x00, 0x50, 0xf2, 0x01, // oui
		0x01, 0x00,				// Version
		0x00, 0x40, 0x96, 0x01, // Multicast
		0x01, 0x00,				// Number of uicast
		0x00, 0x40, 0x96, 0x01, // unicast
		0x01, 0x00,				// number of authentication method
		0x00, 0x40, 0x96, 0x00,
		0x28, 0x00// Authentication
		};

UCHAR	CipherSuiteCiscoCCKM24Len = (sizeof(CipherSuiteCiscoCCKM24) / sizeof(UCHAR));

UCHAR	CipherSuiteCiscoCCKMTkip[] = {
		0xDD, 0x16,				// RSN IE
		0x00, 0x50, 0xf2, 0x01, // oui
		0x01, 0x00,				// Version
		0x00, 0x50, 0xf2, 0x02, // Multicast
		0x01, 0x00,				// Number of uicast
		0x00, 0x50, 0xf2, 0x02, // unicast
		0x01, 0x00,				// number of authentication method
		0x00, 0x40, 0x96, 0x00  // Authentication
		};
UCHAR	CipherSuiteCiscoCCKMTkipLen = (sizeof(CipherSuiteCiscoCCKMTkip) / sizeof(UCHAR));

UCHAR	CipherSuiteCiscoCCKMTkip24[] = {
		0xDD, 0x18,				// RSN IE
		0x00, 0x50, 0xf2, 0x01, // oui
		0x01, 0x00,				// Version
		0x00, 0x50, 0xf2, 0x02, // Multicast
		0x01, 0x00,				// Number of uicast
		0x00, 0x50, 0xf2, 0x02, // unicast
		0x01, 0x00,				// number of authentication method
		0x00, 0x40, 0x96, 0x00,
		0x28, 0x00// Authentication
		};

UCHAR	CipherSuiteCiscoCCKMTkip24Len = (sizeof(CipherSuiteCiscoCCKMTkip24) / sizeof(UCHAR));

UCHAR	CipherSuiteCCXTkip[] = {
		0xDD, 0x16,				// RSN IE
		0x00, 0x50, 0xf2, 0x01,	// oui
		0x01, 0x00,				// Version
		0x00, 0x50, 0xf2, 0x02,	// Multicast
		0x01, 0x00,				// Number of unicast
		0x00, 0x50, 0xf2, 0x02,	// unicast
		0x01, 0x00,				// number of authentication method
		0x00, 0x50, 0xf2, 0x01	// authentication
		};
UCHAR	CipherSuiteCCXTkipLen = (sizeof(CipherSuiteCCXTkip) / sizeof(UCHAR));

UCHAR	CCX_LLC_HDR[] = {0xAA, 0xAA, 0x03, 0x00, 0x40, 0x96, 0x00, 0x02};
UCHAR	LLC_NORMAL[] = {0xAA, 0xAA, 0x03, 0x00, 0x00, 0x00};

UCHAR	EAPOL_FRAME[] = {0x88, 0x8E};

static UCHAR prf_input[1024];

/*
	========================================================================

	Routine Description:
		Classify WPA EAP message type

	Arguments:
		EAPType		Value of EAP message type
		MsgType		Internal Message definition for MLME state machine

	Return Value:
		TRUE		Found appropriate message type
		FALSE		No appropriate message type

	IRQL = DISPATCH_LEVEL

	Note:
		All these constants are defined in wpa.h
		For supplicant, there is only EAPOL Key message avaliable

	========================================================================
*/
BOOLEAN	WpaMsgTypeSubst(
	IN	UCHAR	EAPType,
	OUT	ULONG	*MsgType)
{
	switch (EAPType)
	{
		case EAPPacket:
			*MsgType = MT2_EAPPacket;
			break;
		case EAPOLStart:
			*MsgType = MT2_EAPOLStart;
			break;
		case EAPOLLogoff:
			*MsgType = MT2_EAPOLLogoff;
			break;
		case EAPOLKey:
			*MsgType = MT2_EAPOLKey;
			break;
		case EAPOLASFAlert:
			*MsgType = MT2_EAPOLASFAlert;
			break;
		default:
			DBGPRINT(RT_DEBUG_INFO, ("WpaMsgTypeSubst : return FALSE; \n"));
			return FALSE;
	}
	return TRUE;
}

/*
	==========================================================================
	Description:
		association	state machine init,	including state	transition and timer init
	Parameters:
		S -	pointer	to the association state machine
	==========================================================================
 */
VOID WpaPskStateMachineInit(
	IN	PRTMP_ADAPTER	pAd,
	IN	STATE_MACHINE *S,
	OUT	STATE_MACHINE_FUNC Trans[])
{
	StateMachineInit(S,	Trans, MAX_WPA_PSK_STATE, MAX_WPA_PSK_MSG, (STATE_MACHINE_FUNC)Drop, WPA_PSK_IDLE, WPA_MACHINE_BASE);
	StateMachineSetAction(S, WPA_PSK_IDLE, MT2_EAPOLKey, (STATE_MACHINE_FUNC)WpaEAPOLKeyAction);
}

/*
	==========================================================================
	Description:
		This is	state machine function.
		When receiving EAPOL packets which is  for 802.1x key management.
		Use	both in	WPA, and WPAPSK	case.
		In this	function, further dispatch to different	functions according	to the received	packet.	 3 categories are :
		  1.  normal 4-way pairwisekey and 2-way groupkey handshake
		  2.  MIC error	(Countermeasures attack)  report packet	from STA.
		  3.  Request for pairwise/group key update	from STA
	Return:
	==========================================================================
*/
VOID WpaEAPOLKeyAction(
	IN	PRTMP_ADAPTER	pAd,
	IN	MLME_QUEUE_ELEM	*Elem)
{
	INT				MsgType;
	PKEY_DESCRIPTER	pKeyDesc;

	DBGPRINT(RT_DEBUG_TRACE, ("-----> WpaEAPOLKeyAction\n"));
	// Get 802.11 header first
	pKeyDesc = (PKEY_DESCRIPTER) &Elem->Msg[(LENGTH_802_11 + LENGTH_802_1_H + LENGTH_EAPOL_H)];

	// Sanity check, this should only happen in WPA-PSK mode
	if ((pAd->CommonCfg.AuthMode != Ndis802_11AuthModeWPAPSK) && (pAd->StaCfg.LeapAuthMode != CISCO_AuthModeLEAP))
		return;

	// 0. Debug print all bit information
	DBGPRINT(RT_DEBUG_INFO, ("KeyInfo Key Description Version %d\n", pKeyDesc->KeyInfo.KeyDescVer));
	DBGPRINT(RT_DEBUG_INFO, ("KeyInfo Key Type %d\n", pKeyDesc->KeyInfo.KeyType));
	DBGPRINT(RT_DEBUG_INFO, ("KeyInfo Key Index %d\n", pKeyDesc->KeyInfo.KeyIndex));
	DBGPRINT(RT_DEBUG_INFO, ("KeyInfo Install %d\n", pKeyDesc->KeyInfo.Install));
	DBGPRINT(RT_DEBUG_INFO, ("KeyInfo Key Ack %d\n", pKeyDesc->KeyInfo.KeyAck));
	DBGPRINT(RT_DEBUG_INFO, ("KeyInfo Key MIC %d\n", pKeyDesc->KeyInfo.KeyMic));
	DBGPRINT(RT_DEBUG_INFO, ("KeyInfo Secure %d\n", pKeyDesc->KeyInfo.Secure));
	DBGPRINT(RT_DEBUG_INFO, ("KeyInfo Error %d\n", pKeyDesc->KeyInfo.Error));
	DBGPRINT(RT_DEBUG_INFO, ("KeyInfo Request %d\n", pKeyDesc->KeyInfo.Request));
	DBGPRINT(RT_DEBUG_INFO, ("KeyInfo DL %d\n", pKeyDesc->KeyInfo.EKD_DL));

	// 1. Check EAPOL frame version and type
	if ((Elem->Msg[LENGTH_802_11+LENGTH_802_1_H] !=	EAPOL_VER) || (pKeyDesc->Type != RSN_KEY_DESC))
	{
		DBGPRINT(RT_DEBUG_ERROR, ("	 Key descripter	does not match with	WPA	rule \n"));
		return;
	}

	// 2.Check Version for AES & TKIP
	if ((pAd->CommonCfg.WepStatus ==	Ndis802_11Encryption3Enabled) && (pKeyDesc->KeyInfo.KeyDescVer != DESC_TYPE_AES))
	{
		DBGPRINT(RT_DEBUG_ERROR, ("	 Key descripter	version	not match AES \n"));
		return;
	}
	else if	((pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled) && (pKeyDesc->KeyInfo.KeyDescVer != DESC_TYPE_TKIP))
	{
		DBGPRINT(RT_DEBUG_ERROR, ("	 Key descripter	version	not	match TKIP \n"));
		return;
	}

#if 0 /* have no necessary to check ReplayCounter and almost other implementation didn't check it either. */
	// First validate replay counter, only accept message with larger replay counter
	// Let equal pass, some AP start with all zero replay counter
	{
		UCHAR			ZeroReplay[LEN_KEY_DESC_REPLAY];
		NdisZeroMemory(ZeroReplay, LEN_KEY_DESC_REPLAY);
		if ((RTMPCompareMemory(pKeyDesc->ReplayCounter, pAd->StaCfg.ReplayCounter, LEN_KEY_DESC_REPLAY) != 1) &&
			(RTMPCompareMemory(pKeyDesc->ReplayCounter, ZeroReplay, LEN_KEY_DESC_REPLAY) != 0))
			return;
	}
#endif

	// Classify message Type, either pairwise message 1, 3, or group message 1 for supplicant
	MsgType = EAPOL_MSG_INVALID;
	if ((pKeyDesc->KeyInfo.KeyType == 1) &&
		(pKeyDesc->KeyInfo.KeyIndex == 0) &&
		(pKeyDesc->KeyInfo.KeyAck == 1) &&
		(pKeyDesc->KeyInfo.KeyMic == 0) &&
		(pKeyDesc->KeyInfo.Secure == 0) &&
		(pKeyDesc->KeyInfo.Error == 0) &&
		(pKeyDesc->KeyInfo.Request == 0))
	{
		MsgType = EAPOL_PAIR_MSG_1;
		DBGPRINT(RT_DEBUG_TRACE, ("Receive EAPOL Key Pairwise Message 1\n"));
	}
	else if ((pKeyDesc->KeyInfo.KeyType == 1) &&
		(pKeyDesc->KeyInfo.KeyIndex == 0) &&
		(pKeyDesc->KeyInfo.KeyAck == 1) &&
		(pKeyDesc->KeyInfo.KeyMic == 1) &&
		(pKeyDesc->KeyInfo.Secure == 0) &&
		(pKeyDesc->KeyInfo.Error == 0) &&
		(pKeyDesc->KeyInfo.Request == 0))
	{
		MsgType = EAPOL_PAIR_MSG_3;
		DBGPRINT(RT_DEBUG_TRACE, ("Receive EAPOL Key Pairwise Message 3\n"));
	}
	else if ((pKeyDesc->KeyInfo.KeyType == 0) &&
		(pKeyDesc->KeyInfo.KeyIndex != 0) &&
		(pKeyDesc->KeyInfo.KeyAck == 1) &&
		(pKeyDesc->KeyInfo.KeyMic == 1) &&
		(pKeyDesc->KeyInfo.Secure == 1) &&
		(pKeyDesc->KeyInfo.Error == 0) &&
		(pKeyDesc->KeyInfo.Request == 0))
	{
		MsgType = EAPOL_GROUP_MSG_1;
		DBGPRINT(RT_DEBUG_TRACE, ("Receive EAPOL Key Group Message 1\n"));
	}

	// We will assume link is up (assoc suceess and port not secured).
	// All state has to be able to process message from previous state
	switch (pAd->StaCfg.WpaState)
	{
		case SS_START:
			if (MsgType == EAPOL_PAIR_MSG_1)
			{
				WpaPairMsg1Action(pAd, Elem);
				pAd->StaCfg.WpaState = SS_WAIT_MSG_3;
			}
			break;

		case SS_WAIT_MSG_3:
			if (MsgType == EAPOL_PAIR_MSG_1)
			{
				WpaPairMsg1Action(pAd, Elem);
				pAd->StaCfg.WpaState = SS_WAIT_MSG_3;
			}
			else if (MsgType == EAPOL_PAIR_MSG_3)
			{
				WpaPairMsg3Action(pAd, Elem);
				pAd->StaCfg.WpaState = SS_WAIT_GROUP;
			}
			break;

		case SS_WAIT_GROUP:		// When doing group key exchange
		case SS_FINISH:			// This happened when update group key
			if (MsgType == EAPOL_PAIR_MSG_1)
			{
				WpaPairMsg1Action(pAd, Elem);
				pAd->StaCfg.WpaState = SS_WAIT_MSG_3;
				// Reset port secured variable
				pAd->StaCfg.PortSecured = WPA_802_1X_PORT_NOT_SECURED;
			}
			else if (MsgType == EAPOL_PAIR_MSG_3)
			{
				WpaPairMsg3Action(pAd, Elem);
				pAd->StaCfg.WpaState = SS_WAIT_GROUP;
				// Reset port secured variable
				pAd->StaCfg.PortSecured = WPA_802_1X_PORT_NOT_SECURED;
			}
			else if (MsgType == EAPOL_GROUP_MSG_1)
			{
				WpaGroupMsg1Action(pAd, Elem);
				pAd->StaCfg.WpaState = SS_FINISH;
			}
			break;

		default:
			break;
	}

	DBGPRINT(RT_DEBUG_TRACE, ("<----- WpaEAPOLKeyAction\n"));
}

/*
	========================================================================

	Routine Description:
		Process Pairwise key 4-way handshaking

	Arguments:
		pAd	Pointer	to our adapter
		Elem		Message body

	Return Value:
		None

	Note:

	========================================================================
*/
VOID	WpaPairMsg1Action(
	IN	PRTMP_ADAPTER	pAd,
	IN	MLME_QUEUE_ELEM	*Elem)
{
	PHEADER_802_11		pHeader;
	UCHAR				*PTK;
	PUCHAR				pOutBuffer = NULL;
	HEADER_802_11		Header_802_11;
	NDIS_STATUS			NStatus;
	UCHAR				AckRate = RATE_2;
	USHORT				AckDuration = 0;
	ULONG				FrameLen = 0;
	UCHAR				EAPHEAD[8] = {0xaa,	0xaa, 0x03,	0x00, 0x00,	0x00,0x88,0x8e};
	PEAPOL_PACKET		pMsg1;
	EAPOL_PACKET		Packet;
	UCHAR				Mic[16];
	UCHAR				*KBTK; //for storing KRK and BTK;
	UCHAR               *CalcBTK;
	UCHAR				*mpool = kmalloc(80 + LEN_KEY_DESC_MIC + LEN_KEY_DESC_NONCE + 80 + MAX_LEN_OF_EAP_HS + 32, GFP_ATOMIC);

    DBGPRINT(RT_DEBUG_TRACE, ("===>PeerPairMsg2Action \n"));

	if(mpool == NULL)
		return;

	/* PTK  Len = 80 */
	PTK = (UCHAR *) ROUND_UP(mpool, 4);
	/* KBTK Len = 80 */
	KBTK = (UCHAR *) ROUND_UP(PTK + 80, 4);
	/* CalcBTK Len = 80 */
	CalcBTK = (UCHAR *) ROUND_UP(KBTK + 80, 4);


	DBGPRINT(RT_DEBUG_TRACE, ("WpaPairMsg1Action ----->\n"));

	pHeader	= (PHEADER_802_11) Elem->Msg;

	// Save Data Length to pDesc for receiving packet, then put in outgoing frame	Data Len fields.
	pMsg1 = (PEAPOL_PACKET) &Elem->Msg[LENGTH_802_11 + LENGTH_802_1_H];

	// Process message 1 from authenticator
	// Key must be Pairwise key, already verified at callee.
	// 1. Save Replay counter, it will use to verify message 3 and construct message 2
	NdisMoveMemory(pAd->StaCfg.ReplayCounter, pMsg1->KeyDesc.ReplayCounter, LEN_KEY_DESC_REPLAY);

	// 2. Save ANonce
	NdisMoveMemory(pAd->StaCfg.ANonce, pMsg1->KeyDesc.KeyNonce, LEN_KEY_DESC_NONCE);

	// TSNonce <--- SNonce
	// Generate random SNonce
	GenRandom(pAd,	pAd->StaCfg.SNonce);

	if (LEAP_CCKM_ON(pAd))
	{
		// Cisco's Centralized key management key Hierarchy
		// Generate KRK and BTK
		WpaCountPTK(pAd,
					pAd->StaCfg.SessionKey,
					pAd->StaCfg.ANonce,
					pAd->CommonCfg.Bssid,
					pAd->StaCfg.SNonce,
					pAd->CurrentAddress,
					KBTK,
					(384/8));

		NdisMoveMemory(pAd->StaCfg.KRK, KBTK, 16);
		NdisMoveMemory(pAd->StaCfg.BTK, KBTK + 16, 32);

		//CalcBTK
		NdisMoveMemory(CalcBTK, (PUCHAR) &pAd->StaCfg.CCKMRN, sizeof(pAd->StaCfg.CCKMRN));
		NdisMoveMemory(CalcBTK + sizeof(pAd->StaCfg.CCKMRN), pAd->CommonCfg.Bssid, MAC_ADDR_LEN);

		CCKMPRF(pAd->StaCfg.BTK, 32, CalcBTK, 10, PTK, LEN_PTK);
	}
	else if ((pAd->StaCfg.LeapAuthMode == CISCO_AuthModeLEAP) &&
			 (pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled))
	{
		// LEAP + TKIP
		// Where Preshared key used Cisco Network Session key instead of pAd->StaCfg.PskKey.key
		WpaCountPTK(pAd,
					pAd->StaCfg.SessionKey,
					pAd->StaCfg.ANonce,
					pAd->CommonCfg.Bssid,
					pAd->StaCfg.SNonce,
					pAd->CurrentAddress,
					PTK,
					LEN_PTK);
	}
	else
	{
		// TPTK <--- Calc PTK(ANonce, TSNonce)
		WpaCountPTK(pAd,
					pAd->StaCfg.PskKey.Key,
					pAd->StaCfg.ANonce,
					pAd->CommonCfg.Bssid,
					pAd->StaCfg.SNonce,
					pAd->CurrentAddress,
					PTK,
					LEN_PTK);
	}
	// Save key to PTK entry
	NdisMoveMemory(pAd->StaCfg.PTK, PTK, LEN_PTK);

	// =====================================
	// Use Priority Ring & MiniportMMRequest
	// =====================================
	pAd->Sequence ++;
	WpaMacHeaderInit(pAd, &Header_802_11, 0, pAd->CommonCfg.Bssid);

	// ACK size	is 14 include CRC, and its rate	is based on real time information
	AckRate = pAd->CommonCfg.ExpectedACKRate[pAd->CommonCfg.TxRate];
	AckDuration = RTMPCalcDuration(pAd, AckRate, 14);
	Header_802_11.Duration = pAd->CommonCfg.Dsifs + AckDuration;

	// Zero message 2 body
	NdisZeroMemory(&Packet, sizeof(Packet));
	Packet.Version = EAPOL_VER;
	Packet.Type    = EAPOLKey;
	//
	// Message 2 as  EAPOL-Key(0,1,0,0,0,P,0,SNonce,MIC,RSN IE)
	//
	Packet.KeyDesc.Type = RSN_KEY_DESC;
	// 1. Key descriptor version and appropriate RSN IE
	if (pAd->CommonCfg.WepStatus	== Ndis802_11Encryption3Enabled)
	{
		Packet.KeyDesc.KeyInfo.KeyDescVer = 2;
		Packet.KeyDesc.KeyDataLen[1] = CipherWpaPskAesLen;
		NdisMoveMemory(Packet.KeyDesc.KeyData, CipherWpaPskAes, CipherWpaPskAesLen);
	}
	else	// TKIP
	{
		if (LEAP_CCKM_ON(pAd))
		{
			if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption1Enabled)
			{
				// LEAP + CCKM + WEP
				Packet.KeyDesc.KeyInfo.KeyDescVer = 1;
				Packet.KeyDesc.KeyDataLen[1] = CipherSuiteCiscoCCKMLen;
				NdisMoveMemory(Packet.KeyDesc.KeyData, CipherSuiteCiscoCCKM, CipherSuiteCiscoCCKMLen);
			}
			else if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled)
			{
				// LEAP + CCKM + TKIP
				Packet.KeyDesc.KeyInfo.KeyDescVer = 1;
				Packet.KeyDesc.KeyDataLen[1] = CipherSuiteCiscoCCKMTkipLen;
				NdisMoveMemory(Packet.KeyDesc.KeyData, CipherSuiteCiscoCCKMTkip, CipherSuiteCiscoCCKMTkipLen);
			}
		}
		else if ((pAd->StaCfg.LeapAuthMode == CISCO_AuthModeLEAP) && (pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled))
		{
			// LEAP + TKIP
			Packet.KeyDesc.KeyInfo.KeyDescVer = 1;
			Packet.KeyDesc.KeyDataLen[1] = CipherSuiteCCXTkipLen;
			NdisMoveMemory(Packet.KeyDesc.KeyData, CipherSuiteCCXTkip, CipherSuiteCCXTkipLen);
		}
		else
		{
			Packet.KeyDesc.KeyInfo.KeyDescVer = 1;
			Packet.KeyDesc.KeyDataLen[1] = CipherWpaPskTkipLen;
			NdisMoveMemory(Packet.KeyDesc.KeyData, CipherWpaPskTkip, CipherWpaPskTkipLen);
		}
	}
	// Update packet length after decide Key data payload
	Packet.Len[1]  = sizeof(KEY_DESCRIPTER) - MAX_LEN_OF_RSNIE + Packet.KeyDesc.KeyDataLen[1];

	// Update Key length
	Packet.KeyDesc.KeyLength[0] = pMsg1->KeyDesc.KeyLength[0];
	Packet.KeyDesc.KeyLength[1] = pMsg1->KeyDesc.KeyLength[1];
	// 2. Key Type PeerKey
	Packet.KeyDesc.KeyInfo.KeyType = 1;

	// 3. KeyMic field presented
	Packet.KeyDesc.KeyInfo.KeyMic  = 1;

	// 4. Fill SNonce
	NdisMoveMemory(Packet.KeyDesc.KeyNonce, pAd->StaCfg.SNonce, LEN_KEY_DESC_NONCE);

	// 5. Key Replay Count
	NdisMoveMemory(Packet.KeyDesc.ReplayCounter, pAd->StaCfg.ReplayCounter, LEN_KEY_DESC_REPLAY);

	// Send EAPOL(0, 1, 0, 0, 0, K, 0, TSNonce, 0, MIC(TPTK), 0)
	// Out buffer for transmitting message 2
	NStatus = MlmeAllocateMemory(pAd, (PVOID)&pOutBuffer);  //Get an unused nonpaged memory
	if (NStatus	!= NDIS_STATUS_SUCCESS)
	{
		kfree(mpool);
		return;
	}

	// Prepare EAPOL frame for MIC calculation
	// Be careful, only EAPOL frame is counted for MIC calculation
	MakeOutgoingFrame(pOutBuffer,           &FrameLen,
					Packet.Len[1] + 4,    &Packet,
					END_OF_ARGS);

	// 5. Prepare and Fill MIC value
	NdisZeroMemory(Mic,	sizeof(Mic));
	if (pAd->CommonCfg.WepStatus	== Ndis802_11Encryption3Enabled)
	{
		// AES
		UCHAR digest[80];

		HMAC_SHA1(pOutBuffer, FrameLen, PTK, LEN_EAP_MICK, digest);
		NdisMoveMemory(Mic,	digest,	LEN_KEY_DESC_MIC);
	}
	else
	{
		INT i;
		DBGPRINT_RAW(RT_DEBUG_INFO, (" PMK = "));
		for (i = 0; i < 16; i++)
			DBGPRINT_RAW(RT_DEBUG_INFO, ("%2x-", pAd->StaCfg.PskKey.Key[i]));

		DBGPRINT_RAW(RT_DEBUG_INFO, ("\n PTK = "));
		for (i = 0; i < 64; i++)
			DBGPRINT_RAW(RT_DEBUG_INFO, ("%2x-", pAd->StaCfg.PTK[i]));
		DBGPRINT_RAW(RT_DEBUG_INFO, ("\n FrameLen = %d\n", FrameLen));

		if (LEAP_CCKM_ON(pAd))
			hmac_md5(pAd->StaCfg.KRK, LEN_EAP_MICK, pOutBuffer, FrameLen, Mic);
		else
			hmac_md5(PTK,  LEN_EAP_MICK, pOutBuffer, FrameLen, Mic);
	}
	NdisMoveMemory(Packet.KeyDesc.KeyMic, Mic, LEN_KEY_DESC_MIC);

	MakeOutgoingFrame(pOutBuffer,           &FrameLen,
					sizeof(HEADER_802_11),&Header_802_11,
					sizeof(EAPHEAD),      EAPHEAD,
					Packet.Len[1] + 4,    &Packet,
					END_OF_ARGS);

	// Send using priority queue
	MiniportMMRequest(pAd, pOutBuffer, FrameLen);

	DBGPRINT(RT_DEBUG_TRACE, ("WpaPairMsg1Action <-----\n"));

	kfree(mpool);
	return;
}

/*
	========================================================================

	Routine Description:
		Process Pairwise key 4-way handshaking

	Arguments:
		pAd	Pointer	to our adapter
		Elem		Message body

	Return Value:
		None

	Note:

	========================================================================
*/
VOID	WpaPairMsg3Action(
	IN	PRTMP_ADAPTER	pAd,
	IN	MLME_QUEUE_ELEM	*Elem)
{
	NDIS_STATUS         Status;
	PHEADER_802_11		pHeader;
	PUCHAR				pOutBuffer = NULL;
	HEADER_802_11		Header_802_11;
	NDIS_STATUS			NStatus;
	UCHAR				AckRate = RATE_2;
	USHORT				AckDuration = 0;
	ULONG				FrameLen = 0;
	UCHAR				EAPHEAD[8] = {0xaa,	0xaa, 0x03,	0x00, 0x00,	0x00,0x88,0x8e};
	EAPOL_PACKET		Packet;
	PEAPOL_PACKET		pMsg3;
	PUCHAR				pTmp = (PUCHAR) &CipherWpaPskTkip;
	UCHAR				Mic[16], OldMic[16];
	PNDIS_802_11_KEY	pPeerKey;


	DBGPRINT(RT_DEBUG_TRACE, ("WpaPairMsg3Action ----->\n"));

	pHeader	= (PHEADER_802_11) Elem->Msg;

	// Process message 3 frame.
	pMsg3 = (PEAPOL_PACKET) &Elem->Msg[LENGTH_802_11 + LENGTH_802_1_H];

	// 1. Verify RSN IE & cipher type match
	if (pAd->CommonCfg.WepStatus	== Ndis802_11Encryption3Enabled)
	{
		if (pMsg3->KeyDesc.KeyInfo.KeyDescVer != 2)
			return;
		pTmp = (PUCHAR) &CipherWpaPskAes;
	}
	else	// TKIP
	{
		if (pMsg3->KeyDesc.KeyInfo.KeyDescVer != 1)
			return;

		if (LEAP_CCKM_ON(pAd))
		{
			if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption1Enabled)
				pTmp = (PUCHAR) &CipherSuiteCiscoCCKM;     //LEAP + CCKM + WEP
			else if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled)
				pTmp = (PUCHAR) &CipherSuiteCiscoCCKMTkip;     //LEAP + CCKM + TKIP
		}
		else if ((pAd->StaCfg.LeapAuthMode == CISCO_AuthModeLEAP) && (pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled))
			pTmp = (PUCHAR) &CipherSuiteCCXTkip;   //LEAP + TKIP
		else
			pTmp = (PUCHAR) &CipherWpaPskTkip;
	}

	// Fix compatibility issue, when AP append nonsense data after auth mode with different size.
	// We should qualify this kind of RSN as acceptable
	if (!NdisEqualMemory((PUCHAR) &pMsg3->KeyDesc.KeyData[2], pTmp + 2, CipherWpaPskTkipLen - 2))
	{
		DBGPRINT(RT_DEBUG_ERROR, (" RSN IE mismatched msg 3 of 4-way handshake!!!!!!!!!! \n"));
		return;
	}
	else
		DBGPRINT(RT_DEBUG_TRACE, (" RSN IE matched in msg 3 of 4-way handshake!!!!!!!!!! \n"));

	// 2. Check MIC value
	// Save the MIC and replace with zero
	NdisMoveMemory(OldMic, pMsg3->KeyDesc.KeyMic, LEN_KEY_DESC_MIC);
	NdisZeroMemory(pMsg3->KeyDesc.KeyMic, LEN_KEY_DESC_MIC);
	if (pAd->CommonCfg.WepStatus	== Ndis802_11Encryption3Enabled)
	{
		// AES
		UCHAR digest[80];

		HMAC_SHA1((PUCHAR) pMsg3, pMsg3->Len[1] + 4, pAd->StaCfg.PTK, LEN_EAP_MICK, digest);
		NdisMoveMemory(Mic,	digest,	LEN_KEY_DESC_MIC);
	}
	else
	{
		hmac_md5(pAd->StaCfg.PTK, LEN_EAP_MICK, (PUCHAR) pMsg3, pMsg3->Len[1] + 4, Mic);
	}

	if (!NdisEqualMemory(OldMic, Mic, LEN_KEY_DESC_MIC))
	{
		DBGPRINT(RT_DEBUG_ERROR, (" MIC Different in msg 3 of 4-way handshake!!!!!!!!!! \n"));
		return;
	}
	else
		DBGPRINT(RT_DEBUG_TRACE, (" MIC VALID in msg 3 of 4-way handshake!!!!!!!!!! \n"));

#if 0 /* have no necessary to check ReplayCounter and almost other implementation didn't check it either. */
	// 3. Check Replay Counter, it has to be larger than last one. No need to be exact one larger
	if (RTMPCompareMemory(pMsg3->KeyDesc.ReplayCounter, pAd->StaCfg.ReplayCounter, LEN_KEY_DESC_REPLAY) != 1)
		return;
#endif

	// Update new replay counter
	NdisMoveMemory(pAd->StaCfg.ReplayCounter, pMsg3->KeyDesc.ReplayCounter, LEN_KEY_DESC_REPLAY);

	// 4. Double check ANonce
	if (!NdisEqualMemory(pAd->StaCfg.ANonce, pMsg3->KeyDesc.KeyNonce, LEN_KEY_DESC_NONCE))
		return;

	// 5. Construct Message 4
	// =====================================
	// Use Priority Ring & MiniportMMRequest
	// =====================================
	pAd->Sequence ++;
	WpaMacHeaderInit(pAd, &Header_802_11, 0, pAd->CommonCfg.Bssid);

	// ACK size	is 14 include CRC, and its rate	is based on real time information
	AckRate = pAd->CommonCfg.ExpectedACKRate[pAd->CommonCfg.TxRate];
	AckDuration = RTMPCalcDuration(pAd, AckRate, 14);
	Header_802_11.Duration = pAd->CommonCfg.Dsifs + AckDuration;

	// Zero message 4 body
	NdisZeroMemory(&Packet, sizeof(Packet));
	Packet.Version = EAPOL_VER;
	Packet.Type    = EAPOLKey;
	Packet.Len[1]  = sizeof(KEY_DESCRIPTER) - MAX_LEN_OF_RSNIE;		// No data field

	//
	// Message 4 as  EAPOL-Key(0,1,0,0,0,P,0,0,MIC,0)
	//
	Packet.KeyDesc.Type = RSN_KEY_DESC;

	// Key descriptor version and appropriate RSN IE
	Packet.KeyDesc.KeyInfo.KeyDescVer = pMsg3->KeyDesc.KeyInfo.KeyDescVer;

	// Update Key Length
	Packet.KeyDesc.KeyLength[0] = pMsg3->KeyDesc.KeyLength[0];
	Packet.KeyDesc.KeyLength[1] = pMsg3->KeyDesc.KeyLength[1];

	// Key Type PeerKey
	Packet.KeyDesc.KeyInfo.KeyType = 1;

	// KeyMic field presented
	Packet.KeyDesc.KeyInfo.KeyMic  = 1;

	// Key Replay count
	NdisMoveMemory(Packet.KeyDesc.ReplayCounter, pMsg3->KeyDesc.ReplayCounter, LEN_KEY_DESC_REPLAY);

	// Out buffer for transmitting message 4
	NStatus = MlmeAllocateMemory(pAd, (PVOID)&pOutBuffer);  //Get an unused nonpaged memory
	if (NStatus	!= NDIS_STATUS_SUCCESS)
		return;

	// Prepare EAPOL frame for MIC calculation
	// Be careful, only EAPOL frame is counted for MIC calculation
	MakeOutgoingFrame(pOutBuffer,           &FrameLen,
					Packet.Len[1] + 4,    &Packet,
					END_OF_ARGS);

	// Prepare and Fill MIC value
	NdisZeroMemory(Mic,	sizeof(Mic));
	if (pAd->CommonCfg.WepStatus	== Ndis802_11Encryption3Enabled)
	{
		// AES
		UCHAR digest[80];

		HMAC_SHA1(pOutBuffer, FrameLen, pAd->StaCfg.PTK, LEN_EAP_MICK, digest);
		NdisMoveMemory(Mic,	digest,	LEN_KEY_DESC_MIC);
	}
	else
	{
		hmac_md5(pAd->StaCfg.PTK, LEN_EAP_MICK, pOutBuffer, FrameLen, Mic);
	}
	NdisMoveMemory(Packet.KeyDesc.KeyMic, Mic, LEN_KEY_DESC_MIC);

	// Make	 Transmitting frame
	MakeOutgoingFrame(pOutBuffer,           &FrameLen,
					sizeof(HEADER_802_11),&Header_802_11,
					sizeof(EAPHEAD),      EAPHEAD,
					Packet.Len[1] + 4,    &Packet,
					END_OF_ARGS);

	// 6. Send Message 4 to authenticator
	// Send using priority queue
	MiniportMMRequest(pAd, pOutBuffer, FrameLen);

	// 7. Update PTK
	Status = MlmeAllocateMemory(pAd, (PVOID)&pPeerKey);  //Get an unused nonpaged memory
	if (Status != NDIS_STATUS_SUCCESS)
		return;

	NdisZeroMemory(pPeerKey, sizeof(NDIS_802_11_KEY) + LEN_EAP_KEY);
	pPeerKey->Length    = sizeof(NDIS_802_11_KEY) + LEN_EAP_KEY;
	pPeerKey->KeyIndex  = 0xe0000000;
	pPeerKey->KeyLength = pMsg3->KeyDesc.KeyLength[0] * 256 + pMsg3->KeyDesc.KeyLength[1];

	COPY_MAC_ADDR(pPeerKey->BSSID, pAd->CommonCfg.Bssid);
	NdisMoveMemory(&pPeerKey->KeyRSC, pMsg3->KeyDesc.KeyRsc, LEN_KEY_DESC_RSC);
	NdisMoveMemory(pPeerKey->KeyMaterial, &pAd->StaCfg.PTK[32], LEN_EAP_KEY);
	// Call Add peer key function
	RTMPWPAAddKeyProc(pAd, pPeerKey);
	MlmeFreeMemory(pAd, pPeerKey);

	DBGPRINT(RT_DEBUG_TRACE, ("WpaPairMsg3Action <-----\n"));
}


/*
	========================================================================

	Routine Description:
		Process Group key 2-way handshaking

	Arguments:
		pAd	Pointer	to our adapter
		Elem		Message body

	Return Value:
		None

	Note:

	========================================================================
*/
VOID	WpaGroupMsg1Action(
	IN	PRTMP_ADAPTER	pAd,
	IN	MLME_QUEUE_ELEM	*Elem)
{
	NDIS_STATUS         Status;
	PHEADER_802_11		pHeader;
	PUCHAR				pOutBuffer = NULL;
	HEADER_802_11		Header_802_11;
	NDIS_STATUS			NStatus;
	UCHAR				AckRate = RATE_2;
	USHORT				AckDuration = 0;
	ULONG				FrameLen = 0;
	UCHAR				EAPHEAD[8] = {0xaa,	0xaa, 0x03,	0x00, 0x00,	0x00,0x88,0x8e};
	EAPOL_PACKET		Packet;
	PEAPOL_PACKET		pGroup;
	UCHAR				Mic[16], OldMic[16];
	UCHAR				GTK[32], Key[32];
	PNDIS_802_11_KEY	pGroupKey;
	BOOLEAN				TimerCancelled;

	DBGPRINT(RT_DEBUG_TRACE, ("WpaGroupMsg1Action ----->\n"));

	pHeader	= (PHEADER_802_11) Elem->Msg;

	// Process Group message 1 frame.
	pGroup = (PEAPOL_PACKET) &Elem->Msg[LENGTH_802_11 + LENGTH_802_1_H];

#if 0 /* have no necessary to check ReplayCounter and almost other implementation didn't check it either. */
	// 1. Verify Replay counter
	//    Check Replay Counter, it has to be larger than last one. No need to be exact one larger
	if (RTMPCompareMemory(pGroup->KeyDesc.ReplayCounter, pAd->StaCfg.ReplayCounter, LEN_KEY_DESC_REPLAY) != 1)
		return;
#endif

	// Update new replay counter
	NdisMoveMemory(pAd->StaCfg.ReplayCounter, pGroup->KeyDesc.ReplayCounter, LEN_KEY_DESC_REPLAY);

	// 2. Verify MIC is valid
	// Save the MIC and replace with zero
	NdisMoveMemory(OldMic, pGroup->KeyDesc.KeyMic, LEN_KEY_DESC_MIC);
	NdisZeroMemory(pGroup->KeyDesc.KeyMic, LEN_KEY_DESC_MIC);
	if (pAd->CommonCfg.WepStatus	== Ndis802_11Encryption3Enabled)
	{
		// AES
		UCHAR digest[80];

		HMAC_SHA1((PUCHAR) pGroup, pGroup->Len[1] + 4, pAd->StaCfg.PTK, LEN_EAP_MICK, digest);
		NdisMoveMemory(Mic,	digest,	LEN_KEY_DESC_MIC);
	}
	else
	{
		hmac_md5(pAd->StaCfg.PTK, LEN_EAP_MICK, (PUCHAR) pGroup, pGroup->Len[1] + 4, Mic);
	}

	if (!NdisEqualMemory(OldMic, Mic, LEN_KEY_DESC_MIC))
	{
		DBGPRINT(RT_DEBUG_ERROR, (" MIC Different in group msg 1 of 2-way handshake!!!!!!!!!! \n"));
		return;
	}
	else
		DBGPRINT(RT_DEBUG_TRACE, (" MIC VALID in group msg 1 of 2-way handshake!!!!!!!!!! \n"));

	// 3. Decrypt GTK from Key Data
	if (pAd->CommonCfg.WepStatus	== Ndis802_11Encryption3Enabled)
	{
		if (pGroup->KeyDesc.KeyInfo.KeyDescVer != 2)
			return;
		// Decrypt AES GTK
		AES_GTK_KEY_UNWRAP(&pAd->StaCfg.PTK[16], GTK, pGroup->KeyDesc.KeyData);
	}
	else	// TKIP
	{
		INT	i;

		if (pGroup->KeyDesc.KeyInfo.KeyDescVer != 1)
			return;
		// Decrypt TKIP GTK
		// Construct 32 bytes RC4 Key
		NdisMoveMemory(Key, pGroup->KeyDesc.KeyIv, 16);
		NdisMoveMemory(&Key[16], &pAd->StaCfg.PTK[16], 16);
		ARCFOUR_INIT(&pAd->PrivateInfo.WEPCONTEXT, Key, 32);
		//discard first 256 bytes
		for (i = 0; i < 256; i++)
			ARCFOUR_BYTE(&pAd->PrivateInfo.WEPCONTEXT);
		// Decrypt GTK. Becareful, there is no ICV to check the result is correct or not
		ARCFOUR_DECRYPT(&pAd->PrivateInfo.WEPCONTEXT, GTK, pGroup->KeyDesc.KeyData, 32);
	}

	// 4. Construct Group Message 2
	pAd->Sequence ++;
	WpaMacHeaderInit(pAd, &Header_802_11, 1, pAd->CommonCfg.Bssid);

	// ACK size	is 14 include CRC, and its rate	is based on real time information
	AckRate = pAd->CommonCfg.ExpectedACKRate[pAd->CommonCfg.TxRate];
	AckDuration = RTMPCalcDuration(pAd, AckRate, 14);
	Header_802_11.Duration = pAd->CommonCfg.Dsifs + AckDuration;

	// Zero Group message 1 body
	NdisZeroMemory(&Packet, sizeof(Packet));
	Packet.Version = EAPOL_VER;
	Packet.Type    = EAPOLKey;
	Packet.Len[1]  = sizeof(KEY_DESCRIPTER) - MAX_LEN_OF_RSNIE;		// No data field

	//
	// Group Message 2 as  EAPOL-Key(1,0,0,0,G,0,0,MIC,0)
	//
	Packet.KeyDesc.Type = RSN_KEY_DESC;

	// Key descriptor version and appropriate RSN IE
	Packet.KeyDesc.KeyInfo.KeyDescVer = pGroup->KeyDesc.KeyInfo.KeyDescVer;

	// Update Key Length and Key Index
	Packet.KeyDesc.KeyInfo.KeyIndex = pGroup->KeyDesc.KeyInfo.KeyIndex;
	Packet.KeyDesc.KeyLength[0] = pGroup->KeyDesc.KeyLength[0];
	Packet.KeyDesc.KeyLength[1] = pGroup->KeyDesc.KeyLength[1];

	// Key Type Group key
	Packet.KeyDesc.KeyInfo.KeyType = 0;

	// KeyMic field presented
	Packet.KeyDesc.KeyInfo.KeyMic  = 1;

	// Secure bit is 1
	Packet.KeyDesc.KeyInfo.Secure  = 1;

	// Key Replay count
	NdisMoveMemory(Packet.KeyDesc.ReplayCounter, pGroup->KeyDesc.ReplayCounter, LEN_KEY_DESC_REPLAY);

	// Out buffer for transmitting group message 2
	NStatus = MlmeAllocateMemory(pAd, (PVOID)&pOutBuffer);  //Get an unused nonpaged memory
	if (NStatus	!= NDIS_STATUS_SUCCESS)
		return;

	// Prepare EAPOL frame for MIC calculation
	// Be careful, only EAPOL frame is counted for MIC calculation
	MakeOutgoingFrame(pOutBuffer,           &FrameLen,
					Packet.Len[1] + 4,    &Packet,
					END_OF_ARGS);

	// Prepare and Fill MIC value
	NdisZeroMemory(Mic,	sizeof(Mic));
	if (pAd->CommonCfg.WepStatus	== Ndis802_11Encryption3Enabled)
	{
		// AES
		UCHAR digest[80];

		HMAC_SHA1(pOutBuffer, FrameLen, pAd->StaCfg.PTK, LEN_EAP_MICK, digest);
		NdisMoveMemory(Mic,	digest,	LEN_KEY_DESC_MIC);
	}
	else
	{
		INT i;
		DBGPRINT_RAW(RT_DEBUG_INFO, ("PTK = "));
		for (i = 0; i < 64; i++)
			DBGPRINT_RAW(RT_DEBUG_INFO, ("%2x-", pAd->StaCfg.PTK[i]));
		DBGPRINT_RAW(RT_DEBUG_INFO, ("\n FrameLen = %d\n", FrameLen));

		hmac_md5(pAd->StaCfg.PTK, LEN_EAP_MICK, pOutBuffer, FrameLen, Mic);
	}
	NdisMoveMemory(Packet.KeyDesc.KeyMic, Mic, LEN_KEY_DESC_MIC);

	// Make	Transmitting frame
	MakeOutgoingFrame(pOutBuffer,           &FrameLen,
					sizeof(HEADER_802_11),&Header_802_11,
					sizeof(EAPHEAD),      EAPHEAD,
					Packet.Len[1] + 4,    &Packet,
					END_OF_ARGS);

	// 5. Copy frame to Tx ring and prepare for encryption
	WpaHardTransmit(pAd, pOutBuffer, FrameLen);

	// 6 Free allocated memory
	MlmeFreeMemory(pAd, pOutBuffer);

	// 6. Update GTK
	Status = MlmeAllocateMemory(pAd, (PVOID)&pGroupKey);  //Get an unused nonpaged memory
	if (Status != NDIS_STATUS_SUCCESS)
		return;

	NdisZeroMemory(pGroupKey, sizeof(NDIS_802_11_KEY) + LEN_EAP_KEY);
	pGroupKey->Length    = sizeof(NDIS_802_11_KEY) + LEN_EAP_KEY;
	pGroupKey->KeyIndex  = 0x20000000 | pGroup->KeyDesc.KeyInfo.KeyIndex;
	pGroupKey->KeyLength = pGroup->KeyDesc.KeyLength[0] * 256 + pGroup->KeyDesc.KeyLength[1];

	COPY_MAC_ADDR(pGroupKey->BSSID, pAd->CommonCfg.Bssid);
	NdisMoveMemory(pGroupKey->KeyMaterial, GTK, LEN_EAP_KEY);

	//
	// Before Set GroupKey, we need to check if we need to report RogueAP for CCX.
	//
	if (pAd->StaCfg.LeapAuthMode == CISCO_AuthModeLEAP)
	{
		RTMPCancelTimer(&pAd->StaCfg.LeapAuthTimer, &TimerCancelled);

		if (pAd->StaCfg.LeapAuthInfo.CCKM == TRUE)
		{
			//
			// Indicate CCKM LinkUP
			//
			pAd->StaCfg.CCKMLinkUpFlag = TRUE;
		}

		if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption1Enabled)
		{
			//
			// When port is not equal to WPA_802_1X_PORT_SECURED, means it's the first time we link up to ap.
			// On the same time, we need to report RogueAP.
			// After that port will be set to WPA_802_1X_PORT_SECURED
			//
			if (pAd->StaCfg.PortSecured != WPA_802_1X_PORT_SECURED)
				LeapSendRogueAPReport(pAd);
		}
	}

	// Call Add peer key function
	RTMPWPAAddKeyProc(pAd, pGroupKey);
	MlmeFreeMemory(pAd, pGroupKey);

	DBGPRINT(RT_DEBUG_TRACE, ("WpaGroupMsg1Action <-----\n"));
}
/*
	========================================================================

	Routine Description:
		Init WPA MAC header

	Arguments:
		pAd	Pointer	to our adapter

	Return Value:
		None

	Note:

	========================================================================
*/
VOID	WpaMacHeaderInit(
	IN		PRTMP_ADAPTER	pAd,
	IN OUT	PHEADER_802_11	pHdr80211,
	IN		UCHAR			wep,
	IN		PUCHAR		    pAddr1)
{
	NdisZeroMemory(pHdr80211, sizeof(HEADER_802_11));
	pHdr80211->FC.Type	= BTYPE_DATA;
	pHdr80211->FC.ToDs	= 1;
	if (wep	== 1)
		pHdr80211->FC.Wep = 1;

	 //	Addr1: DA, Addr2: BSSID, Addr3:	SA
	COPY_MAC_ADDR(pHdr80211->Addr1, pAddr1);
	COPY_MAC_ADDR(pHdr80211->Addr2, pAd->CurrentAddress);
	COPY_MAC_ADDR(pHdr80211->Addr3, pAd->CommonCfg.Bssid);
	pHdr80211->Sequence =	pAd->Sequence;
}

/*
	========================================================================

	Routine	Description:
		Copy frame from waiting queue into relative ring buffer and set
	appropriate ASIC register to kick hardware encryption before really
	sent out to air.

	Arguments:
		pAd		Pointer	to our adapter
		PNDIS_PACKET	Pointer to outgoing Ndis frame
		NumberOfFrag	Number of fragment required

	Return Value:
		None

	Note:

	========================================================================
*/
VOID	WpaHardTransmit(
	IN	PRTMP_ADAPTER	pAd,
	IN	PUCHAR			pFrame,
	IN	ULONG			FrameLen)
{
	UCHAR			*OutBuffer = NULL;
	UCHAR			FrameGap;
	PUCHAR			pSrc, pDest;
	ULONG			Iv16,Iv;
	ULONG			Iv32;
	PCIPHER_KEY		pWpaKey;
//For CCX 2.X
	UCHAR			ckip_ck[16];
	UCHAR			ckip_pk[16];     /* permuted key */
//	UCHAR			CMIC[4];
	PUCHAR			ptr;
	INT				idx;
	NDIS_STATUS 	 NStatus;
	UCHAR			i;
	UCHAR			RC4Key[16];
	UINT			p1k[5]; //for mix_key;
	ULONG			pnl;/* Least significant 16 bits of PN */
	ULONG			pnh;/* Most significant 32 bits of PN */


	NStatus = MlmeAllocateMemory(pAd, (PVOID)&OutBuffer);  //Get an unused nonpaged memory
	if (NStatus != NDIS_STATUS_SUCCESS)
	{
		DBGPRINT(RT_DEBUG_TRACE,("ASSOC - MlmeAssocReqAction() allocate memory failed \n"));
		pAd->Mlme.AssocMachine.CurrState = ASSOC_IDLE;
		MlmeCntlConfirm(pAd, MT2_ASSOC_CONF, MLME_FAIL_NO_RESOURCE);
		return;
	}
	FrameGap = IFS_BACKOFF;		// Default frame gap mode
	pDest = (PUCHAR)OutBuffer;
	pSrc = pFrame;

	// outgoing frame always wakeup PHY to prevent frame lost and
	// turn off PSM bit to improve performance
	if (pAd->StaCfg.Psm == PWR_SAVE)
	{
		MlmeSetPsmBit(pAd, PWR_ACTIVE);
	}

	if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_DOZE))
		AsicForceWakeup(pAd);

	pWpaKey = (PCIPHER_KEY) &pAd->SharedKey[BSS0][0];

	if (pWpaKey->KeyLen == 0)
	{
		return;
	}

	if (CKIP_KP_ON(pAd))
	{
		// 1. fill up ckip_ck with default key.
		if (pWpaKey->KeyLen < 16)
		{
			for (i = 0; i < (16 / pWpaKey->KeyLen); i++)
			{
				NdisMoveMemory(ckip_ck + (i * pWpaKey->KeyLen), pWpaKey->Key, pWpaKey->KeyLen);
			}

			NdisMoveMemory(ckip_ck + (i * pWpaKey->KeyLen), pWpaKey->Key, 16 - (i * pWpaKey->KeyLen));
		}
		else
			NdisMoveMemory(ckip_ck, pWpaKey->Key, pWpaKey->KeyLen);


		// 2. Calcaulate CPK
		idx = 2;
		while (++pAd->StaCfg.GIV[idx] == 0x0)
		{
			idx--;
			if (idx < 0)
				break;
		}
		ptr = (PUCHAR) pFrame;

		CKIP_key_permute(ckip_pk, ckip_ck, *(ptr + 1) & 3, pAd->StaCfg.GIV);

		// 3. Init RC4 Engine.
		RTMPInitWepEngine(
						pAd,
						ckip_pk,
						0,
						13,
						(PUCHAR) &Iv);

		NdisMoveMemory(pDest, pSrc, LENGTH_802_11);
		pDest += LENGTH_802_11;
		pSrc += LENGTH_802_11;
		NdisMoveMemory(pDest, &Iv, 4);
		pDest += 4;

		RTMPEncryptData(pAd, pSrc, pDest, FrameLen - LENGTH_802_11);
		pDest += (FrameLen  - LENGTH_802_11);
		RTMPSetICV(pAd, pDest);
		FrameLen = FrameLen + 8;  //IV + ICV
		DBGPRINT(RT_DEBUG_TRACE, ("WpaGroupMsg1Action ----->len = %d\n", FrameLen));
		MiniportMMRequest(pAd, OutBuffer, FrameLen);
	}
	else
	{
		if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled)
		{
			i = 0;

			// Calculate MIC value
			RTMPInitMICEngine(
				pAd,
				pWpaKey->Key,
				pSrc + 4,
				pSrc + 10,
				0,
				pWpaKey->TxMic);

			NdisMoveMemory(pDest, pSrc, LENGTH_802_11);
			pDest += LENGTH_802_11;
			pSrc += LENGTH_802_11;
			RTMPTkipAppend(&pAd->PrivateInfo.Tx, pSrc, (FrameLen - LENGTH_802_11));
			RTMPTkipGetMIC(&pAd->PrivateInfo.Tx);

			RTMPInitTkipEngine(
				pAd,
				pWpaKey->Key,
				0,
				pAd->CurrentAddress,
				pWpaKey->TxMic,
				pWpaKey->TxTsc,
				&Iv16,
				&Iv32);

			pnl = (ULONG) *(pWpaKey->TxTsc) + (((ULONG) *(pWpaKey->TxTsc + 1)) << 8);	//TSC[0]:TSC[1]
			pnh = *(PULONG)(pWpaKey->TxTsc + 2);

			pAd->PrivateInfo.FCSCRC32 = PPPINITFCS32;   //Init crc32.
			RTMPTkipMixKey(pWpaKey->Key, pAd->CurrentAddress, pnl, pnh, RC4Key, p1k);

			// Copy 8 bytes encapsulation into Tx ring
			NdisMoveMemory(pDest, &Iv16, 4);
			pDest += 4;
			NdisMoveMemory(pDest, &Iv32, 4);
			pDest += 4;

			// Init RC4 encyption engine
			ARCFOUR_INIT(&pAd->PrivateInfo.WEPCONTEXT, RC4Key, 16);

			// Increase TxTsc value for next transmission
			while (++pWpaKey->TxTsc[i] == 0x0)
			{
				i++;
				if (i == 6)
					break;
			}

			if (i == 6)
			{
				// TODO: TSC has done one full cycle, do re-keying stuff follow specs
				// Should send a special event microsoft defined to request re-key
			}

			RTMPEncryptData(pAd, pSrc, pDest, (FrameLen - LENGTH_802_11));
			pDest +=  (FrameLen - LENGTH_802_11);

			RTMPEncryptData(pAd, pAd->PrivateInfo.Tx.MIC, pDest, 8);
			pDest +=  8;
			FrameLen += 8;
			RTMPSetICV(pAd, pDest);
			FrameLen += 12;

			MiniportMMRequest(pAd, OutBuffer, FrameLen);
		}
	}
}

/*
	========================================================================

	Routine Description:
		SHA1 function

	Arguments:

	Return Value:

	Note:

	========================================================================
*/
VOID	HMAC_SHA1(
	IN	UCHAR	*text,
	IN	UINT	text_len,
	IN	UCHAR	*key,
	IN	UINT	key_len,
	IN	UCHAR	*digest)
{
	SHA_CTX	context;
	UCHAR	k_ipad[65]; /* inner padding - key XORd with ipad	*/
	UCHAR	k_opad[65]; /* outer padding - key XORd with opad	*/
	INT		i;

	// if key is longer	than 64	bytes reset	it to key=SHA1(key)
	if (key_len	> 64)
	{
		SHA_CTX		 tctx;
		SHAInit(&tctx);
		SHAUpdate(&tctx, key, key_len);
		SHAFinal(&tctx,	key);
		key_len	= 20;
	}
	NdisZeroMemory(k_ipad, sizeof(k_ipad));
	NdisZeroMemory(k_opad, sizeof(k_opad));
	NdisMoveMemory(k_ipad, key,	key_len);
	NdisMoveMemory(k_opad, key,	key_len);

	// XOR key with	ipad and opad values
	for	(i = 0;	i <	64;	i++)
	{
		k_ipad[i] ^= 0x36;
		k_opad[i] ^= 0x5c;
	}

	// perform inner SHA1
	SHAInit(&context); 						/* init context for 1st pass */
	SHAUpdate(&context,	k_ipad,	64);		/*	start with inner pad */
	SHAUpdate(&context,	text, text_len);	/*	then text of datagram */
	SHAFinal(&context, digest);				/* finish up 1st pass */

	//perform outer	SHA1
	SHAInit(&context);					/* init context for 2nd pass */
	SHAUpdate(&context,	k_opad,	64);	/*	start with outer pad */
	SHAUpdate(&context,	digest,	20);	/*	then results of	1st	hash */
	SHAFinal(&context, digest);			/* finish up 2nd pass */
}

/*
	========================================================================

	Routine Description:
		PRF function

	Arguments:

	Return Value:

	Note:
		802.1i	Annex F.9

	========================================================================
*/
VOID	PRF(
	IN	UCHAR	*key,
	IN	INT		key_len,
	IN	UCHAR	*prefix,
	IN	INT		prefix_len,
	IN	UCHAR	*data,
	IN	INT		data_len,
	OUT	UCHAR	*output,
	IN	INT		len)
{
	INT		i;
	UCHAR	*input;
	INT		currentindex = 0;
	INT		total_len;
	BOOLEAN	bfree = TRUE;

	input = kmalloc(1024, MEM_ALLOC_FLAG);  // allocate memory
	if (input == NULL) {
		input = prf_input;
		bfree = FALSE;
	}

	NdisMoveMemory(input, prefix, prefix_len);
	input[prefix_len] =	0;
	NdisMoveMemory(&input[prefix_len + 1], data, data_len);
	total_len =	prefix_len + 1 + data_len;
	input[total_len] = 0;
	total_len++;
	for	(i = 0;	i <	(len + 19) / 20; i++)
	{
		HMAC_SHA1(input, total_len,	key, key_len, &output[currentindex]);
		currentindex +=	20;
		input[total_len - 1]++;
	}

	if (bfree==TRUE) kfree(input);
	return;
}

/*
	========================================================================

	Routine Description:
		Cisco CCKM PRF function

	Arguments:
		key				Cisco Base Transient Key (BTK)
		key_len			The key length of the BTK
		data			Ruquest Number(RN) + BSSID
		data_len		The length of the data
		output			Store for PTK(Pairwise transient keys)
		len				The length of the output
	Return Value:
		None

	Note:
		802.1i	Annex F.9

	========================================================================
*/
VOID    CCKMPRF(
	IN	UCHAR	*key,
	IN	INT		key_len,
	IN	UCHAR	*data,
	IN	INT		data_len,
	OUT	UCHAR	*output,
	IN	INT		len)
{
	INT		i;
	UCHAR	*input;
	INT		currentindex = 0;
	INT		total_len;
	BOOLEAN	bfree = TRUE;

	input = kmalloc(1024, MEM_ALLOC_FLAG);  // allocate memory
	if (input == NULL) {
		input = prf_input;
		bfree = FALSE;
	}


	NdisMoveMemory(input, data, data_len);
	total_len = data_len;
	input[total_len] = 0;
	total_len++;
	for	(i = 0;	i <	(len + 19) / 20; i++)
	{
		HMAC_SHA1(input, total_len,	key, key_len, &output[currentindex]);
		currentindex +=	20;
		input[total_len - 1]++;
	}

	if (bfree==TRUE) kfree(input);
	return;
}

/*
	========================================================================

	Routine Description:
		Count TPTK from PMK

	Arguments:

	Return Value:
		Output		Store the TPTK

	Note:

	========================================================================
*/
VOID WpaCountPTK(
	IN	PRTMP_ADAPTER	pAd,
	IN	UCHAR	*PMK,
	IN	UCHAR	*ANonce,
	IN	UCHAR	*AA,
	IN	UCHAR	*SNonce,
	IN	UCHAR	*SA,
	OUT	UCHAR	*output,
	IN	UINT	len)
{
	UCHAR	concatenation[76];
	UINT	CurrPos = 0;
	UCHAR	temp[32];
	UCHAR	Prefix[] = {'P', 'a', 'i', 'r', 'w', 'i', 's', 'e', ' ', 'k', 'e', 'y', ' ',
						'e', 'x', 'p', 'a', 'n', 's', 'i', 'o', 'n'};
	UCHAR	CCKMPrefix[] = {'F', 'a', 's', 't', '-', 'R', 'o', 'a', 'm', ' ', 'G', 'e', 'n',
						'e', 'r', 'a', 't', 'e', ' ', 'B', 'a', 's', 'e', ' ', 'K', 'e', 'y'};

	NdisZeroMemory(temp, sizeof(temp));

	if (LEAP_CCKM_ON(pAd))
	{
		NdisMoveMemory(concatenation, AA, 6);
		CurrPos += 6;

		NdisMoveMemory(&concatenation[CurrPos],	SA, 6);
		CurrPos += 6;

		NdisMoveMemory(&concatenation[CurrPos],	SNonce, 32);
		CurrPos += 32;

		NdisMoveMemory(&concatenation[CurrPos],	ANonce, 32);
		CurrPos += 32;

		PRF(PMK, 16, CCKMPrefix, 27, concatenation, 76, output, len);
	}
	else
	{
		// Get smaller address
		if (RTMPCompareMemory(SA, AA, 6) == 1)
			NdisMoveMemory(concatenation, AA, 6);
		else
			NdisMoveMemory(concatenation, SA, 6);
		CurrPos += 6;

		// Get larger address
		if (RTMPCompareMemory(SA, AA, 6) == 1)
			NdisMoveMemory(&concatenation[CurrPos], SA, 6);
		else
			NdisMoveMemory(&concatenation[CurrPos], AA, 6);
		CurrPos += 6;

		// Get smaller address
		if (RTMPCompareMemory(ANonce, SNonce, 32) == 1)
			NdisMoveMemory(&concatenation[CurrPos], SNonce, 32);
		else
			NdisMoveMemory(&concatenation[CurrPos], ANonce, 32);
		CurrPos += 32;

		// Get larger address
		if (RTMPCompareMemory(ANonce, SNonce, 32) == 1)
			NdisMoveMemory(&concatenation[CurrPos], ANonce, 32);
		else
			NdisMoveMemory(&concatenation[CurrPos], SNonce, 32);
		CurrPos += 32;

		if ((pAd->StaCfg.LeapAuthMode == CISCO_AuthModeLEAP) && (pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled))
			PRF(PMK, 16, Prefix, 22, concatenation, 76, output, len);
		else
			PRF(PMK, LEN_MASTER_KEY, Prefix, 22, concatenation, 76, output, len);
	}
}

/*
	========================================================================

	Routine Description:
		Misc function to Generate random number

	Arguments:

	Return Value:

	Note:
		802.1i  Annex F.9

	========================================================================
*/
VOID	GenRandom(
	IN	PRTMP_ADAPTER	pAd,
	OUT	UCHAR			*random)
{
	INT		i, curr;
	UCHAR	local[80], KeyCounter[32];
	UCHAR	result[80];
	LARGE_INTEGER	CurrentTime;
	UCHAR	prefix[] = {'I', 'n', 'i', 't', ' ', 'C', 'o', 'u', 'n', 't', 'e', 'r'};

	NdisZeroMemory(result, 80);
	NdisZeroMemory(local, 80);
	NdisZeroMemory(KeyCounter, 32);
	COPY_MAC_ADDR(local, pAd->CurrentAddress);

	for	(i = 0;	i <	32;	i++)
	{
		curr =	MAC_ADDR_LEN;
		NdisGetCurrentSystemTime(&CurrentTime);
		COPY_MAC_ADDR(local,  pAd->CurrentAddress);
		curr +=	MAC_ADDR_LEN;
		NdisMoveMemory(&local[curr],  &CurrentTime.u.LowPart,	sizeof(ULONG));
		curr +=	sizeof(ULONG);
		NdisMoveMemory(&local[curr],  result, 32);
		curr +=	32;
		NdisMoveMemory(&local[curr],  &i,  2);
		curr +=	2;
		PRF(KeyCounter, 32, prefix,12, local,	curr, result, 32);
	}
	NdisMoveMemory(random, result,	32);
}

/*
	========================================================================

	Routine Description:
		Misc function to decrypt AES body

	Arguments:

	Return Value:

	Note:
		This function references to	RFC	3394 for aes key unwrap algorithm.

	========================================================================
*/
VOID	AES_GTK_KEY_UNWRAP(
	IN	UCHAR	*key,
	OUT UCHAR	*plaintext,
	IN	UCHAR	*ciphertext)
{
	UCHAR		A[8],	BIN[16], BOUT[16];
	UCHAR		R1[8],R2[8];
	UCHAR		xor;
	INT			num_blocks = 2;
	INT			j;
	aes_context	aesctx;

	// Initialize
	// A = C[0]
	NdisMoveMemory(A, ciphertext, 8);
	// R1 = C1
	NdisMoveMemory(R1, &ciphertext[8], 8);
	// R2 = C2
	NdisMoveMemory(R2, &ciphertext[16], 8);

	aes_set_key(&aesctx, key, 128);

	for (j = 5; j >= 0; j--)
	{
		xor = num_blocks * j + 2;
		NdisMoveMemory(BIN, A, 8);
		BIN[7] = A[7] ^ xor;
		NdisMoveMemory(&BIN[8],	R2,	8);
		aes_decrypt(&aesctx, BIN, BOUT);
		NdisMoveMemory(A, &BOUT[0],	8);
		NdisMoveMemory(R2, &BOUT[8], 8);

		xor = num_blocks * j + 1;
		NdisMoveMemory(BIN, A, 8);
		BIN[7] = A[7] ^ xor;
		NdisMoveMemory(&BIN[8],	R1,	8);
		aes_decrypt(&aesctx, BIN, BOUT);
		NdisMoveMemory(A, &BOUT[0],	8);
		NdisMoveMemory(R1, &BOUT[8], 8);
	}

	// OUTPUT
	NdisMoveMemory(&plaintext[0], R1, 8);
	NdisMoveMemory(&plaintext[8], R2, 8);
}
