/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002-2005, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	rtusb_data.c

	Abstract:
	Ralink USB driver Tx/Rx functions

	Revision History:
	Who         When          What
	--------    ----------    ----------------------------------------------
	Nemo Tang    02-20-2005    created

*/
#include	"rt_config.h"

extern  UCHAR Phy11BGNextRateUpward[]; // defined in mlme.c

UCHAR	SNAP_802_1H[] = {0xaa, 0xaa, 0x03, 0x00, 0x00, 0x00};
UCHAR	SNAP_BRIDGE_TUNNEL[] = {0xaa, 0xaa, 0x03, 0x00, 0x00, 0xf8};
// Add Cisco Aironet SNAP heade for CCX2 support
UCHAR	SNAP_AIRONET[] = {0xaa, 0xaa, 0x03, 0x00, 0x40, 0x96, 0x00, 0x00};
UCHAR	CKIP_LLC_SNAP[] = {0xaa, 0xaa, 0x03, 0x00, 0x40, 0x96, 0x00, 0x02};
UCHAR	EAPOL_LLC_SNAP[]= {0xaa, 0xaa, 0x03, 0x00, 0x00, 0x00, 0x88, 0x8e};
UCHAR	EAPOL[] = {0x88, 0x8e};

UCHAR	IPX[] = {0x81, 0x37};
UCHAR	APPLE_TALK[] = {0x80, 0xf3};
UCHAR	RateIdToPlcpSignal[12] = {
	 0, /* RATE_1 */    1, /* RATE_2 */     2, /* RATE_5_5 */   3, /* RATE_11 */    // see BBP spec
	11, /* RATE_6 */   15, /* RATE_9 */    10, /* RATE_12 */   14, /* RATE_18 */    // see IEEE802.11a-1999 p.14
	 9, /* RATE_24 */  13, /* RATE_36 */    8, /* RATE_48 */   12  /* RATE_54 */ }; // see IEEE802.11a-1999 p.14

UCHAR    OfdmSignalToRateId[16] = {
	RATE_54,  RATE_54,  RATE_54,  RATE_54,  // OFDM PLCP Signal = 0,  1,  2,  3 respectively
	RATE_54,  RATE_54,  RATE_54,  RATE_54,  // OFDM PLCP Signal = 4,  5,  6,  7 respectively
	RATE_48,  RATE_24,  RATE_12,  RATE_6,   // OFDM PLCP Signal = 8,  9,  10, 11 respectively
	RATE_54,  RATE_36,  RATE_18,  RATE_9,   // OFDM PLCP Signal = 12, 13, 14, 15 respectively
};

UCHAR default_cwmin[]={CW_MIN_IN_BITS, CW_MIN_IN_BITS, CW_MIN_IN_BITS-1, CW_MIN_IN_BITS-2};
UCHAR default_cwmax[]={CW_MAX_IN_BITS, CW_MAX_IN_BITS, CW_MIN_IN_BITS, CW_MIN_IN_BITS-1};
UCHAR default_sta_aifsn[]={3,7,2,2};

UCHAR MapUserPriorityToAccessCategory[8] = {QID_AC_BE, QID_AC_BK, QID_AC_BK, QID_AC_BE, QID_AC_VI, QID_AC_VI, QID_AC_VO, QID_AC_VO};

/////////////////////////////////////////////////////////////////////////////////
// IRQL = DISPATCH_LEVEL
// NOTE: we do have an assumption here, that Byte0 and Byte1 always reasid at the same
//       scatter gather buffer
#if 0 // Dennis Lee
NDIS_STATUS Sniff2BytesFromNdisBuffer(
	IN  PNDIS_BUFFER    pFirstBuffer,
	IN  UCHAR           DesiredOffset,
	OUT PUCHAR          pByte0,
	OUT PUCHAR          pByte1)
{
	PUCHAR pBufferVA;
	ULONG  BufferLen, AccumulateBufferLen, BufferBeginOffset;

	NDIS_QUERY_BUFFER(pFirstBuffer, &pBufferVA, &BufferLen);
	BufferBeginOffset   = 0;
	AccumulateBufferLen = BufferLen;
	while (pFirstBuffer && (DesiredOffset >= AccumulateBufferLen))
	{
		BufferBeginOffset   += BufferLen;
		NdisGetNextBuffer(pFirstBuffer, &pFirstBuffer);
		if (! pFirstBuffer)
		{
			DBGPRINT_RAW(RT_DEBUG_TRACE,("Sniff2BytesFromNdisBuffer(offset=%d) ERROR\n", DesiredOffset));
			return NDIS_STATUS_FAILURE;
		}
		NDIS_QUERY_BUFFER(pFirstBuffer, &pBufferVA, &BufferLen);
		AccumulateBufferLen += BufferLen;
	}
	*pByte0 = *(PUCHAR)(pBufferVA + DesiredOffset - BufferBeginOffset);
	*pByte1 = *(PUCHAR)(pBufferVA + DesiredOffset - BufferBeginOffset + 1);
	return NDIS_STATUS_SUCCESS;
}
#endif

/*
	========================================================================

	Routine Description:
		MiniportSendPackets handler

	Arguments:

	Return Value:
		None

	IRQL = DISPATCH_LEVEL

	Note:

	========================================================================
*/
INT RTMPSendPackets(
    struct sk_buff *skb, struct net_device *dev)
{

	NDIS_HANDLE		MiniportAdapterContext = (NDIS_HANDLE)dev->priv;
	PPNDIS_PACKET	ppPacketArray = (PPNDIS_PACKET)&skb;
	UINT			NumberOfPackets=1;

	UCHAR			Index;
	NDIS_STATUS		Status = NDIS_STATUS_SUCCESS;
	PRTMP_ADAPTER	pAd = (PRTMP_ADAPTER) MiniportAdapterContext;

	// handle AP case here ...
	if (pAd->OpMode == OPMODE_AP)
	{
		APSendPackets(MiniportAdapterContext, ppPacketArray, NumberOfPackets);
		return 0;
	}

	for (Index = 0; Index < NumberOfPackets; Index++)
	{
		if (RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_RESET_IN_PROGRESS) ||
			RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_HALT_IN_PROGRESS))
		{
			// Drop send request since hardware is in reset state
#if defined(ME_98) && (ME_98 == 1)
			IndicateEnqueue(pAd, INDICATE_SEND_COMPLETE, NULL, 0, NULL, 0, 0,
							ppPacketArray[Index], NDIS_STATUS_FAILURE);
#else
			NdisMSendComplete(pAd->AdapterHandle, ppPacketArray[Index], NDIS_STATUS_FAILURE);
#endif
		}
		// Drop packets if no associations
		else if (!INFRA_ON(pAd) && !ADHOC_ON(pAd))
		{
			// Drop send request since there are no physical connection yet
			// Check the association status for infrastructure mode
			// And Mibss for Ad-hoc mode setup
#if defined(ME_98) && (ME_98 == 1)
			IndicateEnqueue(pAd, INDICATE_SEND_COMPLETE, NULL, 0, NULL, 0, 0,
							ppPacketArray[Index], NDIS_STATUS_FAILURE);
			RTUSBIndicateDone(pAd);
#else
			NdisMSendComplete(pAd->AdapterHandle, ppPacketArray[Index], NDIS_STATUS_FAILURE);
#endif
		}
		else
		{
			// This function has to manage NdisSendComplete return call within its routine
			// NdisSendComplete will acknowledge upper layer in two steps.
			// 1. Within Packet Enqueue, set the NDIS_STATUS_PENDING
			// 2. Within TxRingTxDone / PrioRingTxDone call NdisSendComplete with final status
			Status = RTMPSendPacket(pAd,ppPacketArray[Index]);

			if (Status == NDIS_STATUS_SUCCESS)
			{
				// Set Ndis packet Out of band information
				NDIS_SET_PACKET_STATUS(ppPacketArray[Index], NDIS_STATUS_PENDING);
				DBGPRINT(RT_DEBUG_INFO, (">>> One Packet Pending\n"));
			}
			else
			{
				// Errors before enqueue stage
#if defined(ME_98) && (ME_98 == 1)
				IndicateEnqueue(pAd, INDICATE_SEND_COMPLETE, NULL, 0, NULL, 0, 0,
								ppPacketArray[Index], NDIS_STATUS_FAILURE);
				RTUSBIndicateDone(pAd);
#else
				NdisMSendComplete( pAd->AdapterHandle,	ppPacketArray[Index], NDIS_STATUS_FAILURE);
#endif
			}
		}
	}

	// Dequeue one frame from SendTxWait queue and process it
	// There are two place calling dequeue for TX ring.
	// 1. Here, right after queueing the frame.
	// 2. At the end of TxRingTxDone service routine.
	if ((!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_BSS_SCAN_IN_PROGRESS)) &&
		(!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_RADIO_OFF)) &&
		(!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_RESET_IN_PROGRESS)) &&
		(!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_HALT_IN_PROGRESS)))
	{
		for (Index = 0; Index < 4; Index++)
		{
			if(pAd->SendTxWaitQueue[Index].Number > 0)
			{
				RTMPDeQueuePacket(pAd, Index);
			}
		}
	}

	// Kick bulk out
	RTUSBKickBulkOut(pAd);
	return 0;
}

/*
	========================================================================

	Routine	Description:
		This routine is	used to	en-queue outgoing packets when
		there is no	enough shread memory

	Arguments:

	Return Value:
		None

	IRQL = DISPATCH_LEVEL

	Note:

	========================================================================
*/
NDIS_STATUS	RTMPSendPacket(
	IN	PRTMP_ADAPTER	pAd,
	IN	PNDIS_PACKET	pPacket)
{
	PACKET_INFO		PacketInfo;
	PVOID			pVirtualAddress;
	UINT			Length;
	UINT			AllowFragSize;
	UCHAR			NumberOfFrag;
	UCHAR			RTSRequired;
	NDIS_STATUS		Status = NDIS_STATUS_FAILURE;
	UCHAR			PsMode;
	UCHAR			QueIdx, UserPriority;
#ifdef	NDIS51_MINIPORT
	// For 802.1q priority information
	// Only supported after NDIS 51
	NDIS_PACKET_8021Q_INFO	NdisPacket8021qInfo;
#endif

	PQUEUE_HEADER			pTxQueue;
//	ULONG					Priority;
//	UCHAR					AccessCategory;
	unsigned long			IrqFlags;

	DBGPRINT(RT_DEBUG_INFO, ("===> RTMPSendPacket\n"));

	// Prepare packet information structure for buffer descriptor
	// chained within a single NDIS packet.
#ifdef WIN_NDIS
	NdisQueryPacket(
		pPacket,							// Ndis packet
		&PacketInfo.PhysicalBufferCount,	// Physical buffer count
		&PacketInfo.BufferCount,			// Number of buffer descriptor
		&PacketInfo.pFirstBuffer,			// Pointer to first buffer descripotr
		&PacketInfo.TotalPacketLength);		// Ndis packet length
#else
	RTMP_QueryPacketInfo(pPacket, &PacketInfo, (PUCHAR *)&pVirtualAddress, &Length);
#endif

	// For TKIP, MIC value is treated as payload, it might be fragmented through
	// different MPDUs.
	if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled)
	{
		PacketInfo.TotalPacketLength += 8;
	}
#ifdef WIN_NDIS
	NDIS_QUERY_BUFFER(PacketInfo.pFirstBuffer, &pVirtualAddress, &Length);
#endif
	// Check for virtual address allocation, it might fail !!!
	if (pVirtualAddress == NULL)
	{
		// Resourece is low, system did not allocation virtual address
		// return NDIS_STATUS_FAILURE directly to upper layer
		return (Status);
	}

	//
	// Check for multicast or broadcast (First byte of DA)
	//
	if ((*((PUCHAR) pVirtualAddress) & 0x01) != 0)
	{
		// For multicast & broadcast, there is no fragment allowed
		NumberOfFrag = 1;
	}
	else if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_AGGREGATION_INUSED))
	{
		NumberOfFrag = 1;   // Aggregation overwhelms fragmentation
	}
	else if (CKIP_CMIC_ON(pAd))
	{
		//
		// Need to Insert CKIP MIC on the beginning of the payload.
		// It's to complex to do fragment, and it's ok on CCX1 & CC2.
		//
		NumberOfFrag = 1;
	}
	else
	{
		// Check for payload allowed for each fragment
		AllowFragSize = (pAd->CommonCfg.FragmentThreshold) - LENGTH_802_11 - LENGTH_CRC;

		// Calculate fragments required
		NumberOfFrag = ((PacketInfo.TotalPacketLength - LENGTH_802_3 + LENGTH_802_1_H) / AllowFragSize) + 1;
		// Minus 1 if the size just match to allowable fragment size
		if (((PacketInfo.TotalPacketLength - LENGTH_802_3 + LENGTH_802_1_H) % AllowFragSize) == 0)
		{
			NumberOfFrag--;
		}
	}

	// Check for requirement of RTS
	if (NumberOfFrag > 1)
	{
		// If multiple fragment required, RTS is required only for the first fragment
		// if the fragment size large than RTS threshold
		RTSRequired = (pAd->CommonCfg.FragmentThreshold > pAd->CommonCfg.RtsThreshold) ? 1 : 0;
	}
	else
	{
		RTSRequired = (PacketInfo.TotalPacketLength > pAd->CommonCfg.RtsThreshold) ? 1 : 0;
	}
	DBGPRINT(RT_DEBUG_INFO, ("Number of fragments include RTS :%d\n", NumberOfFrag + RTSRequired));

	//
	// Remove the following lines to avoid confusion.
	// CTS requirement will not use Flag "RTSRequired", instead moveing the
	// following lines to RTUSBHardTransmit(..)
	//
	// RTS/CTS may also be required in order to protect OFDM frame
	// if ((pAd->CommonCfg.TxRate >= RATE_FIRST_OFDM_RATE) && OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_BG_PROTECTION_INUSED))
	// {
	// 	RTSRequired = 1;
	// }

	// Save fragment number to Ndis packet reserved field
	RTMP_SET_PACKET_FRAGMENTS(pPacket, NumberOfFrag);

	// Save RTS requirement to Ndis packet reserved field
	RTMP_SET_PACKET_RTS(pPacket, RTSRequired);

	//
	// STEP 3. Traffic classification. outcome = <UserPriority, QueIdx>
	//
	UserPriority = 0;
	QueIdx       = QID_AC_BE;

	if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_WMM_INUSED))
	{
		USHORT Protocol;
		UCHAR  LlcSnapLen = 0, Byte0, Byte1;
		PUCHAR   ppp;
		ppp = (PUCHAR )pVirtualAddress;
		do
		{
			// get Ethernet protocol field

			Protocol = (USHORT)(((UCHAR) ppp[12] << 8) + (UCHAR)ppp[13]);
			if (Protocol <= 1500)
			{
				// get Ethernet protocol field from LLC/SNAP
				if (Sniff2BytesFromNdisBuffer(PacketInfo.pFirstBuffer, LENGTH_802_3 + 6, &Byte0, &Byte1) != NDIS_STATUS_SUCCESS)
					break;

				Protocol = (USHORT)((Byte0 << 8) + Byte1);
				LlcSnapLen = 8;
			}

			// always AC_BE for non-IP packet
			if (Protocol != 0x0800)
				break;

			// get IP header
			if (Sniff2BytesFromNdisBuffer(PacketInfo.pFirstBuffer, LENGTH_802_3 + LlcSnapLen, &Byte0, &Byte1) != NDIS_STATUS_SUCCESS)
				break;

			// return AC_BE if packet is not IPv4
			if ((Byte0 & 0xf0) != 0x40)
				break;

			UserPriority = (Byte1 & 0xe0) >> 5;
			QueIdx = MapUserPriorityToAccessCategory[UserPriority];

			// TODO: have to check ACM bit. apply TSPEC if ACM is ON
			// TODO: downgrade UP & QueIdx before passing ACM
			if (pAd->CommonCfg.APEdcaParm.bACM[QueIdx])
			{
				UserPriority = 0;
				QueIdx       = QID_AC_BE;
			}
		} while (FALSE);
	}

	RTMP_SET_PACKET_UP(pPacket, UserPriority);

	// Make sure SendTxWait queue resource won't be used by other threads
	NdisAcquireSpinLock(&pAd->SendTxWaitQueueLock[QueIdx], IrqFlags);

	pTxQueue = &pAd->SendTxWaitQueue[QueIdx];

	//
	// For infrastructure mode, enqueue this frame immediately to sendwaitqueue
	// For Ad-hoc mode, check the DA power state, then decide which queue to enqueue
	//
	if (INFRA_ON(pAd))
	{
		// In infrastructure mode, simply enqueue the packet into Tx waiting queue.
		DBGPRINT(RT_DEBUG_INFO, ("Infrastructure -> Enqueue one frame\n"));

		// Enqueue Ndis packet to end of Tx wait queue
		InsertTailQueue(pTxQueue, RTMP_GET_PACKET_MR(pPacket));
		Status = NDIS_STATUS_SUCCESS;
	}
	else
	{
		// In IBSS mode, power state of destination should be considered.
		PsMode = PWR_ACTIVE;		// Faked
		if (PsMode == PWR_ACTIVE)
		{
			DBGPRINT(RT_DEBUG_INFO,("Ad-Hoc -> Enqueue one frame\n"));

			// Enqueue Ndis packet to end of Tx wait queue
			InsertTailQueue(pTxQueue, RTMP_GET_PACKET_MR(pPacket));
			Status = NDIS_STATUS_SUCCESS;
		}
	}

	NdisReleaseSpinLock(&pAd->SendTxWaitQueueLock[QueIdx], IrqFlags);

	return (Status);
}

/*
	========================================================================

	Routine	Description:
		To do the enqueue operation and extract the first item of waiting
		list. If a number of available shared memory segments could meet
		the request of extracted item, the extracted item will be fragmented
		into shared memory segments.

	Arguments:
		pAd	Pointer	to our adapter
		pQueue		Pointer to Waiting Queue

	Return Value:
		None

	IRQL = DISPATCH_LEVEL

	Note:

	========================================================================
*/
VOID	RTMPDeQueuePacket(
	IN	PRTMP_ADAPTER	pAd,
	IN	UCHAR			BulkOutPipeId)
{
	PQUEUE_ENTRY	pEntry;
	PNDIS_PACKET	pPacket;
	UCHAR			FragmentRequired;
	NDIS_STATUS		Status;
	UCHAR			Count = 0;
	PQUEUE_HEADER	pQueue;
//	ULONG			Number;
//	UCHAR			AccessCategory;
	UCHAR			QueIdx;
	unsigned long   IrqFlags;

	NdisAcquireSpinLock(&pAd->DeQueueLock[BulkOutPipeId], IrqFlags);
	if (pAd->DeQueueRunning[BulkOutPipeId])
	{
		NdisReleaseSpinLock(&pAd->DeQueueLock[BulkOutPipeId], IrqFlags);
		return;
	}
	else
	{
		pAd->DeQueueRunning[BulkOutPipeId] = TRUE;
		NdisReleaseSpinLock(&pAd->DeQueueLock[BulkOutPipeId], IrqFlags);
	}

	QueIdx = BulkOutPipeId;

	if (pAd->TxRingTotalNumber[BulkOutPipeId])
	DBGPRINT(RT_DEBUG_TRACE,("--RTMPDeQueuePacket %d TxRingTotalNumber %ld !!--\n", BulkOutPipeId, pAd->TxRingTotalNumber[BulkOutPipeId]));

	// Make sure SendTxWait queue resource won't be used by other threads
	NdisAcquireSpinLock(&pAd->SendTxWaitQueueLock[BulkOutPipeId], IrqFlags);

	// Select Queue
	pQueue = &pAd->SendTxWaitQueue[BulkOutPipeId];

	// Check queue before dequeue
	while ((pQueue->Head != NULL) && (Count < MAX_TX_PROCESS))
	{
		// Reset is in progress, stop immediately
		if ( RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_RESET_IN_PROGRESS) ||
			 RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_BSS_SCAN_IN_PROGRESS) ||
			 RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_HALT_IN_PROGRESS))
		{
			DBGPRINT(RT_DEBUG_ERROR, ("--RTMPDeQueuePacket %d  %ld reset-in-progress !!--\n", BulkOutPipeId, pAd->TxRingTotalNumber[BulkOutPipeId]));
			break;
		}

		// Dequeue the first entry from head of queue list
		pEntry = RemoveHeadQueue(pQueue);

		// Retrieve Ndis packet pointer from MiniportReservedEx field
		pPacket = QUEUE_ENTRY_TO_PKT(pEntry) ;//CONTAINING_RECORD(pEntry, NDIS_PACKET, MiniportReservedEx);

		// RTS or CTS-to-self for B/G protection mode has been set already.
		// There is no need to re-do it here.
		// Total fragment required = number of fragment + RST if required
		FragmentRequired = RTMP_GET_PACKET_FRAGMENTS(pPacket) + RTMP_GET_PACKET_RTS(pPacket);

		if ((RTUSBFreeDescriptorRequest(pAd, TX_RING, BulkOutPipeId, FragmentRequired) == NDIS_STATUS_SUCCESS))
		{
			// Avaliable ring descriptors are enough for this frame
			// Call hard transmit
			// Nitro mode / Normal mode selection
			NdisReleaseSpinLock(&pAd->SendTxWaitQueueLock[BulkOutPipeId], IrqFlags);

			if (pAd->OpMode == OPMODE_AP)
				Status = APHardTransmit(pAd, pPacket, FragmentRequired,QueIdx);
			else
			        Status = RTUSBHardTransmit(pAd, pPacket, FragmentRequired, QueIdx);

			// Make sure SendTxWait queue resource won't be used by other threads
			NdisAcquireSpinLock(&pAd->SendTxWaitQueueLock[BulkOutPipeId], IrqFlags);
			// check status
			if (Status == NDIS_STATUS_FAILURE)
			{
				// Packet failed due to various Ndis Packet error
#if defined(ME_98) && (ME_98 == 1)
				IndicateEnqueue(pAd, INDICATE_SEND_COMPLETE, NULL, 0, NULL, 0, 0,
								pPacket, NDIS_STATUS_FAILURE);
				RTUSBIndicateDone(pAd);
#else
				if (pAd->OpMode == OPMODE_AP)
				{
					RELEASE_NDIS_PACKET(pAd, pPacket, NDIS_STATUS_FAILURE);
				}
				else
				{
				        NdisMSendComplete(pAd->AdapterHandle, pPacket,	NDIS_STATUS_FAILURE);
				}
#endif
				break;
			}
			else if (Status == NDIS_STATUS_RESOURCES)
			{
				// Not enough free tx ring, it might happen due to free descriptor inquery might be not correct
				// It also might change to NDIS_STATUS_FAILURE to simply drop the frame
				// Put the frame back into head of queue
				InsertHeadQueue(pQueue, RTMP_GET_PACKET_MR(pPacket));
				break;
			}
			Count++;
		}
		else
		{
			DBGPRINT(RT_DEBUG_ERROR,("--RTMPDeQueuePacket %d queue full !! TxRingTotalNumber= %ld !! \n", BulkOutPipeId, pAd->TxRingTotalNumber[BulkOutPipeId]));
			InsertHeadQueue(pQueue, RTMP_GET_PACKET_MR(pPacket));
			break;
		}
	}

	// Release TxSwQueue0 resources
	NdisReleaseSpinLock(&pAd->SendTxWaitQueueLock[BulkOutPipeId], IrqFlags);

	NdisAcquireSpinLock(&pAd->DeQueueLock[BulkOutPipeId], IrqFlags);
	pAd->DeQueueRunning[BulkOutPipeId] = FALSE;
	NdisReleaseSpinLock(&pAd->DeQueueLock[BulkOutPipeId], IrqFlags);
}

/*
	========================================================================

	Routine	Description:
		This subroutine will scan through releative ring descriptor to find
		out avaliable free ring descriptor and compare with request size.

	Arguments:
		pAd	Pointer	to our adapter
		RingType	Selected Ring

	Return Value:
		NDIS_STATUS_FAILURE		Not enough free descriptor
		NDIS_STATUS_SUCCESS		Enough free descriptor

	Note:

	========================================================================
*/
NDIS_STATUS	RTUSBFreeDescriptorRequest(
	IN	PRTMP_ADAPTER	pAd,
	IN	UCHAR			RingType,
	IN	UCHAR			BulkOutPipeId,
	IN	UCHAR			NumberRequired)
{
	UCHAR			FreeNumber = 0;
	UINT			Index;
	NDIS_STATUS		Status = NDIS_STATUS_FAILURE;

	switch (RingType)
	{
		case TX_RING:
			Index = (pAd->NextTxIndex[BulkOutPipeId] + 1) % TX_RING_SIZE;
			do
			{
				PTX_CONTEXT	pTxD  = &pAd->TxContext[BulkOutPipeId][Index];

				// While Owner bit is NIC, obviously ASIC still need it.
				// If valid bit is TRUE, indicate that TxDone has not process yet
				// We should not use it until TxDone finish cleanup job
				if (pTxD->InUse == FALSE)
				{
					// This one is free
					FreeNumber++;
				}
				else
				{
					break;
				}
				Index = (Index + 1) % TX_RING_SIZE;
			}	while (FreeNumber < NumberRequired);	// Quit here ! Free number is enough !

			if (FreeNumber >= NumberRequired)
			{
				Status = NDIS_STATUS_SUCCESS;
			}

			break;

		case PRIO_RING:
			Index = pAd->NextMLMEIndex;
			do
			{
				PTX_CONTEXT	pTxD  = &pAd->MLMEContext[Index];

				// While Owner bit is NIC, obviously ASIC still need it.
				// If valid bit is TRUE, indicate that TxDone has not process yet
				// We should not use it until TxDone finish cleanup job
				if (pTxD->InUse == FALSE)
				{
					// This one is free
					FreeNumber++;
				}
				else
				{
					break;
				}

				Index = (Index + 1) % PRIO_RING_SIZE;
			}	while (FreeNumber < NumberRequired);	// Quit here ! Free number is enough !

			if (FreeNumber >= NumberRequired)
			{
				Status = NDIS_STATUS_SUCCESS;
			}
			break;

		default:
			DBGPRINT_RAW(RT_DEBUG_ERROR, ("--->RTUSBFreeDescriptorRequest() -----!! \n"));

			break;
	}

	return (Status);
}

/*
	========================================================================

	Routine Description:

	Arguments:

	Return Value:

	IRQL =

	Note:

	========================================================================
*/
VOID	RTUSBRejectPendingPackets(
	IN	PRTMP_ADAPTER	pAd)
{
	UCHAR			Index;
	PQUEUE_ENTRY	pEntry;
	PNDIS_PACKET	pPacket;
	PQUEUE_HEADER	pQueue;
	unsigned long   IrqFlags;

	DBGPRINT_RAW(RT_DEBUG_TRACE, ("--->RejectPendingPackets\n"));

	for (Index = 0; Index < 4; Index++)
	{
		NdisAcquireSpinLock(&pAd->SendTxWaitQueueLock[Index], IrqFlags);
		while (pAd->SendTxWaitQueue[Index].Head != NULL)
		{
			pQueue = (PQUEUE_HEADER) &(pAd->SendTxWaitQueue[Index]);
			pEntry = RemoveHeadQueue(pQueue);
			pPacket = QUEUE_ENTRY_TO_PKT(pEntry) ;//CONTAINING_RECORD(pEntry, NDIS_PACKET, MiniportReservedEx);
#if defined(ME_98) && (ME_98 == 1)
			IndicateEnqueue(pAd, INDICATE_SEND_COMPLETE, NULL, 0, NULL, 0, 0,
							pPacket, NDIS_STATUS_FAILURE);
			RTUSBIndicateDone(pAd);
#else
			NdisMSendComplete(pAd->AdapterHandle, pPacket, NDIS_STATUS_FAILURE);
#endif
		}
		NdisReleaseSpinLock(&pAd->SendTxWaitQueueLock[Index], IrqFlags);

	}

	DBGPRINT_RAW(RT_DEBUG_TRACE, ("<---RejectPendingPackets\n"));
}

/*
	========================================================================

	Routine	Description:
		Suspend MSDU transmission

	Arguments:
		pAd		Pointer	to our adapter

	Return Value:
		None

	Note:

	========================================================================
*/
VOID    RTUSBSuspendMsduTransmission(
	IN	PRTMP_ADAPTER	pAd)
{
	DBGPRINT(RT_DEBUG_TRACE,("SCANNING, suspend MSDU transmission ...\n"));

	//
	// Before BSS_SCAN_IN_PROGRESS, we need to keep Current R17 value and
	// use Lowbound as R17 value on ScanNextChannel(...)
	//
	if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_MEDIA_STATE_CONNECTED))
		RTUSBReadBBPRegister(pAd, 17, &pAd->BbpTuning.R17CurrentValue);

	RTMP_SET_FLAG(pAd, fRTMP_ADAPTER_BSS_SCAN_IN_PROGRESS);
}

/*
	========================================================================

	Routine	Description:
		Resume MSDU transmission

	Arguments:
		pAd		Pointer	to our adapter

	Return Value:
		None

	Note:

	========================================================================
*/
VOID    RTUSBResumeMsduTransmission(
	IN	PRTMP_ADAPTER	pAd)
{
	UCHAR			Index;


	DBGPRINT(RT_DEBUG_ERROR,("SCAN done, resume MSDU transmission ...\n"));
	RTMP_CLEAR_FLAG(pAd, fRTMP_ADAPTER_BSS_SCAN_IN_PROGRESS);

	//
	// After finish BSS_SCAN_IN_PROGRESS, we need to restore Current R17 value
	//
	if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_MEDIA_STATE_CONNECTED))
		RTUSBWriteBBPRegister(pAd, 17, pAd->BbpTuning.R17CurrentValue);

	if ((!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_RESET_IN_PROGRESS)) &&
		(!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_HALT_IN_PROGRESS)) &&
		(!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_RADIO_OFF)))
	{
		// Dequeue all Tx software queue, if have been queued.
		for (Index = 0; Index < 4; Index++)
		{
			if(pAd->SendTxWaitQueue[Index].Number > 0)
			{
				RTMPDeQueuePacket(pAd, Index);
			}
		}
	}

	// Kick bulk out
	RTUSBKickBulkOut(pAd);
}

/*
	========================================================================

	Routine	Description:

	Arguments:

	Return Value:

	Note:

	========================================================================
*/
USHORT	RTUSBCalcDuration(
	IN	PRTMP_ADAPTER	pAd,
	IN	UCHAR			Rate,
	IN	ULONG			Size)
{
	ULONG	Duration = 0;

	if (Rate < RATE_FIRST_OFDM_RATE) // CCK
	{
		if ((Rate > RATE_1) && (pAd->CommonCfg.TxPreamble == Rt802_11PreambleShort))
			Duration = 96;  // 72+24 preamble+plcp
		else
			Duration = 192; // 144+48 preamble+plcp

		Duration += (USHORT)((Size << 4) / RateIdTo500Kbps[Rate]);
		if ((Size << 4) % RateIdTo500Kbps[Rate])
			Duration ++;
	}
	else // OFDM rates
	{
		Duration = 20 + 6;      // 16+4 preamble+plcp + Signal Extension
		Duration += 4 * (USHORT)((11 + Size * 4) / RateIdTo500Kbps[Rate]);
		if ((11 + Size * 4) % RateIdTo500Kbps[Rate])
			Duration += 4;
	}

	return (USHORT)Duration;
}

/*
	========================================================================

	Routine	Description:
		Calculates the duration which is required to transmit out frames
	with given size and specified rate.

	Arguments:
		pTxD		Pointer to transmit descriptor
		Ack			Setting for Ack requirement bit
		Fragment	Setting for Fragment bit
		RetryMode	Setting for retry mode
		Ifs			Setting for IFS gap
		Rate		Setting for transmit rate
		Service		Setting for service
		Length		Frame length
		TxPreamble  Short or Long preamble when using CCK rates
		QueIdx - 0-3, according to 802.11e/d4.4 June/2003

	Return Value:
		None

	IRQL = PASSIVE_LEVEL
	IRQL = DISPATCH_LEVEL

	========================================================================
*/
VOID RTUSBWriteTxDescriptor(
	IN	PRTMP_ADAPTER pAd,
	IN	PTXD_STRUC	pTxD,
	IN	UCHAR		CipherAlg,
	IN	UCHAR		KeyTable,
	IN	UCHAR		KeyIdx,
	IN	BOOLEAN		Ack,
	IN	BOOLEAN		Fragment,
	IN	BOOLEAN		InsTimestamp,
	IN	UCHAR		RetryMode,
	IN	UCHAR		Ifs,
	IN	UINT		Rate,
	IN	ULONG		Length,
	IN	UCHAR		QueIdx,
	IN	UCHAR		PID,
	IN	BOOLEAN		bAfterRTSCTS)
{
	UINT	Residual;

	pTxD->HostQId     = QueIdx;
	pTxD->MoreFrag    = Fragment;
	pTxD->ACK         = Ack;
	pTxD->Timestamp   = InsTimestamp;
	pTxD->RetryMd     = RetryMode;
	pTxD->Ofdm        = (Rate < RATE_FIRST_OFDM_RATE)? 0:1;
	pTxD->IFS         = Ifs;
	pTxD->PktId       = PID;
	pTxD->Drop        = 1;   // 1:valid, 0:drop
	pTxD->HwSeq       = 1;    // (QueIdx == QID_MGMT)? 1:0;
	pTxD->BbpTxPower  = DEFAULT_BBP_TX_POWER; // TODO: to be modified
	pTxD->DataByteCnt = Length;

	RTMPCckBbpTuning(pAd, Rate);

	// fill encryption related information, if required
	pTxD->CipherAlg   = CipherAlg;
	if (CipherAlg != CIPHER_NONE)
	{
		pTxD->KeyTable    = KeyTable;
		pTxD->KeyIndex    = KeyIdx;
		pTxD->TkipMic     = 1;
	}

	// In TKIP+fragmentation. TKIP MIC is already appended by driver. MAC needs not generate MIC
	if (CipherAlg == CIPHER_TKIP_NO_MIC)
	{
		pTxD->CipherAlg   = CIPHER_TKIP;
		pTxD->TkipMic     = 0;   // tell MAC need not insert TKIP MIC
	}
	// in CKIP without key permutation case. WEP RC4 is used by MAC
	else if ((CipherAlg == CIPHER_CKIP128) && !(pAd->StaCfg.CkipFlag & 0x10))
		pTxD->CipherAlg = CIPHER_WEP128;
	else if ((CipherAlg == CIPHER_CKIP64) && !(pAd->StaCfg.CkipFlag & 0x10))
		pTxD->CipherAlg = CIPHER_WEP64;



	if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_WMM_INUSED))
	{

		if ((pAd->CommonCfg.APEdcaParm.bValid) && (QueIdx <= QID_AC_VO))
		{
			pTxD->Cwmin = pAd->CommonCfg.APEdcaParm.Cwmin[QueIdx];
			pTxD->Cwmax = pAd->CommonCfg.APEdcaParm.Cwmax[QueIdx];
			pTxD->Aifsn = pAd->CommonCfg.APEdcaParm.Aifsn[QueIdx];
			//
			// Modify Cwmin/Cwmax on queue[QID_AC_VI], Recommend by Jerry 2005/07/27
			// To degrade our VIDO Queue's throughput for WiFi WMM S3T07 Issue.
			//
			if (QueIdx == QID_AC_VI)
			{
				pTxD->Cwmin += 1;
				pTxD->Cwmax += 1;
			}
		}
		else
		{
			DBGPRINT(RT_DEBUG_ERROR,(" WMM in used but EDCA not valid ERROR !!\n)"));
		}
	}
	else
	{
		if (bAfterRTSCTS)
		{
			// After RTS/CTS frame, data frame should use SIFS time.
			// To patch this code, add the following code.
			// Recommended by Jerry 2005/07/25 for WiFi testing with Proxim AP
			pTxD->Cwmin = 0;
			pTxD->Cwmax = 0;
			pTxD->Aifsn = 1;
			pTxD->IFS = IFS_BACKOFF;
		}
		else
		{
			pTxD->Cwmin = CW_MIN_IN_BITS;
			pTxD->Cwmax = CW_MAX_IN_BITS;
			pTxD->Aifsn = 2;
		}
	}

	// fill up PLCP SIGNAL field
	pTxD->PlcpSignal = RateIdToPlcpSignal[Rate];
	if (((Rate == RATE_2) || (Rate == RATE_5_5) || (Rate == RATE_11)) &&
		OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_SHORT_PREAMBLE_INUSED)) // no short preamble for RATE_1
	{
		pTxD->PlcpSignal |= 0x0008;
	}

	// fill up PLCP SERVICE field, not used for OFDM rates
	pTxD->PlcpService = 4; // Service;

	// file up PLCP LENGTH_LOW and LENGTH_HIGH fields
	 Length += LENGTH_CRC;   // CRC length
	switch (CipherAlg)
	{
		case CIPHER_WEP64:       Length += 8;    break;  // IV + ICV
		case CIPHER_WEP128:      Length += 8;    break;  // IV + ICV
		case CIPHER_TKIP:        Length += 20;   break;  // IV + EIV + MIC + ICV
		case CIPHER_AES:         Length += 16;   break;  // IV + EIV + MIC
		case CIPHER_CKIP64:      Length += 8;    break;  // IV + CMIC + ICV, but CMIC already inserted by driver
		case CIPHER_CKIP128:     Length += 8;    break;  // IV + CMIC + ICV, but CMIC already inserted by driver
		case CIPHER_TKIP_NO_MIC: Length += 12;   break;  // IV + EIV + ICV
		default:                                 break;
	}

	if (Rate < RATE_FIRST_OFDM_RATE)    // 11b - RATE_1, RATE_2, RATE_5_5, RATE_11
	{
		if ((Rate == RATE_1) || ( Rate == RATE_2))
		{
			Length = Length * 8 / (Rate + 1);
		}
		else
		{
			Residual = ((Length * 16) % (11 * (1 + Rate - RATE_5_5)));
			Length = Length * 16 / (11 * (1 + Rate - RATE_5_5));
			if (Residual != 0)
			{
				Length++;
			}
			if ((Residual <= (3 * (1 + Rate - RATE_5_5))) && (Residual != 0))
			{
				if (Rate == RATE_11)			// Only 11Mbps require length extension bit
					pTxD->PlcpService |= 0x80; // 11b's PLCP Length extension bit
			}
		}

		pTxD->PlcpLengthHigh = Length >> 8; // 256;
		pTxD->PlcpLengthLow = Length % 256;
	}
	else    // OFDM - RATE_6, RATE_9, RATE_12, RATE_18, RATE_24, RATE_36, RATE_48, RATE_54
	{
		pTxD->PlcpLengthHigh = Length >> 6; // 64;  // high 6-bit of total byte count
		pTxD->PlcpLengthLow = Length % 64;   // low 6-bit of total byte count
	}

	pTxD->Burst  = Fragment;
	pTxD->Burst2 = pTxD->Burst;
}

// should be called only when -
// 1. MEADIA_CONNECTED
// 2. AGGREGATION_IN_USED
// 3. Fragmentation not in used
// 4. either no previous frame (pPrevAddr1=NULL) .OR. previoud frame is aggregatible
BOOLEAN TxFrameIsAggregatible(
	IN  PRTMP_ADAPTER   pAd,
	IN  PUCHAR          pPrevAddr1,
	IN  PUCHAR          p8023hdr)
{
	// can't aggregate EAPOL (802.1x) frame
	if ((p8023hdr[12] == 0x88) && (p8023hdr[13] == 0x8e))
		return FALSE;

	// can't aggregate multicast/broadcast frame
	if (p8023hdr[0] & 0x01)
		return FALSE;

	//
	// Adhoc mode will not support Aggregation.
	//
	if (INFRA_ON(pAd)) // must be unicast to AP
		return TRUE;
	else if ((pPrevAddr1 == NULL) || MAC_ADDR_EQUAL(pPrevAddr1, p8023hdr)) // unicast to same STA
		return TRUE;
	else
		return FALSE;
}

/*
	========================================================================

	Routine	Description:
		Copy frame from waiting queue into relative ring buffer and set
	appropriate ASIC register to kick hardware encryption before really
	sent out to air.

	Arguments:
		pAd		Pointer	to our adapter
		PNDIS_PACKET	Pointer to outgoing Ndis frame
		NumberOfFrag	Number of fragment required

	Return Value:
		None

	Note:

	========================================================================
*/
NDIS_STATUS RTUSBHardTransmit(
	IN	PRTMP_ADAPTER	pAd,
	IN	PNDIS_PACKET	pPacket,
	IN	UCHAR			NumberRequired,
	IN  UCHAR			QueIdx)
{
	UINT			LengthQosPAD =0;
	PACKET_INFO		PacketInfo;
	UINT			BytesCopied;
	UINT			TxSize; //, PLCPLength;
	UINT			FreeMpduSize;
	INT			SrcRemainingBytes;
	USHORT			Protocol;
	UCHAR			FrameGap;
	HEADER_802_11	Header_802_11;
	UCHAR			Header_802_3[LENGTH_802_3];
	PHEADER_802_11	pHeader80211;
	PUCHAR			pDest;
//	PUCHAR			pSrc;
	PTX_CONTEXT		pTxContext;
	PTXD_STRUC		pTxD;
//	PURB			pUrb;
	BOOLEAN			StartOfFrame;
	BOOLEAN			bEAPOLFrame;
//	BOOLEAN			Encapped;
	ULONG			Iv16;
	ULONG			Iv32;
	BOOLEAN			MICFrag;
//	PCIPHER_KEY		pWpaKey = NULL;
//	UCHAR			RetryLimit = 0;
	NDIS_802_11_ENCRYPTION_STATUS			Cipher;
	ULONG			TransferBufferLength;
//	UINT			FinalPacketSize;
//	UINT			FragmentSize, LastFragmentSize;
//	BOOLEAN			MoreFragment;
//	UCHAR			AckRate = RATE_2;
	USHORT			AckDuration = 0;
	USHORT			EncryptionOverhead = 0;
	UCHAR			CipherAlg = CIPHER_NONE;
	BOOLEAN			bAckRequired;
	UCHAR			RetryMode = SHORT_RETRY;
//	UCHAR			PacketID;
	UCHAR			UserPriority;
	UCHAR			MpduRequired, RtsRequired;
	UCHAR			TxRate;
	PCIPHER_KEY	pKey = NULL ;
	PUCHAR			pSrcBufVA = NULL;
	ULONG			SrcBufLen;
	PUCHAR			pExtraLlcSnapEncap = NULL; // NULL: no extra LLC/SNAP is required
	UCHAR			KeyIdx;
	PUCHAR			pWirelessPacket;
	BOOLEAN			bAggregatible = FALSE;
	ULONG			DataOffSet = 0;
	UCHAR			CKIP_PK[16];	 // ckip permuted key
	ULONG 			NextMpduSize;
	BOOLEAN			bRTS_CTSFrame = FALSE;
	UCHAR			KeyTable = 0;	// default as shared key table
	BOOLEAN			bDLSFrame = FALSE;

	if ((pAd->CommonCfg.bIEEE80211H == 1) && (pAd->CommonCfg.RadarDetect.RDMode != RD_NORMAL_MODE))
	{
		DBGPRINT(RT_DEBUG_INFO,("RTUSBHardTransmit --> radar detect not in normal mode !!!\n"));
		return (NDIS_STATUS_FAILURE);
	}

	TxRate = pAd->CommonCfg.TxRate;
	MpduRequired = RTMP_GET_PACKET_FRAGMENTS(pPacket);
	RtsRequired = RTMP_GET_PACKET_RTS(pPacket);
	UserPriority = RTMP_GET_PACKET_UP(pPacket);

	//
	// Prepare packet information structure which will be query for buffer descriptor
	//
#ifdef WIN_NDIS
	NdisQueryPacket(
		pPacket,							// Ndis packet
		&PacketInfo.PhysicalBufferCount,	// Physical buffer count
		&PacketInfo.BufferCount,			// Number of buffer descriptor
		&PacketInfo.pFirstBuffer,			// Pointer to first buffer descripotr
		&PacketInfo.TotalPacketLength);		// Ndis packet length
	DBGPRINT_RAW(RT_DEBUG_INFO, ("packetsize:%d\n", PacketInfo.TotalPacketLength));

	NDIS_QUERY_BUFFER(PacketInfo.pFirstBuffer, &pSrcBufVA, &SrcBufLen);
#else
	RTMP_QueryPacketInfo(pPacket, &PacketInfo, &pSrcBufVA, &SrcBufLen);
#endif


 	// Check for virtual address allocation, it might fail !!!
	if (pSrcBufVA == NULL)
	{
		DBGPRINT_RAW(RT_DEBUG_TRACE, ("pVirtualAddress == NULL\n"));
		return(NDIS_STATUS_RESOURCES);
	}
	if (SrcBufLen < 14)
	{
		DBGPRINT_RAW(RT_DEBUG_ERROR, ("RTUSBHardTransmit --> Ndis Packet buffer error !!!\n"));
		return (NDIS_STATUS_FAILURE);
	}
	else
	{
		//
		// Backup Header_802_3
		//
		NdisMoveMemory(Header_802_3, pSrcBufVA, LENGTH_802_3);
	}

	//
	// If DHCP datagram or ARP datagram , we need to send it as Low rates.
	//
	if (pAd->CommonCfg.Channel <= 14)
	{
		//
		// Case 802.11 b/g
		// basic channel means that we can use CCKM's low rate as RATE_1.
		//
		if ((TxRate != RATE_1) && RTMPCheckDHCPFrame(pAd, pPacket))
			TxRate = RATE_1;

		if (ADHOC_ON(pAd) && (TxRate < RATE_6) &&
			((pAd->StaCfg.AdhocMode == ADHOC_11G) || (pAd->StaCfg.AdhocMode == ADHOC_11A)))
			TxRate = RATE_6;
	}
	else
	{
		//
		// Case 802.11a
		// We must used OFDM's low rate as RATE_6, note RATE_1 is not allow
		// Only OFDM support on Channel > 14
		//
		if ((TxRate < RATE_6) || RTMPCheckDHCPFrame(pAd, pPacket))
			TxRate = RATE_6;
	}

	// Check if the frame can be sent through DLS direct link interface
	// If packet can be sent through DLS, then force aggregation disable. (Hard to determine peer STA's capability)
	if (RTMPCheckDLSFrame(pAd, pSrcBufVA))
		bDLSFrame = TRUE;
	else
		bDLSFrame = FALSE;

	if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_AGGREGATION_INUSED) 	&&
		(TxRate >= RATE_6)										&&
		(pAd->StaCfg.bCkipCmicOn == FALSE)							&&
		(bDLSFrame == FALSE)									&&
		TxFrameIsAggregatible(pAd, NULL, pSrcBufVA))
	{
		bAggregatible = TRUE;
	}

	// ------------------------------------------
	// STEP 0.1 Add 802.1x protocol check.
	// ------------------------------------------
	// For non-WPA network, 802.1x message should not encrypt even privacy is on.
	if (NdisEqualMemory(EAPOL, pSrcBufVA + 12, 2))
	{
		bEAPOLFrame = TRUE;
		if (pAd->StaCfg.MicErrCnt >= 2)
			pAd->StaCfg.MicErrCnt++;
	}
	else
		bEAPOLFrame = FALSE;

	//
	// WPA 802.1x secured port control - drop all non-802.1x frame before port secured
	//
	if (((pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA) ||
		 (pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPAPSK) ||
		 (pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA2) ||
		 (pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA2PSK) ||
		 (pAd->StaCfg.LeapAuthMode == CISCO_AuthModeLEAP)) &&
		((pAd->StaCfg.PortSecured == WPA_802_1X_PORT_NOT_SECURED) || (pAd->StaCfg.MicErrCnt >= 2)) &&
		(bEAPOLFrame == FALSE))
	{
		DBGPRINT_RAW(RT_DEBUG_INFO, ("RTMPHardEncrypt --> Drop packet before port secured !!!\n"));
		return (NDIS_STATUS_FAILURE);
	}

	if (*pSrcBufVA & 0x01) // Multicast or Broadcast
	{
		bAckRequired = FALSE;
		INC_COUNTER64(pAd->WlanCounters.MulticastTransmittedFrameCount);
		Cipher = pAd->CommonCfg.GroupCipher; // Cipher for Multicast or Broadcast
	}
	else
	{
		bAckRequired = TRUE;
		Cipher = pAd->CommonCfg.PairCipher; // Cipher for Unicast
	}

	// 1. traditional TX burst
	if (pAd->CommonCfg.bEnableTxBurst && (pAd->Sequence & 0x7))
		FrameGap = IFS_SIFS;
	// 2. frame belonging to AC that has non-zero TXOP
	else if (pAd->CommonCfg.APEdcaParm.bValid && pAd->CommonCfg.APEdcaParm.Txop[QueIdx])
		FrameGap = IFS_SIFS;
	// 3. otherwise, always BACKOFF before transmission
	else
		FrameGap = IFS_BACKOFF;		// Default frame gap mode

	Protocol = *(pSrcBufVA + 12) * 256 + *(pSrcBufVA + 13);
	// if orginal Ethernet frame contains no LLC/SNAP, then an extra LLC/SNAP encap is required
	if (Protocol > 1500)
	{
		pExtraLlcSnapEncap = SNAP_802_1H;
		if (NdisEqualMemory(IPX, pSrcBufVA + 12, 2) ||
			NdisEqualMemory(APPLE_TALK, pSrcBufVA + 12, 2))
		{
			pExtraLlcSnapEncap = SNAP_BRIDGE_TUNNEL;
		}
	}
	else
	    pExtraLlcSnapEncap = NULL;

	// Update software power save state
	OPSTATUS_CLEAR_FLAG(pAd, fOP_STATUS_DOZE);
	// It should not change PSM bit, when APSD turn on.
	if (!(pAd->CommonCfg.bAPSDCapable && pAd->CommonCfg.APEdcaParm.bAPSDCapable) && (pAd->CommonCfg.bAPSDForcePowerSave == FALSE))
	{
		pAd->StaCfg.Psm = PWR_ACTIVE;
	}

	// -----------------------------------------------------------------
	// STEP 2. MAKE A COMMON 802.11 HEADER SHARED BY ENTIRE FRAGMENT BURST.
	// -----------------------------------------------------------------

	pAd->Sequence = ((pAd->Sequence) + 1) & (MAX_SEQ_NUMBER);
	MAKE_802_11_HEADER(pAd, Header_802_11, pSrcBufVA, pAd->Sequence, bDLSFrame);
#ifdef WIN_NDIS
	if (ADHOC_ON(pAd) && RX_FILTER_TEST_FLAG(pAd, fRX_FILTER_ACCEPT_PROMISCUOUS))
	{
		COPY_MAC_ADDR(Header_802_11.Addr2, pSrcBufVA+6);

		if (pAd->CommonCfg.PSPXlink)
			bAckRequired = FALSE;
	}
#endif

	if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_WMM_INUSED))
		Header_802_11.FC.SubType = SUBTYPE_QDATA;

	// --------------------------------------------------------
	// STEP 3. FIND ENCRYPT KEY AND DECIDE CIPHER ALGORITHM
	//      Find the WPA key, either Group or Pairwise Key
	//      LEAP + TKIP also use WPA key.
	// --------------------------------------------------------
	// Decide WEP bit and cipher suite to be used. Same cipher suite should be used for whole fragment burst
	// In Cisco CCX 2.0 Leap Authentication
	//         WepStatus is Ndis802_11Encryption1Enabled but the key will use PairwiseKey
	//         Instead of the SharedKey, SharedKey Length may be Zero.
	KeyIdx = 0xff;
	if (bEAPOLFrame)
	{
		ASSERT(pAd->SharedKey[BSS0][0].CipherAlg <= CIPHER_CKIP128);

		if ((pAd->SharedKey[BSS0][0].CipherAlg) &&
			(pAd->SharedKey[BSS0][0].KeyLen) &&
			((pAd->StaCfg.PortSecured == WPA_802_1X_PORT_PASS_4_WAY) ||
			 (pAd->StaCfg.PortSecured == WPA_802_1X_PORT_SECURED)))
		{
			CipherAlg = pAd->SharedKey[BSS0][0].CipherAlg;
			KeyIdx = 0;
		}
	}
	// for WEP, and WPA+WEP mixed mode Group Key (5: WEP-104, 1: WEP-40)
/* ~~sample, take off */
//	else if ((Cipher == Ndis802_11Encryption1Enabled) || (Cipher == 5)) || (Cipher == 1))
	else if ((Cipher == Ndis802_11Encryption1Enabled) || (Cipher == 5))
	{
		if (CKIP_KP_ON(pAd)) // Cisco CKIP KP is on
		{
			if (LEAP_CCKM_ON(pAd))
			{
				if (Header_802_11.Addr1[0] & 0x01)
					KeyIdx = 1;
				else
					KeyIdx = 0;
			}
			else
				KeyIdx = pAd->CommonCfg.DefaultKeyId;
		}
		else if (CKIP_CMIC_ON(pAd)) // only CKIP CMIC
			KeyIdx = pAd->CommonCfg.DefaultKeyId;
		else if (LEAP_CCKM_ON(pAd))
		{
			if (Header_802_11.Addr1[0] & 0x01)
				KeyIdx = 1;
			else
				KeyIdx = 0;
		}
		else    // standard WEP64 or WEP128
			KeyIdx = pAd->CommonCfg.DefaultKeyId;
	}
	else if ((Cipher == Ndis802_11Encryption2Enabled) ||
			 (Cipher == Ndis802_11Encryption3Enabled))
	{
		if (Header_802_11.Addr1[0] & 0x01) // multicast
			KeyIdx = pAd->CommonCfg.DefaultKeyId;
		else if (pAd->SharedKey[BSS0][0].KeyLen)
			KeyIdx = 0;
		else
			KeyIdx = pAd->CommonCfg.DefaultKeyId;
	}

	if (KeyIdx == 0xff)
		CipherAlg = CIPHER_NONE;
	else if (pAd->SharedKey[BSS0][KeyIdx].KeyLen == 0)
		CipherAlg = CIPHER_NONE;
	else
	{
		Header_802_11.FC.Wep = 1;
		CipherAlg = pAd->SharedKey[BSS0][KeyIdx].CipherAlg;
		pKey = &pAd->SharedKey[BSS0][KeyIdx];
	}

#ifdef DBG
	if (KeyIdx != 0xff)
	{
		DBGPRINT(RT_DEBUG_INFO,("RTMPHardTransmit(bEAP=%d) - %s key#%d, KeyLen=%d\n",
			bEAPOLFrame, CipherName[CipherAlg], KeyIdx, pAd->SharedKey[BSS0][KeyIdx].KeyLen));
	}
#endif

	// STEP 3.1 if TKIP is used and fragmentation is required. Driver has to
	//          append TKIP MIC at tail of the scatter buffer (This must be the
	//          ONLY scatter buffer in the NDIS PACKET).
	//          MAC ASIC will only perform IV/EIV/ICV insertion but no TKIP MIC
	if ((MpduRequired > 1) && (CipherAlg == CIPHER_TKIP))
	{
		PacketInfo.TotalPacketLength += 8;
		CipherAlg = CIPHER_TKIP_NO_MIC;
	}

	if (CipherAlg == CIPHER_TKIP_NO_MIC)
	{
		//
		// On this case, we don't support Aggregation, it's diffcult to implement.
		//
		bAggregatible = FALSE;
	}

	// ----------------------------------------------------------------
	// STEP 4. Make RTS frame or CTS-to-self frame if required
	// ----------------------------------------------------------------

	//
	// calcuate the overhead bytes that encryption algorithm may add. This
	// affects the calculate of "duration" field
	//
	if ((CipherAlg == CIPHER_WEP64) || (CipherAlg == CIPHER_WEP128))
		EncryptionOverhead = 8; //WEP: IV[4] + ICV[4];
	else if (CipherAlg == CIPHER_TKIP_NO_MIC)
		EncryptionOverhead = 12;//TKIP: IV[4] + EIV[4] + ICV[4], MIC will be added to TotalPacketLength
	else if (CipherAlg == CIPHER_TKIP)
		EncryptionOverhead = 20;//TKIP: IV[4] + EIV[4] + ICV[4] + MIC[8]
	else if (CipherAlg == CIPHER_AES)
		EncryptionOverhead = 16;    // AES: IV[4] + EIV[4] + MIC[8]
	else
		EncryptionOverhead = 0;

	if (CKIP_CMIC_ON(pAd))
	{
		if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled)
		{
			//
			// LEAP + TKIP,
			// Type[2] + CKIP_MIC[4] + CKIP_SEQ[4] + IV[4] + EIV[4] + ICV[4] + MIC[8]
			//
			// 802_1H :    AA AA 03 00 00 00
			// Cisco SNAP: AA AA 03 00 40 96 00 02
			//                               ^^^^^ Type[2]
			//
			EncryptionOverhead = 30;
		}
		if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption1Enabled)
		{
			//
			// LEAP + WEP
			// Type[2] + CKIP_MIC[4] + CKIP_SEQ[4] + IV[4] + ICV[4]
			//
			EncryptionOverhead = 18;
		}
	}

	// decide how much time an ACK/CTS frame will consume in the air
	AckDuration = RTMPCalcDuration(pAd, pAd->CommonCfg.ExpectedACKRate[TxRate], 14);

	// If fragment required, MPDU size is maximum fragment size
	// Else, MPDU size should be frame with 802.11 header & CRC
	if (MpduRequired > 1)
		NextMpduSize = pAd->CommonCfg.FragmentThreshold;
	else
	{
		NextMpduSize = PacketInfo.TotalPacketLength + LENGTH_802_11 + LENGTH_CRC - LENGTH_802_3;
		if (pExtraLlcSnapEncap)
			NextMpduSize += LENGTH_802_1_H;
	}

	if (RtsRequired || OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_RTS_PROTECTION_ENABLE))
	{
		RTMPSendRTSCTSFrame(pAd,
						 	Header_802_11.Addr1,
						 	NextMpduSize + EncryptionOverhead,
						 	TxRate,
						 	pAd->CommonCfg.RtsRate,
						 	AckDuration,
						 	QueIdx,
						 	FrameGap,
						 	SUBTYPE_RTS);

		// RTS/CTS-protected frame should use LONG_RETRY (=4) and SIFS
		RetryMode = LONG_RETRY;
		FrameGap = IFS_SIFS;
		bRTS_CTSFrame = TRUE;

		if (RtsRequired)
			NumberRequired--;
	}
	else if ((pAd->CommonCfg.TxRate >= RATE_FIRST_OFDM_RATE) && OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_BG_PROTECTION_INUSED))
	{
		RTMPSendRTSCTSFrame(pAd,
						 	Header_802_11.Addr1,
						 	NextMpduSize + EncryptionOverhead,
						 	TxRate,
						 	pAd->CommonCfg.RtsRate,
						 	AckDuration,
						 	QueIdx,
						 	FrameGap,
						 	SUBTYPE_CTS);

		// RTS/CTS-protected frame should use LONG_RETRY (=4) and SIFS
		RetryMode = LONG_RETRY;
		FrameGap = IFS_SIFS;
		bRTS_CTSFrame = TRUE;
	}

	// --------------------------------------------------------
	// STEP 5. START MAKING MPDU(s)
	//      Start Copy Ndis Packet into Ring buffer.
	//      For frame required more than one ring buffer (fragment), all ring buffers
	//      have to be filled before kicking start tx bit.
	//      Make sure TX ring resource won't be used by other threads
	// --------------------------------------------------------
	SrcRemainingBytes = PacketInfo.TotalPacketLength - LENGTH_802_3;
	SrcBufLen        -= LENGTH_802_3;  // skip 802.3 header


	StartOfFrame = TRUE;
	MICFrag = FALSE;	// Flag to indicate MIC shall spread into two MPDUs

	// Start Copy Ndis Packet into Ring buffer.
	// For frame required more than one ring buffer (fragment), all ring buffers
	// have to be filled before kicking start tx bit.
	do
	{
		//
		// STEP 5.1 Get the Tx Ring descriptor & Dma Buffer address
		//
		pTxContext  = &pAd->TxContext[QueIdx][pAd->NextTxIndex[QueIdx]];
		if ((pTxContext->bWaitingBulkOut == TRUE) || (pTxContext->InUse == TRUE))
		{
			DBGPRINT_ERR(("RTUSBHardTransmit: TX RING full\n"));
			pAd->RalinkCounters.TxRingErrCount++;
			return (NDIS_STATUS_RESOURCES);
		}
		pTxContext->InUse   = TRUE;
		pAd->TxRingTotalNumber[QueIdx]++;

		// Increase & maintain Tx Ring Index
		pAd->NextTxIndex[QueIdx]++;
		if (pAd->NextTxIndex[QueIdx] >= TX_RING_SIZE)
		{
			pAd->NextTxIndex[QueIdx] = 0;
		}

		pTxD  = &(pTxContext->TransferBuffer->TxDesc);
		NdisZeroMemory(pTxD, sizeof(TXD_STRUC));
		pWirelessPacket = pTxContext->TransferBuffer->u.WirelessPacket;
		//
		// STEP 5.2 COPY 802.11 HEADER INTO 1ST DMA BUFFER
		//
		pDest = pWirelessPacket;
		NdisMoveMemory(pDest, &Header_802_11, sizeof(Header_802_11));
		pDest       += sizeof(Header_802_11);
		DataOffSet  += sizeof(Header_802_11);

		//
		// STEP 5.3 PUT IVOFFSET, IV, EIV INTO TXD
		//
		pTxD->IvOffset  = LENGTH_802_11;

		if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_WMM_INUSED))
			pTxD->IvOffset += 2;  // add QOS CONTROL bytes

		if ((CipherAlg == CIPHER_WEP64) || (CipherAlg == CIPHER_WEP128))
		{
			PUCHAR pTmp;
			pTmp = (PUCHAR) &pTxD->Iv;
			*pTmp       = RandomByte(pAd);
			*(pTmp + 1) = RandomByte(pAd);
			*(pTmp + 2) = RandomByte(pAd);
			*(pTmp + 3) = (KeyIdx << 6);
		}
		else if ((CipherAlg == CIPHER_CKIP64) || (CipherAlg == CIPHER_CKIP128) ||
			((CipherAlg == CIPHER_NONE) && (pAd->CommonCfg.WepStatus == Ndis802_11Encryption1Enabled) && LEAP_CCKM_ON(pAd)))
		{
			if (CKIP_KP_ON(pAd))  // Cisco CKIP KP is on
			{
				PUCHAR	pTmp;
				int i;

				i = 2;
				while (++pAd->StaCfg.GIV[i] == 0x0)
				{
					i--;
					if (i < 0)  break;
				}

				// when KP is required. IV++
				pTmp = (PUCHAR) &pTxD->Iv;
				*pTmp       = pAd->StaCfg.GIV[0];
				*(pTmp + 1) = pAd->StaCfg.GIV[1];
				*(pTmp + 2) = pAd->StaCfg.GIV[2];
				*(pTmp + 3) = (KeyIdx << 6); // | 0x20;

				//
				// Use software Entrypt CKIP frame.
				//
				if (CipherAlg == CIPHER_NONE)
				{
					RTMGetPCkipPK(pAd, (PUCHAR) &Header_802_11, KeyIdx, pAd->StaCfg.GIV, CKIP_PK);

					RTMPInitWepEngine(
						pAd,
						CKIP_PK,
						KeyIdx,
						13,
						(PUCHAR) &pTxD->Iv);
					NdisMoveMemory(pDest, &pTxD->Iv, 4);
					pDest += 4;
				}
			}
			else
			{
				// when KP not required. IV is randomly generated
				PUCHAR pTmp;
				pTmp = (PUCHAR) &pTxD->Iv;
				*pTmp       = RandomByte(pAd);
				*(pTmp + 1) = RandomByte(pAd);
				*(pTmp + 2) = RandomByte(pAd);
				*(pTmp + 3) = (KeyIdx << 6);
			}
		}
		else if ((CipherAlg == CIPHER_TKIP) || (CipherAlg == CIPHER_TKIP_NO_MIC))
		{
			RTMPInitTkipEngine(
				pAd,
				pKey->Key,
				KeyIdx,		// This might cause problem when using peer key
				Header_802_11.Addr2,
				pKey->TxMic,
				pKey->TxTsc,
				&Iv16,
				&Iv32);

			NdisMoveMemory(&pTxD->Iv, &Iv16, 4);   // Copy IV
			NdisMoveMemory(&pTxD->Eiv, &Iv32, 4);  // Copy EIV
			INC_TX_TSC(pKey->TxTsc);               // Increase TxTsc for next transmission
		}
		else if (CipherAlg == CIPHER_AES)
		{
			PUCHAR	pTmp;
			pTmp = (PUCHAR) &Iv16;
			*pTmp       = pKey->TxTsc[0];
			*(pTmp + 1) = pKey->TxTsc[1];
			*(pTmp + 2) = 0;
			*(pTmp + 3) = (pAd->CommonCfg.DefaultKeyId << 6) | 0x20;
			Iv32 = *(PULONG)(&pKey->TxTsc[2]);

			NdisMoveMemory(&pTxD->Iv, &Iv16, 4);    // Copy IV
			NdisMoveMemory(&pTxD->Eiv, &Iv32, 4);   // Copy EIV
			INC_TX_TSC(pKey->TxTsc);                // Increase TxTsc for next transmission
		}

		if ((pAd->CommonCfg.AuthMode >= Ndis802_11AuthModeWPA) &&
			(pAd->CommonCfg.AuthMode != Ndis802_11AuthModeWPANone))
		{
			KeyTable	= 1;		// pairwise key table
			KeyIdx		= 0;
		}
		else
		{
			KeyTable	= 0;		// shared key table
		}

		//
		// Fragmentation is not allowed on multicast & broadcast
		// So, we need to used the MAX_FRAG_THRESHOLD instead of pAd->CommonCfg.FragmentThreshold
		// otherwise if PacketInfo.TotalPacketLength > pAd->CommonCfg.FragmentThreshold then
		// packet will be fragment on multicast & broadcast.
		//
		// MpduRequired equals to 1 means this could be Aggretaion case.
		//
		if ((Header_802_11.Addr1[0] & 0x01) || MpduRequired == 1)
		{
			FreeMpduSize = MAX_FRAG_THRESHOLD - sizeof(Header_802_11) - LENGTH_CRC;
		}
		else
		{
			FreeMpduSize = pAd->CommonCfg.FragmentThreshold - sizeof(Header_802_11) - LENGTH_CRC;
		}

		if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_WMM_INUSED))
		{
			// copy QOS CONTROL bytes
			*pDest        =  (UserPriority & 0x0f) | pAd->CommonCfg.AckPolicy[QueIdx];
			*(pDest+1)    =  0;
			pDest         += 2;
			FreeMpduSize  -= 2;
			if (pAd->CommonCfg.AckPolicy[QueIdx] != NORMAL_ACK)
			{
				bAckRequired = FALSE;
			}
			LengthQosPAD = 2;
		}

		//
		// STEP 5.4 COPY LLC/SNAP, CKIP MIC INTO 1ST DMA BUFFER ONLY WHEN THIS
		//          MPDU IS THE 1ST OR ONLY FRAGMENT
		//
		if (Header_802_11.Frag == 0)
		{
			if (pExtraLlcSnapEncap)
			{
				if ((CipherAlg == CIPHER_TKIP_NO_MIC) && (pKey != NULL))
				{
					// Calculate MSDU MIC Value
					RTMPCalculateMICValue(pAd, pPacket, pExtraLlcSnapEncap, pKey);
				}

				if (CKIP_CMIC_ON(pAd) && (bEAPOLFrame == FALSE))
				{
					// CKIP_LLC_SNAP is inused. The frame format must be -
					//     802.11 header + CKIP_LLCSNAP(8) + MIC(4) + TxSEQ(4) + Proto(2) + Payload
					NdisMoveMemory(pDest, CKIP_LLC_SNAP, sizeof(CKIP_LLC_SNAP));

					pDest += sizeof(CKIP_LLC_SNAP);
					DataOffSet += sizeof(CKIP_LLC_SNAP);
					//
					// 1.) Insert MIC [4]
					//
					RTMPCkipInsertCMIC(pAd, pDest, (PUCHAR)&Header_802_11, pPacket, pKey, CKIP_LLC_SNAP);
					pDest += 4 ;
					DataOffSet += 4;
					//
					// 2.) Insert TX Sequence.
					//
					NdisMoveMemory(pDest, pAd->StaCfg.TxSEQ, 4);
					pDest += 4;
					DataOffSet += 4;
					NdisMoveMemory(pDest, pSrcBufVA + 12, 2);
					pDest += 2;
					DataOffSet += 2;

					//
					// Cisco LLC-SNAP add 2 bytes than LLC
					// AA:AA:03:00:40:96:00:02
					//
					FreeMpduSize -= 10;  //2+MIC[4]+SEQ[4]

					// Update TxSEQ for next TX
					{
						int i = 3;
						pAd->StaCfg.TxSEQ[i] = pAd->StaCfg.TxSEQ[i] + 2;
						while (pAd->StaCfg.TxSEQ[i] == 0x00)
						{
							i--;
							if (i < 0) break;
							pAd->StaCfg.TxSEQ[i] ++;
						}
					}

				}
				else
				{
					// Insert LLC-SNAP encapsulation
					NdisMoveMemory(pDest, pExtraLlcSnapEncap, 6);
					pDest += 6;
					DataOffSet += 6;
					NdisMoveMemory(pDest, pSrcBufVA + 12, 2);
					pDest += 2;
					DataOffSet += 2;
				}
				pSrcBufVA += LENGTH_802_3;
				FreeMpduSize -= LENGTH_802_1_H;
			}
			else
			{
				if ((CipherAlg == CIPHER_TKIP_NO_MIC) && (pKey != NULL))
				{
					// Calculate MSDU MIC Value
					RTMPCalculateMICValue(pAd, pPacket, pExtraLlcSnapEncap, pKey);
				}
				pSrcBufVA += LENGTH_802_3;
			}
		}

		// Start copying payload
		BytesCopied = 0;
		do
		{
			if (SrcBufLen >= FreeMpduSize)
			{
				// Copy only the free fragment size, and save the pointer
				// of current buffer descriptor for next fragment buffer.
				NdisMoveMemory(pDest, pSrcBufVA, FreeMpduSize);
				BytesCopied += FreeMpduSize;
				pSrcBufVA   += FreeMpduSize;
				pDest       += FreeMpduSize;
				SrcBufLen   -= FreeMpduSize;
				break;
			}
			else
			{
				// Copy the rest of this buffer descriptor pointed data
				// into ring buffer.
				NdisMoveMemory(pDest, pSrcBufVA, SrcBufLen);
				BytesCopied  += SrcBufLen;
				pDest        += SrcBufLen;
				FreeMpduSize -= SrcBufLen;
			}
#ifdef WIN_NDIS
			// Next descriptor
			if (PacketInfo.pFirstBuffer)
				NdisGetNextBuffer(PacketInfo.pFirstBuffer, &PacketInfo.pFirstBuffer);

			// Start scan through the rest buffer descriptors
			if (PacketInfo.pFirstBuffer)
			{
				NDIS_QUERY_BUFFER(PacketInfo.pFirstBuffer, &pSrcBufVA, &SrcBufLen);
			}
			else
#endif
			{
				// No more buffer descriptor
				// Add MIC value if needed

				//if ((pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled) &&
				//	(MICFrag == FALSE) &&
				//	(pKey != NULL))

				if((CipherAlg == CIPHER_TKIP_NO_MIC) &&
					(MICFrag == FALSE) &&
					(pKey != NULL))
				{
				// Fregment and TKIP//
					INT i;

					SrcBufLen = 8;		// Set length to MIC length
					DBGPRINT_RAW(RT_DEBUG_INFO, ("Calculated TX MIC value ="));
					for (i = 0; i < 8; i++)
					{
						DBGPRINT_RAW(RT_DEBUG_INFO, ("%02x:", pAd->PrivateInfo.Tx.MIC[i]));
					}
					DBGPRINT_RAW(RT_DEBUG_INFO, ("\n"));

					if (FreeMpduSize >= SrcBufLen)
					{
						NdisMoveMemory(pDest, pAd->PrivateInfo.Tx.MIC, SrcBufLen);
						BytesCopied  += SrcBufLen;
						pDest		 += SrcBufLen;
						FreeMpduSize -= SrcBufLen;
						SrcBufLen = 0;
					}
					else
					{
						NdisMoveMemory(pDest, pAd->PrivateInfo.Tx.MIC, FreeMpduSize);
						BytesCopied  += FreeMpduSize;
						pSrcBufVA     = pAd->PrivateInfo.Tx.MIC + FreeMpduSize;
						pDest		 += FreeMpduSize;
						SrcBufLen		 -= FreeMpduSize;
						MICFrag 	  = TRUE;
					}
				}
				break;
			}
		}	while (TRUE);		// End of copying payload

		// Real packet size, No 802.1H header for fragments except the first one.
		if ((StartOfFrame == TRUE) && (pExtraLlcSnapEncap != NULL))
		{
			if ( CKIP_KP_ON(pAd) && (bEAPOLFrame == FALSE) && CipherAlg == CIPHER_NONE)
			{
				if (CKIP_CMIC_ON(pAd))
				{
					TxSize = BytesCopied + LENGTH_802_11 + LENGTH_802_1_H + LengthQosPAD + 10; //Type[2] + CKIP_MIC[4] + CKIP_SEQ[4]
				}
				else
				{
					TxSize = BytesCopied + LENGTH_802_11 + LENGTH_802_1_H + LengthQosPAD;
				}

				//
				// Since CKIP Key Permutation per packet, Hardware encryption can't achieve.
				// We have to used software encryption instead.
				//
				// RTMPInitWepEngine has been done before, directly call RTMPEncryptData to encrypt data.
				RTMPEncryptData(pAd,
								pTxContext->TransferBuffer->u.WirelessPacket + LENGTH_802_11 + LENGTH_WEP_IV,
								pTxContext->TransferBuffer->u.WirelessPacket + LENGTH_802_11 + LENGTH_WEP_IV,
								TxSize - LENGTH_802_11);

				RTMPSetICV(pAd, pDest);
				TxSize += LENGTH_WEP_ICV + LENGTH_WEP_IV;
			}
			else
			{
				if (CKIP_CMIC_ON(pAd) && (bEAPOLFrame == FALSE))
					TxSize = BytesCopied + LENGTH_802_11 + LENGTH_802_1_H + LengthQosPAD + 10; //Type[2] + CKIP_MIC[4] + CKIP_SEQ[4]
				else
			TxSize = BytesCopied + LENGTH_802_11 + LENGTH_802_1_H + LengthQosPAD;
			}
		}
		else
		{
			TxSize = BytesCopied + LENGTH_802_11 + LengthQosPAD;
		}

		SrcRemainingBytes -=  BytesCopied;

		//
		// STEP 5.6 MODIFY MORE_FRAGMENT BIT & DURATION FIELD. WRITE TXD
		//
		pHeader80211 = (PHEADER_802_11)pWirelessPacket;
		if (SrcRemainingBytes > 0) // more fragment is required
		{
			 ULONG NextFragMpduSize;

			 pHeader80211->FC.MoreFrag = 1;
			 NextFragMpduSize = min(SrcRemainingBytes, (INT)pAd->CommonCfg.FragmentThreshold);

			 if (NextFragMpduSize < pAd->CommonCfg.FragmentThreshold)
			 {
				// In this case, we need to include LENGTH_802_11 and LENGTH_CRC for calculating Duration.
				pHeader80211->Duration = (3 * pAd->CommonCfg.Dsifs) +
									(2 * AckDuration) +
									RTMPCalcDuration(pAd, TxRate, NextFragMpduSize + EncryptionOverhead + LENGTH_802_11 + LENGTH_CRC);
			 }
			 else
			 {
				pHeader80211->Duration = (3 * pAd->CommonCfg.Dsifs) +
								(2 * AckDuration) +
								RTMPCalcDuration(pAd, TxRate, NextFragMpduSize + EncryptionOverhead);
			 }

			RTUSBWriteTxDescriptor(pAd, pTxD, CipherAlg, KeyTable, KeyIdx, bAckRequired, TRUE, FALSE,
					RetryMode, FrameGap, TxRate, TxSize, QueIdx, 0, bRTS_CTSFrame);

			FrameGap = IFS_SIFS;     // use SIFS for all subsequent fragments
			Header_802_11.Frag ++;   // increase Frag #
		}
		else
		{
			pHeader80211->FC.MoreFrag = 0;
			if (pHeader80211->Addr1[0] & 0x01) // multicast/broadcast
				pHeader80211->Duration = 0;
			else
				pHeader80211->Duration = pAd->CommonCfg.Dsifs + AckDuration;

			if ((bEAPOLFrame) && (TxRate > RATE_6))
				TxRate = RATE_6;

			RTUSBWriteTxDescriptor(pAd, pTxD, CipherAlg, KeyTable, KeyIdx, bAckRequired, FALSE, FALSE,
					RetryMode, FrameGap, TxRate, TxSize, QueIdx, 0, bRTS_CTSFrame);
			if ( pAd->SendTxWaitQueue[QueIdx].Number > 1)
				pTxD->Burst = 1;

		}

		TransferBufferLength = TxSize + sizeof(TXD_STRUC);

		if ((TransferBufferLength % 4) == 1)
			TransferBufferLength  += 3;
		else if ((TransferBufferLength % 4) == 2)
			TransferBufferLength  += 2;
		else if ((TransferBufferLength % 4) == 3)
			TransferBufferLength  += 1;


		if ((TransferBufferLength % pAd->BulkOutMaxPacketSize) == 0)
			TransferBufferLength += 4;

		NdisZeroMemory(pTxContext->TransferBuffer->Aggregation, 4);
		NdisMoveMemory(pTxContext->Header_802_3, Header_802_3, LENGTH_802_3);
		pTxContext->TxRate = TxRate;
		pTxContext->DataOffset = DataOffSet;
		pTxContext->BulkOutSize = TransferBufferLength;
		pTxContext->bAggregatible = bAggregatible;
		pTxContext->bWaitingBulkOut = TRUE;

		RTUSB_SET_BULK_FLAG(pAd, (fRTUSB_BULK_OUT_DATA_NORMAL << QueIdx));

		// Set frame gap for the rest of fragment burst.
		// It won't matter if there is only one fragment (single fragment frame).
		StartOfFrame = FALSE;
		NumberRequired--;
		if (NumberRequired == 0)
		{
			pTxContext->LastOne = TRUE;
		}
		else
		{
			pTxContext->LastOne = FALSE;
		}

		NdisInterlockedIncrement(&pAd->TxCount);
	}	while (NumberRequired > 0); //while (SrcRemainingBytes > 0); //while (NumberRequired > 0);

	// Acknowledge protocol send complete of pending packet.
#if defined(ME_98) && (ME_98 == 1)
	IndicateEnqueue(pAd, INDICATE_SEND_COMPLETE, NULL, 0, NULL, 0, 0,
					pPacket, NDIS_STATUS_SUCCESS);
	RTUSBIndicateDone(pAd);
#else
	NdisMSendComplete(pAd->AdapterHandle, pPacket, NDIS_STATUS_SUCCESS);
#endif

	//
	// Check if MIC error twice within 60 seconds and send EAPOL MIC error to TX queue
	// then we enqueue a message for disasociating with the current AP
	//

	// Check for EAPOL frame sent after MIC countermeasures
	if (pAd->StaCfg.MicErrCnt >= 3)
	{
		MLME_DISASSOC_REQ_STRUCT    DisassocReq;

		// disassoc from current AP first
		DBGPRINT(RT_DEBUG_TRACE, ("MLME - disassociate with current AP after sending second continuous EAPOL frame\n"));
		DisassocParmFill(pAd, &DisassocReq, pAd->CommonCfg.Bssid, REASON_MIC_FAILURE);
		MlmeEnqueue(pAd, ASSOC_STATE_MACHINE, MT2_MLME_DISASSOC_REQ,
					sizeof(MLME_DISASSOC_REQ_STRUCT), &DisassocReq);

		pAd->Mlme.CntlMachine.CurrState = CNTL_WAIT_DISASSOC;
		pAd->StaCfg.bBlockAssoc = TRUE;
	}

	return (NDIS_STATUS_SUCCESS);
}

#ifdef WIN_NDIS

NTSTATUS	RTUSBAPHandleRxPacket(
	IN	PRTMP_ADAPTER  pAd,
	IN	PRX_CONTEXT		pRxContext,
	IN	NTSTATUS		IoStatus)
#else
VOID	RTUSBAPHandleRxPacket(
    IN	 unsigned long data)
#endif
{
	purbb_t 		pUrb = (purbb_t)data;
	PRTMP_ADAPTER	pAd;
	PRX_CONTEXT 	pRxContext;
	PRXD_STRUC		pRxD;
    PHEADER_802_11  pHeader;
    PUCHAR          pData;
    USHORT          DataSize, Msdu2Size;
    PUCHAR          pDA, pSA;
//    NDIS_STATUS     Status;
    UCHAR           Header802_3[14];
    int             wdsidx = 0xFF;
    NDIS_802_11_PRIVACY_FILTER   Privacy;
    AP_WPA_STATE    WpaState;
    MAC_TABLE_ENTRY *pEntry = NULL;
    WDS_ENTRY		*pWDSEntry = NULL;
    BOOLEAN			bWdsPacket;
    ULONG           i, j;
    NTSTATUS		IoStatus = STATUS_SUCCESS;


	pRxContext = (PRX_CONTEXT)pUrb->context;
	pAd = pRxContext->pAd;

    DBGPRINT(RT_DEBUG_INFO, ("--->RTUSBAPHandleRxPacket\n"));

    //
    // We have a number of cases:
    //      1) The USB read timed out and we received no data.
    //      2) The USB read timed out and we received some data.
    //      3) The USB read was successful and fully filled our irp buffer.
    //      4) The irp was cancelled.
    //      5) Some other failure from the USB device object.
    //
    if (IoStatus == STATUS_SUCCESS)
    {

//		DBGPRINT(RT_DEBUG_WARN, ("BulkIn Len(%d)\n", pRxContext->pUrb->UrbBulkOrInterruptTransfer.TransferBufferLength));
		if (pRxContext->pUrb->actual_length >= sizeof(RXD_STRUC)+ LENGTH_802_11)
//		if (pRxContext->pUrb->UrbBulkOrInterruptTransfer.TransferBufferLength >= sizeof(RXD_STRUC))
		{
			pData = pRxContext->TransferBuffer;
   			do
   			{
   				// Saved data pointer for management frame which will pass to MLME block
				pRxD = (PRXD_STRUC)pData ;
				// Cast to 802.11 header for flags checking
				pHeader	= (PHEADER_802_11) (pData + sizeof(RXD_STRUC) );


				// Increase Total receive byte counter after real data received no mater any error or not
				pAd->RalinkCounters.ReceivedByteCount +=  pRxD->DataByteCnt;
				pAd->RalinkCounters.RxCount ++;

				// Check for all RxD errors
				if (APCheckRxError(pRxD) != NDIS_STATUS_SUCCESS)
				{
					if (pRxD->U2M && pRxD->CipherErr)
					{
						DBGPRINT(RT_DEBUG_TRACE, ("Rx u2me DATA Cipher Err=%d,(len=%d)\n",pRxD->CipherErr, pRxD->DataByteCnt));

                    	if ((pRxD->CipherAlg == CIPHER_TKIP) && (pRxD->CipherErr == 2))	//MIC error
                    	{
                    		pEntry = PACInquiry(pAd, pHeader->Addr2, &Privacy, &WpaState);

                    		if (pEntry)
                    			HandleCounterMeasure(pAd, pEntry);
                    	}
					}

					pAd->Counters8023.RxErrors++;
					break;  // give up this frame
				}

				INC_COUNTER64(pAd->WlanCounters.ReceivedFragmentCount);

				// All frames to AP are directed except probe_req. IEEE 802.11/1999 - p.463
				// Do this before checking "duplicate frame".
				// 2003-08-20 accept BEACON to decide if OLBC (Overlapping Legacy BSS Condition) happens
				// TODO: consider move this code to be inside "APCheckRxError()"
				if (pRxD->U2M)
				{
					if (pHeader->FC.Type == BTYPE_DATA)
					{
						CHAR RealRssi;
						RealRssi = ConvertToRssi(pAd, (UCHAR)pRxD->PlcpRssi, RSSI_NO_1);
						pAd->ApCfg.LastRssi  = RealRssi + pAd->BbpRssiToDbmDelta;
						pAd->ApCfg.AvgRssiX8  = (pAd->ApCfg.AvgRssiX8 - pAd->ApCfg.AvgRssi) + pAd->ApCfg.LastRssi;
						pAd->ApCfg.AvgRssi = pAd->ApCfg.AvgRssiX8 >> 3;
						pAd->ApCfg.NumOfAvgRssiSample ++;

						//if (!pAd->Mlme.bTxRateReportPeriod)
						//{
						//	RealRssi = ConvertToRssi(pAd, (UCHAR)pRxD->PlcpSignal, RSSI_NO_2);
						//	pAd->ApCfg.LastRssi2  = RealRssi + pAd->BbpRssiToDbmDelta;
						//}

						// Gather PowerSave information from all valid DATA frames. IEEE 802.11/1999 p.461
						if (pHeader->FC.PwrMgmt)
							APPsIndicate(pAd, pHeader->Addr2, pAd->ApCfg.LastRssi, PWR_SAVE);
						else
							APPsIndicate(pAd, pHeader->Addr2, pAd->ApCfg.LastRssi, PWR_ACTIVE);
					}

					// ignore all CNTL frames except PS-POLL
					else if ((pHeader->FC.Type == BTYPE_CNTL) && (pHeader->FC.SubType != SUBTYPE_PS_POLL))
						break;
				}
				else
				{
					if ((pHeader->FC.Type == BTYPE_MGMT) &&
						((pHeader->FC.SubType == SUBTYPE_BEACON) || (pHeader->FC.SubType == SUBTYPE_PROBE_REQ)))
						;
					else
						break; // give up this frame
				}

				// DUPLICATE FRAME CHECK:
				//   Check retry bit. If this bit is on, search the cache with SA & sequence
				//   as index, if matched, discard this frame, otherwise, update cache
				//   This check only apply to unicast data & management frames
				if ((pRxD->U2M) &&
					(pHeader->FC.Retry) &&
					(RTMPSearchTupleCache(pAd, pHeader) == TRUE))
				{
					DBGPRINT(RT_DEBUG_INFO,("RxDone- drop DUPLICATE frame(len=%d)\n",pRxD->DataByteCnt));
					INC_COUNTER64(pAd->WlanCounters.FrameDuplicateCount);
					break; // give up this frame
				}
				else    // Update Tuple Cache
					RTMPUpdateTupleCache(pAd, pHeader);
				//DBGPRINT(RT_DEBUG_WARN,("header MAC = %02x:%02x:%02x:%02x:%02x:%02x \n",pHeader->Addr2[0]
				//	,pHeader->Addr2[1],pHeader->Addr2[2],pHeader->Addr2[3],pHeader->Addr2[4],pHeader->Addr2[5]));
				//
				// CASE I. receive a DATA frame
				//
				pData += sizeof(RXD_STRUC);
//printk("2. pHeader->FC.Type = %d\n", pHeader->FC.Type);
				if (pHeader->FC.Type == BTYPE_DATA)
				{
					if (pHeader->FC.ToDs == 0)
						break; // give up this frame

					// check if Class2 or 3 error
					if ((pHeader->FC.FrDs == 0) && (APCheckClass2Class3Error(pAd, pHeader)))
						break; // give up this frame

					// Drop NULL, CF-ACK(no data), CF-POLL(no data), and CF-ACK+CF-POLL(no data) data frame
					if (pHeader->FC.SubType & 0x04) // bit 2 : no DATA
						break; // give up this frame

					if(pAd->ApCfg.BANClass3Data==TRUE)
						break; // give up this frame

					// 802.1x frame is sent to MLME instead of upper layer TCPIP
					if (RTMPCheckWPAframe(pAd, (PUCHAR)pHeader, pRxD->DataByteCnt))
					{
						REPORT_MGMT_FRAME_TO_MLME(pAd, pHeader, pRxD->DataByteCnt, pRxD->PlcpRssi, pRxD->PlcpSignal);
						break; // end of processing this frame
					}

						// pData : Pointer skip the first 24 bytes, 802.11 HEADER
						if ((pHeader->FC.FrDs == 1) && (pHeader->FC.ToDs == 1))
						{
							pData += LENGTH_802_11_WITH_ADDR4;
							DataSize = (USHORT)pRxD->DataByteCnt - LENGTH_802_11_WITH_ADDR4;
						}
						else
						{
							pData += LENGTH_802_11;
							DataSize = (USHORT)pRxD->DataByteCnt - LENGTH_802_11;
						}

						// remove the 2 extra QOS CNTL bytes
						if (pHeader->FC.SubType & 0x08)
						{
							pData += 2;
							DataSize -= 2;
						}

						// remove the 2 extra AGGREGATION bytes
						Msdu2Size = 0;
						if (pHeader->FC.Order)
						{
							Msdu2Size = *pData + (*(pData+1) << 8);
							if ((Msdu2Size <= 1536) && (Msdu2Size < DataSize))
							{
								pData += 2;
								DataSize -= 2;
							}
							else
								Msdu2Size = 0;
						}

					//
					// handle WDS
					//
					bWdsPacket = FALSE;
					if ((pHeader->FC.FrDs == 1) && (pHeader->FC.ToDs == 1))
					{
						bWdsPacket = TRUE;

						for (i = 0; i < pAd->WdsTab.Size; i++)
						{
							if (MAC_ADDR_EQUAL(pAd->WdsTab.MacTab[i].WdsAddr, pHeader->Addr2))
							{
								wdsidx = i;
								pWDSEntry = WdsTableLookup(pAd, ((PUCHAR)pHeader + sizeof(HEADER_802_11)), i);
								if (!pWDSEntry)
								{
									// check if other WDS include this entry, if yes, delete it and insert new entry
									for (j = 0; j < pAd->WdsTab.Size; j++)
									{
										if (j == i) continue;

										pWDSEntry = WdsTableLookup(pAd, ((PUCHAR)pHeader + sizeof(HEADER_802_11)), j);
										if (pWDSEntry)
										{
											DBGPRINT(RT_DEBUG_TRACE, ("WDS topology changed!!!\n"));
											WdsTableDeleteEntry(pAd, ((PUCHAR)pHeader + sizeof(HEADER_802_11)), j);
										}
									}
									pWDSEntry = WdsTableInsertEntry(pAd, ((PUCHAR)pHeader + sizeof(HEADER_802_11)), i);
								}
								break;
							}
						}

						if (i == pAd->WdsTab.Size)
						{
							DBGPRINT(RT_DEBUG_INFO, ("WDS Packet not from our WDS AP!!!\n"));
							break; // give up this frame
						}
					}

				// port access control
				pEntry = PACInquiry(pAd, pHeader->Addr2, &Privacy, (AP_WPA_STATE *)&WpaState);

				// WDS packet's DA & SA is not the same
				if (bWdsPacket)
				{
					Privacy = Ndis802_11PrivFilterAcceptAll; // no 802.1x PAC for WDS frame
					pDA = pHeader->Addr3;
					pSA = (PUCHAR)pHeader + sizeof(HEADER_802_11);
				}
				else
				{
					pDA = pHeader->Addr3;
					pSA = pHeader->Addr2;
				}

				// drop all non-802.1x DATA frame before this client's Port-Access-Control is secured
				if (Privacy == Ndis802_11PrivFilter8021xWEP)
					break; // give up this frame

					// First or Only fragment
					if (pHeader->Frag == 0)
					{
						PUCHAR pRemovedLLCSNAP;
						//pData +=  LENGTH_802_11;
						//DataSize = (USHORT) pRxD->DataByteCnt - LENGTH_802_11;
						DBGPRINT_RAW(RT_DEBUG_WARN, ("*pData = %x datasize = %d \n",*pData , DataSize));

						CONVERT_TO_802_3(Header802_3, pDA, pSA, pData, DataSize, pRemovedLLCSNAP);
						pAd->FragFrame.Flags &= 0xFFFFFFFE;

						// Firt Fragment & LLC/SNAP been removed. Keep the removed LLC/SNAP for later on
						// TKIP MIC verification.
						if (pHeader->FC.MoreFrag && pRemovedLLCSNAP)
						{
							NdisMoveMemory(pAd->FragFrame.Header_LLC, pRemovedLLCSNAP, LENGTH_802_1_H);
							pAd->FragFrame.Flags |= 0x01;
						}

						// One & The only fragment
						if (pHeader->FC.MoreFrag == FALSE)
						{
							if ((pHeader->FC.Order == 1)  && (Msdu2Size > 0)) // this is an aggregation
							{
								USHORT Payload1Size, Payload2Size;
								PUCHAR pData2;

								pAd->RalinkCounters.OneSecRxAggregationCount ++;
								Payload1Size = DataSize - Msdu2Size;
								Payload2Size = Msdu2Size - LENGTH_802_3;

								// check if DA is another associted WSTA reachable via wireless bridging,
								// if it is, then no need to indicate to LLC
								if (APBridgeToWdsAndWirelessSta(pAd, Header802_3, LENGTH_802_3, pData, Payload1Size, wdsidx))
								{
									pData2 = pData + Payload1Size + LENGTH_802_3;
									APBridgeToWdsAndWirelessSta(pAd, Header802_3, LENGTH_802_3, pData2, Payload2Size, wdsidx);
								}
								else
								{
									REPORT_ETHERNET_FRAME_TO_LLC(pAd, Header802_3, pData, Payload1Size, pAd->net_dev);
									DBGPRINT_RAW(RT_DEBUG_WARN, ("!!! report segregated MSDU1 to LLC (len=%d, proto=%02x:%02x) %02x:%02x:%02x:%02x-%02x:%02x:%02x:%02x\n",
										LENGTH_802_3+Payload1Size, Header802_3[12], Header802_3[13],
										*pData, *(pData+1),*(pData+2),*(pData+3),*(pData+4),*(pData+5),*(pData+6),*(pData+7)));

									pData2 = pData + Payload1Size + LENGTH_802_3;
									REPORT_ETHERNET_FRAME_TO_LLC(pAd, pData + Payload1Size, pData2, Payload2Size, pAd->net_dev);
									DBGPRINT_RAW(RT_DEBUG_WARN, ("!!! report segregated MSDU2 to LLC (len=%d, proto=%02x:%02x) %02x:%02x:%02x:%02x-%02x:%02x:%02x:%02x\n",
										LENGTH_802_3+Payload2Size, *(pData2 -2), *(pData2 - 1),
										*pData2, *(pData2+1),*(pData2+2),*(pData2+3),*(pData2+4),*(pData2+5),*(pData2+6),*(pData2+7)));
								}
							}
							else
							{
								// check if DA is another associted WSTA reachable via wireless bridging,
								// if it is, then no need to indicate to LLC
								if (APBridgeToWdsAndWirelessSta(pAd, Header802_3, LENGTH_802_3, pData, DataSize, wdsidx))
									break;

								REPORT_ETHERNET_FRAME_TO_LLC(pAd, Header802_3, pData, DataSize, pAd->net_dev);
								DBGPRINT_RAW(RT_DEBUG_WARN, ("!!! report DATA (no frag) to LLC (len=%d, proto=%02x:%02x) %02x:%02x:%02x:%02x-%02x:%02x:%02x:%02x\n",
									DataSize, Header802_3[12], Header802_3[13],
									*pData, *(pData+1),*(pData+2),*(pData+3),*(pData+4),*(pData+5),*(pData+6),*(pData+7)));
							}
						}

						// First fragment - record the 802.3 header and frame body
						else
						{
							NdisMoveMemory(&pAd->FragFrame.Buffer[LENGTH_802_3], pData, DataSize);
							NdisMoveMemory(pAd->FragFrame.Header802_3, Header802_3, LENGTH_802_3);
							pAd->FragFrame.RxSize   = DataSize;
							pAd->FragFrame.Sequence = pHeader->Sequence;
							pAd->FragFrame.LastFrag = pHeader->Frag;       // Should be 0
						}
					}


					// Middle & End of fragment burst
					else
					{
						// No LLC-SNAP header in except the first fragment frame

						if ((pHeader->Sequence != pAd->FragFrame.Sequence) ||
							(pHeader->Frag != (pAd->FragFrame.LastFrag + 1)))
						{
							// Fragment is not the same sequence or out of fragment number order
							// Clear Fragment frame contents
							NdisZeroMemory(&pAd->FragFrame, sizeof(FRAGMENT_FRAME));
							break; // give up this frame
						}
						else if ((pAd->FragFrame.RxSize + DataSize) > MAX_FRAME_SIZE)
						{
							// Fragment frame is too large, it exeeds the maximum frame size.
							// Clear Fragment frame contents
							NdisZeroMemory(&pAd->FragFrame, sizeof(FRAGMENT_FRAME));
							break; // give up this frame
						}

						// concatenate this fragment into the re-assembly buffer
						NdisMoveMemory(&pAd->FragFrame.Buffer[LENGTH_802_3 + pAd->FragFrame.RxSize], pData, DataSize);
						pAd->FragFrame.RxSize  += DataSize;
						pAd->FragFrame.LastFrag = pHeader->Frag;       // Update fragment number

						// Last fragment
						if (pHeader->FC.MoreFrag == FALSE)
						{
							// For TKIP frame, calculate the MIC value
							if (pRxD->CipherAlg == CIPHER_TKIP)
							{
								PCIPHER_KEY pWpaKey;

								if (!pEntry)
									break;
								pWpaKey = &pEntry->PairwiseKey;

								// Minus MIC length
								pAd->FragFrame.RxSize -= 8;

								if (pAd->FragFrame.Flags & 0x00000001)
								{
									// originally there's an LLC/SNAP field in the first fragment
									// but been removed in re-assembly buffer. here we have to include
									// this LLC/SNAP field upon calculating TKIP MIC
									// pData = pAd->FragFrame.Header_LLC;
									// Copy LLC data to the position in front of real data for MIC calculation
									NdisMoveMemory(&pAd->FragFrame.Buffer[LENGTH_802_3 - LENGTH_802_1_H],
										pAd->FragFrame.Header_LLC,
										LENGTH_802_1_H);
									pData = (PUCHAR) &pAd->FragFrame.Buffer[LENGTH_802_3 - LENGTH_802_1_H];
									DataSize = (USHORT)pAd->FragFrame.RxSize + LENGTH_802_1_H;
								}
								else
								{
									pData = (PUCHAR) &pAd->FragFrame.Buffer[LENGTH_802_3];
									DataSize = (USHORT)pAd->FragFrame.RxSize;
								}

								if (RTMPTkipCompareMICValue(pAd,
															pData,
															pDA,
															pSA,
															pWpaKey->RxMic,
															DataSize) == FALSE)
								{
									DBGPRINT_RAW(RT_DEBUG_ERROR,("Rx MIC Value error 2\n"));
									RTMPReportMicError(pAd, pWpaKey);
									break;  // give up this frame
								}

							}

							// check if DA is another associted WSTA reachable via wireless bridging,
							// if it is, then no need to indicate to LLC
							if (APBridgeToWdsAndWirelessSta(pAd, pAd->FragFrame.Header802_3, LENGTH_802_3, &pAd->FragFrame.Buffer[LENGTH_802_3], pAd->FragFrame.RxSize, wdsidx) == FALSE)
							{
								pData = &pAd->FragFrame.Buffer[LENGTH_802_3];
								REPORT_ETHERNET_FRAME_TO_LLC(pAd, pAd->FragFrame.Header802_3, pData, pAd->FragFrame.RxSize, pAd->net_dev);
	//							DBGPRINT_RAW(RT_DEBUG_TRACE, ("!!! report DATA (fragmented) to LLC (len=%d) !!!\n", pAd->FragFrame.RxSize));
							}

							// Clear Fragment frame contents
							NdisZeroMemory(&pAd->FragFrame, sizeof(FRAGMENT_FRAME));
						}
					}
					break;
				}

				//
				// CASE II. receive a MGMT frame
				//
				else if (pHeader->FC.Type == BTYPE_MGMT)
				{
					if (pAd->ApCfg.BANClass3Data==TRUE)
					{
						// disallow new association
						if ((pHeader->FC.SubType == SUBTYPE_ASSOC_REQ) || (pHeader->FC.SubType == SUBTYPE_AUTH))
						{
							DBGPRINT(RT_DEBUG_TRACE, ("   Disallow new Association \n "));
							break; // give up this frame
						}
					}

					REPORT_MGMT_FRAME_TO_MLME(pAd, pHeader, pRxD->DataByteCnt, pRxD->PlcpRssi, pRxD->PlcpSignal);
					break;  // end of processing this frame
				}

				//
				// CASE III. receive a CNTL frame
				//
				else if (pHeader->FC.Type == BTYPE_CNTL)
				{
					// handle PS-POLL here
					if ((pRxD->U2M) && (pHeader->FC.SubType == SUBTYPE_PS_POLL))
					{
						 USHORT Aid = pHeader->Duration & 0x3fff;
						 PUCHAR pAddr = pHeader->Addr2;

						 DBGPRINT(RT_DEBUG_TRACE,("rcv PS-POLL (AID=%d) from %02x:%02x:%02x:%02x:%02x:%02x\n",
							 Aid, pAddr[0], pAddr[1], pAddr[2], pAddr[3], pAddr[4], pAddr[5]));

						 APHandleRxPsPoll(pAd, pAddr, Aid, FALSE);
					}
					else
					{
						 DBGPRINT(RT_DEBUG_TRACE,("ignore CNTL (subtype=%d)\n", pHeader->FC.SubType));
					}
					break; // end of processing this frame
				}

				//
				// CASE IV. receive a frame of invalid type
				//
				else
					break; // give up this frame



			}while(FALSE);
		}

       	 pRxContext->InUse = FALSE;

		if ((!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_RESET_IN_PROGRESS)) &&
			(!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_BULKIN_RESET)) &&
			(!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_HALT_IN_PROGRESS)) &&
			(!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_NIC_NOT_EXIST)))
		{
	 	       RTUSBBulkReceive(pAd);
		}
	}
#if 0
	else if (IoStatus == STATUS_CANCELLED)
	{
        	pRxContext->InUse = FALSE;
	    	DBGPRINT(RT_DEBUG_WARN, ("Bulk In is cancelled!!!\n"));
	}
	else
	{
       	pRxContext->InUse = FALSE;

		if ((!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_RESET_IN_PROGRESS)) &&
			(!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_BULKIN_RESET)) &&
			(!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_HALT_IN_PROGRESS)) &&
			(!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_NIC_NOT_EXIST)))
		{
            		DBGPRINT(RT_DEBUG_ERROR, ("Bulk In is Failed (status = 0x%x)\n\n", IoStatus));
			RTMP_SET_FLAG(pAd, fRTMP_ADAPTER_BULKIN_RESET);
			RTUSBEnqueueInternalCmd(pAd, RT_OID_USB_RESET_BULK_IN, NULL, 0);
		}
    }
#endif

    //
    // We return STATUS_MORE_PROCESSING_REQUIRED so that the completion
    // routine (IofCompleteRequest) will stop working on the irp.
    //
    DBGPRINT(RT_DEBUG_INFO, ("<---RTUSBAPHandleRxPacket\n"));

//    return STATUS_MORE_PROCESSING_REQUIRED;
}

//#endif

/*
	========================================================================

	Routine	Description:
		This is the completion routine for the USB_RxPacket which submits
		a URB to USBD for a transmission.

		If the status is SUCCESS and the length indicated by the URB is
		correct according to the length of the header in the data, and
		packetCRC is correct,and if it is DATA packer origin form the
		BSS where currently is joinned, then if it is a fraggmented packet
		collects it first, and then performs the address translation.
		Finaly stores this packet in the RxQ and triggers the RXThread to
		indicate this packet within the NDIS context.
		If the packet is Management packet, calls the MgmtFrameRxProcessing
		function to process it.

		If the length mismatch, the reception is not correct and a reset to
		the pipe must be scheduled.

	Arguments:
		DeviceObject        Pointer to the device object for next lower
							device. DeviceObject passed in here belongs to
							the next lower driver in the stack because we
							were invoked via IoCallDriver in USB_RxPacket
							AND it is not OUR device object
		Irp                 Ptr to completed IRP
		Context             Ptr to our Adapter object (context specified
							in IoSetCompletionRoutine

	Return Value:
		Always returns STATUS_MORE_PROCESSING_REQUIRED

	Note:
		Always returns STATUS_MORE_PROCESSING_REQUIRED
	========================================================================
*/
#ifdef WIN_NDIS
NTSTATUS	RTUSBRxPacket(
	IN	PRTMP_ADAPTER  pAd,
	IN	PRX_CONTEXT		pRxContext,
	IN	NTSTATUS		status)
{
	PURB			pUrb;
	PRXD_STRUC		pRxD;
	PHEADER_802_11	pHeader;
	PUCHAR			pData;
	PUCHAR			pDA, pSA;
	UCHAR			Count;
	UCHAR			KeyIdx;
	ULONG			i;
	UCHAR			Tmp;
	NDIS_STATUS		Status;
	ULONG			RegValue, Address;
	ULONG			DataSize, Msdu2Size;
	PUCHAR			pEncap;
	UCHAR			LLC_Len[2];
	UCHAR			Header802_3[14];
	PCIPHER_KEY 	pWpaKey;
	BOOLEAN			EAPOLFrame;


	DBGPRINT_RAW(RT_DEBUG_INFO, ("--->RTUSBRxPacket\n"));

	//
	// We have a number of cases:
	//      1) The USB read timed out and we received no data.
	//      2) The USB read timed out and we received some data.
	//      3) The USB read was successful and fully filled our irp buffer.
	//      4) The irp was cancelled.
	//      5) Some other failure from the USB device object.
	//
	if (status == STATUS_SUCCESS)
	{
		DBGPRINT_RAW(RT_DEBUG_INFO, ("BulkIn TransferBufferLength(%d)\n", pRxContext->pUrb->UrbBulkOrInterruptTransfer.TransferBufferLength));
		if (pRxContext->pUrb->UrbBulkOrInterruptTransfer.TransferBufferLength >= sizeof(RXD_STRUC))
		{
			pData = pRxContext->TransferBuffer;
			pRxD = (PRXD_STRUC) pData;

			// Cast to 802.11 header for flags checking
			pHeader	= (PHEADER_802_11) (pData + sizeof(RXD_STRUC) );

			if (pRxD->DataByteCnt < 4)
				Status = NDIS_STATUS_FAILURE;
			else
			{
				// Increase Total receive byte counter after real data received no mater any error or not
				pAd->RalinkCounters.ReceivedByteCount += (pRxD->DataByteCnt - 4);
				pAd->RalinkCounters.RxCount ++;

				// Check for all RxD errors
				Status = RTMPCheckRxDescriptor(pAd, pHeader, pRxD);

			}
			if (Status == NDIS_STATUS_SUCCESS)
			{
				// Apply packet filtering rule based on microsoft requirements.
				Status = RTMPApplyPacketFilter(pAd, pRxD, pHeader);
			}

			// Add receive counters
			if (Status == NDIS_STATUS_SUCCESS)
			{
				// Increase 802.11 counters & general receive counters
				INC_COUNTER64(pAd->WlanCounters.ReceivedFragmentCount);
			}
			else
			{
				// Increase general counters
				pAd->Counters8023.RxErrors++;
			}

			// Check for retry bit, if this bit is on, search the cache with SA & sequence
			// as index, if matched, discard this frame, otherwise, update cache
			// This check only apply to unicast data & management frames
			if ((pRxD->U2M || RX_FILTER_TEST_FLAG(pAd, fRX_FILTER_ACCEPT_PROMISCUOUS)) &&
				(Status == NDIS_STATUS_SUCCESS) && (pHeader->FC.Type != BTYPE_CNTL))
			{
				if (pHeader->FC.Retry)
				{
					if (RTMPSearchTupleCache(pAd, pHeader) == TRUE)
					{
						// Found retry frame in tuple cache, Discard this frame / fragment
						// Increase 802.11 counters
						INC_COUNTER64(pAd->WlanCounters.FrameDuplicateCount);
						DBGPRINT_RAW(RT_DEBUG_TRACE, ("duplicate frame %d\n", pHeader->Sequence));
						Status = NDIS_STATUS_FAILURE;
					}
					else
					{
						RTMPUpdateTupleCache(pAd, pHeader);
					}
				}
				else	// Update Tuple Cache
				{
					RTMPUpdateTupleCache(pAd, pHeader);
				}
			}

			if ((pRxD->U2M)	|| ((pHeader->FC.SubType == SUBTYPE_BEACON) && (MAC_ADDR_EQUAL(&pAd->CommonCfg.Bssid, &pHeader->Addr2))))
			{
				if ((pAd->Antenna.field.NumOfAntenna == 2) && (pAd->Antenna.field.TxDefaultAntenna == 0) && (pAd->Antenna.field.RxDefaultAntenna == 0))
				{
					COLLECT_RX_ANTENNA_AVERAGE_RSSI(pAd, ConvertToRssi(pAd, (UCHAR)pRxD->PlcpRssi, RSSI_NO_1), 0); //Note: RSSI2 not used on RT73
					pAd->StaCfg.NumOfAvgRssiSample ++;
				}
			}

			//
			// Do RxD release operation	for	all	failure	frames
			//
			if (Status == NDIS_STATUS_SUCCESS)
			{
				do
				{
					// pData : Pointer skip	the RxD Descriptior and the first 24 bytes,	802.11 HEADER
					pData += LENGTH_802_11 + sizeof(RXD_STRUC);
					DataSize = (USHORT) pRxD->DataByteCnt - LENGTH_802_11;

					//
					// CASE I. receive a DATA frame
					//
					if (pHeader->FC.Type == BTYPE_DATA)
					{
						//Cipher Ok.
						if (PRIVATE_TEST_STATUS(pAd, PRIVATE_STATUS_WEP_ERROR) && (!pRxD->CipherErr))
						{
							PRIVATE_CLEAR_STATUS(pAd, PRIVATE_STATUS_WEP_ERROR);
							pAd->CommonCfg.PrivateStateChange = TRUE;
						}

						if (RTMPEqualMemory(EAPOL, pData + 6, 2))
							EAPOLFrame = TRUE;
						else
							EAPOLFrame = FALSE;

						pAd->BulkInDataOneSecCount++;
						// before LINK UP, all DATA frames are rejected
						if (!OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_MEDIA_STATE_CONNECTED))
						{
							DBGPRINT(RT_DEBUG_TRACE,("RxDone- drop DATA frame before LINK UP(len=%d)\n",pRxD->DataByteCnt));
							break;
						}

						//Check and handle DLS STA key handshake
						if (RTMPRcvFrameDLSCheck(pAd, pHeader, pRxD->DataByteCnt))
						{
							break;
						}

						// Drop not my BSS frame
						//
						// Not drop EAPOL frame, since this have happen on the first time that we link up
						// And need some more time to set BSSID to asic
						// So pRxD->MyBss may be 0
						//
						if ((pRxD->MyBss == 0) && (EAPOLFrame != TRUE))
							break; // give up this frame

						// Drop NULL (+CF-POLL) (+CF-ACK) data frame
						if ((pHeader->FC.SubType & 0x04) == 0x04)
						{
							DBGPRINT(RT_DEBUG_TRACE,("RxDone- drop NULL frame(subtype=%d)\n",pHeader->FC.SubType));
							break;
						}

						// remove the 2 extra QOS CNTL bytes
						if (pHeader->FC.SubType & 0x08)
						{
							pData += 2;
							DataSize -= 2;
						}

						// remove the 2 extra AGGREGATION bytes
						Msdu2Size = 0;
						if (pHeader->FC.Order)
						{
							Msdu2Size = *pData + (*(pData+1) << 8);
							if ((Msdu2Size <= 1536) && (Msdu2Size < DataSize))
							{
								pData += 2;
								DataSize -= 2;
							}
							else
								Msdu2Size = 0;
						}

						// prepare 802.3 header: DA=addr1; SA=addr3 in INFRA mode, DA=addr2 in ADHOC mode
						pDA = pHeader->Addr1;
						if (INFRA_ON(pAd))
							pSA	= pHeader->Addr3;
						else
							pSA	= pHeader->Addr2;

						if (pHeader->FC.Wep) // frame received in encrypted format
						{
							if (pRxD->CipherAlg == CIPHER_NONE) // unsupported cipher suite
							{
								//
								// Use software decrypt engine to decrypt CKIP,
								// when keylen = 16, we will set cipherAlg to CIPHER_NONE
								//
								if (CKIP_KP_ON(pAd) && (pAd->CommonCfg.WepStatus == Ndis802_11Encryption1Enabled))
								{
									// CKIP case!
									if (RTMPCkipDecrypt(pAd, pRxContext->TransferBuffer + sizeof(RXD_STRUC), pRxD->DataByteCnt) == FALSE)
									{
										DBGPRINT(RT_DEBUG_ERROR, ("RTMPCkipDecrypt failed\n"));
										break;
									}

									// Remove CKIP LLC headers if exist and make it as aa-aa-03-00-00-00
									if (NdisEqualMemory(pData, CKIP_LLC_SNAP, sizeof(CKIP_LLC_SNAP)))
									{
										NdisZeroMemory(pData + 3, 3);
										NdisMoveMemory(pData + 6, pData + sizeof(CKIP_LLC_SNAP) + LENGTH_CKIP_MIC + LENGTH_CKIP_SEQ, DataSize - (sizeof(CKIP_LLC_SNAP) + LENGTH_CKIP_MIC + LENGTH_CKIP_SEQ));
										//DataSize -= (LENGTH_802_3_TYPE + LENGTH_CKIP_MIC + LENGTH_CKIP_SEQ + LENGTH_WEP_IV + LENGTH_WEP_ICV);
										DataSize -= 18;	// skip 4-byte CMIC + 4-byte TSC + 2-byte EtherType + LENGTH_WEP_IV + LENGTH_WEP_ICV
									}
									else
									{
										DataSize -= 8;
									}
								}

								//
								// Patch to H/W Decrypt on 2-Way handshaking.
								// It may not decrypt the first encrypted EAPOL frame of 2-Way handshaking,
								// since the PairwiseKey key may not pass to ASIC before 2-Way packet incoming.
								//
								else if ((pAd->StaCfg.PortSecured == WPA_802_1X_PORT_NOT_SECURED) &&
									(pRxD->U2M))
								{
									if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled)
									{
										//Use Software to decript TKIP packet.
										if (RTMPSoftDecryptTKIP(pAd, pRxContext->TransferBuffer + sizeof(RXD_STRUC), pRxD->DataByteCnt, 0, pAd->SharedKey[BSS0]))
										{
											DBGPRINT(RT_DEBUG_TRACE, ("2-Way::RTMPSoftDecryptTKIP Complete\n"));
											pData = pRxContext->TransferBuffer + sizeof(RXD_STRUC) + LENGTH_802_11;
											DataSize = pRxD->DataByteCnt - 8 - 8 - 4 - LENGTH_802_11;  //8 bytes MIC, 8 bytes IV/EIV, 4 bytes ICV
											pEncap = pData;

										}
										else
										{
											DBGPRINT(RT_DEBUG_ERROR, ("2-Way::RTMPSoftDecryptTKIP Failed\n"));
										}
									}
									else if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption3Enabled)
									{
										//Use Software to decript AES packet.
										if (RTMPSoftDecryptAES(pAd, pRxContext->TransferBuffer + sizeof(RXD_STRUC), pRxD->DataByteCnt , pAd->SharedKey[BSS0]))
										{
											DBGPRINT(RT_DEBUG_TRACE, ("2-Way::RTMPSoftDecryptAES Complete\n"));
											pData = pRxContext->TransferBuffer + sizeof(RXD_STRUC) + LENGTH_802_11 + 8;
											DataSize = pRxD->DataByteCnt - 8 - 8 - 4 - LENGTH_802_11;  //8 bytes MIC, 8 bytes IV/EIV, 4 bytes ICV
											pEncap = pData;
										}
										else
										{
											DBGPRINT(RT_DEBUG_ERROR, ("2-Way::RTMPSoftDecryptAES Failed\n"));
										}
									}
								}
								else
								{
									break; // give up this frame
								}
							}
							else if ((!pAd->CommonCfg.bDLSCapable) && (pAd->SharedKey[BSS0][pRxD->KeyIndex].KeyLen == 0))
							{
                                                                // Do not check the key index when DLS turn on, since DLS will use different key index.
								break; // give up this frame since the keylen is invalid.
							}
							else
							{
								// Remove CKIP LLC headers and make it as aa-aa-03-00-00-00
								if (NdisEqualMemory(pData, CKIP_LLC_SNAP, sizeof(CKIP_LLC_SNAP)))
								{
									NdisZeroMemory(pData + 3, 3);
									NdisMoveMemory(pData + 6, pData + sizeof(CKIP_LLC_SNAP) + 4 + 4, DataSize - (sizeof(CKIP_LLC_SNAP) + 4 + 4));
									DataSize -= 10;	// skip 4-byte CMIC + 4-byte TSC + 2-byte EtherType
								}
							}
						}
						else
						{// frame received in clear text
							// encryption in-use but receive a non-EAPOL clear text frame, drop it
							if (((pAd->CommonCfg.WepStatus == Ndis802_11Encryption1Enabled) ||
								(pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled) ||
								(pAd->CommonCfg.WepStatus == Ndis802_11Encryption3Enabled)) &&
								(pAd->CommonCfg.PrivacyFilter == Ndis802_11PrivFilter8021xWEP) &&
								(!NdisEqualMemory(EAPOL_LLC_SNAP, pData, LENGTH_802_1_H)))
							{
								break; // give up this frame
							}
						}

						//
						// Case I.1  Process Broadcast & Multicast data frame
						//
						if (pRxD->Bcast || pRxD->Mcast)
						{
							PUCHAR pRemovedLLCSNAP;

							INC_COUNTER64(pAd->WlanCounters.MulticastReceivedFrameCount);

							// Drop Mcast/Bcast frame with fragment bit on
							if (pHeader->FC.MoreFrag)
							{
								break; // give up this frame
							}

							// Filter out Bcast frame which AP relayed for us
							if (pHeader->FC.FrDs && MAC_ADDR_EQUAL(pHeader->Addr3, pAd->CurrentAddress))
							{
								break; // give up this frame
							}

							// build 802.3 header and decide if remove the 8-byte LLC/SNAP encapsulation
							CONVERT_TO_802_3(Header802_3, pDA, pSA, pData, DataSize, pRemovedLLCSNAP);
							REPORT_ETHERNET_FRAME_TO_LLC(pAd,Header802_3, pData, DataSize, pAd->net_dev);
							DBGPRINT(RT_DEBUG_TRACE, ("!!! report BCAST DATA to LLC (len=%d) !!!\n", DataSize));
						}
						//
						// Case I.2  Process unicast-to-me DATA frame
						//
						else if	(pRxD->U2M || RX_FILTER_TEST_FLAG(pAd, fRX_FILTER_ACCEPT_PROMISCUOUS))
						{
							RECORD_LATEST_RX_DATA_RATE(pAd, pRxD);

							// Special DATA frame that has to pass to MLME
							//   1. Cisco Aironet frames for CCX2. We need pass it to MLME for special process
							//   2. EAPOL handshaking frames when driver supplicant enabled, pass to MLME for special process
							if (NdisEqualMemory(SNAP_AIRONET, pData, LENGTH_802_1_H) ||
								(NdisEqualMemory(EAPOL_LLC_SNAP, pData, LENGTH_802_1_H) &&
								((pAd->StaCfg.WpaState != SS_NOTUSE) || (pAd->StaCfg.LeapAuthMode == CISCO_AuthModeLEAP))))
							{
								DataSize += LENGTH_802_11;
								REPORT_MGMT_FRAME_TO_MLME(pAd, pHeader, DataSize, pRxD->PlcpRssi, pRxD->PlcpSignal);
								DBGPRINT_RAW(RT_DEBUG_TRACE, ("!!! report EAPOL/AIRONET DATA to MLME (len=%d) !!!\n", DataSize));
								break;	// end of processing this frame
							}

							if (pHeader->Frag == 0) 	// First or Only fragment
							{
								PUCHAR pRemovedLLCSNAP;

								CONVERT_TO_802_3(Header802_3, pDA, pSA, pData, DataSize, pRemovedLLCSNAP);
								pAd->FragFrame.Flags &= 0xFFFFFFFE;

								// Firt Fragment & LLC/SNAP been removed. Keep the removed LLC/SNAP for later on
								// TKIP MIC verification.
								if (pHeader->FC.MoreFrag && pRemovedLLCSNAP)
								{
									NdisMoveMemory(pAd->FragFrame.Header_LLC, pRemovedLLCSNAP, LENGTH_802_1_H);
									pAd->FragFrame.Flags |= 0x01;
								}

								// One & The only fragment
								if (pHeader->FC.MoreFrag == FALSE)
								{
									if ((pHeader->FC.Order == 1)  && (Msdu2Size > 0)) // this is an aggregation
									{
										ULONG Payload1Size, Payload2Size;
										PUCHAR pData2;

										pAd->RalinkCounters.OneSecRxAggregationCount ++;
										Payload1Size = DataSize - Msdu2Size;
										Payload2Size = Msdu2Size - LENGTH_802_3;

										REPORT_ETHERNET_FRAME_TO_LLC(pAd, Header802_3, pData, Payload1Size, pAd->net_dev);
										DBGPRINT(RT_DEBUG_TRACE, ("!!! report segregated MSDU1 to LLC (len=%d, proto=%02x:%02x) %02x:%02x:%02x:%02x-%02x:%02x:%02x:%02x\n",
																LENGTH_802_3+Payload1Size, Header802_3[12], Header802_3[13],
																*pData, *(pData+1),*(pData+2),*(pData+3),*(pData+4),*(pData+5),*(pData+6),*(pData+7)));

										pData2 = pData + Payload1Size + LENGTH_802_3;
										REPORT_ETHERNET_FRAME_TO_LLC(pAd, pData + Payload1Size, pData2, Payload2Size, pAd->net_dev);
										DBGPRINT_RAW(RT_DEBUG_INFO, ("!!! report segregated MSDU2 to LLC (len=%d, proto=%02x:%02x) %02x:%02x:%02x:%02x-%02x:%02x:%02x:%02x\n",
																LENGTH_802_3+Payload2Size, *(pData2 -2), *(pData2 - 1),
																*pData2, *(pData2+1),*(pData2+2),*(pData2+3),*(pData2+4),*(pData2+5),*(pData2+6),*(pData2+7)));
									}
									else
									{
										REPORT_ETHERNET_FRAME_TO_LLC(pAd, Header802_3, pData, DataSize, pAd->net_dev);
										DBGPRINT_RAW(RT_DEBUG_INFO, ("!!! report DATA (no frag) to LLC (len=%d, proto=%02x:%02x) %02x:%02x:%02x:%02x-%02x:%02x:%02x:%02x\n",
																DataSize, Header802_3[12], Header802_3[13],
																*pData, *(pData+1),*(pData+2),*(pData+3),*(pData+4),*(pData+5),*(pData+6),*(pData+7)));
									}
								}
								// First fragment - record the 802.3 header and frame body
								else
								{
									NdisMoveMemory(&pAd->FragFrame.Buffer[LENGTH_802_3], pData, DataSize);
									NdisMoveMemory(pAd->FragFrame.Header802_3, Header802_3, LENGTH_802_3);
									pAd->FragFrame.RxSize	 = DataSize;
									pAd->FragFrame.Sequence = pHeader->Sequence;
									pAd->FragFrame.LastFrag = pHeader->Frag;		// Should be 0
								}
							} //First or Only fragment
							// Middle & End of fragment burst fragments
							else
							{
								// No LLC-SNAP header in except the first fragment frame
								if ((pHeader->Sequence != pAd->FragFrame.Sequence) ||
									(pHeader->Frag != (pAd->FragFrame.LastFrag + 1)))
								{
									// Fragment is not the same sequence or out of fragment number order
									// Clear Fragment frame contents
									NdisZeroMemory(&pAd->FragFrame, sizeof(FRAGMENT_FRAME));
									break;
								}
								else if ((pAd->FragFrame.RxSize + DataSize) > MAX_FRAME_SIZE)
								{
									// Fragment frame is too large, it exeeds the maximum frame size.
									// Clear Fragment frame contents
									NdisZeroMemory(&pAd->FragFrame, sizeof(FRAGMENT_FRAME));
									break; // give up this frame
								}

								// concatenate this fragment into the re-assembly buffer
								NdisMoveMemory(&pAd->FragFrame.Buffer[LENGTH_802_3 + pAd->FragFrame.RxSize], pData, DataSize);
								pAd->FragFrame.RxSize	+= DataSize;
								pAd->FragFrame.LastFrag = pHeader->Frag;		// Update fragment number

								// Last fragment
								if (pHeader->FC.MoreFrag == FALSE)
								{
									// For TKIP frame, calculate the MIC value
									if (pRxD->CipherAlg == CIPHER_TKIP)
									{
										pWpaKey = &pAd->SharedKey[BSS0][pRxD->KeyIndex];

										// Minus MIC length
										pAd->FragFrame.RxSize -= 8;

										if (pAd->FragFrame.Flags & 0x00000001)
										{
											// originally there's an LLC/SNAP field in the first fragment
											// but been removed in re-assembly buffer. here we have to include
											// this LLC/SNAP field upon calculating TKIP MIC
											// pData = pAd->FragFrame.Header_LLC;
											// Copy LLC data to the position in front of real data for MIC calculation
											NdisMoveMemory(&pAd->FragFrame.Buffer[LENGTH_802_3 - LENGTH_802_1_H],
															pAd->FragFrame.Header_LLC,
															LENGTH_802_1_H);
											pData = (PUCHAR) &pAd->FragFrame.Buffer[LENGTH_802_3 - LENGTH_802_1_H];
											DataSize = (USHORT)pAd->FragFrame.RxSize + LENGTH_802_1_H;
										}
										else
										{
											pData = (PUCHAR) &pAd->FragFrame.Buffer[LENGTH_802_3];
											DataSize = (USHORT)pAd->FragFrame.RxSize;
										}

										if (RTMPTkipCompareMICValue(
												pAd,
												pData,
												pDA,
												pSA,
												pWpaKey->RxMic,
												DataSize) == FALSE)
										{
											DBGPRINT_RAW(RT_DEBUG_ERROR,("Rx MIC Value error 2\n"));
											RTMPReportMicError(pAd, pWpaKey);
											break;  // give up this frame
										}
									}

									pData = &pAd->FragFrame.Buffer[LENGTH_802_3];
									REPORT_ETHERNET_FRAME_TO_LLC(pAd, pAd->FragFrame.Header802_3, pData, pAd->FragFrame.RxSize, pAd->net_dev);
									DBGPRINT(RT_DEBUG_TRACE, ("!!! report DATA (fragmented) to LLC (len=%d) !!!\n", pAd->FragFrame.RxSize));
								}
							}
						}
					} // FC.Type == BTYPE_DATA
					//
					// CASE II. receive a MGMT frame
					//
					else if (pHeader->FC.Type == BTYPE_MGMT)
					{
						REPORT_MGMT_FRAME_TO_MLME(pAd, pHeader, pRxD->DataByteCnt, pRxD->PlcpRssi, pRxD->PlcpSignal);
						break;  // end of processing this frame
					}
					//
					// CASE III. receive a CNTL frame
					//
					else if (pHeader->FC.Type == BTYPE_CNTL)
						break; // give up this frame
					//
					// CASE IV. receive a frame of invalid type
					//
					else
						break; // give up this frame
				} while (FALSE); // ************* exit point *********
			}//if (Status == NDIS_STATUS_SUCCESS)

		}//if (pRxContext->pUrb->UrbBulkOrInterruptTransfer.TransferBufferLength >= sizeof(RXD_STRUC))

		pRxContext->InUse = FALSE;

		if ((!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_RESET_IN_PROGRESS)) &&
			(!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_BULKIN_RESET)) &&
			(!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_RADIO_OFF)) &&
			(!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_HALT_IN_PROGRESS)) &&
			(!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_NIC_NOT_EXIST)))
		{
			   RTUSBBulkReceive(pAd);
		}
	}// STATUS_SUCCESS
	else
	{
		pRxContext->InUse = FALSE;
	}

	//
	// We return STATUS_MORE_PROCESSING_REQUIRED so that the completion
	// routine (IofCompleteRequest) will stop working on the irp.
	//
	DBGPRINT_RAW(RT_DEBUG_INFO, ("<---USB_RxPacketComplete\n"));

	return STATUS_MORE_PROCESSING_REQUIRED;
}
#else
/*
	========================================================================
	 Description:
		This is the completion routine for the USB_RxPacket which submits
		a URB to USBD for a transmission.
	========================================================================
*/
VOID	RTUSBRxPacket(
	IN	 unsigned long data)
{
	purbb_t 			pUrb = (purbb_t)data;
	PRTMP_ADAPTER		pAd;
	PRX_CONTEXT 		pRxContext;
	PRXD_STRUC			pRxD;
#ifdef BIG_ENDIAN
	PRXD_STRUC			pDestRxD;
	RXD_STRUC			RxD;
#endif
	PHEADER_802_11		pHeader;
	PUCHAR				pData;
	PUCHAR				pDA, pSA;
	NDIS_STATUS			Status;
	USHORT				DataSize, Msdu2Size;
	UCHAR				Header802_3[14];
	PCIPHER_KEY 		pWpaKey;
//	  struct sk_buff	  *pSkb;
	BOOLEAN				EAPOLFrame;
	struct net_device			*net_dev;

	DBGPRINT_RAW(RT_DEBUG_INFO, ("--->RTUSBRxPacket\n"));

	pRxContext = (PRX_CONTEXT)pUrb->context;
	pAd = pRxContext->pAd;
	net_dev = pAd->net_dev;

	if( RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_NIC_NOT_EXIST) )
		return;

	do
	{
		DBGPRINT_RAW(RT_DEBUG_INFO, ("BulkIn actual length(%d)\n", pRxContext->pUrb->actual_length));
		if (pRxContext->pUrb->actual_length >= sizeof(RXD_STRUC)+ LENGTH_802_11)
		{
		pData = pRxContext->TransferBuffer;
#ifndef BIG_ENDIAN
		pRxD = (PRXD_STRUC) pData;
#else
		pDestRxD = (PRXD_STRUC) pData;
		RxD = *pDestRxD;
		pRxD = &RxD;
		RTMPDescriptorEndianChange((PUCHAR)pRxD, TYPE_RXD);
#endif

		// Cast to 802.11 header for flags checking
		pHeader	= (PHEADER_802_11) (pData + sizeof(RXD_STRUC) );

#ifdef BIG_ENDIAN
		RTMPFrameEndianChange(pAd, (PUCHAR)pHeader, DIR_READ, FALSE);
#endif
		if (pRxD->DataByteCnt < 4)
			Status = NDIS_STATUS_FAILURE;
		else
		{
			// Increase Total receive byte counter after real data received no mater any error or not
			pAd->RalinkCounters.ReceivedByteCount += (pRxD->DataByteCnt - 4);
			pAd->RalinkCounters.RxCount ++;

			// Check for all RxD errors
			Status = RTMPCheckRxDescriptor(pAd, pHeader, pRxD);

		}
		if (Status == NDIS_STATUS_SUCCESS)
		{
			// Apply packet filtering rule based on microsoft requirements.
			Status = RTMPApplyPacketFilter(pAd, pRxD, pHeader);
		}

		// Add receive counters
		if (Status == NDIS_STATUS_SUCCESS)
		{
			// Increase 802.11 counters & general receive counters
			INC_COUNTER64(pAd->WlanCounters.ReceivedFragmentCount);
		}
		else
		{
			// Increase general counters
			pAd->Counters.RxErrors++;
		}

		// Check for retry bit, if this bit is on, search the cache with SA & sequence
		// as index, if matched, discard this frame, otherwise, update cache
		// This check only apply to unicast data & management frames
		if ((pRxD->U2M) && (Status == NDIS_STATUS_SUCCESS) && (pHeader->FC.Type != BTYPE_CNTL))
		{
			if (pHeader->FC.Retry)
			{
				if (RTMPSearchTupleCache(pAd, pHeader) == TRUE)
				{
					// Found retry frame in tuple cache, Discard this frame / fragment
					// Increase 802.11 counters
					INC_COUNTER64(pAd->WlanCounters.FrameDuplicateCount);
					DBGPRINT_RAW(RT_DEBUG_INFO, ("duplicate frame %d\n", pHeader->Sequence));
					Status = NDIS_STATUS_FAILURE;
				}
				else
				{
					RTMPUpdateTupleCache(pAd, pHeader);
				}
			}
			else	// Update Tuple Cache
			{
				RTMPUpdateTupleCache(pAd, pHeader);
			}
		}

		if ((pRxD->U2M)	|| ((pHeader->FC.SubType == SUBTYPE_BEACON) && (MAC_ADDR_EQUAL(&pAd->CommonCfg.Bssid, &pHeader->Addr2))))
		{
			if ((pAd->Antenna.field.NumOfAntenna == 2) && (pAd->Antenna.field.TxDefaultAntenna == 0) && (pAd->Antenna.field.RxDefaultAntenna == 0))
			{
				COLLECT_RX_ANTENNA_AVERAGE_RSSI(pAd, ConvertToRssi(pAd, (UCHAR)pRxD->PlcpRssi, RSSI_NO_1), 0); //Note: RSSI2 not used on RT73
				pAd->StaCfg.NumOfAvgRssiSample ++;
			}
		}

		//
		// Do RxD release operation	for	all	failure	frames
		//
		if (Status == NDIS_STATUS_SUCCESS)
		{
			do
			{
				// pData : Pointer skip	the RxD Descriptior and the first 24 bytes,	802.11 HEADER
				pData += LENGTH_802_11 + sizeof(RXD_STRUC);
				DataSize = (USHORT) pRxD->DataByteCnt - LENGTH_802_11;

				//
				// CASE I. receive a DATA frame
				//
				if (pHeader->FC.Type == BTYPE_DATA)
				{
					// before LINK UP, all DATA frames are rejected
					if (!OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_MEDIA_STATE_CONNECTED))
					{
						DBGPRINT(RT_DEBUG_TRACE, ("RxDone- drop DATA frame before LINK UP(len=%d)\n",pRxD->DataByteCnt));
						break;
					}
                    pAd->BulkInDataOneSecCount++;


					// remove the 2 extra QOS CNTL bytes
					if (pHeader->FC.SubType & 0x08)
					{
						pData += 2;
						DataSize -= 2;
					}

					// remove the 2 extra AGGREGATION bytes
					Msdu2Size = 0;
					if (pHeader->FC.Order)
					{
						Msdu2Size = *pData + (*(pData+1) << 8);
						if ((Msdu2Size <= 1536) && (Msdu2Size < DataSize))
						{
							pData += 2;
							DataSize -= 2;
						}
						else
							Msdu2Size = 0;
					}

					// Drop not my BSS frame
					//
					// Not drop EAPOL frame, since this have happen on the first time that we link up
					// And need some more time to set BSSID to asic
					// So pRxD->MyBss may be 0
					//
			        if (RTMPEqualMemory(EAPOL, pData + 6, 2))
						EAPOLFrame = TRUE;
					else
						EAPOLFrame = FALSE;

					if ((pRxD->MyBss == 0) && (EAPOLFrame != TRUE))
						break; // give up this frame

					// Drop NULL (+CF-POLL) (+CF-ACK) data frame
					if ((pHeader->FC.SubType & 0x04) == 0x04)
					{
						DBGPRINT(RT_DEBUG_TRACE, ("RxDone- drop NULL frame(subtype=%d)\n",pHeader->FC.SubType));
						break;
					}


					// prepare 802.3 header: DA=addr1; SA=addr3 in INFRA mode, DA=addr2 in ADHOC mode
					pDA = pHeader->Addr1;
					if (INFRA_ON(pAd))
						pSA	= pHeader->Addr3;
					else
						pSA	= pHeader->Addr2;

					if (pHeader->FC.Wep) // frame received in encrypted format
					{
						if (pRxD->CipherAlg == CIPHER_NONE) // unsupported cipher suite
						{
							break; // give up this frame
						}
						else if (pAd->SharedKey[BSS0][pRxD->KeyIndex].KeyLen == 0)
						{
							break; // give up this frame since the keylen is invalid.
						}
					}
					else
					{	// frame received in clear text
						// encryption in-use but receive a non-EAPOL clear text frame, drop it
						if (((pAd->CommonCfg.WepStatus == Ndis802_11Encryption1Enabled) ||
							(pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled) ||
							(pAd->CommonCfg.WepStatus == Ndis802_11Encryption3Enabled)) &&
							(pAd->CommonCfg.PrivacyFilter == Ndis802_11PrivFilter8021xWEP) &&
							(!NdisEqualMemory(EAPOL_LLC_SNAP, pData, LENGTH_802_1_H)))
						{
							break; // give up this frame
						}
					}

					//
					// Case I.1  Process Broadcast & Multicast data frame
					//
					if (pRxD->Bcast || pRxD->Mcast)
					{
						PUCHAR pRemovedLLCSNAP;

						INC_COUNTER64(pAd->WlanCounters.MulticastReceivedFrameCount);

						// Drop Mcast/Bcast frame with fragment bit on
						if (pHeader->FC.MoreFrag)
						{
							break; // give up this frame
						}

						// Filter out Bcast frame which AP relayed for us
						if (pHeader->FC.FrDs && MAC_ADDR_EQUAL(pHeader->Addr3, pAd->CurrentAddress))
						{
							break; // give up this frame
						}

						// build 802.3 header and decide if remove the 8-byte LLC/SNAP encapsulation
						CONVERT_TO_802_3(Header802_3, pDA, pSA, pData, DataSize, pRemovedLLCSNAP);
						REPORT_ETHERNET_FRAME_TO_LLC(pAd,Header802_3, pData, DataSize, pAd->net_dev);
						DBGPRINT(RT_DEBUG_TRACE, ("!!! report BCAST DATA to LLC (len=%d) !!!\n", DataSize));
					}
					//
					// Case I.2  Process unicast-to-me DATA frame
					//
					else if	(pRxD->U2M)
					{
						RECORD_LATEST_RX_DATA_RATE(pAd, pRxD);





						// Special DATA frame that has to pass to MLME
						//	 1. EAPOL handshaking frames when driver supplicant enabled, pass to MLME for special process
						if (NdisEqualMemory(EAPOL_LLC_SNAP, pData, LENGTH_802_1_H) && (pAd->StaCfg.WpaState != SS_NOTUSE))
						{
							DataSize += LENGTH_802_11;
							REPORT_MGMT_FRAME_TO_MLME(pAd, pHeader, DataSize, pRxD->PlcpRssi, pRxD->PlcpSignal);
							DBGPRINT_RAW(RT_DEBUG_TRACE, ("!!! report EAPOL/AIRONET DATA to MLME (len=%d) !!!\n", DataSize));
							break;	// end of processing this frame
						}


						if (pHeader->Frag == 0) 	// First or Only fragment
						{
							PUCHAR pRemovedLLCSNAP;

							CONVERT_TO_802_3(Header802_3, pDA, pSA, pData, DataSize, pRemovedLLCSNAP);
							pAd->FragFrame.Flags &= 0xFFFFFFFE;

							// Firt Fragment & LLC/SNAP been removed. Keep the removed LLC/SNAP for later on
							// TKIP MIC verification.
							if (pHeader->FC.MoreFrag && pRemovedLLCSNAP)
							{
								NdisMoveMemory(pAd->FragFrame.Header_LLC, pRemovedLLCSNAP, LENGTH_802_1_H);
								pAd->FragFrame.Flags |= 0x01;
							}

							// One & The only fragment
							if (pHeader->FC.MoreFrag == FALSE)
							{
								if ((pHeader->FC.Order == 1)  && (Msdu2Size > 0)) // this is an aggregation
								{
									USHORT Payload1Size, Payload2Size;
									PUCHAR pData2;

									pAd->RalinkCounters.OneSecRxAggregationCount ++;
									Payload1Size = DataSize - Msdu2Size;
									Payload2Size = Msdu2Size - LENGTH_802_3;

									REPORT_ETHERNET_FRAME_TO_LLC(pAd, Header802_3, pData, Payload1Size, pAd->net_dev);
									DBGPRINT(RT_DEBUG_TRACE, ("!!! report segregated MSDU1 to LLC (len=%d, proto=%02x:%02x) %02x:%02x:%02x:%02x-%02x:%02x:%02x:%02x\n",
															LENGTH_802_3+Payload1Size, Header802_3[12], Header802_3[13],
															*pData, *(pData+1),*(pData+2),*(pData+3),*(pData+4),*(pData+5),*(pData+6),*(pData+7)));

									pData2 = pData + Payload1Size + LENGTH_802_3;
									REPORT_ETHERNET_FRAME_TO_LLC(pAd, pData + Payload1Size, pData2, Payload2Size, pAd->net_dev);
									DBGPRINT_RAW(RT_DEBUG_INFO, ("!!! report segregated MSDU2 to LLC (len=%d, proto=%02x:%02x) %02x:%02x:%02x:%02x-%02x:%02x:%02x:%02x\n",
															LENGTH_802_3+Payload2Size, *(pData2 -2), *(pData2 - 1),
															*pData2, *(pData2+1),*(pData2+2),*(pData2+3),*(pData2+4),*(pData2+5),*(pData2+6),*(pData2+7)));
								}
								else
								{
									REPORT_ETHERNET_FRAME_TO_LLC(pAd, Header802_3, pData, DataSize, pAd->net_dev);
									DBGPRINT_RAW(RT_DEBUG_INFO, ("!!! report DATA (no frag) to LLC (len=%d, proto=%02x:%02x) %02x:%02x:%02x:%02x-%02x:%02x:%02x:%02x\n",
															DataSize, Header802_3[12], Header802_3[13],
															*pData, *(pData+1),*(pData+2),*(pData+3),*(pData+4),*(pData+5),*(pData+6),*(pData+7)));
								}
							}
							// First fragment - record the 802.3 header and frame body
							else
							{
								NdisMoveMemory(&pAd->FragFrame.Buffer[LENGTH_802_3], pData, DataSize);
								NdisMoveMemory(pAd->FragFrame.Header802_3, Header802_3, LENGTH_802_3);
								pAd->FragFrame.RxSize	 = DataSize;
								pAd->FragFrame.Sequence = pHeader->Sequence;
								pAd->FragFrame.LastFrag = pHeader->Frag;		// Should be 0
							}
						} //First or Only fragment
						// Middle & End of fragment burst fragments
						else
						{
							// No LLC-SNAP header in except the first fragment frame
							if ((pHeader->Sequence != pAd->FragFrame.Sequence) ||
								(pHeader->Frag != (pAd->FragFrame.LastFrag + 1)))
							{
								// Fragment is not the same sequence or out of fragment number order
								// Clear Fragment frame contents
								NdisZeroMemory(&pAd->FragFrame, sizeof(FRAGMENT_FRAME));
								break;
							}
							else if ((pAd->FragFrame.RxSize + DataSize) > MAX_FRAME_SIZE)
							{
								// Fragment frame is too large, it exeeds the maximum frame size.
								// Clear Fragment frame contents
								NdisZeroMemory(&pAd->FragFrame, sizeof(FRAGMENT_FRAME));
								break; // give up this frame
							}

							// concatenate this fragment into the re-assembly buffer
							NdisMoveMemory(&pAd->FragFrame.Buffer[LENGTH_802_3 + pAd->FragFrame.RxSize], pData, DataSize);
							pAd->FragFrame.RxSize	+= DataSize;
							pAd->FragFrame.LastFrag = pHeader->Frag;		// Update fragment number

							// Last fragment
							if (pHeader->FC.MoreFrag == FALSE)
							{
								// For TKIP frame, calculate the MIC value
								if (pRxD->CipherAlg == CIPHER_TKIP)
								{
									pWpaKey = &pAd->SharedKey[BSS0][pRxD->KeyIndex];

									// Minus MIC length
									pAd->FragFrame.RxSize -= 8;

									if (pAd->FragFrame.Flags & 0x00000001)
									{
										// originally there's an LLC/SNAP field in the first fragment
										// but been removed in re-assembly buffer. here we have to include
										// this LLC/SNAP field upon calculating TKIP MIC
										// pData = pAd->FragFrame.Header_LLC;
										// Copy LLC data to the position in front of real data for MIC calculation
										NdisMoveMemory(&pAd->FragFrame.Buffer[LENGTH_802_3 - LENGTH_802_1_H],
														pAd->FragFrame.Header_LLC,
														LENGTH_802_1_H);
										pData = (PUCHAR) &pAd->FragFrame.Buffer[LENGTH_802_3 - LENGTH_802_1_H];
										DataSize = (USHORT)pAd->FragFrame.RxSize + LENGTH_802_1_H;
									}
									else
									{
										pData = (PUCHAR) &pAd->FragFrame.Buffer[LENGTH_802_3];
										DataSize = (USHORT)pAd->FragFrame.RxSize;
									}

									if (RTMPTkipCompareMICValue(
											pAd,
											pData,
											pDA,
											pSA,
											pWpaKey->RxMic,
											DataSize) == FALSE)
									{
										DBGPRINT_RAW(RT_DEBUG_ERROR, ("Rx MIC Value error 2\n"));
										RTMPReportMicError(pAd, pWpaKey);
										break;	// give up this frame
									}
								}

								pData = &pAd->FragFrame.Buffer[LENGTH_802_3];
								REPORT_ETHERNET_FRAME_TO_LLC(pAd, pAd->FragFrame.Header802_3, pData, pAd->FragFrame.RxSize, pAd->net_dev);
								DBGPRINT(RT_DEBUG_TRACE, ("!!! report DATA (fragmented) to LLC (len=%d) !!!\n", pAd->FragFrame.RxSize));
							}
						}
					}
				} // FC.Type == BTYPE_DATA
				//
				// CASE II. receive a MGMT frame
				//
				else if (pHeader->FC.Type == BTYPE_MGMT)
				{
					REPORT_MGMT_FRAME_TO_MLME(pAd, pHeader, pRxD->DataByteCnt, pRxD->PlcpRssi, pRxD->PlcpSignal);
					break;	// end of processing this frame
				}
				//
				// CASE III. receive a CNTL frame
				//
				else if (pHeader->FC.Type == BTYPE_CNTL)
					break; // give up this frame
				//
				// CASE IV. receive a frame of invalid type
				//
				else
					break; // give up this frame
			} while (FALSE); // ************* exit point *********

		}//if (Status == NDIS_STATUS_SUCCESS)

		else if (Status == NDIS_STATUS_RESET)
		{
			RTUSBEnqueueInternalCmd(pAd, RT_OID_USB_RESET_BULK_IN, NULL, 0);
			return;
		}

#ifdef BIG_ENDIAN
		RTMPDescriptorEndianChange((PUCHAR)pRxD, TYPE_RXD);
		WriteBackToDescriptor((PUCHAR)pDestRxD, (PUCHAR)pRxD, FALSE, TYPE_RXD);
#endif
	  }//if (pRxContext->pUrb->actual_length >= sizeof(RXD_STRUC)+ LENGTH_802_11)


		pRxContext->InUse = FALSE;

		if ((!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_RESET_IN_PROGRESS)) &&
			(!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_BULKIN_RESET)) &&
			(!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_RADIO_OFF)) &&
			(!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_HALT_IN_PROGRESS)) &&
			(!RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_NIC_NOT_EXIST)))
		{
			   RTUSBBulkReceive(pAd);
		}

	} while (0);

	DBGPRINT_RAW(RT_DEBUG_INFO, ("<---RTUSBRxPacket Complete\n"));
}
#endif
/*
	========================================================================

	Routine Description:

	Arguments:

	Return Value:

	IRQL =

	Note:

	========================================================================
*/
VOID	RTUSBDequeueMLMEPacket(
	IN	PRTMP_ADAPTER	pAd)
{
	unsigned long IrqFlags;

	PMGMT_STRUC		pMgmt;
	NdisAcquireSpinLock(&pAd->DeMGMTQueueLock, IrqFlags);
    if (pAd->DeMGMTQueueRunning)
    {
	DBGPRINT(RT_DEBUG_ERROR, ("<---RTUSBDequeueMLMEPacket : DeMGMTQueueRunning\n"));
        NdisReleaseSpinLock(&pAd->DeMGMTQueueLock, IrqFlags);
        return;
    }
    else
    {
        pAd->DeMGMTQueueRunning = TRUE;
        NdisReleaseSpinLock(&pAd->DeMGMTQueueLock, IrqFlags);
    }

	NdisAcquireSpinLock(&pAd->MLMEWaitQueueLock, IrqFlags);
	while ((pAd->PopMgmtIndex != pAd->PushMgmtIndex) || (atomic_read(&pAd->MgmtQueueSize) > 0))
	{
		pMgmt = &pAd->MgmtRing[pAd->PopMgmtIndex];

		if (RTUSBFreeDescriptorRequest(pAd, PRIO_RING, 0, 1) == NDIS_STATUS_SUCCESS)
		{
			InterlockedDecrement(&pAd->MgmtQueueSize);
			pAd->PopMgmtIndex = (pAd->PopMgmtIndex + 1) % MGMT_RING_SIZE;
			NdisReleaseSpinLock(&pAd->MLMEWaitQueueLock, IrqFlags);

			RTUSBMlmeHardTransmit(pAd, pMgmt);

			MlmeFreeMemory(pAd, pMgmt->pBuffer);
			pMgmt->pBuffer = NULL;
			pMgmt->Valid = FALSE;

			NdisAcquireSpinLock(&pAd->MLMEWaitQueueLock, IrqFlags);
		}
		else
		{
			DBGPRINT(RT_DEBUG_TRACE, ("not enough space in PrioRing[pAdapter->MgmtQueueSize=%d]\n", atomic_read(&pAd->MgmtQueueSize)));
			DBGPRINT(RT_DEBUG_TRACE, ("RTUSBDequeueMLMEPacket::PrioRingFirstIndex = %d, PrioRingTxCnt = %d, PopMgmtIndex = %d, PushMgmtIndex = %d, NextMLMEIndex = %d\n",
					pAd->PrioRingFirstIndex, pAd->PrioRingTxCnt,
					pAd->PopMgmtIndex, pAd->PushMgmtIndex, pAd->NextMLMEIndex));
			break;
		}
	}
	NdisReleaseSpinLock(&pAd->MLMEWaitQueueLock, IrqFlags);
	NdisAcquireSpinLock(&pAd->DeMGMTQueueLock, IrqFlags);
    	pAd->DeMGMTQueueRunning = FALSE;
	NdisReleaseSpinLock(&pAd->DeMGMTQueueLock, IrqFlags);
}

/*
	========================================================================

	Routine Description:

	Arguments:

	Return Value:

	IRQL =

	Note:

	========================================================================
*/
VOID	RTUSBCleanUpMLMEWaitQueue(
	IN	PRTMP_ADAPTER	pAd)
{
	PMGMT_STRUC		pMgmt;
	unsigned long IrqFlags;

	DBGPRINT_RAW(RT_DEBUG_TRACE, ("--->CleanUpMLMEWaitQueue\n"));

	NdisAcquireSpinLock(&pAd->MLMEWaitQueueLock, IrqFlags);
	while (pAd->PopMgmtIndex != pAd->PushMgmtIndex)
	{
		pMgmt = (PMGMT_STRUC)&pAd->MgmtRing[pAd->PopMgmtIndex];
		MlmeFreeMemory(pAd, pMgmt->pBuffer);
		pMgmt->pBuffer = NULL;
		pMgmt->Valid = FALSE;
		InterlockedDecrement(&pAd->MgmtQueueSize);

		pAd->PopMgmtIndex++;
		if (pAd->PopMgmtIndex >= MGMT_RING_SIZE)
		{
			pAd->PopMgmtIndex = 0;
		}
	}
	NdisReleaseSpinLock(&pAd->MLMEWaitQueueLock, IrqFlags);

	DBGPRINT_RAW(RT_DEBUG_TRACE, ("<---CleanUpMLMEWaitQueue\n"));
}


/*
	========================================================================

	Routine	Description:
		API for MLME to transmit management frame to AP (BSS Mode)
	or station (IBSS Mode)

	Arguments:
		pAd	Pointer	to our adapter
		Buffer		Pointer to  memory of outgoing frame
		Length		Size of outgoing management frame

	Return Value:
		NDIS_STATUS_FAILURE
		NDIS_STATUS_PENDING
		NDIS_STATUS_SUCCESS

	Note:

	========================================================================
*/
VOID	MiniportMMRequest(
	IN	PRTMP_ADAPTER	pAd,
	IN	PVOID			pBuffer,
	IN	ULONG			Length)
{
	unsigned long IrqFlags;

	DBGPRINT_RAW(RT_DEBUG_INFO, ("---> MiniportMMRequest\n"));

	if (pBuffer)
	{
		PMGMT_STRUC	pMgmt;

		// Check management ring free avaliability
		NdisAcquireSpinLock(&pAd->MLMEWaitQueueLock, IrqFlags);
		pMgmt = (PMGMT_STRUC)&pAd->MgmtRing[pAd->PushMgmtIndex];
		// This management cell has been occupied
		if (pMgmt->Valid == TRUE)
		{
			NdisReleaseSpinLock(&pAd->MLMEWaitQueueLock, IrqFlags);
			MlmeFreeMemory(pAd, pBuffer);
			pAd->RalinkCounters.MgmtRingFullCount++;
			DBGPRINT_RAW(RT_DEBUG_WARN, ("MiniportMMRequest (error:: MgmtRing full)\n"));
		}
		// Insert this request into software managemnet ring
		else
		{
			pMgmt->pBuffer = pBuffer;
			pMgmt->Length  = Length;
			pMgmt->Valid   = TRUE;
			pAd->PushMgmtIndex++;
			InterlockedIncrement(&pAd->MgmtQueueSize);
			if (pAd->PushMgmtIndex >= MGMT_RING_SIZE)
			{
				pAd->PushMgmtIndex = 0;
			}
			NdisReleaseSpinLock(&pAd->MLMEWaitQueueLock, IrqFlags);
		}
	}
	else
		DBGPRINT(RT_DEBUG_WARN, ("MiniportMMRequest (error:: NULL msg)\n"));

	RTUSBDequeueMLMEPacket(pAd);

	// If pAd->PrioRingTxCnt is larger than 0, this means that prio_ring have something to transmit.
	// Then call KickBulkOut to transmit it
	if (pAd->PrioRingTxCnt > 0)
	{
		if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_DOZE))
			AsicForceWakeup(pAd);
		RTUSBKickBulkOut(pAd);
	}

	DBGPRINT_RAW(RT_DEBUG_INFO, ("<--- MiniportMMRequest\n"));
}

/*
	========================================================================

	Routine	Description:
		Search tuple cache for receive duplicate frame from unicast frames.

	Arguments:
		pAd		Pointer	to our adapter
		pHeader			802.11 header of receiving frame

	Return Value:
		TRUE			found matched tuple cache
		FALSE			no matched found

	Note:

	========================================================================
*/
BOOLEAN	RTMPSearchTupleCache(
	IN	PRTMP_ADAPTER	pAd,
	IN	PHEADER_802_11	pHeader)
{
	INT	Index;

	for (Index = 0; Index < MAX_NUM_OF_TUPLE_CACHE; Index++)
	{
		if (pAd->TupleCache[Index].Valid == FALSE)
			continue;

		if (RTMPEqualMemory(pAd->TupleCache[Index].MacAddress, pHeader->Addr2, 6) &&
			(pAd->TupleCache[Index].Sequence == pHeader->Sequence) &&
			(pAd->TupleCache[Index].Frag == pHeader->Frag))
		{
			return (TRUE);
		}
	}
	return (FALSE);
}

/*
	========================================================================

	Routine	Description:
		Update tuple cache for new received unicast frames.

	Arguments:
		pAd		Pointer	to our adapter
		pHeader			802.11 header of receiving frame

	Return Value:
		None

	Note:

	========================================================================
*/
VOID	RTMPUpdateTupleCache(
	IN	PRTMP_ADAPTER	pAd,
	IN	PHEADER_802_11	pHeader)
{
	UCHAR	Index;

	for (Index = 0; Index < MAX_NUM_OF_TUPLE_CACHE; Index++)
	{
		if (pAd->TupleCache[Index].Valid == FALSE)
		{
			// Add new entry
			NdisMoveMemory(&pAd->TupleCache[Index].MacAddress, &pHeader->Addr2, 6);
			pAd->TupleCache[Index].Sequence = pHeader->Sequence;
			pAd->TupleCache[Index].Frag     = pHeader->Frag;
			pAd->TupleCache[Index].Valid    = TRUE;
			pAd->TupleCacheLastUpdateIndex  = Index;
			DBGPRINT(RT_DEBUG_INFO,("DUPCHECK - Add Entry %d, MAC=%02x:%02x:%02x:%02x:%02x:%02x\n",
			    Index, pAd->TupleCache[Index].MacAddress[0], pAd->TupleCache[Index].MacAddress[1],
			    pAd->TupleCache[Index].MacAddress[2], pAd->TupleCache[Index].MacAddress[3],
			    pAd->TupleCache[Index].MacAddress[4], pAd->TupleCache[Index].MacAddress[5]));
			return;
		}
		else if (RTMPEqualMemory(&pAd->TupleCache[Index].MacAddress, &pHeader->Addr2, 6))
		{
			// Update old entry
			pAd->TupleCache[Index].Sequence = pHeader->Sequence;
			pAd->TupleCache[Index].Frag     = pHeader->Frag;
			return;
		}
	}

	// tuple cache full, replace the first inserted one (even though it may not be
	// least referenced one)
	if (Index == MAX_NUM_OF_TUPLE_CACHE)
	{
		pAd->TupleCacheLastUpdateIndex ++;
		if (pAd->TupleCacheLastUpdateIndex >= MAX_NUM_OF_TUPLE_CACHE)
			pAd->TupleCacheLastUpdateIndex = 0;
		Index = pAd->TupleCacheLastUpdateIndex;

		// replace with new entry
		NdisMoveMemory(&pAd->TupleCache[Index].MacAddress, &pHeader->Addr2, 6);
		pAd->TupleCache[Index].Sequence = pHeader->Sequence;
		pAd->TupleCache[Index].Frag     = pHeader->Frag;
		pAd->TupleCache[Index].Valid    = TRUE;
		DBGPRINT(RT_DEBUG_INFO,("DUPCHECK - replace Entry %d, MAC=%02x:%02x:%02x:%02x:%02x:%02x\n",
				Index, pAd->TupleCache[Index].MacAddress[0], pAd->TupleCache[Index].MacAddress[1],
				pAd->TupleCache[Index].MacAddress[2], pAd->TupleCache[Index].MacAddress[3],
				pAd->TupleCache[Index].MacAddress[4], pAd->TupleCache[Index].MacAddress[5]));
	}
}

/*
	========================================================================

	Routine	Description:
		Apply packet filter policy, return NDIS_STATUS_FAILURE if this frame
		should be dropped.

	Arguments:
		pAd		Pointer	to our adapter
		pRxD			Pointer	to the Rx descriptor
		pHeader			Pointer to the 802.11 frame header

	Return Value:
		NDIS_STATUS_SUCCESS		Accept frame
		NDIS_STATUS_FAILURE		Drop Frame

	Note:
		Maganement frame should bypass this filtering rule.

	========================================================================
*/
NDIS_STATUS	RTMPApplyPacketFilter(
	IN	PRTMP_ADAPTER	pAd,
	IN	PRXD_STRUC		pRxD,
	IN	PHEADER_802_11	pHeader)
{
	UCHAR	i;

	// 0. Management frame should bypass all these filtering rules.
	if (pHeader->FC.Type == BTYPE_MGMT)
	{
		if ((pRxD->U2M) || (pRxD->Bcast) || (pRxD->Mcast))//steven:for ASIC Bug Workaround
		{
			//ASSERT(FALSE);
			return(NDIS_STATUS_SUCCESS);
		}
	}

	// 0.1	Drop all Rx frames if MIC countermeasures kicks in
	if (pAd->StaCfg.MicErrCnt >= 2)
	{
		DBGPRINT_RAW(RT_DEBUG_TRACE,("Rx dropped by MIC countermeasure\n"));
		return(NDIS_STATUS_FAILURE);
	}

	// 1. Drop unicast to me packet if NDIS_PACKET_TYPE_DIRECTED is FALSE
	if (pRxD->U2M)
	{
		if (!RX_FILTER_TEST_FLAG(pAd, fRX_FILTER_ACCEPT_DIRECT))
		{
			DBGPRINT_RAW(RT_DEBUG_TRACE,("Rx U2M dropped by RX_FILTER\n"));
			return(NDIS_STATUS_FAILURE);
		}
	}

	// 2. Drop broadcast packet if NDIS_PACKET_TYPE_BROADCAST is FALSE
	else if (pRxD->Bcast)
	{
		if (!RX_FILTER_TEST_FLAG(pAd, fRX_FILTER_ACCEPT_BROADCAST))
		{
			DBGPRINT_RAW(RT_DEBUG_TRACE,("Rx BCAST dropped by RX_FILTER\n"));
			return(NDIS_STATUS_FAILURE);
		}
	}

	// 3. Drop (non-Broadcast) multicast packet if NDIS_PACKET_TYPE_ALL_MULTICAST is false
	//    and NDIS_PACKET_TYPE_MULTICAST is false.
	//    If NDIS_PACKET_TYPE_MULTICAST is true, but NDIS_PACKET_TYPE_ALL_MULTICAST is false.
	//    We have to deal with multicast table lookup & drop not matched packets.
	else if (pRxD->Mcast)
	{
		if (!RX_FILTER_TEST_FLAG(pAd, fRX_FILTER_ACCEPT_ALL_MULTICAST))
		{
			if (!RX_FILTER_TEST_FLAG(pAd, fRX_FILTER_ACCEPT_MULTICAST))
			{
				DBGPRINT_RAW(RT_DEBUG_INFO,("Rx MCAST dropped by RX_FILTER\n"));
				return(NDIS_STATUS_FAILURE);
			}
			else
			{
				// Selected accept multicast packet based on multicast table
				for (i = 0; i < pAd->NumberOfMcastAddresses; i++)
				{
					if (MAC_ADDR_EQUAL(pHeader->Addr1, pAd->McastTable[i]))
					break;		// Matched
				}

				// Not matched
				if (i == pAd->NumberOfMcastAddresses)
				{
					DBGPRINT(RT_DEBUG_INFO,("Rx MCAST %02x:%02x:%02x:%02x:%02x:%02x dropped by RX_FILTER\n",
											pHeader->Addr1[0], pHeader->Addr1[1], pHeader->Addr1[2],
											pHeader->Addr1[3], pHeader->Addr1[4], pHeader->Addr1[5]));
					return(NDIS_STATUS_FAILURE);
				}
				else
				{
					DBGPRINT(RT_DEBUG_INFO,("Accept multicast %02x:%02x:%02x:%02x:%02x:%02x\n",
											pHeader->Addr1[0], pHeader->Addr1[1], pHeader->Addr1[2],
											pHeader->Addr1[3], pHeader->Addr1[4], pHeader->Addr1[5]));
				}
			}
		}
	}

	// 4. Not U2M, not Mcast, not Bcast, must be unicast to other DA.
	else
	{
		//
		// If in promiscuous mode, then accept this frame.
		//
		if (RX_FILTER_TEST_FLAG(pAd, fRX_FILTER_ACCEPT_PROMISCUOUS))
			return(NDIS_STATUS_SUCCESS);
		else
		{
			DBGPRINT_RAW(RT_DEBUG_TRACE, ("not-to-me unicast\n"));
			return(NDIS_STATUS_FAILURE);
		}
	}

	return(NDIS_STATUS_SUCCESS);
}

/*
	========================================================================

	Routine	Description:
		Check Rx descriptor, return NDIS_STATUS_FAILURE if any error dound

	Arguments:
		pRxD		Pointer	to the Rx descriptor

	Return Value:
		NDIS_STATUS_SUCCESS		No err
		NDIS_STATUS_FAILURE		Error

	Note:

	========================================================================
*/
NDIS_STATUS	RTMPCheckRxDescriptor(
	IN	PRTMP_ADAPTER	pAd,
	IN	PHEADER_802_11	pHeader,
	IN	PRXD_STRUC	pRxD)
{
	PCIPHER_KEY pWpaKey;
	INT	dBm;

	// Phy errors & CRC errors
	if (/*(pRxD->PhyErr) ||*/ (pRxD->Crc))
	{
		// Check RSSI for Noise Hist statistic collection.
		dBm = (INT) (pRxD->PlcpRssi) - pAd->BbpRssiToDbmDelta;
		if (dBm <= -87)
			pAd->StaCfg.RPIDensity[0] += 1;
		else if (dBm <= -82)
			pAd->StaCfg.RPIDensity[1] += 1;
		else if (dBm <= -77)
			pAd->StaCfg.RPIDensity[2] += 1;
		else if (dBm <= -72)
			pAd->StaCfg.RPIDensity[3] += 1;
		else if (dBm <= -67)
			pAd->StaCfg.RPIDensity[4] += 1;
		else if (dBm <= -62)
			pAd->StaCfg.RPIDensity[5] += 1;
		else if (dBm <= -57)
			pAd->StaCfg.RPIDensity[6] += 1;
		else if (dBm > -57)
			pAd->StaCfg.RPIDensity[7] += 1;

		return(NDIS_STATUS_FAILURE);
	}

	// Add Rx size to channel load counter, we should ignore error counts
	pAd->StaCfg.CLBusyBytes += (pRxD->DataByteCnt + 14);

	// Drop ToDs promiscous frame, it is opened due to CCX 2 channel load statistics
	if (pHeader->FC.ToDs)
		return(NDIS_STATUS_FAILURE);

	// Paul 04-03 for OFDM Rx length issue
	if (pRxD->DataByteCnt > MAX_AGGREGATION_SIZE)
	{
		DBGPRINT_RAW(RT_DEBUG_ERROR, ("received packet too long\n"));
		return NDIS_STATUS_FAILURE;
	}

	// Drop not U2M frames, cant's drop here because we will drop beacon in this case
	// I am kind of doubting the U2M bit operation
	// if (pRxD->U2M == 0)
	//	return(NDIS_STATUS_FAILURE);

	// drop decyption fail frame
	if (pRxD->CipherErr)
	{
		UINT i;
		PUCHAR ptr = (PUCHAR)pHeader;
		DBGPRINT_RAW(RT_DEBUG_TRACE,("ERROR: CRC ok but CipherErr %d (len = %d, Mcast=%d, Cipher=%s, KeyId=%d)\n",
			pRxD->CipherErr,
			pRxD->DataByteCnt,
			pRxD->Mcast | pRxD->Bcast,
			CipherName[pRxD->CipherAlg],
			pRxD->KeyIndex));
#if 1
		for (i=0;i<64; i+=16)
		{
			DBGPRINT_RAW(RT_DEBUG_TRACE,("%02x:%02x:%02x:%02x:%02x:%02x:%02x:%02x - %02x:%02x:%02x:%02x:%02x:%02x:%02x:%02x\n",
				*ptr,*(ptr+1),*(ptr+2),*(ptr+3),*(ptr+4),*(ptr+5),*(ptr+6),*(ptr+7),
				*(ptr+8),*(ptr+9),*(ptr+10),*(ptr+11),*(ptr+12),*(ptr+13),*(ptr+14),*(ptr+15)));
			ptr += 16;
		}
#endif

		if ((pRxD->MyBss) && (!PRIVATE_TEST_STATUS(pAd, PRIVATE_STATUS_WEP_ERROR)))
		{
			PRIVATE_SET_STATUS(pAd, PRIVATE_STATUS_WEP_ERROR);
			pAd->CommonCfg.PrivateStateChange = TRUE;
		}

		//
		// MIC Error
		//
		if (pRxD->CipherErr == 2)
		{
			pWpaKey = &pAd->SharedKey[BSS0][pRxD->KeyIndex];
			RTMPReportMicError(pAd, pWpaKey);
			DBGPRINT_RAW(RT_DEBUG_ERROR,("Rx MIC Value error\n"));
		}

		if ((pRxD->CipherAlg == CIPHER_AES) &&
			(pHeader->Sequence == pAd->FragFrame.Sequence))
		{
			//
			// Acceptable since the First FragFrame no CipherErr problem.
			//
			return(NDIS_STATUS_SUCCESS);
		}

		return(NDIS_STATUS_FAILURE);
	}

	return(NDIS_STATUS_SUCCESS);
}

/*
	========================================================================

	Routine	Description:
		Process MIC error indication and record MIC error timer.

	Arguments:
		pAd		Pointer	to our adapter
		pWpaKey			Pointer	to the WPA key structure

	Return Value:
		None

	Note:

	========================================================================
*/
VOID	RTMPReportMicError(
	IN	PRTMP_ADAPTER	pAd,
	IN PCIPHER_KEY pWpaKey)
{
	LARGE_INTEGER	Now64;
	struct
	{
		NDIS_802_11_STATUS_INDICATION		Status;
		NDIS_802_11_AUTHENTICATION_REQUEST	Request;
	}	Report;

	// 0. Set Status to indicate auth error
	Report.Status.StatusType = Ndis802_11StatusType_Authentication;

	// 1. Check for Group or Pairwise MIC error
	if (pWpaKey->Type == PAIRWISE_KEY)
		Report.Request.Flags = NDIS_802_11_AUTH_REQUEST_PAIRWISE_ERROR;
	else
		Report.Request.Flags = NDIS_802_11_AUTH_REQUEST_GROUP_ERROR;

	// 2. Copy AP MAC address
	NdisMoveMemory(Report.Request.Bssid, pWpaKey->BssId, 6);

	// 3. Calculate length
	Report.Request.Length = sizeof(NDIS_802_11_AUTHENTICATION_REQUEST);

	// 4. Indicate to NDIS
	NdisMIndicateStatus(pAd->AdapterHandle, NDIS_STATUS_MEDIA_SPECIFIC_INDICATION, (PVOID) &Report, sizeof(Report));
	NdisMIndicateStatusComplete(pAd->AdapterHandle);

	// 5. Record Last MIC error time and count
	NdisGetCurrentSystemTime(&Now64);
	if (pAd->StaCfg.MicErrCnt == 0)
	{
		pAd->StaCfg.MicErrCnt++;
		pAd->StaCfg.LastMicErrorTime = Now64;
	}
	else if (pAd->StaCfg.MicErrCnt == 1)
	{
		if (RTMPConvertToMiniSecond(pAd->StaCfg.LastMicErrorTime, Now64) > (60 * 1000))
		{
			// Update Last MIC error time, this did not violate two MIC errors within 60 seconds
			pAd->StaCfg.LastMicErrorTime = Now64;
		}
		else
		{
			pAd->StaCfg.LastMicErrorTime = Now64;
			// Violate MIC error counts, MIC countermeasures kicks in
			pAd->StaCfg.MicErrCnt++;
			// We shall block all reception
			// We shall clean all Tx ring and disassoicate from AP after next EAPOL frame
			RTUSBRejectPendingPackets(pAd);
			RTUSBCleanUpDataBulkOutQueue(pAd);
		}
	}
	else
	{
		// MIC error count >= 2
		// This should not happen
		;
	}

	RTMPSetMessageEvent(pAd, RT73_MESSAGE_EVENT_ID, MSG_TYPE_ROGUE_AP, MSG_CODE_ROGUE_AP, MSG_REASON_MIC_ERROR, pWpaKey->BssId);
}

/*
	========================================================================

	Routine	Description:
		Copy frame from waiting queue into relative ring buffer and set
	appropriate ASIC register to kick hardware transmit function

	Arguments:
		pAd	Pointer	to our adapter
		pBuffer		Pointer to  memory of outgoing frame
		Length		Size of outgoing management frame

	Return Value:
		NDIS_STATUS_FAILURE
		NDIS_STATUS_PENDING
		NDIS_STATUS_SUCCESS

	Note:

	========================================================================
*/
VOID	RTUSBMlmeHardTransmit(
	IN	PRTMP_ADAPTER	pAd,
	IN	PMGMT_STRUC		pMgmt)
{
	PTX_CONTEXT		pMLMEContext;
	PTXD_STRUC		pTxD;
	PUCHAR			pDest;
	PHEADER_802_11	pHeader_802_11;
	BOOLEAN         AckRequired, InsertTimestamp;
	ULONG			TransferBufferLength;
	PVOID			pBuffer = pMgmt->pBuffer;
	ULONG			Length = pMgmt->Length;
	UCHAR 			QueIdx;
	UCHAR			MlmeRate;
	DBGPRINT_RAW(RT_DEBUG_INFO, ("--->MlmeHardTransmit\n"));

	pAd->PrioRingTxCnt++;

	pMLMEContext = &pAd->MLMEContext[pAd->NextMLMEIndex];
	pMLMEContext->InUse = TRUE;

	// Increase & maintain Tx Ring Index
	pAd->NextMLMEIndex++;
	if (pAd->NextMLMEIndex >= PRIO_RING_SIZE)
	{
		pAd->NextMLMEIndex = 0;
	}

	pDest				= pMLMEContext->TransferBuffer->u.WirelessPacket;
	pTxD				= (PTXD_STRUC)(&pMLMEContext->TransferBuffer->TxDesc);
	NdisZeroMemory(pTxD, sizeof(TXD_STRUC));

	// Verify Mlme rate for a / g bands.
	MlmeRate = pAd->CommonCfg.MlmeRate;
	if (pAd->LatchRfRegs.Channel > 14)
	{
		//A bands.
		if (MlmeRate < RATE_6)
			MlmeRate = RATE_6;
	}
	else
	{
		//BG bands.
		//On ABG Mixed mode , if link up with A band's AP.
		//the mlmerate will be RATE_6 or higher.
		//but if you want to scan on BG channels, it would be better to use RATE_2.
		if (pAd->CommonCfg.PhyMode == PHY_11ABG_MIXED)
			MlmeRate = RATE_2;
	}

	DBGPRINT(RT_DEBUG_TRACE, ("<---MlmeRate %d   Channel %d\n",MlmeRate, pAd->LatchRfRegs.Channel ));
	pHeader_802_11 = (PHEADER_802_11) pBuffer;

	// Before radar detection done, mgmt frame can not be sent but probe req
	// Because we need to use probe req to trigger driver to send probe req in passive scan
	if ((pHeader_802_11->FC.SubType != SUBTYPE_PROBE_REQ) && (pAd->CommonCfg.bIEEE80211H == 1) && (pAd->CommonCfg.RadarDetect.RDMode != RD_NORMAL_MODE))
	{
		DBGPRINT(RT_DEBUG_ERROR,("RTUSBMlmeHardTransmit --> radar detect not in normal mode !!!\n"));
		return;
	}

	//
	// In WMM-UAPSD, mlme frame should be set psm as power saving but probe request frame
	//
	// We may use this ring to send an NULL function(no data) and be carefully on
	// the following SubType they are the same.
	//       Type value  SubType
	//      ---------- ---------
	// Data    10        0100     Null function (no data)
	// Manage  00        0100     Probe request
	//
	//
	if ((pHeader_802_11->FC.SubType == SUBTYPE_PROBE_REQ) && (pHeader_802_11->FC.Type != BTYPE_DATA))
	{
		pHeader_802_11->FC.PwrMgmt = PWR_ACTIVE;
	}
	else if (pAd->CommonCfg.bAPSDCapable && pAd->CommonCfg.APEdcaParm.bAPSDCapable)
	{
		pHeader_802_11->FC.PwrMgmt = pAd->CommonCfg.bAPSDForcePowerSave;
	}

	InsertTimestamp = FALSE;
	if (pHeader_802_11->FC.Type == BTYPE_CNTL) // must be PS-POLL
	{
		AckRequired = FALSE;
	}
	else // BTYPE_MGMT or BMGMT_DATA(must be NULL frame)
	{
		pAd->Sequence       = ((pAd->Sequence) + 1) & (MAX_SEQ_NUMBER);
		pHeader_802_11->Sequence = pAd->Sequence;

		if (pHeader_802_11->Addr1[0] & 0x01) // MULTICAST, BROADCAST
		{
			INC_COUNTER64(pAd->WlanCounters.MulticastTransmittedFrameCount);
			AckRequired = FALSE;
			pHeader_802_11->Duration = 0;
		}
		else
		{
			AckRequired = TRUE;
			pHeader_802_11->Duration = RTUSBCalcDuration(pAd, MlmeRate, 14);
			if (pHeader_802_11->FC.SubType == SUBTYPE_PROBE_RSP)
			{
				InsertTimestamp = TRUE;
			}
		}
	}

	NdisMoveMemory(pDest, pBuffer, Length);

	// Initialize Priority Descriptor
	// For inter-frame gap, the number is for this frame and next frame
	// For MLME rate, we will fix as 2Mb to match other vendor's implement

	QueIdx = QID_AC_BE;

	RTUSBWriteTxDescriptor(pAd, pTxD, CIPHER_NONE, 0,0, AckRequired, FALSE, InsertTimestamp, SHORT_RETRY,
			IFS_BACKOFF, MlmeRate, /*Length+4*/ Length, QueIdx, PID_MGMT_FRAME, FALSE);

	// Build our URB for USBD
	TransferBufferLength = sizeof(TXD_STRUC) + Length;
	if ((TransferBufferLength % 2) == 1)
		TransferBufferLength++;

	if ((TransferBufferLength % pAd->BulkOutMaxPacketSize) == 0)
		TransferBufferLength += 2;

	pMLMEContext->BulkOutSize = TransferBufferLength;
	pMLMEContext->bWaitingBulkOut =TRUE;
	RTUSB_SET_BULK_FLAG(pAd, fRTUSB_BULK_OUT_MLME);

	DBGPRINT(RT_DEBUG_INFO, ("<---MlmeHardTransmit\n"));
}

/*
	==========================================================================
	Description:
		Send out a NULL frame to AP. The prpose is to inform AP this client
		current PSM bit.
	NOTE:
		This routine should only be used in infrastructure mode.
	==========================================================================
 */
VOID RTMPSendNullFrame(
	IN	PRTMP_ADAPTER	pAd,
	IN	UCHAR			TxRate)
{
	PTX_CONTEXT	pNullContext;
	PTXD_STRUC		pTxD;
	UCHAR 			QueIdx =QID_AC_VO;
	PHEADER_802_11  pHdr80211;
	ULONG			TransferBufferLength;


	QueIdx =QID_AC_BE;

	if ((RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_RESET_IN_PROGRESS)) ||
		(RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_BULKOUT_RESET)) ||
		(RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_HALT_IN_PROGRESS)) ||
		(RTMP_TEST_FLAG(pAd, fRTMP_ADAPTER_NIC_NOT_EXIST)))
	{
		return;
	}

	// WPA 802.1x secured port control
	if (((pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA) ||
		(pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPAPSK) ||
		(pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA2) ||
		(pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA2PSK) ||
		(pAd->StaCfg.LeapAuthMode == CISCO_AuthModeLEAP)) &&
		(pAd->StaCfg.PortSecured == WPA_802_1X_PORT_NOT_SECURED))
	{
		return;
	}

	pNullContext = &(pAd->NullContext);
	if (pNullContext->InUse == FALSE)
	{
		// Set the in use bit
		pNullContext->InUse = TRUE;

		// Fill Null frame body and TxD
		pTxD  = &(pNullContext->TransferBuffer->TxDesc);
		NdisZeroMemory(pTxD, sizeof(TXD_STRUC));

		pHdr80211 = (PHEADER_802_11) &pAd->NullContext.TransferBuffer->u.NullFrame;
		MgtMacHeaderInit(pAd, pHdr80211, SUBTYPE_NULL_FUNC, 1, pAd->CommonCfg.Bssid, pAd->CommonCfg.Bssid);
		pHdr80211->Duration = RTUSBCalcDuration(pAd, TxRate, 14);
		pHdr80211->FC.Type = BTYPE_DATA;
		pHdr80211->FC.PwrMgmt = (pAd->StaCfg.Psm == PWR_SAVE);

		TransferBufferLength = sizeof(TXD_STRUC) + sizeof(HEADER_802_11);

		if (pAd->CommonCfg.bAPSDCapable && pAd->CommonCfg.APEdcaParm.bAPSDCapable)
		{
			pHdr80211->FC.SubType = SUBTYPE_QOS_NULL;

			// copy QOS control bytes
			*((PUCHAR)pHdr80211+TransferBufferLength-sizeof(TXD_STRUC))		= 0;
			*((PUCHAR)pHdr80211+TransferBufferLength-sizeof(TXD_STRUC)+1)	= 0;
			TransferBufferLength += 2;
		}

		RTUSBWriteTxDescriptor(pAd, pTxD, CIPHER_NONE, 0,0, FALSE, FALSE, FALSE, SHORT_RETRY,
			IFS_BACKOFF, TxRate, (TransferBufferLength-sizeof(TXD_STRUC)), QueIdx, PID_MGMT_FRAME, FALSE);

		DBGPRINT(RT_DEBUG_ERROR, ("SYNC - send NULL Frame @%d Mbps...\n", RateIdToMbps[TxRate]));

		if ((TransferBufferLength % 2) == 1)
			TransferBufferLength++;
		if ((TransferBufferLength % pAd->BulkOutMaxPacketSize) == 0)
			TransferBufferLength += 2;

		// Fill out frame length information for global Bulk out arbitor
		pNullContext->BulkOutSize = TransferBufferLength;
		RTUSB_SET_BULK_FLAG(pAd, fRTUSB_BULK_OUT_DATA_NULL);

		// Kick bulk out
		RTUSBKickBulkOut(pAd);
	}
}

VOID RTMPSendHardEncryptFrame(
	IN	PRTMP_ADAPTER	pAd,
	IN	UCHAR			TxRate,
	IN  PCIPHER_KEY		pKey,
	IN	UCHAR			KeyTable,
	IN	UCHAR			KeyIdx,
	IN	PUCHAR			pFrame,
	IN	ULONG			FrameLen)
{
	PTX_CONTEXT	pSpecialDataContext;
	UCHAR			FrameGap;
	UCHAR		QueIdx = 0; //default QueIdx.
	PHEADER_802_11  pHeader_802_11;
	UCHAR			CipherAlg;
	USHORT			AckDuration = 0;
	PTXD_STRUC		pTxD;
	ULONG			Iv16;
	ULONG			Iv32;
	UCHAR			CKIP_PK[16];	 // ckip permuted key
	PUCHAR			pDest;
	BOOLEAN			bAckRequired = FALSE;
	UCHAR			RetryMode = SHORT_RETRY;
	ULONG			TxSize;
	UCHAR			LengthQosPAD =0;
	ULONG			TransferBufferLength;
	UCHAR			UserPriority = 0; //Default value

	pSpecialDataContext = &pAd->SpecialDataContext;
	if (pSpecialDataContext->InUse == FALSE)
	{
 		if (pAd->CommonCfg.APEdcaParm.bValid && pAd->CommonCfg.APEdcaParm.Txop[QueIdx])
			FrameGap = IFS_SIFS;
 		else
			FrameGap = IFS_BACKOFF;		// Default frame gap mode

		pHeader_802_11 = (PHEADER_802_11) pFrame;

		if (pHeader_802_11->Addr1[0] & 0x01) // MULTICAST, BROADCAST
		{
			INC_COUNTER64(pAd->WlanCounters.MulticastTransmittedFrameCount);
			bAckRequired = FALSE;
			pHeader_802_11->Duration = 0;
		}
		else
		{
			bAckRequired = TRUE;
			// decide how much time an ACK/CTS frame will consume in the air
			AckDuration = RTMPCalcDuration(pAd, pAd->CommonCfg.ExpectedACKRate[TxRate], 14);
			pHeader_802_11->Duration = pAd->CommonCfg.Dsifs + AckDuration;
		}

		if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_WMM_INUSED))
			pHeader_802_11->FC.SubType = SUBTYPE_QDATA;

		CipherAlg = pKey->CipherAlg;

		pTxD  = &pSpecialDataContext->TransferBuffer->TxDesc;
		pDest = pSpecialDataContext->TransferBuffer->u.WirelessPacket;
		NdisMoveMemory(pDest, pHeader_802_11, sizeof(HEADER_802_11));
		pDest       += sizeof(HEADER_802_11);

		pTxD->IvOffset  = LENGTH_802_11;

		if (OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_WMM_INUSED))
		{
			pTxD->IvOffset += 2;  // add QOS CONTROL bytes

			// copy QOS CONTROL bytes
			//
			// Add QOS CONTROL bytes offset, if supported WMM
			// Otherwise IV & EIV will be mixed up by following IV/EIV update
			// For example: LEAP_CCKM_ON, Use software Entrypt CKIP frame.
			//
			*pDest        =  (UserPriority & 0x0f) | pAd->CommonCfg.AckPolicy[QueIdx];
			*(pDest+1)    =  0;
			pDest         += 2;
			if (pAd->CommonCfg.AckPolicy[QueIdx] != NORMAL_ACK)
			{
				bAckRequired = FALSE;
			}
			LengthQosPAD = 2;
		}

		if ((CipherAlg == CIPHER_WEP64) || (CipherAlg == CIPHER_WEP128))
		{
			PUCHAR pTmp;
			pTmp = (PUCHAR) &pTxD->Iv;
			*pTmp       = RandomByte(pAd);
			*(pTmp + 1) = RandomByte(pAd);
			*(pTmp + 2) = RandomByte(pAd);
			*(pTmp + 3) = (KeyIdx << 6);
		}
		else if ((CipherAlg == CIPHER_CKIP64) || (CipherAlg == CIPHER_CKIP128) ||
			((CipherAlg == CIPHER_NONE) && (pAd->CommonCfg.WepStatus == Ndis802_11Encryption1Enabled) && LEAP_CCKM_ON(pAd)))
		{
			if (CKIP_KP_ON(pAd))  // Cisco CKIP KP is on
			{
				PUCHAR	pTmp;
				int i;

				i = 2;
				while (++pAd->StaCfg.GIV[i] == 0x0)
				{
					i--;
					if (i < 0)  break;
				}

				// when KP is required. IV++
				pTmp = (PUCHAR) &pTxD->Iv;
				*pTmp       = pAd->StaCfg.GIV[0];
				*(pTmp + 1) = pAd->StaCfg.GIV[1];
				*(pTmp + 2) = pAd->StaCfg.GIV[2];
				*(pTmp + 3) = (KeyIdx << 6); // | 0x20;

				//
				// Use software Entrypt CKIP frame.
				//
				if (CipherAlg == CIPHER_NONE)
				{
					RTMGetPCkipPK(pAd, (PUCHAR) pHeader_802_11, KeyIdx, pAd->StaCfg.GIV, CKIP_PK);

					RTMPInitWepEngine(
						pAd,
						CKIP_PK,
						KeyIdx,
						13,
						(PUCHAR) &pTxD->Iv);
					NdisMoveMemory(pDest, &pTxD->Iv, 4);
					pDest += 4;
				}
			}
			else
			{
				// when KP not required. IV is randomly generated
				PUCHAR pTmp;
				pTmp = (PUCHAR) &pTxD->Iv;
				*pTmp       = RandomByte(pAd);
				*(pTmp + 1) = RandomByte(pAd);
				*(pTmp + 2) = RandomByte(pAd);
				*(pTmp + 3) = (KeyIdx << 6);
			}
		}
		else if ((CipherAlg == CIPHER_TKIP) || (CipherAlg == CIPHER_TKIP_NO_MIC))
		{
			RTMPInitTkipEngine(
				pAd,
				pKey->Key,
				KeyIdx,		// This might cause problem when using peer key
				pHeader_802_11->Addr2,
				pKey->TxMic,
				pKey->TxTsc,
				&Iv16,
				&Iv32);

			NdisMoveMemory(&pTxD->Iv, &Iv16, 4);   // Copy IV
			NdisMoveMemory(&pTxD->Eiv, &Iv32, 4);  // Copy EIV
			INC_TX_TSC(pKey->TxTsc);               // Increase TxTsc for next transmission
		}
		else if (CipherAlg == CIPHER_AES)
		{
			PUCHAR	pTmp;
			pTmp = (PUCHAR) &Iv16;
			*pTmp       = pKey->TxTsc[0];
			*(pTmp + 1) = pKey->TxTsc[1];
			*(pTmp + 2) = 0;
			*(pTmp + 3) = (pAd->CommonCfg.DefaultKeyId << 6) | 0x20;
			Iv32 = *(PULONG)(&pKey->TxTsc[2]);

			NdisMoveMemory(&pTxD->Iv, &Iv16, 4);    // Copy IV
			NdisMoveMemory(&pTxD->Eiv, &Iv32, 4);   // Copy EIV
			INC_TX_TSC(pKey->TxTsc);                // Increase TxTsc for next transmission
		}

		//
		// Copy MPDU.
		//
		NdisMoveMemory(pDest, pFrame + LENGTH_802_11, FrameLen - LENGTH_802_11);
		TxSize = FrameLen + LengthQosPAD;

		RTUSBWriteTxDescriptor(pAd, pTxD, CipherAlg, KeyTable, KeyIdx, bAckRequired, FALSE, FALSE,
				RetryMode, FrameGap, TxRate, TxSize, QueIdx, 0, FALSE);

		TransferBufferLength = TxSize + sizeof(TXD_STRUC);

		if ((TransferBufferLength % 2) == 1)
			TransferBufferLength++;

		if ((TransferBufferLength % pAd->BulkOutMaxPacketSize) == 0)
			TransferBufferLength += 2;

		pSpecialDataContext->BulkOutSize = TransferBufferLength;

		RTUSB_SET_BULK_FLAG(pAd, (fRTUSB_BULK_OUT_DATA_SPECIAL));

		// Kick bulk out
		RTUSBKickBulkOut(pAd);
 	}
}

VOID RTMPSendRTSCTSFrame(
	IN  PRTMP_ADAPTER	pAd,
	IN  PUCHAR			pDA,
	IN  ULONG			NextMpduSize,
	IN  UCHAR			TxRate,
	IN  UCHAR			RTSRate,
	IN  USHORT			AckDuration,
	IN  UCHAR			QueIdx,
	IN  UCHAR			FrameGap,
	IN  UCHAR			Type)
{
	PTX_CONTEXT     		pTxContext;
	PTXD_STRUC			pTxD;
	PRTS_FRAME			pRtsFrame;
	PUCHAR				pBuf;
	ULONG				Length = 0;
	ULONG				TransferBufferLength = 0;

	if ((Type != SUBTYPE_RTS) && ( Type != SUBTYPE_CTS))
	{
		DBGPRINT(RT_DEBUG_WARN,("Making RTS/CTS Frame failed, type not matched!\n"));
		return;
	}
	else if ((Type == SUBTYPE_RTS) && ((*pDA) & 0x01))
	{
		if ((*pDA) & 0x01)
		{
			// should not use RTS/CTS to protect MCAST frame since no one will reply CTS
			DBGPRINT(RT_DEBUG_INFO,("Not use RTS Frame to proect MCAST frame\n"));
			return;
		}
	}

	pTxContext  = &pAd->TxContext[QueIdx][pAd->NextTxIndex[QueIdx]];
	if (pTxContext->InUse == FALSE)
	{
		pTxContext->InUse   = TRUE;
		pTxContext->LastOne = FALSE;
		pAd->TxRingTotalNumber[QueIdx]++;
		pAd->NextTxIndex[QueIdx]++;
		if (pAd->NextTxIndex[QueIdx] >= TX_RING_SIZE)
		{
			pAd->NextTxIndex[QueIdx] = 0;
		}
		pTxD = (PTXD_STRUC) &pTxContext->TransferBuffer->TxDesc;
		pRtsFrame = (PRTS_FRAME) &pTxContext->TransferBuffer->u.RTSFrame;
		pBuf = (PUCHAR) pRtsFrame;

		NdisZeroMemory(pRtsFrame, sizeof(RTS_FRAME));
		pRtsFrame->FC.Type    = BTYPE_CNTL;
		// CTS-to-self's duration = SIFS + MPDU
		pRtsFrame->Duration = (2 * pAd->CommonCfg.Dsifs) + RTMPCalcDuration(pAd, TxRate, NextMpduSize) + AckDuration;// SIFS + Data + SIFS + ACK

		// Write Tx descriptor
		// Don't kick tx start until all frames are prepared
		// RTS has to set more fragment bit for fragment burst
		// RTS did not encrypt

		if (Type == SUBTYPE_RTS)
		{
			DBGPRINT(RT_DEBUG_INFO,("Making RTS Frame\n"));

			pRtsFrame->FC.SubType = SUBTYPE_RTS;
			COPY_MAC_ADDR(pRtsFrame->Addr1, pDA);
			COPY_MAC_ADDR(pRtsFrame->Addr2, pAd->CurrentAddress);

			// RTS's duration need to include and extra (SIFS + CTS) time
			pRtsFrame->Duration += (pAd->CommonCfg.Dsifs + RTMPCalcDuration(pAd, RTSRate, 14)); // SIFS + CTS-Duration

			Length = sizeof(RTS_FRAME);
			RTUSBWriteTxDescriptor(pAd, pTxD, CIPHER_NONE, 0,0, TRUE, TRUE, FALSE, SHORT_RETRY,
				FrameGap, RTSRate, Length, QueIdx, 0, FALSE);
		}
		else if (Type == SUBTYPE_CTS)
		{
			DBGPRINT(RT_DEBUG_INFO,("Making CTS-to-self Frame\n"));
			pRtsFrame->FC.SubType = SUBTYPE_CTS;
			COPY_MAC_ADDR(pRtsFrame->Addr1, pAd->CurrentAddress);

			Length = 10;  //CTS frame length.
			RTUSBWriteTxDescriptor(pAd, pTxD, CIPHER_NONE, 0,0, FALSE, TRUE, FALSE, SHORT_RETRY,
				FrameGap, RTSRate, Length, QueIdx, 0, FALSE);
		}

		// Build our URB for USBD
		TransferBufferLength = sizeof(TXD_STRUC) + Length;
		if ((TransferBufferLength % 2) == 1)
			TransferBufferLength++;
		if ((TransferBufferLength % pAd->BulkOutMaxPacketSize) == 0)
			TransferBufferLength += 2;

		// Fill out frame length information for global Bulk out arbitor
		pTxContext->BulkOutSize = TransferBufferLength;
		pTxContext->bWaitingBulkOut = TRUE;
		pTxContext->LastOne = TRUE;
		NdisInterlockedIncrement(&pAd->TxCount);
		RTUSB_SET_BULK_FLAG(pAd, fRTUSB_BULK_OUT_DATA_NORMAL << QueIdx);

	}
}

/*
	========================================================================

	Routine	Description:
		Calculates the duration which is required to transmit out frames
	with given size and specified rate.

	Arguments:
		pAd		Pointer	to our adapter
		Rate			Transmit rate
		Size			Frame size in units of byte

	Return Value:
		Duration number in units of usec

	IRQL = PASSIVE_LEVEL
	IRQL = DISPATCH_LEVEL

	Note:

	========================================================================
*/
USHORT	RTMPCalcDuration(
	IN	PRTMP_ADAPTER	pAd,
	IN	UCHAR			Rate,
	IN	ULONG			Size)
{
	ULONG	Duration = 0;

	if (Rate < RATE_FIRST_OFDM_RATE) // CCK
	{
		if ((Rate > RATE_1) && OPSTATUS_TEST_FLAG(pAd, fOP_STATUS_SHORT_PREAMBLE_INUSED))
			Duration = 96;  // 72+24 preamble+plcp
		else
			Duration = 192; // 144+48 preamble+plcp

		Duration += (USHORT)((Size << 4) / RateIdTo500Kbps[Rate]);
		if ((Size << 4) % RateIdTo500Kbps[Rate])
			Duration ++;
	}
	else // OFDM rates
	{
		Duration = 20 + 6;      // 16+4 preamble+plcp + Signal Extension
		Duration += 4 * (USHORT)((11 + Size * 4) / RateIdTo500Kbps[Rate]);
		if ((11 + Size * 4) % RateIdTo500Kbps[Rate])
			Duration += 4;
	}

	return (USHORT)Duration;

}

/*
	========================================================================

	Routine	Description:
		Check the out going frame, if this is an DHCP or ARP datagram
	will be duplicate another frame at low data rate transmit.

	Arguments:
		pAd			Pointer	to our adapter
		pPacket		Pointer to outgoing Ndis frame

	Return Value:
		TRUE		To be duplicate at Low data rate transmit. (1mb)
		FALSE		Do nothing.

	IRQL = DISPATCH_LEVEL

	Note:

		MAC header + IP Header + UDP Header
		  14 Bytes    20 Bytes

		UDP Header
		00|01|02|03|04|05|06|07|08|09|10|11|12|13|14|15|
						Source Port
		16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31|
					Destination Port

		port 0x43 means Bootstrap Protocol, server.
		Port 0x44 means Bootstrap Protocol, client.

	========================================================================
*/

BOOLEAN RTMPCheckDHCPFrame(
	IN	PRTMP_ADAPTER	pAd,
	IN	PNDIS_PACKET	pPacket)
{
	PACKET_INFO		PacketInfo;
	ULONG			NumberOfBytesRead = 0;
	ULONG			CurrentOffset = 0;
	PVOID			pVirtualAddress = NULL;
	ULONG			NdisBufferLength;
	PUCHAR			pSrc;
	USHORT			Protocol;
	UCHAR			ByteOffset36 = 0;
	UCHAR			ByteOffset38 = 0;
	BOOLEAN			ReadFirstParm = TRUE;
#ifdef WIN_NDIS
	NdisQueryPacket(
		pPacket,							// Ndis packet
		&PacketInfo.PhysicalBufferCount,	// Physical buffer count
		&PacketInfo.BufferCount,			// Number of buffer descriptor
		&PacketInfo.pFirstBuffer,			// Pointer to first buffer descripotr
		&PacketInfo.TotalPacketLength);		// Ndis packet length

	// Query The First Buffer
	NDIS_QUERY_BUFFER(PacketInfo.pFirstBuffer, &pVirtualAddress, &NdisBufferLength);
#else
	RTMP_QueryPacketInfo(pPacket, &PacketInfo, (PUCHAR *)&pVirtualAddress, &NdisBufferLength);
#endif
	NumberOfBytesRead += NdisBufferLength;
	pSrc = (PUCHAR) pVirtualAddress;
	Protocol = *(pSrc + 12) * 256 + *(pSrc + 13);

	//
	// Check DHCP & BOOTP protocol
	//
	while (NumberOfBytesRead <= PacketInfo.TotalPacketLength)
	{
		if ((NumberOfBytesRead >= 35) && (ReadFirstParm == TRUE))
		{
			CurrentOffset = 35 - (NumberOfBytesRead - NdisBufferLength);
			ByteOffset36 = *(pSrc + CurrentOffset);
			ReadFirstParm = FALSE;
		}

		if (NumberOfBytesRead >= 37)
		{
			CurrentOffset = 37 - (NumberOfBytesRead - NdisBufferLength);
			ByteOffset38 = *(pSrc + CurrentOffset);
			//End of Read
			break;
		}
#ifdef WIN_NDIS
		if (PacketInfo.pFirstBuffer)
		{
			// Get next descriptor
			NdisGetNextBuffer(PacketInfo.pFirstBuffer, &PacketInfo.pFirstBuffer);
		}

		// Start scan through the rest buffer descriptors
		if (PacketInfo.pFirstBuffer)
		{
		    NDIS_QUERY_BUFFER(PacketInfo.pFirstBuffer, &pVirtualAddress, &NdisBufferLength);
			pSrc = (PUCHAR) pVirtualAddress;

			NumberOfBytesRead += NdisBufferLength;
		}
		else
			return FALSE;  //End of read.
#endif

	}

	// Check for DHCP & BOOTP protocol
	if ((ByteOffset36 != 0x44) || (ByteOffset38 != 0x43))
	{
		//
		// 2054 (hex 0806) for ARP datagrams
		// if this packet is not ARP datagrams, then do nothing
		// ARP datagrams will also be duplicate at 1mb broadcast frames
		//
		if (Protocol != 0x0806 )
			return FALSE;
	}

	return TRUE;
}

#if defined(ME_98) && (ME_98 == 1)
NDIS_STATUS IndicateQueueInit(
	IN PRTMP_ADAPTER pAd)
{
	PINDICATE_QUEUE	pQueue = &pAd->IndicateQueue;
	INT i;

	NdisAllocateSpinLock(&pQueue->Lock);

	pQueue->Num  = 0;
	pQueue->Head = 0;
	pQueue->Tail = 0;

	for (i = 0; i < MAX_LEN_OF_INDICATE_QUEUE; i++)
	{
		NdisZeroMemory(&pQueue->Entry[i], sizeof(INDICATE_QUEUE_ELEM));
	}

	RTMPInitTimer(pAd, &pQueue->IndicateTimer, GET_TIMER_FUNCTION(RTUSBNdicateCallBack), FALSE, pAd);


	return NDIS_STATUS_SUCCESS;
}

BOOLEAN IndicateEnqueue(
	IN	PRTMP_ADAPTER pAd,
	IN	ULONG	IndicateType,
	IN	PUCHAR	HeaderBuffer,
	IN	UINT	HeaderBufferSize,
	IN	PUCHAR	LookaheadBuffer,
	IN	UINT	LookaheadBufferSize,
	IN	UINT	PacketSize,
	IN	PNDIS_PACKET Packet,
	IN	NDIS_STATUS	Status)
{
	PINDICATE_QUEUE	pQueue = &pAd->IndicateQueue;
	INT Tail;

	if (IndicateQueueFull(pQueue))
	{
		DBGPRINT(RT_DEBUG_ERROR, ("IndicateEnqueue full.\n"));
		return FALSE;
	}

	NdisAcquireSpinLock(&(pQueue->Lock));
	Tail = pQueue->Tail;
	pQueue->Tail++;
	pQueue->Num++;
	if (pQueue->Tail == MAX_LEN_OF_INDICATE_QUEUE)
	{
		pQueue->Tail = 0;
	}

	pQueue->Entry[Tail].IndicateType = IndicateType;
	pQueue->Entry[Tail].HeaderBuffer = HeaderBuffer;
	pQueue->Entry[Tail].HeaderBufferSize = HeaderBufferSize;
	pQueue->Entry[Tail].LookaheadBuffer = LookaheadBuffer;
	pQueue->Entry[Tail].LookaheadBufferSize = LookaheadBufferSize;
	pQueue->Entry[Tail].PacketSize = PacketSize;
	pQueue->Entry[Tail].Packet = Packet;
	pQueue->Entry[Tail].Status = Status;

	NdisReleaseSpinLock(&(pQueue->Lock));
	DBGPRINT(RT_DEBUG_INFO, ("IndicateEnqueue, num=%d\n", pQueue->Num));

	return TRUE;
}

BOOLEAN IndicateQueueEmpty(
	IN INDICATE_QUEUE *Queue)
{
	BOOLEAN Ans;

	NdisAcquireSpinLock(&(Queue->Lock));
	Ans = (Queue->Num == 0);
	NdisReleaseSpinLock(&(Queue->Lock));

	return Ans;
}

BOOLEAN IndicateQueueFull(
	IN INDICATE_QUEUE *Queue)
{
	BOOLEAN Ans;

	NdisAcquireSpinLock(&(Queue->Lock));
	Ans = (Queue->Num == MAX_LEN_OF_INDICATE_QUEUE);
	NdisReleaseSpinLock(&(Queue->Lock));

	return Ans;
}

BOOLEAN IndicateDequeue(
	IN INDICATE_QUEUE *Queue,
	OUT INDICATE_QUEUE_ELEM **Elem)
{
	NdisAcquireSpinLock(&(Queue->Lock));

	*Elem = &(Queue->Entry[Queue->Head]);
	Queue->Num--;
	Queue->Head++;
	if (Queue->Head == MAX_LEN_OF_INDICATE_QUEUE)
	{
		Queue->Head = 0;
	}

	NdisReleaseSpinLock(&(Queue->Lock));
	DBGPRINT(RT_DEBUG_INFO, ("IndicateDequeue, num=%d\n",Queue->Num));

	return TRUE;
}

VOID IndicateQueueDestroy(
	IN PRTMP_ADAPTER pAd)
{
	PINDICATE_QUEUE		pQueue = &pAd->IndicateQueue;
	BOOLEAN				TimerCancelled;

	ASSERT(pQueue->Num == 0);

	RTMPCancelTimer(&pQueue->IndicateTimer, &TimerCancelled);
	NdisFreeSpinLock(&(pQueue->Lock));
}

VOID RTUSBNdicateCallBack(
	IN PVOID SystemSpecific1,
	IN PVOID FunctionContext,
	IN PVOID SystemSpecific2,
	IN PVOID SystemSpecific3)
{
	PRTMP_ADAPTER	pAd = (PRTMP_ADAPTER)FunctionContext;

	INDICATE_QUEUE_ELEM        *Elem = NULL;

	while (!IndicateQueueEmpty(&pAd->IndicateQueue))
	{
		if (IndicateDequeue(&pAd->IndicateQueue, &Elem))
		{
			// if dequeue success
			switch (Elem->IndicateType)
			{
				case INDICATE_RECEIVE_COMPLETE:
					NdisMEthIndicateReceive(pAd->AdapterHandle, (NDIS_HANDLE)pAd, (PVOID)Elem->HeaderBuffer,
							Elem->HeaderBufferSize, (PVOID)Elem->LookaheadBuffer, Elem->LookaheadBufferSize, Elem->PacketSize);
					NdisMEthIndicateReceiveComplete(pAd->AdapterHandle);
					break;
				case INDICATE_SEND_COMPLETE:
					NdisMSendComplete(pAd->AdapterHandle, Elem->Packet, Elem->Status);
					break;
				default:
					DBGPRINT(RT_DEBUG_TRACE, ("ERROR: Illegal IndicateType in INDICATE_QUEUE\n"));
					break;
			}
		}
	}

	NdisAcquireSpinLock(&pAd->IndicateTaskLock);
	pAd->IndicateRunning = FALSE;
	NdisReleaseSpinLock(&pAd->IndicateTaskLock);
}

VOID RTUSBIndicateDone(
	IN PRTMP_ADAPTER pAd)
{
	NdisAcquireSpinLock(&pAd->IndicateTaskLock);
	if (pAd->IndicateRunning)
	{
		NdisReleaseSpinLock(&pAd->IndicateTaskLock);
		return;
	}
	pAd->IndicateRunning = TRUE;
	NdisReleaseSpinLock(&pAd->IndicateTaskLock);

	RTMPSetTimer(pAd, &pAd->IndicateQueue.IndicateTimer, 0);
}
#endif

