/***********************************************************************/
/*                                                                     */
/*   Program:    rt_linux.c                                            */
/*   Created:    4/21/2006 1:17:38 PM                                  */
/*   Author:     Wu Xi-Kun                                             */
/*   Comments:   `description`                                         */
/*                                                                     */
/*---------------------------------------------------------------------*/
/*                                                                     */
/* History:                                                            */
/*    Revision 1.1 4/21/2006 1:17:38 PM  xsikun                        */
/*    Initial revision                                                 */
/*                                                                     */
/***********************************************************************/

#include <linux/module.h>
#include <linux/version.h>
#include <linux/kernel.h>

#include <linux/init.h>
#include <linux/string.h>
#include <linux/timer.h>
#include <linux/errno.h>
#include <linux/slab.h>
#include <linux/interrupt.h>
#include <linux/pci.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/ethtool.h>
#include <linux/wireless.h>
#include <linux/proc_fs.h>
#include <linux/delay.h>
#include <linux/if_arp.h>
#include <linux/ctype.h>

// load firmware
#define __KERNEL_SYSCALLS__
#include <linux/unistd.h>
#include <asm/uaccess.h>
// MACRO for linux usb
//
typedef struct urb *purbb_t;
typedef struct usb_ctrlrequest devctrlrequest;
#define PIRP		PVOID
#define PMDL		PVOID
#define NDIS_OID	UINT

//#define CONFIG_CKIP_SUPPORT

#undef __inline
#define __inline	   static inline

#define CHAR            signed char
#define INT             signed int
#define SHORT           signed short
#define UINT            unsigned int
#undef  ULONG
#define ULONG           unsigned int
#define USHORT          unsigned short
#define UCHAR           unsigned char


#define BOOLEAN         unsigned char
//#define LARGE_INTEGER s64

#define VOID            void
#define LONG            int
#define LONGLONG        s64
#define ULONGLONG       u64
typedef VOID            *PVOID;
typedef CHAR            *PCHAR;
typedef UCHAR           *PUCHAR;
typedef USHORT          *PUSHORT;
typedef LONG            *PLONG;
typedef ULONG           *PULONG;
#define PURB			purbb_t
#define OS_HZ			HZ

#define _WIN32_WINNT	0 /* adaptiv the MS-SDK driver to linux. */

typedef union _LARGE_INTEGER {
    struct {
        ULONG LowPart;
        LONG HighPart;
    };
    struct {
        ULONG LowPart;
        LONG HighPart;
    } u;
    s64 QuadPart;
} LARGE_INTEGER;


#define ETH_LENGTH_OF_ADDRESS	6

#define IN
#define OUT

#define TRUE        1
#define FALSE       0

#define NDIS_STATUS                             INT
#define NDIS_STATUS_SUCCESS                     0x00
#define NDIS_STATUS_FAILURE                     0x01
#define NDIS_STATUS_INVALID_DATA				0x02
#define NDIS_STATUS_RESOURCES                   0x03
#define NDIS_STATUS_MEDIA_DISCONNECT            0x04
#define NDIS_STATUS_MEDIA_CONNECT               0x05
#define NDIS_STATUS_RESET                       0x06
#define NDIS_STATUS_NOT_SUPPORTED				0x07
#define NDIS_STATUS_PENDING						0x08

#define NDIS_STATUS_INVALID_LENGTH				-EINVAL
#define NDIS_STATUS_ADAPTER_NOT_READY			-EINVAL
#define NDIS_STATUS_BUFFER_TOO_SHORT			-EINVAL
#define NDIS_STATUS_MULTICAST_FULL				-EINVAL

#define STATUS_SUCCESS		0x00
#define STATUS_UNSUCCESSFUL 0x01

#define DEVICE_VENDOR_REQUEST_OUT       0x40
#define DEVICE_VENDOR_REQUEST_IN        0xc0
#define INTERFACE_VENDOR_REQUEST_OUT    0x41
#define INTERFACE_VENDOR_REQUEST_IN     0xc1

#define USBD_TRANSFER_DIRECTION_OUT		0
#define USBD_TRANSFER_DIRECTION_IN		0
#define USBD_SHORT_TRANSFER_OK			0

// Dennis Lee just let it compile
//
// Ndis Packet Filter Bits (OID_GEN_CURRENT_PACKET_FILTER).
//
#define NDIS_PACKET_TYPE_DIRECTED               0x00000001
#define NDIS_PACKET_TYPE_MULTICAST              0x00000002
#define NDIS_PACKET_TYPE_ALL_MULTICAST          0x00000004
#define NDIS_PACKET_TYPE_BROADCAST              0x00000008
#define NDIS_PACKET_TYPE_SOURCE_ROUTING         0x00000010
#define NDIS_PACKET_TYPE_PROMISCUOUS            0x00000020
#define NDIS_PACKET_TYPE_SMT                    0x00000040
#define NDIS_PACKET_TYPE_ALL_LOCAL              0x00000080
#define NDIS_PACKET_TYPE_GROUP                  0x00001000
#define NDIS_PACKET_TYPE_ALL_FUNCTIONAL         0x00002000
#define NDIS_PACKET_TYPE_FUNCTIONAL             0x00004000
#define NDIS_PACKET_TYPE_MAC_FRAME              0x00008000

#define NdisMSetTimer				RTMPSetTimer
#define InterlockedIncrement 	 	atomic_inc
#define NdisInterlockedIncrement 	atomic_inc
#define InterlockedDecrement		atomic_dec
#define NdisInterlockedDecrement 	atomic_dec
#define NdisMSendComplete			RTMP_SendComplete
#define NdisMCancelTimer			RTMPCancelTimer
#define NdisFreeMemory(a, b, c) 	kfree((a))
#define NdisMSleep					RTMPusecDelay
#define NdisGetCurrentSystemTime	RTMP_GetCurrentSystemTime
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,7)
#define RTUSB_UNLINK_URB(urb)		usb_kill_urb(urb)
#else
#define RTUSB_UNLINK_URB(urb)		usb_unlink_urb(urb)
#endif

#define NT_SUCCESS(status)			(((status) > 0) ? (1):(0))

struct os_lock  {
	spinlock_t		lock;
	//unsigned long  	flags; // Dennis Lee remark
};

struct os_cookie {
	struct pci_dev 			*pci_dev;
	dma_addr_t		  		pAd_pa;

	struct tasklet_struct 	rx_done_task;
	struct tasklet_struct 	mgmt_dma_done_task;
	struct tasklet_struct 	ac0_dma_done_task;
	struct tasklet_struct 	ac1_dma_done_task;
	struct tasklet_struct 	ac2_dma_done_task;
	struct tasklet_struct 	ac3_dma_done_task;
	struct tasklet_struct 	hcca_dma_done_task;
	struct tasklet_struct	fifo_statistic_full_task;
	unsigned long			apd_pid; //802.1x daemon pid
	int 					ioctl_if;
};

typedef struct _VIRTUAL_ADAPTER
{
	struct net_device		*RtmpDev;
	struct net_device		*VirtualDev;
} VIRTUAL_ADAPTER, PVIRTUAL_ADAPTER;

#undef  ASSERT
#ifdef DBG
#define ASSERT(x)                                                               \
{                                                                               \
    if (!(x))                                                                   \
    {                                                                           \
        printk(KERN_WARNING __FILE__ ":%d assert " #x "failed\n", __LINE__);    \
    }                                                                           \
}
#else
#define ASSERT(x)                                                               \
{                                                                               \
    if (!(x))                                                                   \
    {                                                                           \
    }                                                                           \
}
#endif

typedef struct os_cookie	* POS_COOKIE;
typedef struct pci_dev 		* PPCI_DEV;
typedef struct usb_device	* PUSB_DEV;

typedef struct net_device	* PNET_DEV;
typedef void				* PNDIS_PACKET;
typedef char				NDIS_PACKET;
typedef PNDIS_PACKET		* PPNDIS_PACKET;
typedef	dma_addr_t			NDIS_PHYSICAL_ADDRESS;
typedef	dma_addr_t			* PNDIS_PHYSICAL_ADDRESS;
//typedef struct timer_list	RALINK_TIMER_STRUCT;
//typedef struct timer_list	* PRALINK_TIMER_STRUCT;
//typedef struct os_lock		NDIS_SPIN_LOCK; //Dennis Lee remark
typedef spinlock_t			NDIS_SPIN_LOCK;

typedef struct timer_list	NDIS_MINIPORT_TIMER;
typedef void				* NDIS_HANDLE;
typedef char 				* PNDIS_BUFFER;

typedef LONG		NTSTATUS;
typedef NTSTATUS	*PNTSTATUS;


void hex_dump(char *str, unsigned char *pSrcBufVA, unsigned int SrcBufLen);

dma_addr_t linux_pci_map_single(void *handle, void *ptr, size_t size, int direction);
void linux_pci_unmap_single(void *handle, dma_addr_t dma_addr, size_t size, int direction);


////////////////////////////////////////
// MOVE TO rtmp.h ?
/////////////////////////////////////////
#define PKTSRC_NDIS             0x7f
#define PKTSRC_DRIVER           0x0f
#define PRINT_MAC(addr)	\
	addr[0], addr[1], addr[2], addr[3], addr[4], addr[5]


#define RT2860_PCI_DEVICE_ID		0x0601
#if 0
/* This defines the direction arg to the DMA mapping routines. */
#define PCI_DMA_BIDIRECTIONAL	0
#define PCI_DMA_TODEVICE	1
#define PCI_DMA_FROMDEVICE	2
#define PCI_DMA_NONE		3
#endif

#define PCI_MAP_SINGLE(_handle, _ptr, _size, _dir) \
	linux_pci_map_single(_handle, _ptr, _size, _dir)

#define PCI_UNMAP_SINGLE(_handle, _ptr, _size, _dir) \
	linux_pci_unmap_single(_handle, _ptr, _size, _dir)


#define BEACON_FRAME_DMA_CACHE_WBACK(_ptr, _size)	\
	dma_cache_wback(_ptr, _size)


//////////////////////////////////////////
//
//////////////////////////////////////////


#define NdisMIndicateStatus(_w, _x, _y, _z)
#define NdisMIndicateStatusComplete(_w)
#define NdisMediaStateConnected		1
#define NdisMediaStateDisconnected	0
typedef unsigned int	NDIS_MEDIA_STATE;


#ifdef WIN_NDIS
typedef	NDIS_MINIPORT_TIMER	RTMP_OS_TIMER;
#else
typedef struct timer_list	RTMP_OS_TIMER;
#endif


typedef struct  _RALINK_TIMER_STRUCT    {
	BOOLEAN				Valid;			// Set to True when call RTMPInitTimer
    RTMP_OS_TIMER		TimerObj;       // Ndis Timer object
    ULONG               TimerValue;     // Timer value in milliseconds
    BOOLEAN             State;          // True if timer cancelled
    BOOLEAN             Repeat;         // True if periodic timer
	ULONG				cookie;			// os specific object
}   RALINK_TIMER_STRUCT, *PRALINK_TIMER_STRUCT;



//#define DBG	1

//
//  MACRO for debugging information
//

#ifdef DBG
extern ULONG    RTDebugLevel;

#define DBGPRINT_RAW(Level, Fmt)    \
{                                   \
    if (Level <= RTDebugLevel)      \
    {                               \
        printk Fmt;               \
    }                               \
}

#define DBGPRINT(Level, Fmt)    DBGPRINT_RAW(Level, Fmt)


#define DBGPRINT_ERR(Fmt)           \
{                                   \
    printk("ERROR!!! ");          \
    printk Fmt;                  \
}

#define DBGPRINT_S(Status, Fmt)		\
{									\
	printk Fmt;					\
}


#else
#define DBGPRINT(Level, Fmt)
#define DBGPRINT_RAW(Level, Fmt)
#define DBGPRINT_S(Status, Fmt)
#define DBGPRINT_ERR(Fmt)
#endif


//
//  spin_lock enhanced for Nested spin lock
//
#define NdisAllocateSpinLock(__lock)      \
{                                       \
    spin_lock_init(__lock);               \
}

#define NdisFreeSpinLock(lock)          \
{                                       \
}


#define RTMP_SEM_LOCK(__lock)					\
{												\
	spin_lock_bh((__lock));				\
}

#define RTMP_SEM_UNLOCK(__lock)					\
{												\
	spin_unlock_bh((__lock));				\
}

#define RTMP_SPIN_LOCK(lock, flagg)	\
{											\
	spin_lock_irqsave(lock, flagg);			\
}

#define RTMP_SPIN_UNLOCK(lock, flagg)	\
{											\
	spin_unlock_irqrestore(lock, flagg);	\
}

extern spinlock_t	rtmp_irq_lock;

#define LOCAL_IRQ_LOCK(__irqflag)					\
{													\
	spin_lock_irqsave(&rtmp_irq_lock, (__irqflag));	\
}

#define LOCAL_IRQ_UNLOCK(__irqflag)						\
{														\
	spin_unlock_irqrestore(&rtmp_irq_lock, ((unsigned long)__irqflag));	\
}


#if 1
//Patch for ASIC turst read/write bug, needs to remove after metel fix
#define RTMP_IO_READ32(_A, _R, _pV)								\
{																\
	(*_pV = readl((void *)((_A)->CSRBaseAddress + MAC_CSR0)));			\
	(*_pV = readl((void *)((_A)->CSRBaseAddress + (_R))));					\
}
#define RTMP_IO_READ8(_A, _R, _pV)								\
{																\
	(*_pV = readl((void *)((_A)->CSRBaseAddress + MAC_CSR0)));			\
	(*_pV = readb((void *)((_A)->CSRBaseAddress + (_R))));				\
}
#define RTMP_IO_WRITE32(_A, _R, _V)												\
{																				\
	ULONG	Val;																\
	Val = readl((void *)((_A)->CSRBaseAddress + MAC_CSR0));			\
	writel(_V, (void *)((_A)->CSRBaseAddress + (_R)));								\
}
#define RTMP_IO_WRITE8(_A, _R, _V)												\
{																				\
	ULONG	Val;																\
	Val = readl((void *)((_A)->CSRBaseAddress + MAC_CSR0));			\
	writeb((_V), (PUCHAR)((_A)->CSRBaseAddress + (_R)));		\
}
#define RTMP_IO_WRITE16(_A, _R, _V)												\
{																				\
	ULONG	Val;																\
	Val = readl((void *)((_A)->CSRBaseAddress + MAC_CSR0));			\
	writew((_V), (PUSHORT)((_A)->CSRBaseAddress + (_R)));	\
}
#else
//Patch for ASIC turst read/write bug, needs to remove after metel fix
#define RTMP_IO_READ32(_A, _R, _pV)								\
{																\
}
#define RTMP_IO_READ8(_A, _R, _pV)								\
{																\
}
#define RTMP_IO_WRITE32(_A, _R, _V)												\
{																				\
	printk("_V = %x\n", _V);													\
}
#define RTMP_IO_WRITE8(_A, _R, _V)												\
{																				\
	printk("_V = %x\n", _V);													\
}
#define RTMP_IO_WRITE16(_A, _R, _V)												\
{																				\
}
#endif


#ifdef WIN_NDIS

/* Modified by Wu Xi-Kun 4/21/2006 */
typedef void (*TIMER_FUNCTION)(
	IN  PVOID   SystemSpecific1,
	IN  PVOID   FunctionContext,
	IN  PVOID   SystemSpecific2,
	IN  PVOID   SystemSpecific3);

#define RTMP_GREKEYPeriodicExec				GREKEYPeriodicExec
#define RTMP_CMTimerExec					CMTimerExec
#define RTMP_APQuickResponeForRateUpExec	APQuickResponeForRateUpExec

#else  // WIN_NDIS //

/* Modified by Wu Xi-Kun 4/21/2006 */
typedef void (*TIMER_FUNCTION)(unsigned long);


#define RTMP_IndicateMediaState()
#define COPY_MAC_ADDR(Addr1, Addr2)             memcpy((Addr1), (Addr2), MAC_ADDR_LEN)

//#define MlmeAllocateMemory(_pAd, _ppVA) os_alloc_mem(_pAd, _ppVA, MGMT_DMA_BUFFER_SIZE)
//#define MlmeFreeMemory(_pAd, _pVA)     os_free_mem(_pAd, _pVA)

#define BUILD_TIMER_FUNCTION(_func)												\
void linux_##_func(unsigned long data)											\
{																				\
	PRALINK_TIMER_STRUCT	pTimer = (PRALINK_TIMER_STRUCT) data;				\
																				\
	_func(NULL, (PVOID) pTimer->cookie, NULL, NULL); 							\
	if (pTimer->Repeat)															\
		RTMP_OS_Add_Timer(&pTimer->TimerObj, pTimer->TimerValue);				\
}

#define DECLARE_TIMER_FUNCTION(_func)			\
void linux_##_func(unsigned long data)

#define GET_TIMER_FUNCTION(_func)				\
		linux_##_func


DECLARE_TIMER_FUNCTION(MlmePeriodicExec);
DECLARE_TIMER_FUNCTION(MlmeTBTTExec);
DECLARE_TIMER_FUNCTION(AsicRxAntEvalTimeout);

DECLARE_TIMER_FUNCTION(GREKEYPeriodicExec);
DECLARE_TIMER_FUNCTION(CMTimerExec);
DECLARE_TIMER_FUNCTION(APQuickResponeForRateUpExec);
DECLARE_TIMER_FUNCTION(WPARetryExec);
DECLARE_TIMER_FUNCTION(DlsTimeout);
DECLARE_TIMER_FUNCTION(EnqueueStartForPSKExec);

DECLARE_TIMER_FUNCTION(BeaconTimeout);
DECLARE_TIMER_FUNCTION(ScanTimeout);
DECLARE_TIMER_FUNCTION(AuthTimeout);
DECLARE_TIMER_FUNCTION(AssocTimeout);
DECLARE_TIMER_FUNCTION(ReassocTimeout);
DECLARE_TIMER_FUNCTION(DisassocTimeout);
DECLARE_TIMER_FUNCTION(LinkDownExec);
DECLARE_TIMER_FUNCTION(LeapAuthTimeout);
DECLARE_TIMER_FUNCTION(StaQuickResponeForRateUpExec);
#endif // WIN_NDIS //

void RTMP_GetCurrentSystemTime(LARGE_INTEGER *time);


/*
 * packet helper
 * 	- convert internal rt packet to os packet or
 *             os packet to rt packet
 */
#define RTPKT_TO_OSPKT(_p)		((struct sk_buff *)(_p))
#define OSPKT_TO_RTPKT(_p)		((PNDIS_PACKET)(_p))

#define GET_OS_PKT_DATAPTR(_pkt) \
		(RTPKT_TO_OSPKT(_pkt)->data)

#define GET_OS_PKT_LEN(_pkt) \
		(RTPKT_TO_OSPKT(_pkt)->len)

#define GET_OS_PKT_TYPE(_pkt) \
		(RTPKT_TO_OSPKT(_pkt))

#define GET_OS_PKT_NEXT(_pkt) \
		(RTPKT_TO_OSPKT(_pkt)->next)


/* statistics counter */
#define STATS_INC_RX_PACKETS(_pAd, _dev)
#define STATS_INC_TX_PACKETS(_pAd, _dev)

#define STATS_INC_RX_BYTESS(_pAd, _dev, len)
#define STATS_INC_TX_BYTESS(_pAd, _dev, len)

#define STATS_INC_RX_ERRORS(_pAd, _dev)
#define STATS_INC_TX_ERRORS(_pAd, _dev)

#define STATS_INC_RX_DROPPED(_pAd, _dev)
#define STATS_INC_TX_DROPPED(_pAd, _dev)




//   check DDK NDIS_PACKET data structure and find out only MiniportReservedEx[0..7] can be used by our driver without
//   ambiguity. Fields after pPacket->MiniportReservedEx[8] may be used by other wrapper layer thus crashes the driver
//
#define RTMP_GET_PACKET_MR(_p)			(RTPKT_TO_OSPKT(_p))

// b0-b3 as User Priority
#define RTMP_SET_PACKET_UP(_p, _prio)			(RTPKT_TO_OSPKT(_p)->cb[0] = _prio)
#define RTMP_GET_PACKET_UP(_p)					(RTPKT_TO_OSPKT(_p)->cb[0])

// b4-b7 as fragment #
#define RTMP_SET_PACKET_FRAGMENTS(_p, _num)		(RTPKT_TO_OSPKT(_p)->cb[1] = _num)
#define RTMP_GET_PACKET_FRAGMENTS(_p)			(RTPKT_TO_OSPKT(_p)->cb[1])

// 0x0 ~0x7f: TX to AP's own BSS which has the specified AID. if AID>127, set bit 7 in RTMP_SET_PACKET_EMACTAB too.
//(this value also as MAC(on-chip WCID) table index)
// 0x80~0xff: TX to a WDS link. b0~6: WDS index
#define RTMP_SET_PACKET_WDS(_p, _wdsidx)		(RTPKT_TO_OSPKT(_p)->cb[2] = _wdsidx)
#define RTMP_GET_PACKET_WDS(_p)          		(RTPKT_TO_OSPKT(_p)->cb[2])

// 0xff: PKTSRC_NDIS, others: local TX buffer index. This value affects how to a packet
#define RTMP_SET_PACKET_SOURCE(_p, _pktsrc)		(RTPKT_TO_OSPKT(_p)->cb[3] = _pktsrc)
#define RTMP_GET_PACKET_SOURCE(_p)       		(RTPKT_TO_OSPKT(_p)->cb[3])

// b0~2: RTS/CTS-to-self protection method
#define RTMP_SET_PACKET_RTS(_p, _num)      		(RTPKT_TO_OSPKT(_p)->cb[4] = _num)
#define RTMP_GET_PACKET_RTS(_p)          		(RTPKT_TO_OSPKT(_p)->cb[4])
// b7: see RTMP_S(G)ET_PACKET_EMACTAB

// b3~7: TX rate index
#define RTMP_SET_PACKET_TXRATE(_p, _rate)		(RTPKT_TO_OSPKT(_p)->cb[5] = _rate)
#define RTMP_GET_PACKET_TXRATE(_p)		  		(RTPKT_TO_OSPKT(_p)->cb[5])

#define RTMP_SET_PACKET_MOREDATA(_p, _morebit)	(RTPKT_TO_OSPKT(_p)->cb[6] = _morebit)
#define RTMP_GET_PACKET_MOREDATA(_p)			(RTPKT_TO_OSPKT(_p)->cb[6])


#define NDIS_SET_PACKET_STATUS(_p, _status)


#define GET_SG_LIST_FROM_PACKET(_p, _sc)	\
    rt_get_sg_list_from_packet(_p, _sc)

#define NdisMoveMemory(Destination, Source, Length) memmove(Destination, Source, Length)
#define NdisZeroMemory(Destination, Length)         memset(Destination, 0, Length)
#define NdisFillMemory(Destination, Length, Fill)   memset(Destination, Fill, Length)
#define NdisEqualMemory(Source1, Source2, Length)   (!memcmp(Source1, Source2, Length))
#define RTMPEqualMemory(Source1, Source2, Length)	(!memcmp(Source1, Source2, Length))


#define RTMP_INC_REF(_A)		0
#define RTMP_DEC_REF(_A)		0
#define RTMP_GET_REF(_A)		0



/*
 * ULONG
 * RTMP_GetPhysicalAddressLow(
 *   IN NDIS_PHYSICAL_ADDRESS  PhysicalAddress);
 */
#define RTMP_GetPhysicalAddressLow(PhysicalAddress)		(PhysicalAddress)

/*
 * ULONG
 * RTMP_GetPhysicalAddressHigh(
 *   IN NDIS_PHYSICAL_ADDRESS  PhysicalAddress);
 */
#define RTMP_GetPhysicalAddressHigh(PhysicalAddress)		(0)

/*
 * VOID
 * RTMP_SetPhysicalAddressLow(
 *   IN NDIS_PHYSICAL_ADDRESS  PhysicalAddress,
 *   IN ULONG  Value);
 */
#define RTMP_SetPhysicalAddressLow(PhysicalAddress, Value)	\
			PhysicalAddress = Value;

/*
 * VOID
 * RTMP_SetPhysicalAddressHigh(
 *   IN NDIS_PHYSICAL_ADDRESS  PhysicalAddress,
 *   IN ULONG  Value);
 */
#define RTMP_SetPhysicalAddressHigh(PhysicalAddress, Value)


//CONTAINING_RECORD(pEntry, NDIS_PACKET, MiniportReservedEx);
#define QUEUE_ENTRY_TO_PACKET(pEntry) \
	(PNDIS_PACKET)(pEntry)

#define PACKET_TO_QUEUE_ENTRY(pPacket) \
	(PQUEUE_ENTRY)(pPacket)


#ifndef CONTAINING_RECORD
#define CONTAINING_RECORD(address, type, field)			\
((type *)((PCHAR)(address) - offsetof(type, field)))
#endif


#define RELEASE_NDIS_PACKET(_pAd, _pPacket, _Status)                    \
{                                                                       \
    if (RTMP_GET_PACKET_SOURCE(_pPacket) == PKTSRC_NDIS)                \
    {                                                                   \
		RTMPFreeNdisPacket(_pAd, _pPacket);                             \
        _pAd->RalinkCounters.PendingNdisPacketCount --;                 \
    }                                                                   \
    else                                                                \
        RTMPFreeNdisPacket(_pAd, _pPacket);                             \
}


#define SWITCH_PhyAB(_pAA, _pBB)    \
{                                                                           \
    ULONG	AABasePaHigh;                           \
    ULONG	AABasePaLow;                           \
    ULONG	BBBasePaHigh;                           \
    ULONG	BBBasePaLow;                           \
    BBBasePaHigh = RTMP_GetPhysicalAddressHigh(_pBB);                                                 \
    BBBasePaLow = RTMP_GetPhysicalAddressLow(_pBB);                                                 \
    AABasePaHigh = RTMP_GetPhysicalAddressHigh(_pAA);                                                 \
    AABasePaLow = RTMP_GetPhysicalAddressLow(_pAA);                                                 \
    RTMP_SetPhysicalAddressHigh(_pAA, BBBasePaHigh);                                                 \
    RTMP_SetPhysicalAddressLow(_pAA, BBBasePaLow);                                                 \
    RTMP_SetPhysicalAddressHigh(_pBB, AABasePaHigh);                                                 \
    RTMP_SetPhysicalAddressLow(_pBB, AABasePaLow);                                                 \
}


#define NdisWriteErrorLogEntry(_a, _b, _c, _d)
#define NdisMAllocateMapRegisters(_a, _b, _c, _d, _e)		NDIS_STATUS_SUCCESS


#define NdisAcquireSpinLock		RTMP_SPIN_LOCK
#define NdisReleaseSpinLock		RTMP_SPIN_UNLOCK

static inline void NdisGetSystemUpTime(ULONG *time)
{
	*time = jiffies;
}

//pPacket = CONTAINING_RECORD(pEntry, NDIS_PACKET, MiniportReservedEx);
#define QUEUE_ENTRY_TO_PKT(pEntry) \
		((PNDIS_PACKET) (pEntry))


// macro definitions and prototypes of completion funuc.
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)
#define RTUSBBulkOutDataPacketComplete(purb, pt_regs)    RTUSBBulkOutDataPacketComplete(purb)
#define RTUSBBulkOutNullFrameComplete(pUrb, pt_regs)     RTUSBBulkOutNullFrameComplete(pUrb)
#define RTUSBBulkOutRTSFrameComplete(pUrb, pt_regs)      RTUSBBulkOutRTSFrameComplete(pUrb)
#define RTUSBBulkOutMLMEPacketComplete(pUrb, pt_regs)    RTUSBBulkOutMLMEPacketComplete(pUrb)
#define RTUSBBulkOutPsPollComplete(pUrb, pt_regs)        RTUSBBulkOutPsPollComplete(pUrb)
#define RTUSBBulkRxComplete(pUrb, pt_regs)               RTUSBBulkRxComplete(pUrb)
#endif
VOID RTUSBBulkOutDataPacketComplete(purbb_t purb, struct pt_regs *pt_regs);
VOID RTUSBBulkOutNullFrameComplete(purbb_t pUrb, struct pt_regs *pt_regs);
VOID RTUSBBulkOutRTSFrameComplete(purbb_t pUrb, struct pt_regs *pt_regs);
VOID RTUSBBulkOutMLMEPacketComplete(purbb_t pUrb, struct pt_regs *pt_regs);
VOID RTUSBBulkOutPsPollComplete(purbb_t pUrb, struct pt_regs *pt_regs);
VOID RTUSBBulkRxComplete(purbb_t pUrb, struct pt_regs *pt_regs);

ULONG RTMPConvertToMiniSecond(
    IN LARGE_INTEGER Previous,
    IN LARGE_INTEGER Current);

#define RT73_USB_DEVICES { \
 {USB_DEVICE(0x148f,0x2573)}, /* Ralink */      \
 {USB_DEVICE(0x148f,0x2671)}, /* Ralink */      \
 {USB_DEVICE(0x18e8,0x6196)}, /* Qcom */        \
 {USB_DEVICE(0x18e8,0x6229)}, /* Qcom */        \
 {USB_DEVICE(0x1044,0x8008)}, /* Gigabyte */    \
 {USB_DEVICE(0x14b2,0x3c22)}, /* Conceptronic */    \
 {USB_DEVICE(0x0db0,0x6877)}, /* MSI */         \
 {USB_DEVICE(0x0db0,0xa874)}, /* MSI */         \
 {USB_DEVICE(0x0db0,0xa861)}, /* MSI */         \
 {USB_DEVICE(0x07b8,0xb21d)}, /* AboCom */      \
 {USB_DEVICE(0x0769,0x31f3)}, /* Surecom */     \
 {USB_DEVICE(0x1472,0x0009)}, /* Huawei-3Com */     \
 {USB_DEVICE(0x1371,0x9022)}, /* CNet */        \
 {USB_DEVICE(0x1371,0x9032)}, /* CNet */        \
 {USB_DEVICE(0x1631,0xc019)}, /* Billionton */  \
 {USB_DEVICE(0x1044,0x800a)}, /* Gigabyte */	\
 {USB_DEVICE(0x1690,0x0722)}, /* Askey */		\
 {USB_DEVICE(0x0df6,0x9712)}, /* Sitecom WL-113 v1 002 */	\
 {USB_DEVICE(0,0)}} /* end marker */


INT rt73_ioctl(
	IN	struct net_device	*net_dev,
	IN	OUT	struct ifreq	*rq,
	IN	INT					cmd);

VOID RTMPusecDelay(
	IN	ULONG	usec);


// for vendor-specific control operations
#define CONTROL_TIMEOUT_MS		(1000)	 /* msec */  // lengthen timeout for loading firmware
#define CONTROL_TIMEOUT_JIFFIES ((CONTROL_TIMEOUT_MS * HZ)/1000)

#define RTUSBMlmeUp(pAd)	        \
{								    \
	if(pAd->MLMEThr_pid>0)		    \
        up(&(pAd->mlme_semaphore)); \
}

#define RTUSBCMDUp(pAd)	                \
{									    \
	if(pAd->RTUSBCmdThr_pid>0)		    \
	    up(&(pAd->RTUSBCmd_semaphore)); \
}


static inline NDIS_STATUS RTMPAllocateMemory(
	OUT PVOID *ptr,
	IN size_t size)
{
	*ptr = kmalloc(size, GFP_ATOMIC);
	if(*ptr)
		return NDIS_STATUS_SUCCESS;
	else
		return NDIS_STATUS_RESOURCES;
}


