/****************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ****************************************************************************

     Module Name:
     sync.c

     Abstract:
     Synchronization state machine related services

     Revision History:
     Who         When          What
     --------    ----------    ----------------------------------------------
     John Chang  08-04-2003    created for 11g soft-AP

 */

#include "rt_config.h"

/*
	==========================================================================
	Description:
		The sync state machine,
	Parameters:
		Sm - pointer to the state machine
	Note:
		the state machine looks like the following

							AP_SYNC_IDLE
	APMT2_PEER_PROBE_REQ	peer_probe_req_action
	==========================================================================
 */
VOID APSyncStateMachineInit(
	IN PRTMP_ADAPTER pAd,
	IN STATE_MACHINE *Sm,
	OUT STATE_MACHINE_FUNC Trans[])
{
	StateMachineInit(Sm, Trans, AP_MAX_SYNC_STATE, AP_MAX_SYNC_MSG, (STATE_MACHINE_FUNC)Drop, AP_SYNC_IDLE, AP_SYNC_MACHINE_BASE);

	StateMachineSetAction(Sm, AP_SYNC_IDLE, APMT2_PEER_PROBE_REQ, (STATE_MACHINE_FUNC)APPeerProbeReqAction);
	StateMachineSetAction(Sm, AP_SYNC_IDLE, APMT2_PEER_BEACON, (STATE_MACHINE_FUNC)APPeerBeaconAction);
}

/*
	==========================================================================
	Description:
		Process the received ProbeRequest from clients
	Parameters:
		Elem - msg containing the ProbeReq frame
	==========================================================================
 */
VOID APPeerProbeReqAction(
	IN PRTMP_ADAPTER pAd,
	IN MLME_QUEUE_ELEM *Elem)
{
	UCHAR         Addr2[MAC_ADDR_LEN];
	CHAR          Ssid[MAX_LEN_OF_SSID];
	UCHAR         SsidLen; //, Rates[MAX_LEN_OF_SUPPORTED_RATES], RatesLen;
	HEADER_802_11 ProbeRspHdr;
	NDIS_STATUS   NStatus;
	PUCHAR        pOutBuffer = NULL;
	ULONG         FrameLen = 0, TmpLen;
	LARGE_INTEGER FakeTimestamp;
    UCHAR         DsLen = 1;
//	UCHAR         DsLen = 1, IbssLen = 2, TimLen=1,
//				  BitmapControl=0, VirtualBitmap=0;
	UCHAR   ErpIeLen = 1;
//	UCHAR   RSN_IE[22]={ 0x00,0x50,0xf2,0x01,0x01,0x00,0x00,0x50,0xf2,0x02,0x01,0x00,0x00,0x50,0xf2,0x02,0x01,0x00,0x00,0x50,0xf2,0x02};
	UCHAR   RSNIe=IE_WPA, RSNIe2=IE_WPA2; //, RSN_Len=22;

	if (! APPeerProbeReqSanity(pAd, Elem->Msg, Elem->MsgLen, Addr2, Ssid, &SsidLen)) //, Rates, &RatesLen))
		return;

	if (((SsidLen == 0) && (! pAd->ApCfg.bHideSsid)) ||
		((SsidLen == pAd->CommonCfg.SsidLen) && NdisEqualMemory(Ssid, pAd->CommonCfg.Ssid, (ULONG) SsidLen)))
	{
		// allocate and send out ProbeRsp frame
		NStatus = MlmeAllocateMemory(pAd, (PVOID)&pOutBuffer);
		if (NStatus != NDIS_STATUS_SUCCESS)
			return;

		DBGPRINT(RT_DEBUG_TRACE, ("SYNC - Send PROBE_RSP to %02x:%02x:%02x:%02x:%02x:%02x...\n", Addr2[0],Addr2[1],Addr2[2],Addr2[3],Addr2[4],Addr2[5] ));

		MgtMacHeaderInit(pAd, &ProbeRspHdr, SUBTYPE_PROBE_RSP, 0, Addr2, pAd->CommonCfg.Bssid);

		 if ((pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA) ||
			(pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPAPSK))
			RSNIe = IE_WPA;
		else if ((pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA2) ||
			(pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA2PSK))
			RSNIe = IE_WPA2;

		MakeOutgoingFrame(pOutBuffer,                 &FrameLen,
						  sizeof(HEADER_802_11),      &ProbeRspHdr,
						  TIMESTAMP_LEN,              &FakeTimestamp,
						  2,                          &pAd->CommonCfg.BeaconPeriod,
						  2,                          &pAd->ApCfg.CapabilityInfo,
						  1,                          &SsidIe,
						  1,                          &pAd->CommonCfg.SsidLen,
						  pAd->CommonCfg.SsidLen,     pAd->CommonCfg.Ssid,
						  1,                          &SupRateIe,
						  1,                          &pAd->CommonCfg.SupRateLen,
						  pAd->CommonCfg.SupRateLen,      pAd->CommonCfg.SupRate,
						  1,                          &DsIe,
						  1,                          &DsLen,
						  1,                          &pAd->CommonCfg.Channel,
						  END_OF_ARGS);

		if (pAd->CommonCfg.ExtRateLen)
		{
			MakeOutgoingFrame(pOutBuffer+FrameLen,      &TmpLen,
							  1,                        &ErpIe,
							  1,                        &ErpIeLen,
							  1,                        &pAd->ApCfg.ErpIeContent,
							  1,                        &ExtRateIe,
							  1,                        &pAd->CommonCfg.ExtRateLen,
							  pAd->CommonCfg.ExtRateLen,    pAd->CommonCfg.ExtRate,
							  END_OF_ARGS);
			FrameLen += TmpLen;
		}

		// Append RSN_IE when  WPA OR WPAPSK,
		if (pAd->CommonCfg.AuthMode < Ndis802_11AuthModeWPA)
			; // enough information
		else if ((pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA1WPA2) ||
			(pAd->CommonCfg.AuthMode == Ndis802_11AuthModeWPA1PSKWPA2PSK))
		{
			MakeOutgoingFrame(pOutBuffer+FrameLen,      &TmpLen,
							  1,                        &RSNIe,
							  1,                        &pAd->ApCfg.RSNIE_Len[0],
							  pAd->ApCfg.RSNIE_Len[0],  pAd->ApCfg.RSN_IE[0],
							  1,                        &RSNIe2,
							  1,                        &pAd->ApCfg.RSNIE_Len[1],
							  pAd->ApCfg.RSNIE_Len[1],  pAd->ApCfg.RSN_IE[1],
							  END_OF_ARGS);
			FrameLen += TmpLen;
		}
		else
		{
			MakeOutgoingFrame(pOutBuffer+FrameLen,      &TmpLen,
							  1,                        &RSNIe,
							  1,                        &pAd->ApCfg.RSNIE_Len[0],
							  pAd->ApCfg.RSNIE_Len[0],  pAd->ApCfg.RSN_IE[0],
							  END_OF_ARGS);
			FrameLen += TmpLen;
		}

		// add WMM IE here
		if (pAd->CommonCfg.bWmmCapable)
		{
			UCHAR i;
			UCHAR WmeParmIe[26] = {IE_VENDOR_SPECIFIC, 24, 0x00, 0x50, 0xf2, 0x02, 0x01, 0x01, 0, 0};
			WmeParmIe[8] = pAd->ApCfg.BssEdcaParm.EdcaUpdateCount & 0x0f;
			for (i=QID_AC_BE; i<=QID_AC_VO; i++)
			{
				WmeParmIe[10+ (i*4)] = (i << 5)                                         +     // b5-6 is ACI
									   ((UCHAR)pAd->ApCfg.BssEdcaParm.bACM[i] << 4)     +     // b4 is ACM
									   (pAd->ApCfg.BssEdcaParm.Aifsn[i] & 0x0f);              // b0-3 is AIFSN
				WmeParmIe[11+ (i*4)] = (pAd->ApCfg.BssEdcaParm.Cwmax[i] << 4)           +     // b5-8 is CWMAX
									   (pAd->ApCfg.BssEdcaParm.Cwmin[i] & 0x0f);              // b0-3 is CWMIN
				WmeParmIe[12+ (i*4)] = (UCHAR)(pAd->ApCfg.BssEdcaParm.Txop[i] & 0xff);        // low byte of TXOP
				WmeParmIe[13+ (i*4)] = (UCHAR)(pAd->ApCfg.BssEdcaParm.Txop[i] >> 8);          // high byte of TXOP
			}

			MakeOutgoingFrame(pOutBuffer+FrameLen,      &TmpLen,
							  26,                       WmeParmIe,
							  END_OF_ARGS);
			FrameLen += TmpLen;
		}

		// add Ralink-specific IE here - Byte0.b0=1 for aggregation, Byte0.b1=1 for piggy-back
		if (pAd->CommonCfg.bAggregationCapable)
		{
			UCHAR RalinkSpecificIe[9] = {IE_VENDOR_SPECIFIC, 7, 0x00, 0x0c, 0x43, 0x01, 0x00, 0x00, 0x00};
			MakeOutgoingFrame(pOutBuffer+FrameLen,       &TmpLen,
								  9,                         RalinkSpecificIe,
								  END_OF_ARGS);
			FrameLen += TmpLen;

		}

		// add Channel switch announcement IE
		if ((pAd->CommonCfg.PhyMode == PHY_11A) && (pAd->CommonCfg.bIEEE80211H == 1) && (pAd->CommonCfg.RadarDetect.RDMode == RD_SWITCHING_MODE))
		{
			UCHAR CSAIe=IE_CHANNEL_SWITCH_ANNOUNCEMENT;
			UCHAR CSALen=3;
			UCHAR CSAMode=1;

			MakeOutgoingFrame(pOutBuffer+FrameLen,      &TmpLen,
							  1,                        &CSAIe,
							  1,                        &CSALen,
							  1,                        &CSAMode,
							  1,                        &pAd->CommonCfg.Channel,
							  1,                        &pAd->CommonCfg.RadarDetect.CSCount,
							  END_OF_ARGS);
			FrameLen += TmpLen;
		}

		MiniportMMRequest(pAd, pOutBuffer, FrameLen);
	}
}

/*
	==========================================================================
	Description:
		parse the received BEACON

	NOTE:
		The only thing AP cares about received BEACON frames is to decide
		if there's any overlapped legacy BSS condition (OLBC).
		If OLBC happened, this AP should set the ERP->Use_Protection bit in its
		outgoing BEACON. The result is to tell all its clients to use RTS/CTS
		or CTS-to-self protection to protect B/G mixed traffic
	==========================================================================
 */
VOID APPeerBeaconAction(
	IN PRTMP_ADAPTER pAd,
	IN MLME_QUEUE_ELEM *Elem)
{
	UCHAR         Bssid[MAC_ADDR_LEN], Addr2[MAC_ADDR_LEN];
	CHAR          Ssid[MAX_LEN_OF_SSID];
	UCHAR         SsidLen, BssType, Channel, Rates[MAX_LEN_OF_SUPPORTED_RATES];
	UCHAR         RatesLen; //, DtimCount=0, DtimPeriod=0, BcastFlag=0;
	USHORT        CapabilityInfo, BeaconPeriod;
	LARGE_INTEGER TimeStamp;
	BOOLEAN       ExtendedRateIeExist;
	BOOLEAN       LegacyBssExist;
	UCHAR         Erp;

	if (APPeerBeaconAndProbeRspSanity(pAd,
								Elem->Msg,
								Elem->MsgLen,
								Addr2,
								Bssid,
								Ssid,
								&SsidLen,
								&BssType,
								&BeaconPeriod,
								&Channel,
								&TimeStamp,
								&CapabilityInfo,
								Rates,
								&RatesLen,
								&ExtendedRateIeExist,
								&Erp))
	{
		if (Channel == pAd->ApCfg.AutoChannel_Channel)
		{
			CHAR RealRssi = ConvertToRssi(pAd, Elem->Rssi, RSSI_NO_1);
			// record the max RSSI of any received BEACON frames. APStartUp phase will
			// use this information to help select a less interference channel
			// TODO: 2005-03-04 this is a dirty patch. we should change all RSSI related variables to UNSIGNED SHORT for easy reading and calculation
			if ((RealRssi + pAd->BbpRssiToDbmDelta) > pAd->ApCfg.AutoChannel_MaxRssi)
				pAd->ApCfg.AutoChannel_MaxRssi = RealRssi + pAd->BbpRssiToDbmDelta;
		}

		// ignore BEACON not in this channel
		if (Channel != pAd->CommonCfg.Channel)
			return;

		if ((Erp & 0x01) || (RatesLen <= 4))
			LegacyBssExist = TRUE;
		else
			LegacyBssExist = FALSE;

        if (LegacyBssExist)
		{
 			pAd->ApCfg.LastOLBCDetectTime = pAd->Mlme.Now64;

			DBGPRINT(RT_DEBUG_WARN, ("%02x:%02x:%02x:%02x:%02x:%02x is a legacy BSS (rate# =%d, ERP=%d), set Use_Protection bit\n",
				Bssid[0], Bssid[1], Bssid[2], Bssid[3], Bssid[4], Bssid[5], RatesLen, Erp));
		}
	}
	// sanity check fail, ignore this frame
}

