/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

    Module Name:
    ap_info.c

    Abstract:
    Miniport Query information related subroutines

    Revision History:
    Who         When          What
    --------    ----------    ----------------------------------------------
    Paul Lin    08-10-2002    created
    John Chang  01-25-2003    modified as Access Point

*/
#include    "rt_config.h"

//
// List of supported OID for this driver.  This list must be in ascending
// sorted order, so be careful when adding new OIDs.
//
#ifdef WIN_NDIS
NDIS_OID    APSupportedOids[] =
{
	OID_GEN_SUPPORTED_LIST,
	OID_GEN_HARDWARE_STATUS,
	OID_GEN_MEDIA_SUPPORTED,
	OID_GEN_MEDIA_IN_USE,
	OID_GEN_MAXIMUM_LOOKAHEAD,
	OID_GEN_MAXIMUM_FRAME_SIZE,
	OID_GEN_LINK_SPEED,
	OID_GEN_TRANSMIT_BUFFER_SPACE,
	OID_GEN_RECEIVE_BUFFER_SPACE,
	OID_GEN_TRANSMIT_BLOCK_SIZE,
	OID_GEN_RECEIVE_BLOCK_SIZE,
	OID_GEN_VENDOR_ID,
	OID_GEN_VENDOR_DESCRIPTION,
	OID_GEN_CURRENT_PACKET_FILTER,
	OID_GEN_CURRENT_LOOKAHEAD,
	OID_GEN_DRIVER_VERSION,
	OID_GEN_MAXIMUM_TOTAL_SIZE,
	OID_GEN_PROTOCOL_OPTIONS,
	OID_GEN_MAC_OPTIONS,
	OID_GEN_MEDIA_CONNECT_STATUS,
	OID_GEN_MAXIMUM_SEND_PACKETS,
	OID_GEN_VENDOR_DRIVER_VERSION,
//	OID_GEN_SUPPORTED_GUIDS,
	OID_GEN_PHYSICAL_MEDIUM,
//	OID_GEN_MACHINE_NAME,
	OID_GEN_XMIT_OK,
	OID_GEN_RCV_OK,
	OID_GEN_XMIT_ERROR,
	OID_GEN_RCV_ERROR,
	OID_GEN_RCV_NO_BUFFER,

	OID_802_3_PERMANENT_ADDRESS,
	OID_802_3_CURRENT_ADDRESS,
	OID_802_3_MULTICAST_LIST,
	OID_802_3_MAXIMUM_LIST_SIZE,
	OID_802_3_MAC_OPTIONS,
	OID_802_3_RCV_ERROR_ALIGNMENT,
	OID_802_3_XMIT_ONE_COLLISION,
	OID_802_3_XMIT_MORE_COLLISIONS,

	OID_802_11_BSSID,
	OID_802_11_SSID,
	OID_802_11_INFRASTRUCTURE_MODE,
	OID_802_11_ADD_WEP,
	OID_802_11_REMOVE_WEP,
	OID_802_11_DISASSOCIATE,
	OID_802_11_AUTHENTICATION_MODE,
	OID_802_11_PRIVACY_FILTER,
	OID_802_11_BSSID_LIST_SCAN,
	OID_802_11_WEP_STATUS,
	OID_802_11_RELOAD_DEFAULTS,
	OID_802_11_NETWORK_TYPES_SUPPORTED,
	OID_802_11_NETWORK_TYPE_IN_USE,
	OID_802_11_TX_POWER_LEVEL,
	OID_802_11_RSSI,
//	OID_802_11_RSSI_TRIGGER,
	OID_802_11_FRAGMENTATION_THRESHOLD,
	OID_802_11_RTS_THRESHOLD,
	OID_802_11_NUMBER_OF_ANTENNAS,
	OID_802_11_RX_ANTENNA_SELECTED,
	OID_802_11_TX_ANTENNA_SELECTED,
	OID_802_11_SUPPORTED_RATES,
	OID_802_11_DESIRED_RATES,
	OID_802_11_CONFIGURATION,
//	OID_802_11_POWER_MODE,
	OID_802_11_BSSID_LIST,
	OID_802_11_STATISTICS,
	// New for WPA
	OID_802_11_ADD_KEY,
	OID_802_11_REMOVE_KEY,
	OID_802_11_ASSOCIATION_INFORMATION,
//	OID_802_11_TEST,

	RT_OID_802_11_BSSID,
	RT_OID_802_11_SSID,
	RT_OID_802_11_INFRASTRUCTURE_MODE,
	RT_OID_802_11_ADD_WEP,
	RT_OID_802_11_REMOVE_WEP,
	RT_OID_802_11_DISASSOCIATE,
	RT_OID_802_11_AUTHENTICATION_MODE,
	RT_OID_802_11_PRIVACY_FILTER,
	RT_OID_802_11_BSSID_LIST_SCAN,
	RT_OID_802_11_WEP_STATUS,
	RT_OID_802_11_RELOAD_DEFAULTS,
	RT_OID_802_11_NETWORK_TYPE_IN_USE,
	RT_OID_802_11_TX_POWER_LEVEL,
//	RT_OID_802_11_RSSI_TRIGGER,
	RT_OID_802_11_FRAGMENTATION_THRESHOLD,
	RT_OID_802_11_RTS_THRESHOLD,
	RT_OID_802_11_RX_ANTENNA_SELECTED,
	RT_OID_802_11_TX_ANTENNA_SELECTED,
	RT_OID_802_11_DESIRED_RATES,
	RT_OID_802_11_CONFIGURATION,
//	RT_OID_802_11_POWER_MODE,
//	RT_OID_802_11_STATISTICS,

	RT_OID_802_11_QUERY_LINK_STATUS,
	RT_OID_802_11_QUERY_PREAMBLE,
	RT_OID_802_11_SET_PREAMBLE,
	RT_OID_802_11_RESET_COUNTERS,
//	RT_OID_802_11_QUERY_RACONFIG,
//	RT_OID_802_11_SET_RACONFIG,
	RT_OID_802_11_QUERY_COUNTRY_REGION,
	RT_OID_802_11_SET_COUNTRY_REGION,
	RT_OID_802_11_QUERY_RADIO,
	RT_OID_802_11_SET_RADIO,

	// New for WPA
	RT_OID_802_11_ADD_KEY,

	RT_OID_802_11_QUERY_HARDWARE_REGISTER,
	RT_OID_802_11_SET_HARDWARE_REGISTER,

	RT_OID_802_11_QUERY_EVENT_TABLE,
	RT_OID_802_11_QUERY_MAC_TABLE,

#ifdef  NDIS51_MINIPORT
	OID_PNP_SET_POWER,
	OID_PNP_QUERY_POWER,
	RT_OID_802_11_SET_AC_CAM,
#endif
	RT_OID_802_11_QUERY_WPA_REKEY,
	RT_OID_802_11_SET_WPA_REKEY,

	RT_OID_802_11_QUERY_AP_CONFIG,
	RT_OID_802_11_SET_AP_CONFIG,
	RT_OID_802_11_QUERY_ACL,
	RT_OID_802_11_SET_ACL,
	RT_OID_802_11_QUERY_WDS,
	RT_OID_802_11_SET_WDS,
	RT_OID_802_11_QUERY_CURRENT_CHANNEL_ID,
	RT_OID_802_11_QUERY_TX_POWER_LEVEL_1,
	RT_OID_802_11_SET_TX_POWER_LEVEL_1,
	RT_OID_802_11_QUERY_EEPROM_VERSION,
	RT_OID_802_11_RSSI_2,
	RT_OID_802_11_QUERY_OP_MODE,
	RT_OID_802_11_SET_OP_MODE,
	RT_OID_802_11_QUERY_FIRMWARE_VERSION,
};
#endif // WIN_NDIS //

UCHAR	CipherSuiteWPAPSKTKIP[] = {
		0x00, 0x50, 0xf2, 0x01,	// oui
		0x01, 0x00,				// Version
		0x00, 0x50, 0xf2, 0x02,	// Multicast
		0x01, 0x00,				// Number of unicast
		0x00, 0x50, 0xf2, 0x02,	// unicast
		0x01, 0x00,				// number of authentication method
		0x00, 0x50, 0xf2, 0x02	// authentication
		};
UCHAR	CipherSuiteWPAPSKTKIPLen = (sizeof(CipherSuiteWPAPSKTKIP) / sizeof(UCHAR));

/*
	========================================================================
	Routine Description:
		RTMPQueryInformation will redirect all AP-specific OID QUERY/SET requsts
		to this routine

	IRQL = DISPATCH_LEVEL

	========================================================================
*/
NDIS_STATUS APQueryInformation(
	IN  NDIS_HANDLE MiniportAdapterContext,
	IN  NDIS_OID    Oid,
	IN  PVOID       pInformationBuffer,
	IN  ULONG       InformationBufferLength,
	OUT PULONG      pBytesWritten,
	OUT PULONG      pBytesNeeded)
{
	NDIS_STATUS             Status = NDIS_STATUS_SUCCESS;
	PRTMP_ADAPTER           pAd;

	ULONG                   ulInfo = 0;
//	USHORT                  usInfo = 0;
	PVOID                   pInfo = (PVOID) &ulInfo;
	ULONG                   ulInfoLen = sizeof(ulInfo);
	ULONG                   ulBytesAvailable = ulInfoLen;
//	PRT_802_11_WPA_REKEY    WPA_REKEY;
	NDIS_802_11_MAC_ADDRESS                     Bssid;
	NDIS_802_11_SSID                            Ssid;
//  NDIS_802_11_CONFIGURATION                   Configuration;
//	NDIS_802_11_BSSID_LIST_EX                   *pBssidList = NULL;
//  RT_802_11_LINK_STATUS                       LinkStatus;
//  PRT_802_11_HARDWARE_REGISTER                pHardwareRegister;
	UINT                                        i;
	RT_802_11_MAC_TABLE                         MacTab;
//	UCHAR                                       *pBuf = NULL;
	RT_802_11_AP_CONFIG                         ApConfig;

	pAd = (PRTMP_ADAPTER) MiniportAdapterContext;

	//
	// Initialize the result
	//
	*pBytesWritten = 0;
	*pBytesNeeded = 0;

	//
	// Process different type of requests
	//

	switch(Oid)
	{
#ifdef WIN_NDIS
		case OID_GEN_SUPPORTED_LIST:
			DBGPRINT(RT_DEBUG_INFO, ("Query::OID_GEN_SUPPORTED_LIST \n"));
			pInfo = (PVOID) APSupportedOids;
			ulBytesAvailable = ulInfoLen = sizeof(APSupportedOids);
			break;
#endif

		case OID_802_11_BSSID:
			COPY_MAC_ADDR(Bssid, &pAd->CommonCfg.Bssid);
			DBGPRINT(RT_DEBUG_TRACE, ("Query::OID_802_11_BSSID(=%02x:%02x:%02x:%02x:%02x:%02x)\n",
					 Bssid[0],Bssid[1],Bssid[2],Bssid[3],Bssid[4],Bssid[5]));
			pInfo = (VOID *)Bssid;
			ulBytesAvailable = ulInfoLen = MAC_ADDR_LEN;
			break;

		case OID_802_11_SSID:
			Ssid.SsidLength = pAd->CommonCfg.SsidLen;
			NdisZeroMemory(Ssid.Ssid, MAX_LEN_OF_SSID);
			NdisMoveMemory(Ssid.Ssid, pAd->CommonCfg.Ssid, Ssid.SsidLength);
			DBGPRINT(RT_DEBUG_TRACE, ("Query::OID_802_11_SSID (Len=%d, ssid=%s)\n", Ssid.SsidLength, Ssid.Ssid));
			pInfo = (VOID *)&Ssid;
			ulBytesAvailable = ulInfoLen = sizeof(ULONG) + Ssid.SsidLength;
			break;

		case OID_802_11_RSSI:
			ulInfo = pAd->ApCfg.LastRssi - pAd->BbpRssiToDbmDelta;
			DBGPRINT(RT_DEBUG_TRACE, ("Query::OID_802_11_RSSI(=%d)\n", ulInfo));
			break;

//		case OID_802_11_RSSI_TRIGGER:
//			ulInfo = pAd->ApCfg.RssiTrigger - pAd->BbpRssiToDbmDelta;
//			DBGPRINT(RT_DEBUG_TRACE, ("Query::OID_802_11_RSSI_TRIGGER(=%d)\n", ulInfo));
//			break;

		case OID_802_11_INFRASTRUCTURE_MODE:
			ulInfo = Ndis802_11Infrastructure;
			DBGPRINT(RT_DEBUG_TRACE, ("Query::OID_802_11_INFRASTRUCTURE_MODE(=%d)\n", ulInfo));
			break;

//		case OID_802_11_POWER_MODE:
//			ulInfo = pAd->ApCfg.WindowsPowerMode;
//			DBGPRINT(RT_DEBUG_TRACE, ("Query::OID_802_11_POWER_MODE(=%d)\n", ulInfo));
//			break;

		case OID_802_11_BSSID_LIST:
			DBGPRINT(RT_DEBUG_TRACE, ("Query::OID_802_11_BSSID_LIST\n"));
			ulInfo = 0;
			break;

		case RT_OID_802_11_QUERY_EVENT_TABLE:
			if (InformationBufferLength != sizeof(RT_802_11_EVENT_TABLE))
				Status = NDIS_STATUS_INVALID_LENGTH;
			else
			{
				pInfo = (UCHAR *)&pAd->EventTab;
				ulBytesAvailable = ulInfoLen = 8 + pAd->EventTab.Num * sizeof(RT_802_11_EVENT_LOG);
			}
			break;

		case RT_OID_802_11_QUERY_MAC_TABLE:
			if (InformationBufferLength < sizeof(RT_802_11_MAC_TABLE))
				Status = NDIS_STATUS_INVALID_LENGTH;
			else
			{
				MacTab.Num=0;
				for (i=0; i<MAX_LEN_OF_MAC_TABLE; i++)
				{
					if (pAd->MacTab.Content[i].Valid && (pAd->MacTab.Content[i].Sst == SST_ASSOC))
					{
						COPY_MAC_ADDR(MacTab.Entry[MacTab.Num].Addr, &pAd->MacTab.Content[i].Addr);
						MacTab.Entry[MacTab.Num].Aid = (UCHAR)pAd->MacTab.Content[i].Aid;
						MacTab.Entry[MacTab.Num].Psm = pAd->MacTab.Content[i].PsMode;
						MacTab.Num += 1;
					}
				}
				pInfo = &MacTab;
				ulBytesAvailable = ulInfoLen = 4 + MacTab.Num * sizeof(RT_802_11_MAC_ENTRY);
			}
			break;

		case RT_OID_802_11_QUERY_AP_CONFIG:
			if (InformationBufferLength != sizeof(RT_802_11_AP_CONFIG))
				Status = NDIS_STATUS_INVALID_LENGTH;
			else
			{
				DBGPRINT(RT_DEBUG_TRACE, ("Query::RT_OID_802_11_QUERY_AP_CONFIG\n"));
				ApConfig.bEnableTxBurst = pAd->CommonCfg.bEnableTxBurst;
				ApConfig.EnableTurboRate = 0;
				ApConfig.IsolateInterStaTraffic = pAd->ApCfg.bIsolateInterStaTraffic;
				ApConfig.HideSsid = pAd->ApCfg.bHideSsid;
				ApConfig.UseBGProtection = pAd->CommonCfg.UseBGProtection;
				ApConfig.UseShortSlotTime = pAd->CommonCfg.bUseShortSlotTime;
				ApConfig.AgeoutTime = pAd->ApCfg.AgeoutTime;
				ApConfig.Rsv1 = 0;
				ApConfig.SystemErrorBitmap = pAd->SystemErrorBitmap;
				pInfo = &ApConfig;
				ulBytesAvailable = ulInfoLen = sizeof(RT_802_11_AP_CONFIG);
			}
			break;

		case RT_OID_802_11_QUERY_ACL:
			if (InformationBufferLength < sizeof(RT_802_11_ACL))
				Status = NDIS_STATUS_INVALID_LENGTH;
			else
			{
				DBGPRINT(RT_DEBUG_TRACE, ("Query::RT_OID_802_11_QUERY_ACL (Policy=%d, Entry#=%d\n",
					pAd->AccessControlList.Policy, pAd->AccessControlList.Num));
				pInfo = &pAd->AccessControlList;
				ulBytesAvailable = ulInfoLen = sizeof(RT_802_11_ACL);
			}
			break;

		case RT_OID_802_11_QUERY_WPA_REKEY:
#ifdef WIN_NDIS
			WPA_REKEY = (PRT_802_11_WPA_REKEY) pInformationBuffer;
#endif
			if (InformationBufferLength < sizeof(RT_802_11_WPA_REKEY))
				Status = NDIS_STATUS_INVALID_LENGTH;
			else
			{
				pInfo = &pAd->ApCfg.WPAREKEY;
				ulBytesAvailable = ulInfoLen = sizeof(RT_802_11_WPA_REKEY);
			}
			DBGPRINT(RT_DEBUG_TRACE, (" Query :: RT_OID_802_11_QUERY_WPA_REKEY     \n"));
			break;

		case RT_OID_802_11_RSSI_2:
			/*if ((pAd->RfIcType == RFIC_5325) || (pAd->RfIcType == RFIC_2529))
			{
				ulInfo = pAd->ApCfg.LastRssi2 - pAd->BbpRssiToDbmDelta;
				DBGPRINT(RT_DEBUG_INFO, ("Query::RT_OID_802_11_RSSI_2(=%d)\n", ulInfo));
			}
			else*/
				Status = NDIS_STATUS_NOT_SUPPORTED;
			break;

		case RT_OID_802_11_QUERY_OP_MODE:
			ulInfo = pAd->OpMode;
			DBGPRINT(RT_DEBUG_TRACE, ("Query::RT_OID_802_11_QUERY_OP_MODE(=%d)\n", ulInfo));
			break;

#ifdef	WDS
		case RT_OID_802_11_QUERY_WDS:
			DBGPRINT(RT_DEBUG_TRACE, ("Query::RT_OID_802_11_QUERY_WDS\n"));
			break;

		case RT_OID_802_11_SET_WDS:
#endif
		case RT_OID_802_11_BSSID:
		case RT_OID_802_11_SSID:
		case RT_OID_802_11_INFRASTRUCTURE_MODE:
		case RT_OID_802_11_ADD_WEP:
		case RT_OID_802_11_ADD_KEY:
		case RT_OID_802_11_REMOVE_WEP:
		case RT_OID_802_11_DISASSOCIATE:
		case RT_OID_802_11_AUTHENTICATION_MODE:
		case RT_OID_802_11_PRIVACY_FILTER:
		case RT_OID_802_11_BSSID_LIST_SCAN:
		case RT_OID_802_11_WEP_STATUS:
		case RT_OID_802_11_RELOAD_DEFAULTS:
		case RT_OID_802_11_NETWORK_TYPE_IN_USE:
//		case RT_OID_802_11_TX_POWER_LEVEL:
//		case RT_OID_802_11_RSSI_TRIGGER:
		case RT_OID_802_11_FRAGMENTATION_THRESHOLD:
		case RT_OID_802_11_RTS_THRESHOLD:
		case RT_OID_802_11_DESIRED_RATES:
		case RT_OID_802_11_SUPPORTED_RATES:
		case RT_OID_802_11_CONFIGURATION:
//		case RT_OID_802_11_POWER_MODE:
//		case RT_OID_802_11_SET_PREAMBLE:
//		case RT_OID_802_11_RESET_COUNTERS:
		case RT_OID_802_11_SET_AC_CAM:
//		case RT_OID_802_11_SET_RACONFIG:
//		case RT_OID_802_11_SET_COUNTRY_REGION:

		case RT_OID_802_11_SET_PHY_MODE:
//		case RT_OID_802_11_SET_TX_PACKET_BURST:
		case RT_OID_802_11_SET_AP_CONFIG:
		case RT_OID_802_11_SET_ACL:
		case RT_OID_802_11_SET_TX_POWER_LEVEL_1:
		case RT_OID_802_11_SET_WPA_REKEY:
		case RT_OID_802_11_SET_OP_MODE:
			Status = APSetInformation(MiniportAdapterContext,
										Oid,                    // Oid & ~(OID_GET_SET_TOGGLE),
										pInformationBuffer,
										InformationBufferLength,
										pBytesWritten,
										pBytesNeeded);
			ulBytesAvailable = ulInfoLen = 0;
			break;

		default:
			DBGPRINT(RT_DEBUG_INFO, ("Query::unknown OID 0x%08x \n",Oid));
			Status = NDIS_STATUS_NOT_SUPPORTED;
			break;
	}

	if (Status == NDIS_STATUS_SUCCESS)
	{
		*pBytesNeeded = ulBytesAvailable;
		if (ulInfoLen <= InformationBufferLength)
		{
			// Copy result into InformationBuffer
			*pBytesWritten = ulInfoLen;
			if (ulInfoLen)
#ifdef WIN_NDIS
				NdisMoveMemory(pInformationBuffer, pInfo, ulInfoLen);
#else
				Status = copy_from_user(pInformationBuffer, pInfo, ulInfoLen);
#endif
		}
		else
		{
			// too short
			*pBytesNeeded = ulInfoLen;
			Status = NDIS_STATUS_BUFFER_TOO_SHORT;
		}

		// pAd->EventTab is read-and-clear
		if (Oid == RT_OID_802_11_QUERY_EVENT_TABLE)
		{
			NdisZeroMemory(&pAd->EventTab, sizeof(RT_802_11_EVENT_TABLE));
		}
	}

	return(Status);
}

/*
	========================================================================

	Routine Description:
		APQueryInformation will redirect all AP-specific OID SET requests to
		this routine.

	IRQL = DISPATCH_LEVEL

	========================================================================
*/
NDIS_STATUS APSetInformation(
	IN  NDIS_HANDLE MiniportAdapterContext,
	IN  NDIS_OID    Oid,
	IN  PVOID       pInformationBuffer,
	IN  ULONG       InformationBufferLength,
	OUT PULONG      pBytesRead,
	OUT PULONG      pBytesNeeded)
{
	NDIS_STATUS								Status = NDIS_STATUS_SUCCESS;
	PRTMP_ADAPTER							pAd;
	NDIS_802_11_WEP_STATUS					WepStatus;
	NDIS_802_11_NETWORK_TYPE				NetType;
//	NDIS_802_11_TX_POWER_LEVEL				TxPower;
//	NDIS_802_11_RSSI						RssiTrigger;
//	NDIS_802_11_NETWORK_INFRASTRUCTURE		BssType;
//	NDIS_802_11_FRAGMENTATION_THRESHOLD		FragThresh;
//	NDIS_802_11_RTS_THRESHOLD				RtsThresh;
	NDIS_802_11_CONFIGURATION				*pConfig;
	PNDIS_802_11_WEP						pWepKey;
	NDIS_802_11_WEP							WepKeyBuf;
	PNDIS_802_11_KEY						pKey;
	NDIS_802_11_KEY							KeyBuf;
	PNDIS_802_11_REMOVE_KEY					pRemoveKey;
	NDIS_802_11_REMOVE_KEY					RemoveKeyBuf;
//	NDIS_802_11_POWER_MODE					PowerMode;
	NDIS_802_11_PRIVACY_FILTER				Filter;
	NDIS_802_11_AUTHENTICATION_MODE			AuthMode;
	ULONG									KeyIdx;
//	UINT									i;
//	BOOLEAN									ACCAMEnable = FALSE;
//	PRT_802_11_HARDWARE_REGISTER			pHardwareRegister;

	ULONG									phymode;
//	BOOLEAN									RestartAPIsRequired = FALSE;
	PRT_WPA_REKEY							WPA_REKEY;
	RT_WPA_REKEY							WPA_REKEY_Buf;
//	PRT_802_11_WDS							pWds;
//	RT_802_11_WDS							WdsBuf;


	pAd = (PRTMP_ADAPTER) MiniportAdapterContext;
	*pBytesRead   = 0;
	*pBytesNeeded = 0;


	DBGPRINT(RT_DEBUG_TRACE, ("---->APSetInformation\n"));
	switch (Oid)
	{
		case RT_OID_802_11_BSSID:
		case OID_802_11_BSSID:
			DBGPRINT(RT_DEBUG_TRACE, ("Set::RT_OID_802_11_BSSID\n"));
			break;

		case RT_OID_802_11_SSID:
		case OID_802_11_SSID:
			if (InformationBufferLength > MAX_LEN_OF_SSID + sizeof(ULONG))
				Status = NDIS_STATUS_INVALID_LENGTH;
			else
			{
#ifdef WIN_NDIS
				PUCHAR pSsid = pInformationBuffer;
#else
				UCHAR SsidBuff[MAX_LEN_OF_SSID];
				PUCHAR pSsid = (PUCHAR)&SsidBuff;
				Status = copy_from_user(pSsid, pInformationBuffer, InformationBufferLength);
#endif
				DBGPRINT(RT_DEBUG_TRACE, ("Set:: EnqueueCmd RT_OID_802_11_BSSID\n"));
				Status = RTUSBEnqueueCmdFromNdis(pAd, OID_802_11_SSID, TRUE, pSsid, InformationBufferLength);
			}
			break;
		case RT_OID_802_11_INFRASTRUCTURE_MODE:
		case OID_802_11_INFRASTRUCTURE_MODE:
			DBGPRINT(RT_DEBUG_TRACE, ("Set::OID_802_11_INFRASTRUCTURE_MODE\n"));
			break;

		// New for WPA
		case RT_OID_802_11_SET_WPA_REKEY:

			if (pAd->CommonCfg.AuthMode < Ndis802_11AuthModeWPA)
			{
				if(pAd->ApCfg.REKEYTimerRunning == TRUE)
				{
					BOOLEAN     Cancelled;
					NdisMCancelTimer(&pAd->ApCfg.REKEYTimer, &Cancelled);
					pAd->ApCfg.REKEYTimerRunning = FALSE;
				}
				break;
			}
#ifdef WIN_NDIS
			WPA_REKEY = (PRT_WPA_REKEY) pInformationBuffer;
#else
			WPA_REKEY = &WPA_REKEY_Buf;
			Status = copy_from_user(WPA_REKEY, pInformationBuffer, InformationBufferLength);
#endif
			// mechanism for rekeying: 0:disable, 1: time-based, 2: packet-based
			if (WPA_REKEY->ReKeyMethod >MAX_REKEY)
				Status = NDIS_STATUS_INVALID_LENGTH;
			else if (WPA_REKEY->ReKeyInterval > MAX_REKEY_INTER)
				Status = NDIS_STATUS_INVALID_DATA;
			else if ((WPA_REKEY->ReKeyMethod == DISABLE_REKEY) ||(WPA_REKEY->ReKeyInterval == 0))
			{
				DBGPRINT(RT_DEBUG_TRACE, ("  DISABLE WPA_REKEY      \n"));
				pAd->ApCfg.WPAREKEY.ReKeyInterval = WPA_REKEY->ReKeyInterval;
				pAd->ApCfg.WPAREKEY.ReKeyMethod = DISABLE_REKEY;
				if(pAd->ApCfg.REKEYTimerRunning == TRUE)
				{
					BOOLEAN     Cancelled;
					NdisMCancelTimer(&pAd->ApCfg.REKEYTimer, &Cancelled);
					pAd->ApCfg.REKEYTimerRunning = FALSE;
				}
			}
			else if ((WPA_REKEY->ReKeyMethod == PKT_REKEY)    || (WPA_REKEY->ReKeyMethod == TIME_REKEY))  //packet-based
			{
				if(pAd->ApCfg.REKEYTimerRunning == FALSE)
				{
#ifdef WIN_NDIS
					NdisMSetPeriodicTimer(&pAd->ApCfg.REKEYTimer, GROUP_KEY_UPDATE_EXEC_INTV);
#else
					/* ~~sample, modification for TIME_REKEY method */
					RTMPSetTimer(&pAd->ApCfg.REKEYTimer, GROUP_KEY_UPDATE_EXEC_INTV);
#endif
					pAd->ApCfg.REKEYTimerRunning = TRUE;
					pAd->ApCfg.REKEYCOUNTER = 0;
				}
				pAd->ApCfg.WPAREKEY.ReKeyInterval = WPA_REKEY->ReKeyInterval;
				pAd->ApCfg.WPAREKEY.ReKeyMethod = WPA_REKEY->ReKeyMethod;
			}
			DBGPRINT(RT_DEBUG_TRACE, (" Set::RT_OID_802_11_SET_WPA_REKEY , ReKeyMethod= %x  , interval= %x    \n",WPA_REKEY->ReKeyMethod,WPA_REKEY->ReKeyInterval));
			break;

		case RT_OID_802_11_ADD_KEY:
		case OID_802_11_ADD_KEY:
#ifdef WIN_NDIS
			pKey = (PNDIS_802_11_KEY) pInformationBuffer;
#else
			pKey = &KeyBuf;
			Status = copy_from_user(pKey, pInformationBuffer, InformationBufferLength);
#endif
			if (InformationBufferLength != pKey->Length)
				Status = NDIS_STATUS_INVALID_LENGTH;
			else
			{
				if (pAd->CommonCfg.AuthMode >= Ndis802_11AuthModeWPA)
				{
					if(pKey->KeyLength==32)
					{
						NdisMoveMemory(pAd->ApCfg.PMK, pKey->KeyMaterial, 32);
						DBGPRINT(RT_DEBUG_TRACE, ("OID_802_11_ADD_KEY::PMK = %x:%x:%x:%x:%x:%x:%x:%x \n",pAd->ApCfg.PMK[0],pAd->ApCfg.PMK[1],pAd->ApCfg.PMK[2],pAd->ApCfg.PMK[3],pAd->ApCfg.PMK[4],pAd->ApCfg.PMK[5],pAd->ApCfg.PMK[6],pAd->ApCfg.PMK[7]));
					}
					else
						DBGPRINT(RT_DEBUG_TRACE, ("Set::OID_802_11_ADD_KEY ERROR \n"));
				}
				else    // Old WEP stuff
				{
					 KeyIdx = pKey->KeyIndex & 0x0fffffff;

					 // it is a shared key
					 if ((KeyIdx >= 4) || ((pKey->KeyLength != 5) && (pKey->KeyLength != 13)))
						 Status = NDIS_STATUS_INVALID_DATA;
					 else
					 {
						 UCHAR CipherAlg = (pKey->KeyLength == 5)? CIPHER_WEP64 : CIPHER_WEP128;
						 NdisMoveMemory(pAd->SharedKey[BSS0][KeyIdx].Key, &pKey->KeyMaterial, pKey->KeyLength);
						 pAd->SharedKey[BSS0][KeyIdx].KeyLen = (UCHAR) pKey->KeyLength;
						 pAd->SharedKey[BSS0][KeyIdx].CipherAlg = CipherAlg;
						 if (pKey->KeyIndex & 0x80000000)
						 {
							 // Default key for tx (shared key)
							 pAd->CommonCfg.DefaultKeyId = (UCHAR) KeyIdx;
						 }
						 Status = RTUSBEnqueueCmdFromNdis(pAd, OID_802_11_ADD_KEY, TRUE, pKey, InformationBufferLength);
						 //AsicAddSharedKeyEntry(pAd, BSS0, (UCHAR) KeyIdx, CipherAlg, pKey->KeyMaterial, NULL, NULL);
					}
				}
			}
			DBGPRINT(RT_DEBUG_TRACE, ("Set::OID_802_11_ADD_KEY (info-len=%d, id=0x%x, Len=%d-byte)\n", InformationBufferLength, pKey->KeyIndex, pKey->KeyLength));
			break;

		case OID_802_11_REMOVE_KEY:
#ifdef WIN_NDIS
			pRemoveKey = (PNDIS_802_11_REMOVE_KEY) pInformationBuffer;
#else
			pRemoveKey = &RemoveKeyBuf;
			Status = copy_from_user(pRemoveKey, pInformationBuffer, InformationBufferLength);
#endif
			if (InformationBufferLength != pRemoveKey->Length)
				Status = NDIS_STATUS_INVALID_LENGTH;
			else
			{
				if (pAd->CommonCfg.AuthMode >= Ndis802_11AuthModeWPA)
				{
				}
				else
				{
					KeyIdx = *(NDIS_802_11_KEY_INDEX *) pRemoveKey;

					if (KeyIdx & 0x80000000)
					{
						// Should never set default bit when remove key
						Status = NDIS_STATUS_INVALID_DATA;
					}
					else
					{
						KeyIdx = KeyIdx & 0x0fffffff;
						if (KeyIdx >= 4)
							Status = NDIS_STATUS_INVALID_DATA;
						else
						{
							pAd->SharedKey[BSS0][KeyIdx].KeyLen = 0;
							pAd->SharedKey[BSS0][KeyIdx].CipherAlg = CIPHER_NONE;
							AsicRemoveSharedKeyEntry(pAd, BSS0, (UCHAR) KeyIdx);
						}
					}
				}
			}
			DBGPRINT(RT_DEBUG_TRACE, ("Set::OID_802_11_REMOVE_KEY (id=0x%x, Len=%d-byte)\n", pRemoveKey->KeyIndex, pRemoveKey->Length));
			break;

		case RT_OID_802_11_ADD_WEP:
		case OID_802_11_ADD_WEP:
			DBGPRINT(RT_DEBUG_TRACE, ("Set::OID_802_11_ADD_WEP\n"));
#ifdef WIN_NDIS
			pWepKey = (PNDIS_802_11_WEP) pInformationBuffer;
#else
			pWepKey = &WepKeyBuf;
			Status = copy_from_user(pWepKey, pInformationBuffer, InformationBufferLength);
#endif
			KeyIdx = pWepKey->KeyIndex & 0x0fffffff;

			// it is a shared key
			if ((KeyIdx >= 4) || ((pWepKey->KeyLength != 5) && (pWepKey->KeyLength != 13)))
				Status = NDIS_STATUS_INVALID_DATA;
			else
			{
				UCHAR CipherAlg = (pWepKey->KeyLength == 5)? CIPHER_WEP64 : CIPHER_WEP128;
				NdisMoveMemory(pAd->SharedKey[BSS0][KeyIdx].Key, &pWepKey->KeyMaterial, pWepKey->KeyLength);
				pAd->SharedKey[BSS0][KeyIdx].KeyLen = (UCHAR) pWepKey->KeyLength;
				pAd->SharedKey[BSS0][KeyIdx].CipherAlg = CipherAlg;
				if (pWepKey->KeyIndex & 0x80000000)
				{
					// Default key for tx (shared key)
					pAd->CommonCfg.DefaultKeyId = (UCHAR) KeyIdx;
				}
				AsicAddSharedKeyEntry(pAd, BSS0, (UCHAR) KeyIdx, CipherAlg, pWepKey->KeyMaterial, pAd->SharedKey[BSS0][KeyIdx].KeyLen,NULL, NULL);
			}

			DBGPRINT(RT_DEBUG_TRACE, ("Set::OID_802_11_ADD_WEP (id=%d, Len=%d-byte)\n", KeyIdx, pWepKey->KeyLength));
			break;

		case RT_OID_802_11_REMOVE_WEP:
		case OID_802_11_REMOVE_WEP:
			if (InformationBufferLength != sizeof(NDIS_802_11_KEY_INDEX))
				Status = NDIS_STATUS_INVALID_LENGTH;
			else
			{
#ifdef WIN_NDIS
				KeyIdx = *(NDIS_802_11_KEY_INDEX *)pInformationBuffer;
#else
				Status = copy_from_user(&KeyIdx, pInformationBuffer, InformationBufferLength);
#endif

				if (KeyIdx & 0x80000000)
				{
					// Should never set default bit when remove key
					Status = NDIS_STATUS_INVALID_DATA;
				}
				else
				{
					KeyIdx = KeyIdx & 0x0fffffff;
					if (KeyIdx >= 4)
						Status = NDIS_STATUS_INVALID_DATA;
					else
					{
						pAd->SharedKey[BSS0][KeyIdx].KeyLen = 0;
						pAd->SharedKey[BSS0][KeyIdx].CipherAlg = CIPHER_NONE;
						AsicRemoveSharedKeyEntry(pAd, BSS0, (UCHAR) KeyIdx);
					}
				}
			}
			DBGPRINT(RT_DEBUG_TRACE, ("Set::OID_802_11_REMOVE_WEP (id=%d)\n",KeyIdx));
			break;

		case RT_OID_802_11_DISASSOCIATE:
		case OID_802_11_DISASSOCIATE:
			DBGPRINT(RT_DEBUG_TRACE, ("Set::OID_802_11_DISASSOCIATE \n"));
			break;

		case RT_OID_802_11_AUTHENTICATION_MODE:
		case OID_802_11_AUTHENTICATION_MODE:
			DBGPRINT(RT_DEBUG_TRACE, ("Set::RT_OID_802_11_AUTHENTICATION_MODE \n"));
			if (InformationBufferLength != sizeof(NDIS_802_11_AUTHENTICATION_MODE))
				Status = NDIS_STATUS_INVALID_LENGTH;
			else
			{
#ifdef WIN_NDIS
				AuthMode = *(PNDIS_802_11_AUTHENTICATION_MODE)pInformationBuffer;
#else
				Status = copy_from_user(&AuthMode, pInformationBuffer, InformationBufferLength);
#endif
				pAd->CommonCfg.AuthMode = AuthMode;
				if (AuthMode > Ndis802_11AuthModeMax)
					Status = NDIS_STATUS_INVALID_DATA;
				else
				{
					Status = RTUSBEnqueueCmdFromNdis(pAd, RT_OID_802_11_AUTHENTICATION_MODE, TRUE, &AuthMode, InformationBufferLength);
				}

			}


			break;

		case RT_OID_802_11_PRIVACY_FILTER:
		case OID_802_11_PRIVACY_FILTER:
			if (InformationBufferLength != sizeof(NDIS_802_11_PRIVACY_FILTER))
				Status = NDIS_STATUS_INVALID_LENGTH;
			else
			{
#ifdef WIN_NDIS
				Filter = *(PNDIS_802_11_PRIVACY_FILTER)pInformationBuffer;
#else
				Status = copy_from_user(&Filter, pInformationBuffer, InformationBufferLength);
#endif
				if ((Filter == Ndis802_11PrivFilterAcceptAll) || (Filter == Ndis802_11PrivFilter8021xWEP))
					pAd->CommonCfg.PrivacyFilter = Filter;
				else
					Status = NDIS_STATUS_INVALID_DATA;
			}
			DBGPRINT(RT_DEBUG_TRACE, ("Set::OID_802_11_PRIVACY_FILTER (=%d) \n",pAd->CommonCfg.PrivacyFilter));
			break;

		case RT_OID_802_11_BSSID_LIST_SCAN:
		case OID_802_11_BSSID_LIST_SCAN:
			DBGPRINT(RT_DEBUG_TRACE, ("Set::OID_802_11_BSSID_LIST_SCAN \n"));
			break;

		case RT_OID_802_11_WEP_STATUS:
		case OID_802_11_WEP_STATUS:
			if (InformationBufferLength != sizeof(NDIS_802_11_WEP_STATUS))
				Status = NDIS_STATUS_INVALID_LENGTH;
			else
			{
#ifdef WIN_NDIS
				WepStatus = *(PNDIS_802_11_WEP_STATUS)pInformationBuffer;
#else
				Status = copy_from_user(&WepStatus, pInformationBuffer, InformationBufferLength);
#endif
				// Since TKIP, AES, WEP are all supported. It should not have any invalid setting
				if (WepStatus >= Ndis802_11Encryption2Enabled)
					pAd->CommonCfg.DefaultKeyId = 1;
				if (WepStatus <= Ndis802_11Encryption4Enabled)
				{
					pAd->CommonCfg.WepStatus = WepStatus;
				}
				else
					Status = NDIS_STATUS_INVALID_DATA;
			}
			// modify RSN IE
			RTMPMakeRSNIE(pAd, pAd->CommonCfg.AuthMode, pAd->CommonCfg.WepStatus);
			RTUSBEnqueueInternalCmd(pAd, OID_802_11_CONFIGURATION, NULL, 0);
			DBGPRINT(RT_DEBUG_WARN, ("Set::OID_802_11_WEP_STATUS (=%d)\n", pAd->CommonCfg.WepStatus));
			break;

		case RT_OID_802_11_RELOAD_DEFAULTS:
		case OID_802_11_RELOAD_DEFAULTS:
			// TODO:
			DBGPRINT(RT_DEBUG_TRACE, ("Set::OID_802_11_RELOAD_DEFAULTS (to be implement) \n"));
			break;

		case RT_OID_802_11_NETWORK_TYPE_IN_USE:
		case OID_802_11_NETWORK_TYPE_IN_USE:
			DBGPRINT(RT_DEBUG_TRACE, ("Set::OID_802_11_NETWORK_TYPE_IN_USE \n"));
			if (InformationBufferLength != sizeof(NDIS_802_11_NETWORK_TYPE))
				Status = NDIS_STATUS_INVALID_LENGTH;
			else
			{
#ifdef WIN_NDIS
				NetType = *(PNDIS_802_11_NETWORK_TYPE)pInformationBuffer;
#else
				Status = copy_from_user(&NetType, pInformationBuffer, InformationBufferLength);
#endif
				Status = RTUSBEnqueueCmdFromNdis(pAd, OID_802_11_NETWORK_TYPE_IN_USE, TRUE, &NetType, InformationBufferLength);
				DBGPRINT(RT_DEBUG_TRACE, ("Set::OID_802_11_NETWORK_TYPE_IN_USE (=%d)\n",NetType));
			}
			break;

//		case RT_OID_802_11_RSSI_TRIGGER:
//		case OID_802_11_RSSI_TRIGGER:
//			DBGPRINT(RT_DEBUG_TRACE, ("Set::OID_802_11_RSSI_TRIGGER\n"));
//			break;

		case RT_OID_802_11_DESIRED_RATES:
		case OID_802_11_DESIRED_RATES:
			if (InformationBufferLength != sizeof(NDIS_802_11_RATES))
				Status = NDIS_STATUS_INVALID_LENGTH;
			else
			{
#ifdef WIN_NDIS
				PUCHAR pNdis80211Rate = pInformationBuffer;
#else
				NDIS_802_11_RATES Ndis80211RateBuf;
				PUCHAR pNdis80211Rate = (PUCHAR)&Ndis80211RateBuf;
				Status = copy_from_user(pNdis80211Rate, pInformationBuffer, InformationBufferLength);
#endif
				DBGPRINT(RT_DEBUG_TRACE, ("Set::OID_802_11_DESIRED_RATES (%02x,%02x,%02x,%02x,%02x,%02x,%02x,%02x)\n",
					pAd->CommonCfg.DesireRate[0],pAd->CommonCfg.DesireRate[1],
					pAd->CommonCfg.DesireRate[2],pAd->CommonCfg.DesireRate[3],
					pAd->CommonCfg.DesireRate[4],pAd->CommonCfg.DesireRate[5],
					pAd->CommonCfg.DesireRate[6],pAd->CommonCfg.DesireRate[7] ));
				Status= RTUSBEnqueueCmdFromNdis(pAd, RT_OID_802_11_DESIRED_RATES, TRUE, pNdis80211Rate, InformationBufferLength);
			}
			//RestartAPIsRequired = TRUE;
			break;

		case RT_OID_802_11_SUPPORTED_RATES:
		case OID_802_11_SUPPORTED_RATES:
#if 0
			if (InformationBufferLength != sizeof(NDIS_802_11_RATES))
				Status = NDIS_STATUS_INVALID_LENGTH;
			else
			{
				NdisMoveMemory(pAd->CommonCfg.SupRate, pInformationBuffer, sizeof(NDIS_802_11_RATES));
				MlmeUpdateTxRates(pAd, TRUE);
			}
			DBGPRINT(RT_DEBUG_TRACE, ("Set::OID_802_11_SUPPORTED_RATES (%02x,%02x,%02x,%02x,%02x,%02x,%02x,%02x)\n",
				pAd->CommonCfg.SupRate[0],pAd->CommonCfg.SupRate[1],
				pAd->CommonCfg.SupRate[2],pAd->CommonCfg.SupRate[3],
				pAd->CommonCfg.SupRate[4],pAd->CommonCfg.SupRate[5],
				pAd->CommonCfg.SupRate[6],pAd->CommonCfg.SupRate[7] ));
#endif
			break;

		case RT_OID_802_11_CONFIGURATION:
		case OID_802_11_CONFIGURATION:
			if (InformationBufferLength != sizeof(NDIS_802_11_CONFIGURATION))
            {
				Status = NDIS_STATUS_INVALID_LENGTH;
                break; /* ~~sample, bug fix, 2006/10/23 */
			}
            else
			{
//				BOOLEAN Cancelled;
#ifdef WIN_NDIS
				pConfig = (PNDIS_802_11_CONFIGURATION)pInformationBuffer;
#else
				NDIS_802_11_CONFIGURATION ConfigBuf;
				pConfig = &ConfigBuf;
				Status = copy_from_user(pConfig, pInformationBuffer, InformationBufferLength);
#endif
				pAd->CommonCfg.BeaconPeriod = (USHORT) pConfig->BeaconPeriod;
				MAP_KHZ_TO_CHANNEL_ID(pConfig->DSConfig, pAd->CommonCfg.Channel);
				//RTMPCancelTimer(&pAd->Mlme.BeaconPeriodicTimer, &Cancelled);
				//RTMPSetTimer(pAd, &pAd->Mlme.BeaconPeriodicTimer, pAd->CommonCfg.BeaconPeriod);
			}
			DBGPRINT(RT_DEBUG_TRACE, ("Set::OID_802_11_CONFIGURATION (BeacnPeriod=%d,AtimW=%d,Ch=%d)\n",
				pConfig->BeaconPeriod, pConfig->ATIMWindow, pAd->CommonCfg.Channel));
			Status = RTUSBEnqueueCmdFromNdis(pAd, OID_802_11_CONFIGURATION, TRUE, pConfig, InformationBufferLength);
			break;

//		case RT_OID_802_11_POWER_MODE:
//		case OID_802_11_POWER_MODE:
//			DBGPRINT(RT_DEBUG_TRACE, ("Set::OID_802_11_POWER_MODE\n"));
//			break;

#ifdef  NDIS51_MINIPORT
		// Enable CAM when AC on
		case RT_OID_802_11_SET_AC_CAM:
			break;
#endif

		case RT_OID_802_11_SET_PHY_MODE:
#ifdef WIN_NDIS
			phymode = *(ULONG *) pInformationBuffer;
#else
			Status = copy_from_user(&phymode, pInformationBuffer, InformationBufferLength);
#endif
			DBGPRINT(RT_DEBUG_TRACE, ("Set::RT_OID_802_11_SET_PHY_MODE (=%d)\n", phymode));
			if (phymode != pAd->CommonCfg.PhyMode)
			{
				Status = RTUSBEnqueueCmdFromNdis(pAd, RT_OID_802_11_SET_PHY_MODE, TRUE, &phymode, InformationBufferLength);
			}
			break;

		case RT_OID_802_11_SET_AP_CONFIG:
			DBGPRINT(RT_DEBUG_TRACE, ("Set::RT_OID_802_11_SET_AP_CONFIG\n"));
			if (InformationBufferLength != sizeof(RT_802_11_AP_CONFIG))
				Status = NDIS_STATUS_INVALID_LENGTH;
			else
			{
#ifdef WIN_NDIS
				PUCHAR pInform = pInformationBuffer;
#else
				PUCHAR pInform = kmalloc(InformationBufferLength, GFP_ATOMIC);
				if (!pInform)
					break;
				Status = copy_from_user(pInform, pInformationBuffer, InformationBufferLength);
#endif
				Status = RTUSBEnqueueCmdFromNdis(pAd, RT_OID_802_11_SET_AP_CONFIG, TRUE, pInform, InformationBufferLength);
#ifndef WIN_NDIS
				kfree(pInform);
#endif
				/*RT_802_11_AP_CONFIG *pApConfig = (RT_802_11_AP_CONFIG *)pInformationBuffer;
				pAd->CommonCfg.bEnableTxBurst          = (pApConfig->bEnableTxBurst == 1);
				pAd->ApCfg.bIsolateInterStaTraffic = (pApConfig->IsolateInterStaTraffic == 1);
				pAd->CommonCfg.UseBGProtection         = pApConfig->UseBGProtection;
//				pAd->CommonCfg.bUseShortSlotTime       = (pApConfig->UseShortSlotTime == 1);
				pAd->CommonCfg.bUseShortSlotTime       = TRUE;
				pAd->ApCfg.AegoutTime                  = pApConfig->AgeoutTime;
				if (pAd->ApCfg.bHideSsid != (pApConfig->HideSsid == 1))
				{
					pAd->ApCfg.bHideSsid = (pApConfig->HideSsid == 1);
					// re-built BEACON frame format
					AsicDisableSync(pAd);
					APMakeBssBeacon(pAd);
					APUpdateBeaconFrame(pAd);
					AsicEnableBssSync(pAd);
				}
				APUpdateCapabilityAndErpIe(pAd);
				DBGPRINT(RT_DEBUG_TRACE, ("Set::RT_OID_802_11_SET_AP_CONFIG (Burst=%d,Hotspot=%d,HideSsid=%d,BGprot=%d,ShortSlot=%d,AgeoutTime=%d\n",
					pApConfig->bEnableTxBurst,
					pApConfig->IsolateInterStaTraffic,
					pApConfig->HideSsid,
					pApConfig->UseBGProtection,
					pApConfig->UseShortSlotTime,
					pApConfig->AgeoutTime));*/
			}
			break;

		case RT_OID_802_11_SET_ACL:
			if (InformationBufferLength < sizeof(RT_802_11_ACL))
				Status = NDIS_STATUS_INVALID_LENGTH;
			else
			{
#ifdef WIN_NDIS
				NdisMoveMemory(&pAd->AccessControlList, pInformationBuffer, sizeof(RT_802_11_ACL));
#else
				Status = copy_from_user(&pAd->AccessControlList, pInformationBuffer, InformationBufferLength);
#endif
				if (pAd->AccessControlList.Num > MAX_LEN_OF_MAC_TABLE)
					pAd->AccessControlList.Num = MAX_LEN_OF_MAC_TABLE;

				// check if ACL change affects any existent associtions
				ApUpdateAccessControlList(pAd);

				DBGPRINT(RT_DEBUG_TRACE, ("Set::RT_OID_802_11_SET_ACL (Policy=%d, Entry#=%d)\n",
					pAd->AccessControlList.Policy, pAd->AccessControlList.Num));
			}
			break;

#ifdef	WDS
		case RT_OID_802_11_SET_WDS:
#ifdef WIN_NDIS
			pWds = (PRT_802_11_WDS)pInformationBuffer;
#else
			pWds = &WdsBuf;
			Status = copy_from_user(pWds, pInformationBuffer, InformationBufferLength);
#endif
			pAd->WdsTab.Size = pWds->Num;
			for(i = 0; i < pAd->WdsTab.Size; i++)
			{
				pAd->WdsTab.MacTab[i].CurrTxRate = RATE_11;
				if(pAd->CommonCfg.PhyMode == PHY_11B)
					pAd->WdsTab.MacTab[i].MaxSupportedRate = RATE_11;
				else
					pAd->WdsTab.MacTab[i].MaxSupportedRate = RATE_54;
				NdisMoveMemory(pAd->WdsTab.MacTab[i].WdsAddr, &pWds->Entry[i], MAC_ADDR_LEN);
				DBGPRINT(RT_DEBUG_TRACE,("WDS-AP(%d)-%02x:%02x:%02x:%02x:%02x:%02x\n", i,
					pAd->WdsTab.MacTab[i].WdsAddr[0], pAd->WdsTab.MacTab[i].WdsAddr[1], pAd->WdsTab.MacTab[i].WdsAddr[2],
					pAd->WdsTab.MacTab[i].WdsAddr[3], pAd->WdsTab.MacTab[i].WdsAddr[4], pAd->WdsTab.MacTab[i].WdsAddr[5]));
			}

			if(pWds->KeyLength == 32)
			{
				NdisZeroMemory(&pAd->WdsTab.Wpa_key, sizeof(CIPHER_KEY));
				NdisMoveMemory(pAd->WdsTab.Wpa_key.Key, pWds->KeyMaterial, 16);
				pAd->WdsTab.Wpa_key.KeyLen = 16;
				//require the same TXMIC key and RXMIC key
				NdisMoveMemory(pAd->WdsTab.Wpa_key.RxMic, pWds->KeyMaterial + 16, 8);
				NdisMoveMemory(pAd->WdsTab.Wpa_key.TxMic, pWds->KeyMaterial + 16, 8);
				if ((pAd->CommonCfg.WepStatus == Ndis802_11Encryption2Enabled) ||
					(pAd->CommonCfg.WepStatus == Ndis802_11Encryption4Enabled))
					pAd->WdsTab.Wpa_key.CipherAlg = CIPHER_TKIP;
				else if (pAd->CommonCfg.WepStatus == Ndis802_11Encryption3Enabled)
					pAd->WdsTab.Wpa_key.CipherAlg = CIPHER_AES;
				else
					pAd->WdsTab.Wpa_key.CipherAlg = CIPHER_NONE;
				for (i=0; i<pAd->WdsTab.Size; i++)
				{
					AsicAddPairwiseKeyEntry(pAd,
											pAd->WdsTab.MacTab[i].WdsAddr,
											WDS_PAIRWISE_KEY_OFFSET + (UCHAR)i,
											pAd->WdsTab.Wpa_key.CipherAlg,
											pAd->WdsTab.Wpa_key.Key,
											pAd->WdsTab.Wpa_key.TxMic,
											pAd->WdsTab.Wpa_key.RxMic);
				}
			}
			DBGPRINT(RT_DEBUG_TRACE,("Set:: %x, %x, %x ...)\n", pWds->KeyMaterial[0], pWds->KeyMaterial[1],pWds->KeyMaterial[2]));
			DBGPRINT(RT_DEBUG_TRACE,("Set::RT_OID_802_11_SET_WDS (num=%d, keylen=%d, Alg=%s)\n", pAd->WdsTab.Size, pWds->KeyLength, CipherName[pAd->WdsTab.Wpa_key.CipherAlg]));
			break;
#endif

		case RT_OID_802_11_SET_TX_POWER_LEVEL_1:
			if (InformationBufferLength != sizeof(ULONG))
				Status = NDIS_STATUS_INVALID_LENGTH;
			else
			{
#ifdef WIN_NDIS
				pAd->CommonCfg.TxPowerPercentage = *(ULONG *)pInformationBuffer;
#else
				Status = copy_from_user(&pAd->CommonCfg.TxPowerPercentage, pInformationBuffer, InformationBufferLength);
#endif
				if (pAd->CommonCfg.TxPowerPercentage > 100)
					pAd->CommonCfg.TxPowerPercentage = 100;
				DBGPRINT(RT_DEBUG_TRACE,("Set::RT_OID_802_11_SET_TX_POWER_LEVEL_1 (=%d)\n", pAd->CommonCfg.TxPowerPercentage));
			}
			break;

		case RT_OID_802_11_SET_OP_MODE:
			if (InformationBufferLength != sizeof(ULONG))
				Status = NDIS_STATUS_INVALID_LENGTH;
			else
			{
#ifdef WIN_NDIS
				pAd->OpMode = *(UCHAR *)pInformationBuffer;
#else
				Status = copy_from_user(&pAd->OpMode, pInformationBuffer, InformationBufferLength);
#endif
				Status = RTUSBEnqueueCmdFromNdis(pAd, RT_OID_802_11_SET_OP_MODE, TRUE, &pAd->OpMode, InformationBufferLength);
				DBGPRINT(RT_DEBUG_INFO,("Set::RT_OID_802_11_SET_OP_MODE (=%d)\n", pAd->OpMode));
			}
			break;

		default:
			DBGPRINT(RT_DEBUG_TRACE, ("Set::!!! unknown OID 0x%08x\n", Oid));
			Status = NDIS_STATUS_NOT_SUPPORTED;
			break;
	}

#ifdef WIN_NDIS
	if (Status == NDIS_STATUS_SUCCESS)
		*pBytesRead = InformationBufferLength;
#endif

#if 0
	if (RestartAPIsRequired)
	{
		DBGPRINT(RT_DEBUG_TRACE, ("restart AP\n"));
		if ((pAd->CommonCfg.bIEEE80211H == 1) && (pAd->CommonCfg.PhyMode == PHY_11A) && RadarChannelCheck(pAd, pAd->CommonCfg.Channel))
		{
			if (pAd->CommonCfg.RadarDetect.RDMode == RD_SILENCE_MODE)
			{
				RadarDetectionStop(pAd);
			}
			pAd->CommonCfg.RadarDetect.RDMode = RD_SWITCHING_MODE;
			pAd->CommonCfg.RadarDetect.CSCount = 0;
			DBGPRINT(RT_DEBUG_TRACE, ("APSetInformation: Channel change to ch%d, will do Channel-Switch-Announcement\n", pAd->CommonCfg.Channel));
		}
		else
		{
			if (pAd->CommonCfg.RadarDetect.RDMode == RD_SILENCE_MODE)
			{
				RadarDetectionStop(pAd);
			}
			pAd->CommonCfg.RadarDetect.RDMode = RD_NORMAL_MODE;
			pAd->CommonCfg.RadarDetect.CSCount = 0;

			APStop(pAd);
			APStartUp(pAd);
		}
	}
#endif
	DBGPRINT(RT_DEBUG_TRACE, ("<------APSetInformation\n"));
	return(Status);
}

