// PanelSettings.cpp : implementation file
//

#include "stdafx.h"
#include "DcDcUsb.h"
#include "DcDcUsbDlg.h"
#include "PanelSettings.h"
#include "utils/TxFile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CPanelSettings dialog

IMPLEMENT_DYNAMIC(CPanelSettings, CDialog)

CPanelSettings::CPanelSettings(CDcDcUsbDlg* mainDlg, CWnd* pParent /*=NULL*/)
	: CDialog(CPanelSettings::IDD, pParent)
{
	m_pMainDlg = mainDlg;
	for (int i=0;i<SETTINGS_PACKS;i++) m_bPackagesArrived[i] = false;
}

CPanelSettings::~CPanelSettings()
{
}

void CPanelSettings::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_MESSAGE, m_comboMessage);
	DDX_Control(pDX, IDC_EDIT_MESSAGE, m_editMessage);
	DDX_Control(pDX, IDC_STATIC_UNIT, m_sUnit);
	DDX_Control(pDX, IDC_STATIC_COMMENT, m_sComment);
	DDX_Control(pDX, IDC_BUTTON_SENDSETTINGS, m_bSend);
	DDX_Control(pDX, IDC_PROGRESS_RW, m_progressRW);
	DDX_Control(pDX, IDC_STATIC_RW, m_staticRW);
}


BEGIN_MESSAGE_MAP(CPanelSettings, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_LOADDEFVAL, &CPanelSettings::OnBnClickedButtonLoaddefval)
	ON_BN_CLICKED(IDC_BUTTON_SENDSETTINGS, &CPanelSettings::OnBnClickedButtonSendsettings)
	ON_CBN_SELCHANGE(IDC_COMBO_MESSAGE, &CPanelSettings::OnCbnSelchangeComboMessage)
	ON_BN_CLICKED(IDC_BUTTON_READSETTINGS, &CPanelSettings::OnBnClickedButtonReadsettings)
	ON_BN_CLICKED(IDC_BUTTON_WRITESETTINGS, &CPanelSettings::OnBnClickedButtonWritesettings)
END_MESSAGE_MAP()


// CPanelSettings message handlers

void CPanelSettings::OnBnClickedButtonLoaddefval()
{
	if (!m_pMainDlg->m_pDcDcUsb)
	{
		AfxMessageBox("No device connected!");
		return;
	}

	if (AfxMessageBox(_T("Are you sure you want to load defaults?"),MB_OKCANCEL|MB_DEFBUTTON2)==IDOK)
		if (m_pMainDlg->m_pDcDcUsb)
		{
			m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_CMD_OUT, 3, CMD_LOAD_DEFAULTS, 0, 0);
			m_pMainDlg->m_pDcDcUsb->waitForAnswer();
			LoadValues(true);
		}
}

void CPanelSettings::resetAll(bool visual)
{
	for (int i=0;i<SETTINGS_PACKS;i++) m_bPackagesArrived[i] = false;
	memset(m_chPackages,0,SETTINGS_PACKS*16);
	
	if (visual)
	{
		m_editMessage.EnableWindow(FALSE);
		m_comboMessage.EnableWindow(FALSE);
		m_bSend.EnableWindow(FALSE);
		m_pMainDlg->m_buttonSetSave.EnableWindow(FALSE);
	}
}

void CPanelSettings::LoadValues(bool visual)
{
	resetAll(visual);
	
	if (m_pMainDlg->m_pDcDcUsb)
		m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_READ_OUT, 4, 0xC0, 0x3F, 0x00, 0x10);

	if (m_pMainDlg->m_pDcDcUsb)
		m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_READ_OUT, 4, 0xD0, 0x3F, 0x00, 0x10);

	if (m_pMainDlg->m_pDcDcUsb)
		m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_READ_OUT, 4, 0xE0, 0x3F, 0x00, 0x10);

	if (m_pMainDlg->m_pDcDcUsb)
		m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_READ_OUT, 4, 0xF0, 0x3F, 0x00, 0x10);
}

void CPanelSettings::AddPackage(unsigned long address, unsigned long length, HArray* parray)
{
	if (address == 0x3FC0)
	{
		m_bPackagesArrived[0]=true;
		memcpy(m_chPackages, parray->getBuf()+5, 16);
	}
	else if (address == 0x3FD0)
	{
		m_bPackagesArrived[1]=true;
		memcpy(m_chPackages+16, parray->getBuf()+5, 16);
	}
	else if (address == 0x3FE0)
	{
		m_bPackagesArrived[2]=true;
		memcpy(m_chPackages+2*16, parray->getBuf()+5, 16);
	}
	else if (address == 0x3FF0)
	{
		m_bPackagesArrived[3]=true;
		memcpy(m_chPackages+3*16, parray->getBuf()+5, 16);

		if (m_bPackagesArrived[0] && m_bPackagesArrived[1] && m_bPackagesArrived[2] && m_bPackagesArrived[3])
		{
			m_editMessage.EnableWindow(TRUE);
			m_comboMessage.EnableWindow(TRUE);
			m_bSend.EnableWindow(TRUE);
			m_pMainDlg->m_buttonSetSave.EnableWindow(TRUE);

			OnCbnSelchangeComboMessage();
		}
	}
}

BOOL CPanelSettings::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_progressRW.SetRange(0,64);
	m_progressRW.SetStep(1);

	m_comboMessage.AddString(_T("Select parameter ..."));
	m_comboMessage.SetItemData(m_comboMessage.GetCount()-1, -1);

	for (int i=0;i<MAX_MESSAGE_CNT;i++)//M3AtxMessage::EPROM_END
	{
		if (HIDDcDcUsb::GetMessages()[i].nLen!=0)
		{
#ifndef _DCDCUSBTEST
			if (HIDDcDcUsb::GetMessages()[i].bEnabled)
#endif
			{
				m_comboMessage.AddString(HIDDcDcUsb::GetMessages()[i].strName);
				m_comboMessage.SetItemData(m_comboMessage.GetCount()-1, i);
			}
		}
	}
	m_comboMessage.SetCurSel(0);

	resetAll(true);

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

CString CPanelSettings::ConvertOneValue(unsigned char* buffer, int nLen, int nIndex, int nReadMode, double dMultiplier)
{
	CString str;
	double value = 0;

	if (nLen == 1)
	{
		str.Format(_T("%02X"), buffer[nIndex]);
		value = (double)buffer[nIndex] * dMultiplier;
	}
	else
	{
		str.Format(_T("%02X %02X"), buffer[nIndex], buffer[nIndex+1]);
		value = (double)( (((int)buffer[nIndex] ) << 8)|buffer[nIndex+1]) * dMultiplier;
	}

	switch (nReadMode)
	{
		case 2:str = float2string((float)value);break;
		case 3:
			{
				unsigned int ivalue = (unsigned int)value;
				if (ivalue == 0xFFFF)
					str = _T("Never");
				else str.Format("%02d:%02d:%02d"
						, ivalue/3600
						, (ivalue/60)%60
						, ivalue % 60
						);
			}break;
		case 4:
			{
				double dvalue = (buffer[nIndex] & 0x7f) * dMultiplier;
				str = float2string((float)dvalue);

				if ((buffer[nIndex] & 0x80)!=0)
					str = "-"+str;
			}break;
		case 5:
			{
				if (nLen == 1)
					value = (double)((char)buffer[nIndex]) * dMultiplier;
				else
					value = (double)( (((int)((char)buffer[nIndex]) ) << 8)|buffer[nIndex+1])
						* dMultiplier;
				str.Format("%d", (int)value);
			}break;
		case 6:
			{
				str = _T("-");
			}break;
		case 7:
			{//no multiplier - voltage value calcualted with formula
				str = float2string(HIDDcDcUsb::GetVOut(buffer[nIndex]));
			}break;
		case 8:
			{
				if (nLen == 1)
				{
					if (buffer[nIndex] == 0xFF)
						 str = _T("Never");
					else str.Format("%d", (int)value);
				}
				else
				{
					if ((buffer[nIndex] == 0xFF) && (buffer[nIndex+1] == 0xFF))
						 str = _T("Never");
					else str.Format("%d", (int)value);
				}
			}break;
		case 9:
			str = char2bin(buffer[nIndex]);
			break;
		case 1:
		default:
			{
				str.Format("%d", (int)value);
			}
	}

	return str;
}

void CPanelSettings::OnCbnSelchangeComboMessage()
{
	int sel = m_comboMessage.GetCurSel();
	if (sel != -1)
	{
		if (sel != 0)
		{
			unsigned char mesg_no = (unsigned char)m_comboMessage.GetItemData(sel);

			m_sComment.SetWindowText(HIDDcDcUsb::GetMessages()[mesg_no].strText);
			m_sUnit.SetWindowText(HIDDcDcUsb::GetMessages()[mesg_no].strUnit);

//				HIDDcDcUsb::GetMessages()[mesg_no].nIndex, false, false,
//				HIDDcDcUsb::GetMessages()[mesg_no].nLen, 

			CString str = ConvertOneValue(m_chPackages
										, HIDDcDcUsb::GetMessages()[mesg_no].nLen
										, HIDDcDcUsb::GetMessages()[mesg_no].nIndex
										, HIDDcDcUsb::GetMessages()[mesg_no].nReadMode
										, HIDDcDcUsb::GetMessages()[mesg_no].dMultiplier);

			m_editMessage.SetWindowText(str);
		}
		else
		{
			m_editMessage.SetWindowText(_T(""));
			m_sComment.SetWindowText(_T(""));
			m_sUnit.SetWindowText(_T("[---]"));
		}
	}
}

bool CPanelSettings::ReadOneValue(CString str, int nReadMode, double dMultiplier, int len, unsigned char &c1, unsigned char &c2) 
{
	bool ok = false;
	c1 = 0;
	c2 = 0;

	/* //array like settings
	_TCHAR* end = NULL;
	if (len == 1)
	{
		c2 = (unsigned char)_tcstol(str, &end, 16);
		TRACE("%d\n", errno);
		ok = true;
	}
	else
	{
		c1 = (unsigned char)_tcstol(str, &end, 16);
		TRACE("%d\n", errno);
		if (end!=NULL)
		{
			c2 = (unsigned char)_tcstol(end+1, &end, 16);
			TRACE("%d\n", errno);
			ok = true;
		}
	}*/

	double val = 0;
	
	switch (nReadMode)
	{
	case 3:
		{//hh:mm:ss
			if (str.CompareNoCase(_T("Never"))==0)
			{
				val = 0xFFFF;
				ok = true;
			}
			else if ((str.GetLength()==8)&&(str[2]==':')&&(str[5]==':'))
			{
				_TCHAR* end = NULL;

				int hh  = _tcstol(str.Left(2), &end, 10);
				if (((errno != ERANGE)&&(errno != EINVAL))&&(hh>=0)&&(hh<18))
				{
					int mm  = _tcstol(str.Mid(3,2), &end, 10);
					if (((errno != ERANGE)&&(errno != EINVAL))&&(mm>=0)&&(mm<60))
					{
						int ss  = _tcstol(str.Right(2), &end, 10);

						if (((errno != ERANGE)&&(errno != EINVAL))&&(ss>=0)&&(ss<60))
						{
							val = hh*3600+mm*60+ss;
							ok = true;
						}
					}
				}
			}
		}break;
	case 4:
		{//"signed" float
			if (str.GetLength()!=0)
			{
				bool negative = false;
				if (str[0] == '-')
				{
					str = str.Right(str.GetLength()-1);
					negative = true;
				}

				_TCHAR* end = NULL;
				val = _tcstod(str.Left(8), &end);

				if ((errno != ERANGE)&&(errno != EINVAL))
				{
					ok = true;

					val /= dMultiplier;
					if (val < 0) val = 0;
					double rem = val - (int) val;
					unsigned long uval = (unsigned long)val;
					if (rem >= 0.5) uval += 1;

					if (uval > 0x7F) uval = 0x7F;

					c1 = 0;
					c2 = (unsigned char)uval;
					if (negative) c2 |= 0x80;
				}
			}
		}break;
	case 6:
		{
			val = 0xFF;
			ok = true;
		}break;
	case 7:
		{
			_TCHAR* end = NULL;
			val = _tcstod(str.Left(8), &end);

			c1 = 0;
			c2 = HIDDcDcUsb::GetData(val);
			ok = true;
		}break;
	case 8:
		{
			if (str.CompareNoCase(_T("Never"))==0)
			{
				val = (double)0xFFFF * dMultiplier;
				ok = true;
			}
			else
			{
				TCHAR* end = NULL;
				val = _tcstod(str.Left(8), &end);
				if ((errno != ERANGE)&&(errno != EINVAL)) ok = true;
			}
		}break;
	case 9:
		{
			c1 = 0;
			c2 = bin2char(str, &ok);
		}break;
	case 1:
		//normal read - integer
	case 2:
	case 5:
	default:
		{//normal read - float
			_TCHAR* end = NULL;
			val = _tcstod(str.Left(8), &end);

//					CString err;
//					err.Format("Convert: (%f) (%d) (%s)",val, errno, str.Left(8));
//					AfxMessageBox(err);

			if ((errno != ERANGE)&&(errno != EINVAL)) ok = true;
		}
	}

	if (ok)
	{
		if ((nReadMode != 4)&&(nReadMode != 7)&&(nReadMode != 9))
		{
			val /= dMultiplier;

			if (nReadMode!=5)
			{//unsigned
				if (val < 0) val = 0;
				double rem = val - (int) val;
				unsigned long uval = (unsigned long)val;
				if (rem >= 0.5) uval += 1;

				if (len == 1)
				{
					if (uval > 0xFF) uval = 0xFF;
					
					c1 = 0;
					c2 = (unsigned char)uval;
				}
				else
				{
					if (uval > 0xFFFF) uval = 0xFFFF;

					c1 = (unsigned char)((((unsigned int)uval)>>8) & 0xFF);
					c2 = (unsigned char)(((unsigned int)uval) & 0xFF);
				}
			}
			else
			{
				double rem = -val + (int) val;
				long uval = (long)val;
				if (rem >= 0.5) uval += 1;

				if (len == 1)
				{
					if (uval > 127) uval = 127;
					if (uval <-128) uval = -128;
					
					c1 = 0;
					c2 = (char)uval;
				}
				else
				{
					if (uval > 32767) uval = 32767;
					if (uval <-32768) uval = -32768;

					c1 = (char)((((int)uval)>>8) & 0xFF);
					c2 = (char)(((int)uval) & 0xFF);
				}
			}
		}
	}

	return ok;
}

void CPanelSettings::OnBnClickedButtonSendsettings()
{
	if (m_bPackagesArrived[0] && m_bPackagesArrived[1] && m_bPackagesArrived[2] && m_bPackagesArrived[3])
	{
		CString str;
		m_editMessage.GetWindowText(str);

		int sel = m_comboMessage.GetCurSel();
		if (sel > 0)
		{
			unsigned char mesg_no = (unsigned char)m_comboMessage.GetItemData(sel);
			
			SendValue(mesg_no, str);
		}
	}
}

void CPanelSettings::SendValue(int mesg_no, CString str)
{
	if (m_bPackagesArrived[0] && m_bPackagesArrived[1] && m_bPackagesArrived[2] && m_bPackagesArrived[3])
	{
		int len = HIDDcDcUsb::GetMessages()[mesg_no].nLen;

		if (len!=0)
		{
			unsigned char c1 = 0;
			unsigned char c2 = 0;

			if (ReadOneValue(str
							,HIDDcDcUsb::GetMessages()[mesg_no].nReadMode
							,HIDDcDcUsb::GetMessages()[mesg_no].dMultiplier
							,len
							,c1, c2))
			{
				unsigned char chPackages[SETTINGS_PACKS*16];
				memcpy(chPackages, m_chPackages, SETTINGS_PACKS*16);
				if (len == 1)
					chPackages[HIDDcDcUsb::GetMessages()[mesg_no].nIndex]   = c2;
				else
				{
					chPackages[HIDDcDcUsb::GetMessages()[mesg_no].nIndex]   = c1;
					chPackages[HIDDcDcUsb::GetMessages()[mesg_no].nIndex+1] = c2;
				}
				/*chPackages[14] = CHECK_CHAR;
				chPackages[15] = CHECK_CHAR;
				chPackages[30] = CHECK_CHAR;
				chPackages[31] = CHECK_CHAR;
				chPackages[46] = CHECK_CHAR;
				chPackages[47] = CHECK_CHAR;
				chPackages[62] = CHECK_CHAR;
				chPackages[63] = CHECK_CHAR;*/

				bool ok = true;
				//erase
				if (m_pMainDlg->m_pDcDcUsb)
				{
					if (!m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_ERASE, 4, 0xC0, 0x3F, 0x00, 0x40)) ok = false;
				}else ok = false;

				//write
				if (m_pMainDlg->m_pDcDcUsb)
				{
					if (!m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_WRITE_OUT, 16, chPackages		, 4, 0xC0, 0x3F, 0x00, 0x10)) ok = false;
				}else ok = false;
				if (m_pMainDlg->m_pDcDcUsb)
				{
					if (!m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_WRITE_OUT, 16, chPackages+16	, 4, 0xD0, 0x3F, 0x00, 0x10)) ok = false;
				}else ok = false;
				if (m_pMainDlg->m_pDcDcUsb)
				{
					if (!m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_WRITE_OUT, 16, chPackages+2*16	, 4, 0xE0, 0x3F, 0x00, 0x10)) ok = false;
				}else ok = false;
				if (m_pMainDlg->m_pDcDcUsb)
				{
					if (!m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_WRITE_OUT, 16, chPackages+3*16	, 4, 0xF0, 0x3F, 0x00, 0x10)) ok = false;
				}else ok = false;

				if (!ok)
					AfxMessageBox("Error occured during write - please retry!");

				LoadValues(true);
			}
			else AfxMessageBox("Invalid or too big value!");
		}
	}
}

int CPanelSettings::getLoadStatus()
{
	int cnt = 0;
	for (int i=0;i<SETTINGS_PACKS;i++)
		if (m_bPackagesArrived[i]) cnt++;

	return cnt;
}

/*void CPanelSettings::checkWriteIniFile()
{
	if (m_bWriteIniFile)
	{
		int status = getLoadStatus()+m_pMainDlg->m_pPanelScripts->getLoadStatus();
		TRACE("loadstatus %d\r\n",status);

		m_progressRW.SetPos(status);

		if (status == (SCRIPTS_PACKS+SETTINGS_PACKS))
		{
			FILE* f = fopen("settings.ini", "wt");
			if (f)
			{
				fprintf(f, "#This file is a parameter and script file for DCDC-USB\r\n");
				fprintf(f, "#Can be created from the DCDC-USB software importing from device\r\n");
				fprintf(f, "#DO NOT MODIFY IT MANUALLY! WRONG VALUES CAN BURN DOWN YOUR DEVICE!\r\n");
				fprintf(f, "#version:\r\n");
				fprintf(f, "00\r\n");
				fprintf(f, "#Parameters\r\n");
				for (int i=0;i<SETTINGS_PACKS;i++)
				{
					for (int len=0;len<16;len++)
						fprintf(f, "%02x ", m_chPackages[i*16+len]);
					fprintf(f, "\r\n");
				}
				fprintf(f, "#Scripts\r\n");
				for (int i=0;i<SCRIPTS_PACKS;i++)
				{
					for (int len=0;len<16;len++)
						fprintf(f, "%02x ", m_pMainDlg->m_pPanelScripts->getPackage()[i*16+len]);
					fprintf(f, "\r\n");
				}
				fclose(f);
			}
			m_bWriteIniFile = false;
			m_staticRW.SetWindowText("SUCCESS (Device ===> File)");
		}
		else
		{
			m_staticRW.SetWindowText("ERROR (Device ===> File)");
			m_bWriteIniFile = false;
		}
	}
}*/

void CPanelSettings::OnBnClickedButtonReadsettings()
{
	CWaitCursor cursor;

	m_staticRW.SetWindowText("IN PROGRESS (Device ===> File)");

	m_progressRW.SetPos(0);

	FILE* f = fopen("settings.ini", "wt");
	if (!f)
	{
		m_staticRW.SetWindowText("ERROR (Device ===> File)");
		return;
	}

	fprintf(f, "#This file is a parameter and script file for DCDC-USB\r\n");
	fprintf(f, "#Can be created from the DCDC-USB software importing from device\r\n");
	fprintf(f, "#DO NOT MODIFY IT MANUALLY! WRONG VALUES CAN BURN DOWN YOUR DEVICE!\r\n");
	fprintf(f, "#version:\r\n");
	fprintf(f, "00\r\n");
	fprintf(f, "#-----------------------------------\r\n");

	unsigned long addr = SCRIPT_START_ADDR;//3c00
	int timeout = 0;
	
	while ((addr <= 0x3ff0) && m_pMainDlg->m_pDcDcUsb)
	{
		m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_READ_OUT, 4, addr & 0xFF, (addr >> 8) & 0xFF, 0x00, 0x10);
		
		//read value
		timeout = 0;
		HArray* parray = NULL;
		while ((timeout < 100) && (parray == NULL) && m_pMainDlg->m_pDcDcUsb)
		{
			parray = m_pMainDlg->m_pDcDcUsb->getReceivedMessage();
			
			if (parray->getAt(0) != DCDCUSB_MEM_READ_IN)
			{
				delete parray;
				parray = NULL;
			}

			timeout++;
		}

		if (!parray)
		{
			m_staticRW.SetWindowText("TIMEOUT ERROR (Device ===> File)");
			fclose(f);
			CFile::Remove("settings.ini");
			return;
		}

		fprintf(f, "%02x %02x", addr & 0xFF, (addr >> 8) & 0xFF);
		for (int len=0;len<16;len++)
			fprintf(f, " %02x", parray->getAt(5+len));
		fprintf(f, "\r\n");
		delete parray;

		m_progressRW.StepIt();

		addr += 16;
	}

	fclose(f);

	m_staticRW.SetWindowText("SUCCESS (Device ===> File)");
}

void CPanelSettings::OnBnClickedButtonWritesettings()
{
	if (!writeIniToDevice())
	{
		m_staticRW.SetWindowText("WRITE ERROR (Device <=== File)");

		m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_CMD_OUT, 3, CMD_LOAD_DEFAULTS, 0, 0);
		m_pMainDlg->m_pDcDcUsb->waitForAnswer();
		LoadValues(true);

		AfxMessageBox("Write error occured! Factory defaults loaded for parameters!");
	}
	else
	{
		LoadValues(true);
	}
}

bool CPanelSettings::writeIniToDevice()
{
	CWaitCursor wait;
	m_progressRW.SetPos(0);
	m_staticRW.SetWindowText("IN PROGRESS (Device <=== File)");
	
	TxFile file("settings.ini");
	if (file.Open() == 0)
	{
		bool ok = true;

		HArray line;
	
		file.NextArray(&line);
		if (line.length()<=0) return false;
		unsigned char version = line.getAt(0);

		int counter = 0;
		unsigned long addr = SCRIPT_START_ADDR;//3c00
		unsigned long addr_read = 0;
		int timeout = 0;

		file.NextArray(&line);
		while ( (line.length()>0) && m_pMainDlg->m_pDcDcUsb)
		{
			addr_read = line.getAt(1);
			addr_read = (addr_read << 8);
			addr_read = addr_read | line.getAt(0);

			TRACE("addr: %04x=%04x pkt:",addr_read,addr);
			for (int len=0;len<16;len++)
				TRACE(" %02x",line.getAt(2+len));
			TRACE("\r\n");

			HArray* parray = NULL;
			if (addr != addr_read) return false;

			if ( ((addr - SCRIPT_START_ADDR)%64) == 0)
			{
				m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_ERASE, 4, addr & 0xFF, (addr >> 8) & 0xFF, 0x00, 0x40);
				if (m_pMainDlg->m_pDcDcUsb->waitForAnswer())
				{
					timeout = 0;
			
					while ((timeout < 100) && (parray == NULL) && m_pMainDlg->m_pDcDcUsb)
					{
						parray = m_pMainDlg->m_pDcDcUsb->getReceivedMessage();
						
						if (parray->getAt(0) != DCDCUSB_MEM_READ_IN)
						{
							delete parray;
							parray = NULL;
						}

						timeout++;
					}

					if (!parray) return false;
					delete parray;
					parray = NULL;
				}
			}

			m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_WRITE_OUT, 16, line.getBuf()+2 , 4, addr & 0xFF, (addr >> 8) & 0xFF, 0x00, 0x10);
			timeout = 0;
			
			while ((timeout < 100) && (parray == NULL) && m_pMainDlg->m_pDcDcUsb)
			{
				parray = m_pMainDlg->m_pDcDcUsb->getReceivedMessage();
				
				if (parray->getAt(0) != DCDCUSB_MEM_READ_IN)
				{
					delete parray;
					parray = NULL;
				}

				timeout++;
			}

			if (!parray) return false;

			for (int i=0;i<16;i++)
				if (parray->getAt(5+i)!=line.getAt(2+i)) 
				{
					TRACE("%02x!=%02X\n",parray->getAt(5+i),line.getAt(2+i));
					delete parray;
					return false;
				}

			delete parray;

			m_progressRW.StepIt();
			counter ++;
			addr += 16; 
			file.NextArray(&line);
		}

		if ((addr <= 0x3ff0)||(addr_read!=0x3ff0)) 
			return false;//end address does not match

		if (!m_pMainDlg->m_pDcDcUsb)
			return false;

		m_staticRW.SetWindowText("SUCCESS (Device <=== File)");
	}
	else m_staticRW.SetWindowText("FILE NOT FOUND (Device <=== File)");

	return true;
	
	/*	if (!m_bWriteIniFile)
	{
		CWaitCursor wait;
		m_progressRW.SetPos(0);
		m_staticRW.SetWindowText("IN PROGRESS (Device <=== File)");

		TxFile file("settings.ini");
		if (file.Open() == 0)
		{
			bool ok = true;

			HArray line;

			HArray settings[SETTINGS_PACKS];
			HArray scripts[SCRIPTS_PACKS];

			file.NextArray(&line);
			if (line.length()!=0)
			{
				unsigned char version = line.getAt(0);

				TRACE("SETTINGS\r\n");
				for (int i=0;i<SETTINGS_PACKS;i++)
				{
					file.NextArray(&settings[i]);
					
					if (settings[i].length() >= 16)
					{
						for (int len=0;len<settings[i].length();len++)
							TRACE("%02x ",settings[i].getAt(len));
						TRACE("\r\n");
					}
					else ok = false;
				}
				TRACE("SCRIPTS\r\n");
				for (int i=0;i<SCRIPTS_PACKS;i++)
				{
					file.NextArray(&scripts[i]);

					if (scripts[i].length() >= 16)
					{
						for (int len=0;len<scripts[i].length();len++)
							TRACE("%02x ",scripts[i].getAt(len));
						TRACE("\r\n");
					}
					else ok = false;
				}

				//this->LoadValues(true);
				//m_pMainDlg->m_pPanelScripts->LoadValues(true, true);
			}
			else ok = false;

			if (!ok)
				m_staticRW.SetWindowText("FILE ERROR (Device <=== File)");
			else
			{
				//m_progressRW.SetPos(i+1+SETTINGS_PACKS);

				//erase
				if (m_pMainDlg->m_pDcDcUsb)
				{
					if (!m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_ERASE, 4, 0xC0, 0x3F, 0x00, 0x40)) ok = false;
				}else ok = false;

				//write
				if (m_pMainDlg->m_pDcDcUsb)
				{
					if (!m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_WRITE_OUT, 16, settings[0].getBuf() , 4, 0xC0, 0x3F, 0x00, 0x10)) ok = false;
					m_progressRW.SetPos(1);
				}else ok = false;
				if (m_pMainDlg->m_pDcDcUsb)
				{
					if (!m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_WRITE_OUT, 16, settings[1].getBuf() , 4, 0xD0, 0x3F, 0x00, 0x10)) ok = false;
					m_progressRW.SetPos(2);
				}else ok = false;
				if (m_pMainDlg->m_pDcDcUsb)
				{
					if (!m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_WRITE_OUT, 16, settings[2].getBuf() , 4, 0xE0, 0x3F, 0x00, 0x10)) ok = false;
					m_progressRW.SetPos(3);
				}else ok = false;
				if (m_pMainDlg->m_pDcDcUsb)
				{
					if (!m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_WRITE_OUT, 16, settings[3].getBuf() , 4, 0xF0, 0x3F, 0x00, 0x10)) ok = false;
					m_progressRW.SetPos(4);
				}else ok = false;

				//---------------
				if (m_pMainDlg->m_pDcDcUsb)
				{
					if (!m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_ERASE, 4, addr & 0xFF, (addr >> 8) & 0xFF, 0x00, 0x40)) ok = false;
				}else ok = false;

				//write
				if (m_pMainDlg->m_pDcDcUsb)
				{
					if (!m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_WRITE_OUT, 16, chPackages		, 4, addr & 0xFF, (addr >> 8) & 0xFF, 0x00, 0x10)) ok = false;
				}else ok = false;

				addr += 16;
				if (m_pMainDlg->m_pDcDcUsb)
				{
					if (!m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_WRITE_OUT, 16, chPackages+16	, 4, addr & 0xFF, (addr >> 8) & 0xFF, 0x00, 0x10)) ok = false;
				}else ok = false;

				addr += 16;
				if (m_pMainDlg->m_pDcDcUsb)
				{
					if (!m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_WRITE_OUT, 16, chPackages+2*16	, 4, addr & 0xFF, (addr >> 8) & 0xFF, 0x00, 0x10)) ok = false;
				}else ok = false;

				addr += 16;
				if (m_pMainDlg->m_pDcDcUsb)
				{
					if (!m_pMainDlg->m_pDcDcUsb->sendMessage(DCDCUSB_MEM_WRITE_OUT, 16, chPackages+3*16	, 4, addr & 0xFF, (addr >> 8) & 0xFF, 0x00, 0x10)) ok = false;
				}else ok = false;

			}
		}
		else
		{
			m_staticRW.SetWindowText("FILE NOT FOUND (Device <=== File)");
		}
	}*/
}
